/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMarketplaceResourceRequest extends ImagebuilderRequest implements
        ToCopyableBuilder<GetMarketplaceResourceRequest.Builder, GetMarketplaceResourceRequest> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(GetMarketplaceResourceRequest::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(GetMarketplaceResourceRequest::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> RESOURCE_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceLocation").getter(getter(GetMarketplaceResourceRequest::resourceLocation))
            .setter(setter(Builder::resourceLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD,
            RESOURCE_ARN_FIELD, RESOURCE_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceType;

    private final String resourceArn;

    private final String resourceLocation;

    private GetMarketplaceResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceType = builder.resourceType;
        this.resourceArn = builder.resourceArn;
        this.resourceLocation = builder.resourceLocation;
    }

    /**
     * <p>
     * Specifies which type of Amazon Web Services Marketplace resource Image Builder retrieves.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link MarketplaceResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return Specifies which type of Amazon Web Services Marketplace resource Image Builder retrieves.
     * @see MarketplaceResourceType
     */
    public final MarketplaceResourceType resourceType() {
        return MarketplaceResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * Specifies which type of Amazon Web Services Marketplace resource Image Builder retrieves.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link MarketplaceResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return Specifies which type of Amazon Web Services Marketplace resource Image Builder retrieves.
     * @see MarketplaceResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that uniquely identifies an Amazon Web Services Marketplace resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that uniquely identifies an Amazon Web Services Marketplace resource.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The bucket path that you can specify to download the resource from Amazon S3.
     * </p>
     * 
     * @return The bucket path that you can specify to download the resource from Amazon S3.
     */
    public final String resourceLocation() {
        return resourceLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMarketplaceResourceRequest)) {
            return false;
        }
        GetMarketplaceResourceRequest other = (GetMarketplaceResourceRequest) obj;
        return Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(resourceLocation(), other.resourceLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMarketplaceResourceRequest").add("ResourceType", resourceTypeAsString())
                .add("ResourceArn", resourceArn()).add("ResourceLocation", resourceLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "resourceLocation":
            return Optional.ofNullable(clazz.cast(resourceLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("resourceLocation", RESOURCE_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMarketplaceResourceRequest, T> g) {
        return obj -> g.apply((GetMarketplaceResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetMarketplaceResourceRequest> {
        /**
         * <p>
         * Specifies which type of Amazon Web Services Marketplace resource Image Builder retrieves.
         * </p>
         * 
         * @param resourceType
         *        Specifies which type of Amazon Web Services Marketplace resource Image Builder retrieves.
         * @see MarketplaceResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MarketplaceResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Specifies which type of Amazon Web Services Marketplace resource Image Builder retrieves.
         * </p>
         * 
         * @param resourceType
         *        Specifies which type of Amazon Web Services Marketplace resource Image Builder retrieves.
         * @see MarketplaceResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MarketplaceResourceType
         */
        Builder resourceType(MarketplaceResourceType resourceType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that uniquely identifies an Amazon Web Services Marketplace resource.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) that uniquely identifies an Amazon Web Services Marketplace resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The bucket path that you can specify to download the resource from Amazon S3.
         * </p>
         * 
         * @param resourceLocation
         *        The bucket path that you can specify to download the resource from Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceLocation(String resourceLocation);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ImagebuilderRequest.BuilderImpl implements Builder {
        private String resourceType;

        private String resourceArn;

        private String resourceLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMarketplaceResourceRequest model) {
            super(model);
            resourceType(model.resourceType);
            resourceArn(model.resourceArn);
            resourceLocation(model.resourceLocation);
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(MarketplaceResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceLocation() {
            return resourceLocation;
        }

        public final void setResourceLocation(String resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        @Override
        public final Builder resourceLocation(String resourceLocation) {
            this.resourceLocation = resourceLocation;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMarketplaceResourceRequest build() {
            return new GetMarketplaceResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
