/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWorkflowStepExecutionRequest extends ImagebuilderRequest implements
        ToCopyableBuilder<GetWorkflowStepExecutionRequest.Builder, GetWorkflowStepExecutionRequest> {
    private static final SdkField<String> STEP_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stepExecutionId").getter(getter(GetWorkflowStepExecutionRequest::stepExecutionId))
            .setter(setter(Builder::stepExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("stepExecutionId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_EXECUTION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String stepExecutionId;

    private GetWorkflowStepExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.stepExecutionId = builder.stepExecutionId;
    }

    /**
     * <p>
     * Use the unique identifier for a specific runtime instance of the workflow step to get runtime details for that
     * step.
     * </p>
     * 
     * @return Use the unique identifier for a specific runtime instance of the workflow step to get runtime details for
     *         that step.
     */
    public final String stepExecutionId() {
        return stepExecutionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stepExecutionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowStepExecutionRequest)) {
            return false;
        }
        GetWorkflowStepExecutionRequest other = (GetWorkflowStepExecutionRequest) obj;
        return Objects.equals(stepExecutionId(), other.stepExecutionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWorkflowStepExecutionRequest").add("StepExecutionId", stepExecutionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stepExecutionId":
            return Optional.ofNullable(clazz.cast(stepExecutionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stepExecutionId", STEP_EXECUTION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWorkflowStepExecutionRequest, T> g) {
        return obj -> g.apply((GetWorkflowStepExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetWorkflowStepExecutionRequest> {
        /**
         * <p>
         * Use the unique identifier for a specific runtime instance of the workflow step to get runtime details for
         * that step.
         * </p>
         * 
         * @param stepExecutionId
         *        Use the unique identifier for a specific runtime instance of the workflow step to get runtime details
         *        for that step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepExecutionId(String stepExecutionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ImagebuilderRequest.BuilderImpl implements Builder {
        private String stepExecutionId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowStepExecutionRequest model) {
            super(model);
            stepExecutionId(model.stepExecutionId);
        }

        public final String getStepExecutionId() {
            return stepExecutionId;
        }

        public final void setStepExecutionId(String stepExecutionId) {
            this.stepExecutionId = stepExecutionId;
        }

        @Override
        public final Builder stepExecutionId(String stepExecutionId) {
            this.stepExecutionId = stepExecutionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetWorkflowStepExecutionRequest build() {
            return new GetWorkflowStepExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
