/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWorkflowStepExecutionResponse extends ImagebuilderResponse implements
        ToCopyableBuilder<GetWorkflowStepExecutionResponse.Builder, GetWorkflowStepExecutionResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestId").getter(getter(GetWorkflowStepExecutionResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()).build();

    private static final SdkField<String> STEP_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stepExecutionId").getter(getter(GetWorkflowStepExecutionResponse::stepExecutionId))
            .setter(setter(Builder::stepExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepExecutionId").build()).build();

    private static final SdkField<String> WORKFLOW_BUILD_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowBuildVersionArn").getter(getter(GetWorkflowStepExecutionResponse::workflowBuildVersionArn))
            .setter(setter(Builder::workflowBuildVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowBuildVersionArn").build())
            .build();

    private static final SdkField<String> WORKFLOW_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowExecutionId").getter(getter(GetWorkflowStepExecutionResponse::workflowExecutionId))
            .setter(setter(Builder::workflowExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowExecutionId").build())
            .build();

    private static final SdkField<String> IMAGE_BUILD_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageBuildVersionArn").getter(getter(GetWorkflowStepExecutionResponse::imageBuildVersionArn))
            .setter(setter(Builder::imageBuildVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageBuildVersionArn").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetWorkflowStepExecutionResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetWorkflowStepExecutionResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(GetWorkflowStepExecutionResponse::action)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetWorkflowStepExecutionResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> ROLLBACK_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rollbackStatus").getter(getter(GetWorkflowStepExecutionResponse::rollbackStatusAsString))
            .setter(setter(Builder::rollbackStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rollbackStatus").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(GetWorkflowStepExecutionResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<String> INPUTS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("inputs")
            .getter(getter(GetWorkflowStepExecutionResponse::inputs)).setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputs").build()).build();

    private static final SdkField<String> OUTPUTS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("outputs")
            .getter(getter(GetWorkflowStepExecutionResponse::outputs)).setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build()).build();

    private static final SdkField<String> START_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("startTime").getter(getter(GetWorkflowStepExecutionResponse::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<String> END_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endTime").getter(getter(GetWorkflowStepExecutionResponse::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> ON_FAILURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("onFailure").getter(getter(GetWorkflowStepExecutionResponse::onFailure))
            .setter(setter(Builder::onFailure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onFailure").build()).build();

    private static final SdkField<Integer> TIMEOUT_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("timeoutSeconds").getter(getter(GetWorkflowStepExecutionResponse::timeoutSeconds))
            .setter(setter(Builder::timeoutSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutSeconds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(REQUEST_ID_FIELD, STEP_EXECUTION_ID_FIELD, WORKFLOW_BUILD_VERSION_ARN_FIELD, WORKFLOW_EXECUTION_ID_FIELD,
                    IMAGE_BUILD_VERSION_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, ACTION_FIELD, STATUS_FIELD,
                    ROLLBACK_STATUS_FIELD, MESSAGE_FIELD, INPUTS_FIELD, OUTPUTS_FIELD, START_TIME_FIELD, END_TIME_FIELD,
                    ON_FAILURE_FIELD, TIMEOUT_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String requestIdValue;

    private final String stepExecutionId;

    private final String workflowBuildVersionArn;

    private final String workflowExecutionId;

    private final String imageBuildVersionArn;

    private final String name;

    private final String description;

    private final String action;

    private final String status;

    private final String rollbackStatus;

    private final String message;

    private final String inputs;

    private final String outputs;

    private final String startTime;

    private final String endTime;

    private final String onFailure;

    private final Integer timeoutSeconds;

    private GetWorkflowStepExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.stepExecutionId = builder.stepExecutionId;
        this.workflowBuildVersionArn = builder.workflowBuildVersionArn;
        this.workflowExecutionId = builder.workflowExecutionId;
        this.imageBuildVersionArn = builder.imageBuildVersionArn;
        this.name = builder.name;
        this.description = builder.description;
        this.action = builder.action;
        this.status = builder.status;
        this.rollbackStatus = builder.rollbackStatus;
        this.message = builder.message;
        this.inputs = builder.inputs;
        this.outputs = builder.outputs;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.onFailure = builder.onFailure;
        this.timeoutSeconds = builder.timeoutSeconds;
    }

    /**
     * <p>
     * The request ID that uniquely identifies this request.
     * </p>
     * 
     * @return The request ID that uniquely identifies this request.
     */
    public final String requestId() {
        return requestIdValue;
    }

    /**
     * <p>
     * The unique identifier for the runtime version of the workflow step that you specified in the request.
     * </p>
     * 
     * @return The unique identifier for the runtime version of the workflow step that you specified in the request.
     */
    public final String stepExecutionId() {
        return stepExecutionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the build version for the Image Builder workflow resource that defines this
     * workflow step.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the build version for the Image Builder workflow resource that defines
     *         this workflow step.
     */
    public final String workflowBuildVersionArn() {
        return workflowBuildVersionArn;
    }

    /**
     * <p>
     * The unique identifier that Image Builder assigned to keep track of runtime details when it ran the workflow.
     * </p>
     * 
     * @return The unique identifier that Image Builder assigned to keep track of runtime details when it ran the
     *         workflow.
     */
    public final String workflowExecutionId() {
        return workflowExecutionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the image resource build version that the specified runtime instance of the
     * workflow step creates.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the image resource build version that the specified runtime instance of
     *         the workflow step creates.
     */
    public final String imageBuildVersionArn() {
        return imageBuildVersionArn;
    }

    /**
     * <p>
     * The name of the specified runtime instance of the workflow step.
     * </p>
     * 
     * @return The name of the specified runtime instance of the workflow step.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Describes the specified workflow step.
     * </p>
     * 
     * @return Describes the specified workflow step.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the action that the specified step performs.
     * </p>
     * 
     * @return The name of the action that the specified step performs.
     */
    public final String action() {
        return action;
    }

    /**
     * <p>
     * The current status for the specified runtime version of the workflow step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkflowStepExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status for the specified runtime version of the workflow step.
     * @see WorkflowStepExecutionStatus
     */
    public final WorkflowStepExecutionStatus status() {
        return WorkflowStepExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status for the specified runtime version of the workflow step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkflowStepExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status for the specified runtime version of the workflow step.
     * @see WorkflowStepExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Reports on the rollback status of the specified runtime version of the workflow step, if applicable.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rollbackStatus}
     * will return {@link WorkflowStepExecutionRollbackStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #rollbackStatusAsString}.
     * </p>
     * 
     * @return Reports on the rollback status of the specified runtime version of the workflow step, if applicable.
     * @see WorkflowStepExecutionRollbackStatus
     */
    public final WorkflowStepExecutionRollbackStatus rollbackStatus() {
        return WorkflowStepExecutionRollbackStatus.fromValue(rollbackStatus);
    }

    /**
     * <p>
     * Reports on the rollback status of the specified runtime version of the workflow step, if applicable.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rollbackStatus}
     * will return {@link WorkflowStepExecutionRollbackStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #rollbackStatusAsString}.
     * </p>
     * 
     * @return Reports on the rollback status of the specified runtime version of the workflow step, if applicable.
     * @see WorkflowStepExecutionRollbackStatus
     */
    public final String rollbackStatusAsString() {
        return rollbackStatus;
    }

    /**
     * <p>
     * The output message from the specified runtime instance of the workflow step, if applicable.
     * </p>
     * 
     * @return The output message from the specified runtime instance of the workflow step, if applicable.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * Input parameters that Image Builder provided for the specified runtime instance of the workflow step.
     * </p>
     * 
     * @return Input parameters that Image Builder provided for the specified runtime instance of the workflow step.
     */
    public final String inputs() {
        return inputs;
    }

    /**
     * <p>
     * The file names that the specified runtime version of the workflow step created as output.
     * </p>
     * 
     * @return The file names that the specified runtime version of the workflow step created as output.
     */
    public final String outputs() {
        return outputs;
    }

    /**
     * <p>
     * The timestamp when the specified runtime version of the workflow step started.
     * </p>
     * 
     * @return The timestamp when the specified runtime version of the workflow step started.
     */
    public final String startTime() {
        return startTime;
    }

    /**
     * <p>
     * The timestamp when the specified runtime instance of the workflow step finished.
     * </p>
     * 
     * @return The timestamp when the specified runtime instance of the workflow step finished.
     */
    public final String endTime() {
        return endTime;
    }

    /**
     * <p>
     * The action to perform if the workflow step fails.
     * </p>
     * 
     * @return The action to perform if the workflow step fails.
     */
    public final String onFailure() {
        return onFailure;
    }

    /**
     * <p>
     * The maximum duration in seconds for this step to complete its action.
     * </p>
     * 
     * @return The maximum duration in seconds for this step to complete its action.
     */
    public final Integer timeoutSeconds() {
        return timeoutSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(stepExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(workflowBuildVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(workflowExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(imageBuildVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(rollbackStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(inputs());
        hashCode = 31 * hashCode + Objects.hashCode(outputs());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(onFailure());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowStepExecutionResponse)) {
            return false;
        }
        GetWorkflowStepExecutionResponse other = (GetWorkflowStepExecutionResponse) obj;
        return Objects.equals(requestId(), other.requestId()) && Objects.equals(stepExecutionId(), other.stepExecutionId())
                && Objects.equals(workflowBuildVersionArn(), other.workflowBuildVersionArn())
                && Objects.equals(workflowExecutionId(), other.workflowExecutionId())
                && Objects.equals(imageBuildVersionArn(), other.imageBuildVersionArn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(action(), other.action())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(rollbackStatusAsString(), other.rollbackStatusAsString())
                && Objects.equals(message(), other.message()) && Objects.equals(inputs(), other.inputs())
                && Objects.equals(outputs(), other.outputs()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(onFailure(), other.onFailure())
                && Objects.equals(timeoutSeconds(), other.timeoutSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWorkflowStepExecutionResponse").add("RequestId", requestId())
                .add("StepExecutionId", stepExecutionId()).add("WorkflowBuildVersionArn", workflowBuildVersionArn())
                .add("WorkflowExecutionId", workflowExecutionId()).add("ImageBuildVersionArn", imageBuildVersionArn())
                .add("Name", name()).add("Description", description()).add("Action", action()).add("Status", statusAsString())
                .add("RollbackStatus", rollbackStatusAsString()).add("Message", message()).add("Inputs", inputs())
                .add("Outputs", outputs()).add("StartTime", startTime()).add("EndTime", endTime()).add("OnFailure", onFailure())
                .add("TimeoutSeconds", timeoutSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "requestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "stepExecutionId":
            return Optional.ofNullable(clazz.cast(stepExecutionId()));
        case "workflowBuildVersionArn":
            return Optional.ofNullable(clazz.cast(workflowBuildVersionArn()));
        case "workflowExecutionId":
            return Optional.ofNullable(clazz.cast(workflowExecutionId()));
        case "imageBuildVersionArn":
            return Optional.ofNullable(clazz.cast(imageBuildVersionArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "rollbackStatus":
            return Optional.ofNullable(clazz.cast(rollbackStatusAsString()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "onFailure":
            return Optional.ofNullable(clazz.cast(onFailure()));
        case "timeoutSeconds":
            return Optional.ofNullable(clazz.cast(timeoutSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("requestId", REQUEST_ID_FIELD);
        map.put("stepExecutionId", STEP_EXECUTION_ID_FIELD);
        map.put("workflowBuildVersionArn", WORKFLOW_BUILD_VERSION_ARN_FIELD);
        map.put("workflowExecutionId", WORKFLOW_EXECUTION_ID_FIELD);
        map.put("imageBuildVersionArn", IMAGE_BUILD_VERSION_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("action", ACTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("rollbackStatus", ROLLBACK_STATUS_FIELD);
        map.put("message", MESSAGE_FIELD);
        map.put("inputs", INPUTS_FIELD);
        map.put("outputs", OUTPUTS_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("onFailure", ON_FAILURE_FIELD);
        map.put("timeoutSeconds", TIMEOUT_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWorkflowStepExecutionResponse, T> g) {
        return obj -> g.apply((GetWorkflowStepExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetWorkflowStepExecutionResponse> {
        /**
         * <p>
         * The request ID that uniquely identifies this request.
         * </p>
         * 
         * @param requestIdValue
         *        The request ID that uniquely identifies this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestIdValue);

        /**
         * <p>
         * The unique identifier for the runtime version of the workflow step that you specified in the request.
         * </p>
         * 
         * @param stepExecutionId
         *        The unique identifier for the runtime version of the workflow step that you specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepExecutionId(String stepExecutionId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the build version for the Image Builder workflow resource that defines this
         * workflow step.
         * </p>
         * 
         * @param workflowBuildVersionArn
         *        The Amazon Resource Name (ARN) of the build version for the Image Builder workflow resource that
         *        defines this workflow step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowBuildVersionArn(String workflowBuildVersionArn);

        /**
         * <p>
         * The unique identifier that Image Builder assigned to keep track of runtime details when it ran the workflow.
         * </p>
         * 
         * @param workflowExecutionId
         *        The unique identifier that Image Builder assigned to keep track of runtime details when it ran the
         *        workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecutionId(String workflowExecutionId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the image resource build version that the specified runtime instance of the
         * workflow step creates.
         * </p>
         * 
         * @param imageBuildVersionArn
         *        The Amazon Resource Name (ARN) of the image resource build version that the specified runtime instance
         *        of the workflow step creates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageBuildVersionArn(String imageBuildVersionArn);

        /**
         * <p>
         * The name of the specified runtime instance of the workflow step.
         * </p>
         * 
         * @param name
         *        The name of the specified runtime instance of the workflow step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Describes the specified workflow step.
         * </p>
         * 
         * @param description
         *        Describes the specified workflow step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the action that the specified step performs.
         * </p>
         * 
         * @param action
         *        The name of the action that the specified step performs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String action);

        /**
         * <p>
         * The current status for the specified runtime version of the workflow step.
         * </p>
         * 
         * @param status
         *        The current status for the specified runtime version of the workflow step.
         * @see WorkflowStepExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowStepExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status for the specified runtime version of the workflow step.
         * </p>
         * 
         * @param status
         *        The current status for the specified runtime version of the workflow step.
         * @see WorkflowStepExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowStepExecutionStatus
         */
        Builder status(WorkflowStepExecutionStatus status);

        /**
         * <p>
         * Reports on the rollback status of the specified runtime version of the workflow step, if applicable.
         * </p>
         * 
         * @param rollbackStatus
         *        Reports on the rollback status of the specified runtime version of the workflow step, if applicable.
         * @see WorkflowStepExecutionRollbackStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowStepExecutionRollbackStatus
         */
        Builder rollbackStatus(String rollbackStatus);

        /**
         * <p>
         * Reports on the rollback status of the specified runtime version of the workflow step, if applicable.
         * </p>
         * 
         * @param rollbackStatus
         *        Reports on the rollback status of the specified runtime version of the workflow step, if applicable.
         * @see WorkflowStepExecutionRollbackStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowStepExecutionRollbackStatus
         */
        Builder rollbackStatus(WorkflowStepExecutionRollbackStatus rollbackStatus);

        /**
         * <p>
         * The output message from the specified runtime instance of the workflow step, if applicable.
         * </p>
         * 
         * @param message
         *        The output message from the specified runtime instance of the workflow step, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * Input parameters that Image Builder provided for the specified runtime instance of the workflow step.
         * </p>
         * 
         * @param inputs
         *        Input parameters that Image Builder provided for the specified runtime instance of the workflow step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(String inputs);

        /**
         * <p>
         * The file names that the specified runtime version of the workflow step created as output.
         * </p>
         * 
         * @param outputs
         *        The file names that the specified runtime version of the workflow step created as output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(String outputs);

        /**
         * <p>
         * The timestamp when the specified runtime version of the workflow step started.
         * </p>
         * 
         * @param startTime
         *        The timestamp when the specified runtime version of the workflow step started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(String startTime);

        /**
         * <p>
         * The timestamp when the specified runtime instance of the workflow step finished.
         * </p>
         * 
         * @param endTime
         *        The timestamp when the specified runtime instance of the workflow step finished.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(String endTime);

        /**
         * <p>
         * The action to perform if the workflow step fails.
         * </p>
         * 
         * @param onFailure
         *        The action to perform if the workflow step fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onFailure(String onFailure);

        /**
         * <p>
         * The maximum duration in seconds for this step to complete its action.
         * </p>
         * 
         * @param timeoutSeconds
         *        The maximum duration in seconds for this step to complete its action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutSeconds(Integer timeoutSeconds);
    }

    static final class BuilderImpl extends ImagebuilderResponse.BuilderImpl implements Builder {
        private String requestIdValue;

        private String stepExecutionId;

        private String workflowBuildVersionArn;

        private String workflowExecutionId;

        private String imageBuildVersionArn;

        private String name;

        private String description;

        private String action;

        private String status;

        private String rollbackStatus;

        private String message;

        private String inputs;

        private String outputs;

        private String startTime;

        private String endTime;

        private String onFailure;

        private Integer timeoutSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowStepExecutionResponse model) {
            super(model);
            requestId(model.requestIdValue);
            stepExecutionId(model.stepExecutionId);
            workflowBuildVersionArn(model.workflowBuildVersionArn);
            workflowExecutionId(model.workflowExecutionId);
            imageBuildVersionArn(model.imageBuildVersionArn);
            name(model.name);
            description(model.description);
            action(model.action);
            status(model.status);
            rollbackStatus(model.rollbackStatus);
            message(model.message);
            inputs(model.inputs);
            outputs(model.outputs);
            startTime(model.startTime);
            endTime(model.endTime);
            onFailure(model.onFailure);
            timeoutSeconds(model.timeoutSeconds);
        }

        public final String getRequestId() {
            return requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final String getStepExecutionId() {
            return stepExecutionId;
        }

        public final void setStepExecutionId(String stepExecutionId) {
            this.stepExecutionId = stepExecutionId;
        }

        @Override
        public final Builder stepExecutionId(String stepExecutionId) {
            this.stepExecutionId = stepExecutionId;
            return this;
        }

        public final String getWorkflowBuildVersionArn() {
            return workflowBuildVersionArn;
        }

        public final void setWorkflowBuildVersionArn(String workflowBuildVersionArn) {
            this.workflowBuildVersionArn = workflowBuildVersionArn;
        }

        @Override
        public final Builder workflowBuildVersionArn(String workflowBuildVersionArn) {
            this.workflowBuildVersionArn = workflowBuildVersionArn;
            return this;
        }

        public final String getWorkflowExecutionId() {
            return workflowExecutionId;
        }

        public final void setWorkflowExecutionId(String workflowExecutionId) {
            this.workflowExecutionId = workflowExecutionId;
        }

        @Override
        public final Builder workflowExecutionId(String workflowExecutionId) {
            this.workflowExecutionId = workflowExecutionId;
            return this;
        }

        public final String getImageBuildVersionArn() {
            return imageBuildVersionArn;
        }

        public final void setImageBuildVersionArn(String imageBuildVersionArn) {
            this.imageBuildVersionArn = imageBuildVersionArn;
        }

        @Override
        public final Builder imageBuildVersionArn(String imageBuildVersionArn) {
            this.imageBuildVersionArn = imageBuildVersionArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkflowStepExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getRollbackStatus() {
            return rollbackStatus;
        }

        public final void setRollbackStatus(String rollbackStatus) {
            this.rollbackStatus = rollbackStatus;
        }

        @Override
        public final Builder rollbackStatus(String rollbackStatus) {
            this.rollbackStatus = rollbackStatus;
            return this;
        }

        @Override
        public final Builder rollbackStatus(WorkflowStepExecutionRollbackStatus rollbackStatus) {
            this.rollbackStatus(rollbackStatus == null ? null : rollbackStatus.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getInputs() {
            return inputs;
        }

        public final void setInputs(String inputs) {
            this.inputs = inputs;
        }

        @Override
        public final Builder inputs(String inputs) {
            this.inputs = inputs;
            return this;
        }

        public final String getOutputs() {
            return outputs;
        }

        public final void setOutputs(String outputs) {
            this.outputs = outputs;
        }

        @Override
        public final Builder outputs(String outputs) {
            this.outputs = outputs;
            return this;
        }

        public final String getStartTime() {
            return startTime;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getEndTime() {
            return endTime;
        }

        public final void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getOnFailure() {
            return onFailure;
        }

        public final void setOnFailure(String onFailure) {
            this.onFailure = onFailure;
        }

        @Override
        public final Builder onFailure(String onFailure) {
            this.onFailure = onFailure;
            return this;
        }

        public final Integer getTimeoutSeconds() {
            return timeoutSeconds;
        }

        public final void setTimeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
        }

        @Override
        public final Builder timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        @Override
        public GetWorkflowStepExecutionResponse build() {
            return new GetWorkflowStepExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
