/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about a vulnerability scan finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageScanFinding implements SdkPojo, Serializable,
        ToCopyableBuilder<ImageScanFinding.Builder, ImageScanFinding> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountId").getter(getter(ImageScanFinding::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()).build();

    private static final SdkField<String> IMAGE_BUILD_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageBuildVersionArn").getter(getter(ImageScanFinding::imageBuildVersionArn))
            .setter(setter(Builder::imageBuildVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageBuildVersionArn").build())
            .build();

    private static final SdkField<String> IMAGE_PIPELINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imagePipelineArn").getter(getter(ImageScanFinding::imagePipelineArn))
            .setter(setter(Builder::imagePipelineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imagePipelineArn").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ImageScanFinding::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ImageScanFinding::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(ImageScanFinding::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<Remediation> REMEDIATION_FIELD = SdkField.<Remediation> builder(MarshallingType.SDK_POJO)
            .memberName("remediation").getter(getter(ImageScanFinding::remediation)).setter(setter(Builder::remediation))
            .constructor(Remediation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remediation").build()).build();

    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("severity").getter(getter(ImageScanFinding::severity)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()).build();

    private static final SdkField<Instant> FIRST_OBSERVED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("firstObservedAt").getter(getter(ImageScanFinding::firstObservedAt))
            .setter(setter(Builder::firstObservedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstObservedAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(ImageScanFinding::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<Double> INSPECTOR_SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("inspectorScore").getter(getter(ImageScanFinding::inspectorScore))
            .setter(setter(Builder::inspectorScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inspectorScore").build()).build();

    private static final SdkField<InspectorScoreDetails> INSPECTOR_SCORE_DETAILS_FIELD = SdkField
            .<InspectorScoreDetails> builder(MarshallingType.SDK_POJO).memberName("inspectorScoreDetails")
            .getter(getter(ImageScanFinding::inspectorScoreDetails)).setter(setter(Builder::inspectorScoreDetails))
            .constructor(InspectorScoreDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inspectorScoreDetails").build())
            .build();

    private static final SdkField<PackageVulnerabilityDetails> PACKAGE_VULNERABILITY_DETAILS_FIELD = SdkField
            .<PackageVulnerabilityDetails> builder(MarshallingType.SDK_POJO)
            .memberName("packageVulnerabilityDetails")
            .getter(getter(ImageScanFinding::packageVulnerabilityDetails))
            .setter(setter(Builder::packageVulnerabilityDetails))
            .constructor(PackageVulnerabilityDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageVulnerabilityDetails")
                    .build()).build();

    private static final SdkField<String> FIX_AVAILABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fixAvailable").getter(getter(ImageScanFinding::fixAvailable)).setter(setter(Builder::fixAvailable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixAvailable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            IMAGE_BUILD_VERSION_ARN_FIELD, IMAGE_PIPELINE_ARN_FIELD, TYPE_FIELD, DESCRIPTION_FIELD, TITLE_FIELD,
            REMEDIATION_FIELD, SEVERITY_FIELD, FIRST_OBSERVED_AT_FIELD, UPDATED_AT_FIELD, INSPECTOR_SCORE_FIELD,
            INSPECTOR_SCORE_DETAILS_FIELD, PACKAGE_VULNERABILITY_DETAILS_FIELD, FIX_AVAILABLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String awsAccountId;

    private final String imageBuildVersionArn;

    private final String imagePipelineArn;

    private final String type;

    private final String description;

    private final String title;

    private final Remediation remediation;

    private final String severity;

    private final Instant firstObservedAt;

    private final Instant updatedAt;

    private final Double inspectorScore;

    private final InspectorScoreDetails inspectorScoreDetails;

    private final PackageVulnerabilityDetails packageVulnerabilityDetails;

    private final String fixAvailable;

    private ImageScanFinding(BuilderImpl builder) {
        this.awsAccountId = builder.awsAccountId;
        this.imageBuildVersionArn = builder.imageBuildVersionArn;
        this.imagePipelineArn = builder.imagePipelineArn;
        this.type = builder.type;
        this.description = builder.description;
        this.title = builder.title;
        this.remediation = builder.remediation;
        this.severity = builder.severity;
        this.firstObservedAt = builder.firstObservedAt;
        this.updatedAt = builder.updatedAt;
        this.inspectorScore = builder.inspectorScore;
        this.inspectorScoreDetails = builder.inspectorScoreDetails;
        this.packageVulnerabilityDetails = builder.packageVulnerabilityDetails;
        this.fixAvailable = builder.fixAvailable;
    }

    /**
     * <p>
     * The Amazon Web Services account ID that's associated with the finding.
     * </p>
     * 
     * @return The Amazon Web Services account ID that's associated with the finding.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the image build version that's associated with the finding.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the image build version that's associated with the finding.
     */
    public final String imageBuildVersionArn() {
        return imageBuildVersionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the image pipeline that's associated with the finding.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the image pipeline that's associated with the finding.
     */
    public final String imagePipelineArn() {
        return imagePipelineArn;
    }

    /**
     * <p>
     * The type of the finding. Image Builder looks for findings of the type <code>PACKAGE_VULNERABILITY</code> that
     * apply to output images, and excludes other types.
     * </p>
     * 
     * @return The type of the finding. Image Builder looks for findings of the type <code>PACKAGE_VULNERABILITY</code>
     *         that apply to output images, and excludes other types.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The description of the finding.
     * </p>
     * 
     * @return The description of the finding.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The title of the finding.
     * </p>
     * 
     * @return The title of the finding.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * An object that contains the details about how to remediate the finding.
     * </p>
     * 
     * @return An object that contains the details about how to remediate the finding.
     */
    public final Remediation remediation() {
        return remediation;
    }

    /**
     * <p>
     * The severity of the finding.
     * </p>
     * 
     * @return The severity of the finding.
     */
    public final String severity() {
        return severity;
    }

    /**
     * <p>
     * The date and time when the finding was first observed.
     * </p>
     * 
     * @return The date and time when the finding was first observed.
     */
    public final Instant firstObservedAt() {
        return firstObservedAt;
    }

    /**
     * <p>
     * The timestamp when the finding was last updated.
     * </p>
     * 
     * @return The timestamp when the finding was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The score that Amazon Inspector assigned for the finding.
     * </p>
     * 
     * @return The score that Amazon Inspector assigned for the finding.
     */
    public final Double inspectorScore() {
        return inspectorScore;
    }

    /**
     * <p>
     * An object that contains details of the Amazon Inspector score.
     * </p>
     * 
     * @return An object that contains details of the Amazon Inspector score.
     */
    public final InspectorScoreDetails inspectorScoreDetails() {
        return inspectorScoreDetails;
    }

    /**
     * <p>
     * An object that contains the details of a package vulnerability finding.
     * </p>
     * 
     * @return An object that contains the details of a package vulnerability finding.
     */
    public final PackageVulnerabilityDetails packageVulnerabilityDetails() {
        return packageVulnerabilityDetails;
    }

    /**
     * <p>
     * Details about whether a fix is available for any of the packages that are identified in the finding through a
     * version update.
     * </p>
     * 
     * @return Details about whether a fix is available for any of the packages that are identified in the finding
     *         through a version update.
     */
    public final String fixAvailable() {
        return fixAvailable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(imageBuildVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(imagePipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(remediation());
        hashCode = 31 * hashCode + Objects.hashCode(severity());
        hashCode = 31 * hashCode + Objects.hashCode(firstObservedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(inspectorScore());
        hashCode = 31 * hashCode + Objects.hashCode(inspectorScoreDetails());
        hashCode = 31 * hashCode + Objects.hashCode(packageVulnerabilityDetails());
        hashCode = 31 * hashCode + Objects.hashCode(fixAvailable());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageScanFinding)) {
            return false;
        }
        ImageScanFinding other = (ImageScanFinding) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(imageBuildVersionArn(), other.imageBuildVersionArn())
                && Objects.equals(imagePipelineArn(), other.imagePipelineArn()) && Objects.equals(type(), other.type())
                && Objects.equals(description(), other.description()) && Objects.equals(title(), other.title())
                && Objects.equals(remediation(), other.remediation()) && Objects.equals(severity(), other.severity())
                && Objects.equals(firstObservedAt(), other.firstObservedAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(inspectorScore(), other.inspectorScore())
                && Objects.equals(inspectorScoreDetails(), other.inspectorScoreDetails())
                && Objects.equals(packageVulnerabilityDetails(), other.packageVulnerabilityDetails())
                && Objects.equals(fixAvailable(), other.fixAvailable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageScanFinding").add("AwsAccountId", awsAccountId())
                .add("ImageBuildVersionArn", imageBuildVersionArn()).add("ImagePipelineArn", imagePipelineArn())
                .add("Type", type()).add("Description", description()).add("Title", title()).add("Remediation", remediation())
                .add("Severity", severity()).add("FirstObservedAt", firstObservedAt()).add("UpdatedAt", updatedAt())
                .add("InspectorScore", inspectorScore()).add("InspectorScoreDetails", inspectorScoreDetails())
                .add("PackageVulnerabilityDetails", packageVulnerabilityDetails()).add("FixAvailable", fixAvailable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "imageBuildVersionArn":
            return Optional.ofNullable(clazz.cast(imageBuildVersionArn()));
        case "imagePipelineArn":
            return Optional.ofNullable(clazz.cast(imagePipelineArn()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "remediation":
            return Optional.ofNullable(clazz.cast(remediation()));
        case "severity":
            return Optional.ofNullable(clazz.cast(severity()));
        case "firstObservedAt":
            return Optional.ofNullable(clazz.cast(firstObservedAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "inspectorScore":
            return Optional.ofNullable(clazz.cast(inspectorScore()));
        case "inspectorScoreDetails":
            return Optional.ofNullable(clazz.cast(inspectorScoreDetails()));
        case "packageVulnerabilityDetails":
            return Optional.ofNullable(clazz.cast(packageVulnerabilityDetails()));
        case "fixAvailable":
            return Optional.ofNullable(clazz.cast(fixAvailable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("awsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("imageBuildVersionArn", IMAGE_BUILD_VERSION_ARN_FIELD);
        map.put("imagePipelineArn", IMAGE_PIPELINE_ARN_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("title", TITLE_FIELD);
        map.put("remediation", REMEDIATION_FIELD);
        map.put("severity", SEVERITY_FIELD);
        map.put("firstObservedAt", FIRST_OBSERVED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("inspectorScore", INSPECTOR_SCORE_FIELD);
        map.put("inspectorScoreDetails", INSPECTOR_SCORE_DETAILS_FIELD);
        map.put("packageVulnerabilityDetails", PACKAGE_VULNERABILITY_DETAILS_FIELD);
        map.put("fixAvailable", FIX_AVAILABLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageScanFinding, T> g) {
        return obj -> g.apply((ImageScanFinding) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageScanFinding> {
        /**
         * <p>
         * The Amazon Web Services account ID that's associated with the finding.
         * </p>
         * 
         * @param awsAccountId
         *        The Amazon Web Services account ID that's associated with the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the image build version that's associated with the finding.
         * </p>
         * 
         * @param imageBuildVersionArn
         *        The Amazon Resource Name (ARN) of the image build version that's associated with the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageBuildVersionArn(String imageBuildVersionArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the image pipeline that's associated with the finding.
         * </p>
         * 
         * @param imagePipelineArn
         *        The Amazon Resource Name (ARN) of the image pipeline that's associated with the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imagePipelineArn(String imagePipelineArn);

        /**
         * <p>
         * The type of the finding. Image Builder looks for findings of the type <code>PACKAGE_VULNERABILITY</code> that
         * apply to output images, and excludes other types.
         * </p>
         * 
         * @param type
         *        The type of the finding. Image Builder looks for findings of the type
         *        <code>PACKAGE_VULNERABILITY</code> that apply to output images, and excludes other types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The description of the finding.
         * </p>
         * 
         * @param description
         *        The description of the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The title of the finding.
         * </p>
         * 
         * @param title
         *        The title of the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * An object that contains the details about how to remediate the finding.
         * </p>
         * 
         * @param remediation
         *        An object that contains the details about how to remediate the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediation(Remediation remediation);

        /**
         * <p>
         * An object that contains the details about how to remediate the finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link Remediation.Builder} avoiding the need to
         * create one manually via {@link Remediation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Remediation.Builder#build()} is called immediately and its result
         * is passed to {@link #remediation(Remediation)}.
         * 
         * @param remediation
         *        a consumer that will call methods on {@link Remediation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remediation(Remediation)
         */
        default Builder remediation(Consumer<Remediation.Builder> remediation) {
            return remediation(Remediation.builder().applyMutation(remediation).build());
        }

        /**
         * <p>
         * The severity of the finding.
         * </p>
         * 
         * @param severity
         *        The severity of the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severity(String severity);

        /**
         * <p>
         * The date and time when the finding was first observed.
         * </p>
         * 
         * @param firstObservedAt
         *        The date and time when the finding was first observed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstObservedAt(Instant firstObservedAt);

        /**
         * <p>
         * The timestamp when the finding was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when the finding was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The score that Amazon Inspector assigned for the finding.
         * </p>
         * 
         * @param inspectorScore
         *        The score that Amazon Inspector assigned for the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inspectorScore(Double inspectorScore);

        /**
         * <p>
         * An object that contains details of the Amazon Inspector score.
         * </p>
         * 
         * @param inspectorScoreDetails
         *        An object that contains details of the Amazon Inspector score.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inspectorScoreDetails(InspectorScoreDetails inspectorScoreDetails);

        /**
         * <p>
         * An object that contains details of the Amazon Inspector score.
         * </p>
         * This is a convenience method that creates an instance of the {@link InspectorScoreDetails.Builder} avoiding
         * the need to create one manually via {@link InspectorScoreDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InspectorScoreDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #inspectorScoreDetails(InspectorScoreDetails)}.
         * 
         * @param inspectorScoreDetails
         *        a consumer that will call methods on {@link InspectorScoreDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inspectorScoreDetails(InspectorScoreDetails)
         */
        default Builder inspectorScoreDetails(Consumer<InspectorScoreDetails.Builder> inspectorScoreDetails) {
            return inspectorScoreDetails(InspectorScoreDetails.builder().applyMutation(inspectorScoreDetails).build());
        }

        /**
         * <p>
         * An object that contains the details of a package vulnerability finding.
         * </p>
         * 
         * @param packageVulnerabilityDetails
         *        An object that contains the details of a package vulnerability finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageVulnerabilityDetails(PackageVulnerabilityDetails packageVulnerabilityDetails);

        /**
         * <p>
         * An object that contains the details of a package vulnerability finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link PackageVulnerabilityDetails.Builder}
         * avoiding the need to create one manually via {@link PackageVulnerabilityDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PackageVulnerabilityDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #packageVulnerabilityDetails(PackageVulnerabilityDetails)}.
         * 
         * @param packageVulnerabilityDetails
         *        a consumer that will call methods on {@link PackageVulnerabilityDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packageVulnerabilityDetails(PackageVulnerabilityDetails)
         */
        default Builder packageVulnerabilityDetails(Consumer<PackageVulnerabilityDetails.Builder> packageVulnerabilityDetails) {
            return packageVulnerabilityDetails(PackageVulnerabilityDetails.builder().applyMutation(packageVulnerabilityDetails)
                    .build());
        }

        /**
         * <p>
         * Details about whether a fix is available for any of the packages that are identified in the finding through a
         * version update.
         * </p>
         * 
         * @param fixAvailable
         *        Details about whether a fix is available for any of the packages that are identified in the finding
         *        through a version update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixAvailable(String fixAvailable);
    }

    static final class BuilderImpl implements Builder {
        private String awsAccountId;

        private String imageBuildVersionArn;

        private String imagePipelineArn;

        private String type;

        private String description;

        private String title;

        private Remediation remediation;

        private String severity;

        private Instant firstObservedAt;

        private Instant updatedAt;

        private Double inspectorScore;

        private InspectorScoreDetails inspectorScoreDetails;

        private PackageVulnerabilityDetails packageVulnerabilityDetails;

        private String fixAvailable;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageScanFinding model) {
            awsAccountId(model.awsAccountId);
            imageBuildVersionArn(model.imageBuildVersionArn);
            imagePipelineArn(model.imagePipelineArn);
            type(model.type);
            description(model.description);
            title(model.title);
            remediation(model.remediation);
            severity(model.severity);
            firstObservedAt(model.firstObservedAt);
            updatedAt(model.updatedAt);
            inspectorScore(model.inspectorScore);
            inspectorScoreDetails(model.inspectorScoreDetails);
            packageVulnerabilityDetails(model.packageVulnerabilityDetails);
            fixAvailable(model.fixAvailable);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getImageBuildVersionArn() {
            return imageBuildVersionArn;
        }

        public final void setImageBuildVersionArn(String imageBuildVersionArn) {
            this.imageBuildVersionArn = imageBuildVersionArn;
        }

        @Override
        public final Builder imageBuildVersionArn(String imageBuildVersionArn) {
            this.imageBuildVersionArn = imageBuildVersionArn;
            return this;
        }

        public final String getImagePipelineArn() {
            return imagePipelineArn;
        }

        public final void setImagePipelineArn(String imagePipelineArn) {
            this.imagePipelineArn = imagePipelineArn;
        }

        @Override
        public final Builder imagePipelineArn(String imagePipelineArn) {
            this.imagePipelineArn = imagePipelineArn;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final Remediation.Builder getRemediation() {
            return remediation != null ? remediation.toBuilder() : null;
        }

        public final void setRemediation(Remediation.BuilderImpl remediation) {
            this.remediation = remediation != null ? remediation.build() : null;
        }

        @Override
        public final Builder remediation(Remediation remediation) {
            this.remediation = remediation;
            return this;
        }

        public final String getSeverity() {
            return severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public final Instant getFirstObservedAt() {
            return firstObservedAt;
        }

        public final void setFirstObservedAt(Instant firstObservedAt) {
            this.firstObservedAt = firstObservedAt;
        }

        @Override
        public final Builder firstObservedAt(Instant firstObservedAt) {
            this.firstObservedAt = firstObservedAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Double getInspectorScore() {
            return inspectorScore;
        }

        public final void setInspectorScore(Double inspectorScore) {
            this.inspectorScore = inspectorScore;
        }

        @Override
        public final Builder inspectorScore(Double inspectorScore) {
            this.inspectorScore = inspectorScore;
            return this;
        }

        public final InspectorScoreDetails.Builder getInspectorScoreDetails() {
            return inspectorScoreDetails != null ? inspectorScoreDetails.toBuilder() : null;
        }

        public final void setInspectorScoreDetails(InspectorScoreDetails.BuilderImpl inspectorScoreDetails) {
            this.inspectorScoreDetails = inspectorScoreDetails != null ? inspectorScoreDetails.build() : null;
        }

        @Override
        public final Builder inspectorScoreDetails(InspectorScoreDetails inspectorScoreDetails) {
            this.inspectorScoreDetails = inspectorScoreDetails;
            return this;
        }

        public final PackageVulnerabilityDetails.Builder getPackageVulnerabilityDetails() {
            return packageVulnerabilityDetails != null ? packageVulnerabilityDetails.toBuilder() : null;
        }

        public final void setPackageVulnerabilityDetails(PackageVulnerabilityDetails.BuilderImpl packageVulnerabilityDetails) {
            this.packageVulnerabilityDetails = packageVulnerabilityDetails != null ? packageVulnerabilityDetails.build() : null;
        }

        @Override
        public final Builder packageVulnerabilityDetails(PackageVulnerabilityDetails packageVulnerabilityDetails) {
            this.packageVulnerabilityDetails = packageVulnerabilityDetails;
            return this;
        }

        public final String getFixAvailable() {
            return fixAvailable;
        }

        public final void setFixAvailable(String fixAvailable) {
            this.fixAvailable = fixAvailable;
        }

        @Override
        public final Builder fixAvailable(String fixAvailable) {
            this.fixAvailable = fixAvailable;
            return this;
        }

        @Override
        public ImageScanFinding build() {
            return new ImageScanFinding(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
