/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This returns exactly one type of aggregation, based on the filter that Image Builder applies in its API action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageScanFindingAggregation implements SdkPojo, Serializable,
        ToCopyableBuilder<ImageScanFindingAggregation.Builder, ImageScanFindingAggregation> {
    private static final SdkField<AccountAggregation> ACCOUNT_AGGREGATION_FIELD = SdkField
            .<AccountAggregation> builder(MarshallingType.SDK_POJO).memberName("accountAggregation")
            .getter(getter(ImageScanFindingAggregation::accountAggregation)).setter(setter(Builder::accountAggregation))
            .constructor(AccountAggregation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountAggregation").build())
            .build();

    private static final SdkField<ImageAggregation> IMAGE_AGGREGATION_FIELD = SdkField
            .<ImageAggregation> builder(MarshallingType.SDK_POJO).memberName("imageAggregation")
            .getter(getter(ImageScanFindingAggregation::imageAggregation)).setter(setter(Builder::imageAggregation))
            .constructor(ImageAggregation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageAggregation").build()).build();

    private static final SdkField<ImagePipelineAggregation> IMAGE_PIPELINE_AGGREGATION_FIELD = SdkField
            .<ImagePipelineAggregation> builder(MarshallingType.SDK_POJO).memberName("imagePipelineAggregation")
            .getter(getter(ImageScanFindingAggregation::imagePipelineAggregation))
            .setter(setter(Builder::imagePipelineAggregation)).constructor(ImagePipelineAggregation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imagePipelineAggregation").build())
            .build();

    private static final SdkField<VulnerabilityIdAggregation> VULNERABILITY_ID_AGGREGATION_FIELD = SdkField
            .<VulnerabilityIdAggregation> builder(MarshallingType.SDK_POJO)
            .memberName("vulnerabilityIdAggregation")
            .getter(getter(ImageScanFindingAggregation::vulnerabilityIdAggregation))
            .setter(setter(Builder::vulnerabilityIdAggregation))
            .constructor(VulnerabilityIdAggregation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vulnerabilityIdAggregation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_AGGREGATION_FIELD,
            IMAGE_AGGREGATION_FIELD, IMAGE_PIPELINE_AGGREGATION_FIELD, VULNERABILITY_ID_AGGREGATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AccountAggregation accountAggregation;

    private final ImageAggregation imageAggregation;

    private final ImagePipelineAggregation imagePipelineAggregation;

    private final VulnerabilityIdAggregation vulnerabilityIdAggregation;

    private ImageScanFindingAggregation(BuilderImpl builder) {
        this.accountAggregation = builder.accountAggregation;
        this.imageAggregation = builder.imageAggregation;
        this.imagePipelineAggregation = builder.imagePipelineAggregation;
        this.vulnerabilityIdAggregation = builder.vulnerabilityIdAggregation;
    }

    /**
     * <p>
     * Returns an object that contains severity counts based on an account ID.
     * </p>
     * 
     * @return Returns an object that contains severity counts based on an account ID.
     */
    public final AccountAggregation accountAggregation() {
        return accountAggregation;
    }

    /**
     * <p>
     * Returns an object that contains severity counts based on the Amazon Resource Name (ARN) for a specific image.
     * </p>
     * 
     * @return Returns an object that contains severity counts based on the Amazon Resource Name (ARN) for a specific
     *         image.
     */
    public final ImageAggregation imageAggregation() {
        return imageAggregation;
    }

    /**
     * <p>
     * Returns an object that contains severity counts based on an image pipeline ARN.
     * </p>
     * 
     * @return Returns an object that contains severity counts based on an image pipeline ARN.
     */
    public final ImagePipelineAggregation imagePipelineAggregation() {
        return imagePipelineAggregation;
    }

    /**
     * <p>
     * Returns an object that contains severity counts based on vulnerability ID.
     * </p>
     * 
     * @return Returns an object that contains severity counts based on vulnerability ID.
     */
    public final VulnerabilityIdAggregation vulnerabilityIdAggregation() {
        return vulnerabilityIdAggregation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(imageAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(imagePipelineAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(vulnerabilityIdAggregation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageScanFindingAggregation)) {
            return false;
        }
        ImageScanFindingAggregation other = (ImageScanFindingAggregation) obj;
        return Objects.equals(accountAggregation(), other.accountAggregation())
                && Objects.equals(imageAggregation(), other.imageAggregation())
                && Objects.equals(imagePipelineAggregation(), other.imagePipelineAggregation())
                && Objects.equals(vulnerabilityIdAggregation(), other.vulnerabilityIdAggregation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageScanFindingAggregation").add("AccountAggregation", accountAggregation())
                .add("ImageAggregation", imageAggregation()).add("ImagePipelineAggregation", imagePipelineAggregation())
                .add("VulnerabilityIdAggregation", vulnerabilityIdAggregation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountAggregation":
            return Optional.ofNullable(clazz.cast(accountAggregation()));
        case "imageAggregation":
            return Optional.ofNullable(clazz.cast(imageAggregation()));
        case "imagePipelineAggregation":
            return Optional.ofNullable(clazz.cast(imagePipelineAggregation()));
        case "vulnerabilityIdAggregation":
            return Optional.ofNullable(clazz.cast(vulnerabilityIdAggregation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountAggregation", ACCOUNT_AGGREGATION_FIELD);
        map.put("imageAggregation", IMAGE_AGGREGATION_FIELD);
        map.put("imagePipelineAggregation", IMAGE_PIPELINE_AGGREGATION_FIELD);
        map.put("vulnerabilityIdAggregation", VULNERABILITY_ID_AGGREGATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageScanFindingAggregation, T> g) {
        return obj -> g.apply((ImageScanFindingAggregation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageScanFindingAggregation> {
        /**
         * <p>
         * Returns an object that contains severity counts based on an account ID.
         * </p>
         * 
         * @param accountAggregation
         *        Returns an object that contains severity counts based on an account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountAggregation(AccountAggregation accountAggregation);

        /**
         * <p>
         * Returns an object that contains severity counts based on an account ID.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccountAggregation.Builder} avoiding the
         * need to create one manually via {@link AccountAggregation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccountAggregation.Builder#build()} is called immediately and its
         * result is passed to {@link #accountAggregation(AccountAggregation)}.
         * 
         * @param accountAggregation
         *        a consumer that will call methods on {@link AccountAggregation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountAggregation(AccountAggregation)
         */
        default Builder accountAggregation(Consumer<AccountAggregation.Builder> accountAggregation) {
            return accountAggregation(AccountAggregation.builder().applyMutation(accountAggregation).build());
        }

        /**
         * <p>
         * Returns an object that contains severity counts based on the Amazon Resource Name (ARN) for a specific image.
         * </p>
         * 
         * @param imageAggregation
         *        Returns an object that contains severity counts based on the Amazon Resource Name (ARN) for a specific
         *        image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageAggregation(ImageAggregation imageAggregation);

        /**
         * <p>
         * Returns an object that contains severity counts based on the Amazon Resource Name (ARN) for a specific image.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageAggregation.Builder} avoiding the
         * need to create one manually via {@link ImageAggregation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageAggregation.Builder#build()} is called immediately and its
         * result is passed to {@link #imageAggregation(ImageAggregation)}.
         * 
         * @param imageAggregation
         *        a consumer that will call methods on {@link ImageAggregation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageAggregation(ImageAggregation)
         */
        default Builder imageAggregation(Consumer<ImageAggregation.Builder> imageAggregation) {
            return imageAggregation(ImageAggregation.builder().applyMutation(imageAggregation).build());
        }

        /**
         * <p>
         * Returns an object that contains severity counts based on an image pipeline ARN.
         * </p>
         * 
         * @param imagePipelineAggregation
         *        Returns an object that contains severity counts based on an image pipeline ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imagePipelineAggregation(ImagePipelineAggregation imagePipelineAggregation);

        /**
         * <p>
         * Returns an object that contains severity counts based on an image pipeline ARN.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImagePipelineAggregation.Builder}
         * avoiding the need to create one manually via {@link ImagePipelineAggregation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImagePipelineAggregation.Builder#build()} is called immediately
         * and its result is passed to {@link #imagePipelineAggregation(ImagePipelineAggregation)}.
         * 
         * @param imagePipelineAggregation
         *        a consumer that will call methods on {@link ImagePipelineAggregation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imagePipelineAggregation(ImagePipelineAggregation)
         */
        default Builder imagePipelineAggregation(Consumer<ImagePipelineAggregation.Builder> imagePipelineAggregation) {
            return imagePipelineAggregation(ImagePipelineAggregation.builder().applyMutation(imagePipelineAggregation).build());
        }

        /**
         * <p>
         * Returns an object that contains severity counts based on vulnerability ID.
         * </p>
         * 
         * @param vulnerabilityIdAggregation
         *        Returns an object that contains severity counts based on vulnerability ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vulnerabilityIdAggregation(VulnerabilityIdAggregation vulnerabilityIdAggregation);

        /**
         * <p>
         * Returns an object that contains severity counts based on vulnerability ID.
         * </p>
         * This is a convenience method that creates an instance of the {@link VulnerabilityIdAggregation.Builder}
         * avoiding the need to create one manually via {@link VulnerabilityIdAggregation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VulnerabilityIdAggregation.Builder#build()} is called immediately
         * and its result is passed to {@link #vulnerabilityIdAggregation(VulnerabilityIdAggregation)}.
         * 
         * @param vulnerabilityIdAggregation
         *        a consumer that will call methods on {@link VulnerabilityIdAggregation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vulnerabilityIdAggregation(VulnerabilityIdAggregation)
         */
        default Builder vulnerabilityIdAggregation(Consumer<VulnerabilityIdAggregation.Builder> vulnerabilityIdAggregation) {
            return vulnerabilityIdAggregation(VulnerabilityIdAggregation.builder().applyMutation(vulnerabilityIdAggregation)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AccountAggregation accountAggregation;

        private ImageAggregation imageAggregation;

        private ImagePipelineAggregation imagePipelineAggregation;

        private VulnerabilityIdAggregation vulnerabilityIdAggregation;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageScanFindingAggregation model) {
            accountAggregation(model.accountAggregation);
            imageAggregation(model.imageAggregation);
            imagePipelineAggregation(model.imagePipelineAggregation);
            vulnerabilityIdAggregation(model.vulnerabilityIdAggregation);
        }

        public final AccountAggregation.Builder getAccountAggregation() {
            return accountAggregation != null ? accountAggregation.toBuilder() : null;
        }

        public final void setAccountAggregation(AccountAggregation.BuilderImpl accountAggregation) {
            this.accountAggregation = accountAggregation != null ? accountAggregation.build() : null;
        }

        @Override
        public final Builder accountAggregation(AccountAggregation accountAggregation) {
            this.accountAggregation = accountAggregation;
            return this;
        }

        public final ImageAggregation.Builder getImageAggregation() {
            return imageAggregation != null ? imageAggregation.toBuilder() : null;
        }

        public final void setImageAggregation(ImageAggregation.BuilderImpl imageAggregation) {
            this.imageAggregation = imageAggregation != null ? imageAggregation.build() : null;
        }

        @Override
        public final Builder imageAggregation(ImageAggregation imageAggregation) {
            this.imageAggregation = imageAggregation;
            return this;
        }

        public final ImagePipelineAggregation.Builder getImagePipelineAggregation() {
            return imagePipelineAggregation != null ? imagePipelineAggregation.toBuilder() : null;
        }

        public final void setImagePipelineAggregation(ImagePipelineAggregation.BuilderImpl imagePipelineAggregation) {
            this.imagePipelineAggregation = imagePipelineAggregation != null ? imagePipelineAggregation.build() : null;
        }

        @Override
        public final Builder imagePipelineAggregation(ImagePipelineAggregation imagePipelineAggregation) {
            this.imagePipelineAggregation = imagePipelineAggregation;
            return this;
        }

        public final VulnerabilityIdAggregation.Builder getVulnerabilityIdAggregation() {
            return vulnerabilityIdAggregation != null ? vulnerabilityIdAggregation.toBuilder() : null;
        }

        public final void setVulnerabilityIdAggregation(VulnerabilityIdAggregation.BuilderImpl vulnerabilityIdAggregation) {
            this.vulnerabilityIdAggregation = vulnerabilityIdAggregation != null ? vulnerabilityIdAggregation.build() : null;
        }

        @Override
        public final Builder vulnerabilityIdAggregation(VulnerabilityIdAggregation vulnerabilityIdAggregation) {
            this.vulnerabilityIdAggregation = vulnerabilityIdAggregation;
            return this;
        }

        @Override
        public ImageScanFindingAggregation build() {
            return new ImageScanFindingAggregation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
