/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configure image tests for your pipeline build. Tests run after building the image, to verify that the AMI or
 * container image is valid before distributing it.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageTestsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ImageTestsConfiguration.Builder, ImageTestsConfiguration> {
    private static final SdkField<Boolean> IMAGE_TESTS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("imageTestsEnabled").getter(getter(ImageTestsConfiguration::imageTestsEnabled))
            .setter(setter(Builder::imageTestsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTestsEnabled").build()).build();

    private static final SdkField<Integer> TIMEOUT_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("timeoutMinutes").getter(getter(ImageTestsConfiguration::timeoutMinutes))
            .setter(setter(Builder::timeoutMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutMinutes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_TESTS_ENABLED_FIELD,
            TIMEOUT_MINUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean imageTestsEnabled;

    private final Integer timeoutMinutes;

    private ImageTestsConfiguration(BuilderImpl builder) {
        this.imageTestsEnabled = builder.imageTestsEnabled;
        this.timeoutMinutes = builder.timeoutMinutes;
    }

    /**
     * <p>
     * Determines if tests should run after building the image. Image Builder defaults to enable tests to run following
     * the image build, before image distribution.
     * </p>
     * 
     * @return Determines if tests should run after building the image. Image Builder defaults to enable tests to run
     *         following the image build, before image distribution.
     */
    public final Boolean imageTestsEnabled() {
        return imageTestsEnabled;
    }

    /**
     * <p>
     * The maximum time in minutes that tests are permitted to run.
     * </p>
     * <note>
     * <p>
     * The timeout property is not currently active. This value is ignored.
     * </p>
     * </note>
     * 
     * @return The maximum time in minutes that tests are permitted to run.</p> <note>
     *         <p>
     *         The timeout property is not currently active. This value is ignored.
     *         </p>
     */
    public final Integer timeoutMinutes() {
        return timeoutMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageTestsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageTestsConfiguration)) {
            return false;
        }
        ImageTestsConfiguration other = (ImageTestsConfiguration) obj;
        return Objects.equals(imageTestsEnabled(), other.imageTestsEnabled())
                && Objects.equals(timeoutMinutes(), other.timeoutMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageTestsConfiguration").add("ImageTestsEnabled", imageTestsEnabled())
                .add("TimeoutMinutes", timeoutMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "imageTestsEnabled":
            return Optional.ofNullable(clazz.cast(imageTestsEnabled()));
        case "timeoutMinutes":
            return Optional.ofNullable(clazz.cast(timeoutMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("imageTestsEnabled", IMAGE_TESTS_ENABLED_FIELD);
        map.put("timeoutMinutes", TIMEOUT_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageTestsConfiguration, T> g) {
        return obj -> g.apply((ImageTestsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageTestsConfiguration> {
        /**
         * <p>
         * Determines if tests should run after building the image. Image Builder defaults to enable tests to run
         * following the image build, before image distribution.
         * </p>
         * 
         * @param imageTestsEnabled
         *        Determines if tests should run after building the image. Image Builder defaults to enable tests to run
         *        following the image build, before image distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageTestsEnabled(Boolean imageTestsEnabled);

        /**
         * <p>
         * The maximum time in minutes that tests are permitted to run.
         * </p>
         * <note>
         * <p>
         * The timeout property is not currently active. This value is ignored.
         * </p>
         * </note>
         * 
         * @param timeoutMinutes
         *        The maximum time in minutes that tests are permitted to run.</p> <note>
         *        <p>
         *        The timeout property is not currently active. This value is ignored.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutMinutes(Integer timeoutMinutes);
    }

    static final class BuilderImpl implements Builder {
        private Boolean imageTestsEnabled;

        private Integer timeoutMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageTestsConfiguration model) {
            imageTestsEnabled(model.imageTestsEnabled);
            timeoutMinutes(model.timeoutMinutes);
        }

        public final Boolean getImageTestsEnabled() {
            return imageTestsEnabled;
        }

        public final void setImageTestsEnabled(Boolean imageTestsEnabled) {
            this.imageTestsEnabled = imageTestsEnabled;
        }

        @Override
        public final Builder imageTestsEnabled(Boolean imageTestsEnabled) {
            this.imageTestsEnabled = imageTestsEnabled;
            return this;
        }

        public final Integer getTimeoutMinutes() {
            return timeoutMinutes;
        }

        public final void setTimeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
        }

        @Override
        public final Builder timeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
            return this;
        }

        @Override
        public ImageTestsConfiguration build() {
            return new ImageTestsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
