/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportVmImageRequest extends ImagebuilderRequest implements
        ToCopyableBuilder<ImportVmImageRequest.Builder, ImportVmImageRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ImportVmImageRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SEMANTIC_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("semanticVersion").getter(getter(ImportVmImageRequest::semanticVersion))
            .setter(setter(Builder::semanticVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticVersion").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ImportVmImageRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platform").getter(getter(ImportVmImageRequest::platformAsString)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final SdkField<String> OS_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("osVersion").getter(getter(ImportVmImageRequest::osVersion)).setter(setter(Builder::osVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("osVersion").build()).build();

    private static final SdkField<String> VM_IMPORT_TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vmImportTaskId").getter(getter(ImportVmImageRequest::vmImportTaskId))
            .setter(setter(Builder::vmImportTaskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vmImportTaskId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(ImportVmImageRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(ImportVmImageRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            SEMANTIC_VERSION_FIELD, DESCRIPTION_FIELD, PLATFORM_FIELD, OS_VERSION_FIELD, VM_IMPORT_TASK_ID_FIELD, TAGS_FIELD,
            CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String semanticVersion;

    private final String description;

    private final String platform;

    private final String osVersion;

    private final String vmImportTaskId;

    private final Map<String, String> tags;

    private final String clientToken;

    private ImportVmImageRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.semanticVersion = builder.semanticVersion;
        this.description = builder.description;
        this.platform = builder.platform;
        this.osVersion = builder.osVersion;
        this.vmImportTaskId = builder.vmImportTaskId;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name of the base image that is created by the import process.
     * </p>
     * 
     * @return The name of the base image that is created by the import process.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The semantic version to attach to the base image that was created during the import process. This version follows
     * the semantic version syntax.
     * </p>
     * <note>
     * <p>
     * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
     * values for the first three, and can filter on all of them.
     * </p>
     * <p>
     * <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an
     * upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the
     * fourth node.
     * </p>
     * <p>
     * <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that
     * you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as
     * 2021.01.01.
     * </p>
     * </note>
     * 
     * @return The semantic version to attach to the base image that was created during the import process. This version
     *         follows the semantic version syntax.</p> <note>
     *         <p>
     *         The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can
     *         assign values for the first three, and can filter on all of them.
     *         </p>
     *         <p>
     *         <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero,
     *         with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build
     *         number to the fourth node.
     *         </p>
     *         <p>
     *         <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the
     *         nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a
     *         date, such as 2021.01.01.
     *         </p>
     */
    public final String semanticVersion() {
        return semanticVersion;
    }

    /**
     * <p>
     * The description for the base image that is created by the import process.
     * </p>
     * 
     * @return The description for the base image that is created by the import process.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The operating system platform for the imported VM.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The operating system platform for the imported VM.
     * @see Platform
     */
    public final Platform platform() {
        return Platform.fromValue(platform);
    }

    /**
     * <p>
     * The operating system platform for the imported VM.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The operating system platform for the imported VM.
     * @see Platform
     */
    public final String platformAsString() {
        return platform;
    }

    /**
     * <p>
     * The operating system version for the imported VM.
     * </p>
     * 
     * @return The operating system version for the imported VM.
     */
    public final String osVersion() {
        return osVersion;
    }

    /**
     * <p>
     * The <code>importTaskId</code> (API) or <code>ImportTaskId</code> (CLI) from the Amazon EC2 VM import process.
     * Image Builder retrieves information from the import process to pull in the AMI that is created from the VM source
     * as the base image for your recipe.
     * </p>
     * 
     * @return The <code>importTaskId</code> (API) or <code>ImportTaskId</code> (CLI) from the Amazon EC2 VM import
     *         process. Image Builder retrieves information from the import process to pull in the AMI that is created
     *         from the VM source as the base image for your recipe.
     */
    public final String vmImportTaskId() {
        return vmImportTaskId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags that are attached to the import resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags that are attached to the import resources.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * idempotency</a> in the <i>Amazon EC2 API Reference</i>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information,
     *         see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         idempotency</a> in the <i>Amazon EC2 API Reference</i>.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(osVersion());
        hashCode = 31 * hashCode + Objects.hashCode(vmImportTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportVmImageRequest)) {
            return false;
        }
        ImportVmImageRequest other = (ImportVmImageRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(semanticVersion(), other.semanticVersion())
                && Objects.equals(description(), other.description())
                && Objects.equals(platformAsString(), other.platformAsString()) && Objects.equals(osVersion(), other.osVersion())
                && Objects.equals(vmImportTaskId(), other.vmImportTaskId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportVmImageRequest").add("Name", name()).add("SemanticVersion", semanticVersion())
                .add("Description", description()).add("Platform", platformAsString()).add("OsVersion", osVersion())
                .add("VmImportTaskId", vmImportTaskId()).add("Tags", hasTags() ? tags() : null).add("ClientToken", clientToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "semanticVersion":
            return Optional.ofNullable(clazz.cast(semanticVersion()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "platform":
            return Optional.ofNullable(clazz.cast(platformAsString()));
        case "osVersion":
            return Optional.ofNullable(clazz.cast(osVersion()));
        case "vmImportTaskId":
            return Optional.ofNullable(clazz.cast(vmImportTaskId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("semanticVersion", SEMANTIC_VERSION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("platform", PLATFORM_FIELD);
        map.put("osVersion", OS_VERSION_FIELD);
        map.put("vmImportTaskId", VM_IMPORT_TASK_ID_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportVmImageRequest, T> g) {
        return obj -> g.apply((ImportVmImageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderRequest.Builder, SdkPojo, CopyableBuilder<Builder, ImportVmImageRequest> {
        /**
         * <p>
         * The name of the base image that is created by the import process.
         * </p>
         * 
         * @param name
         *        The name of the base image that is created by the import process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The semantic version to attach to the base image that was created during the import process. This version
         * follows the semantic version syntax.
         * </p>
         * <note>
         * <p>
         * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
         * values for the first three, and can filter on all of them.
         * </p>
         * <p>
         * <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with
         * an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number
         * to the fourth node.
         * </p>
         * <p>
         * <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes
         * that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such
         * as 2021.01.01.
         * </p>
         * </note>
         * 
         * @param semanticVersion
         *        The semantic version to attach to the base image that was created during the import process. This
         *        version follows the semantic version syntax.</p> <note>
         *        <p>
         *        The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can
         *        assign values for the first three, and can filter on all of them.
         *        </p>
         *        <p>
         *        <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including
         *        zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns
         *        the build number to the fourth node.
         *        </p>
         *        <p>
         *        <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the
         *        nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
         *        a date, such as 2021.01.01.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semanticVersion(String semanticVersion);

        /**
         * <p>
         * The description for the base image that is created by the import process.
         * </p>
         * 
         * @param description
         *        The description for the base image that is created by the import process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The operating system platform for the imported VM.
         * </p>
         * 
         * @param platform
         *        The operating system platform for the imported VM.
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(String platform);

        /**
         * <p>
         * The operating system platform for the imported VM.
         * </p>
         * 
         * @param platform
         *        The operating system platform for the imported VM.
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(Platform platform);

        /**
         * <p>
         * The operating system version for the imported VM.
         * </p>
         * 
         * @param osVersion
         *        The operating system version for the imported VM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder osVersion(String osVersion);

        /**
         * <p>
         * The <code>importTaskId</code> (API) or <code>ImportTaskId</code> (CLI) from the Amazon EC2 VM import process.
         * Image Builder retrieves information from the import process to pull in the AMI that is created from the VM
         * source as the base image for your recipe.
         * </p>
         * 
         * @param vmImportTaskId
         *        The <code>importTaskId</code> (API) or <code>ImportTaskId</code> (CLI) from the Amazon EC2 VM import
         *        process. Image Builder retrieves information from the import process to pull in the AMI that is
         *        created from the VM source as the base image for your recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vmImportTaskId(String vmImportTaskId);

        /**
         * <p>
         * Tags that are attached to the import resources.
         * </p>
         * 
         * @param tags
         *        Tags that are attached to the import resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see
         * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * idempotency</a> in the <i>Amazon EC2 API Reference</i>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        idempotency</a> in the <i>Amazon EC2 API Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ImagebuilderRequest.BuilderImpl implements Builder {
        private String name;

        private String semanticVersion;

        private String description;

        private String platform;

        private String osVersion;

        private String vmImportTaskId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportVmImageRequest model) {
            super(model);
            name(model.name);
            semanticVersion(model.semanticVersion);
            description(model.description);
            platform(model.platform);
            osVersion(model.osVersion);
            vmImportTaskId(model.vmImportTaskId);
            tags(model.tags);
            clientToken(model.clientToken);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSemanticVersion() {
            return semanticVersion;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        @Override
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(Platform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final String getOsVersion() {
            return osVersion;
        }

        public final void setOsVersion(String osVersion) {
            this.osVersion = osVersion;
        }

        @Override
        public final Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        public final String getVmImportTaskId() {
            return vmImportTaskId;
        }

        public final void setVmImportTaskId(String vmImportTaskId) {
            this.vmImportTaskId = vmImportTaskId;
        }

        @Override
        public final Builder vmImportTaskId(String vmImportTaskId) {
            this.vmImportTaskId = vmImportTaskId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportVmImageRequest build() {
            return new ImportVmImageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
