/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains metadata from a runtime instance of a lifecycle policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LifecycleExecution implements SdkPojo, Serializable,
        ToCopyableBuilder<LifecycleExecution.Builder, LifecycleExecution> {
    private static final SdkField<String> LIFECYCLE_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lifecycleExecutionId").getter(getter(LifecycleExecution::lifecycleExecutionId))
            .setter(setter(Builder::lifecycleExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleExecutionId").build())
            .build();

    private static final SdkField<String> LIFECYCLE_POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lifecyclePolicyArn").getter(getter(LifecycleExecution::lifecyclePolicyArn))
            .setter(setter(Builder::lifecyclePolicyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecyclePolicyArn").build())
            .build();

    private static final SdkField<LifecycleExecutionResourcesImpactedSummary> RESOURCES_IMPACTED_SUMMARY_FIELD = SdkField
            .<LifecycleExecutionResourcesImpactedSummary> builder(MarshallingType.SDK_POJO)
            .memberName("resourcesImpactedSummary").getter(getter(LifecycleExecution::resourcesImpactedSummary))
            .setter(setter(Builder::resourcesImpactedSummary)).constructor(LifecycleExecutionResourcesImpactedSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesImpactedSummary").build())
            .build();

    private static final SdkField<LifecycleExecutionState> STATE_FIELD = SdkField
            .<LifecycleExecutionState> builder(MarshallingType.SDK_POJO).memberName("state")
            .getter(getter(LifecycleExecution::state)).setter(setter(Builder::state))
            .constructor(LifecycleExecutionState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(LifecycleExecution::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(LifecycleExecution::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_EXECUTION_ID_FIELD,
            LIFECYCLE_POLICY_ARN_FIELD, RESOURCES_IMPACTED_SUMMARY_FIELD, STATE_FIELD, START_TIME_FIELD, END_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String lifecycleExecutionId;

    private final String lifecyclePolicyArn;

    private final LifecycleExecutionResourcesImpactedSummary resourcesImpactedSummary;

    private final LifecycleExecutionState state;

    private final Instant startTime;

    private final Instant endTime;

    private LifecycleExecution(BuilderImpl builder) {
        this.lifecycleExecutionId = builder.lifecycleExecutionId;
        this.lifecyclePolicyArn = builder.lifecyclePolicyArn;
        this.resourcesImpactedSummary = builder.resourcesImpactedSummary;
        this.state = builder.state;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    /**
     * <p>
     * Identifies the lifecycle policy runtime instance.
     * </p>
     * 
     * @return Identifies the lifecycle policy runtime instance.
     */
    public final String lifecycleExecutionId() {
        return lifecycleExecutionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the lifecycle policy that ran.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the lifecycle policy that ran.
     */
    public final String lifecyclePolicyArn() {
        return lifecyclePolicyArn;
    }

    /**
     * <p>
     * Contains information about associated resources that are identified for action by the runtime instance of the
     * lifecycle policy.
     * </p>
     * 
     * @return Contains information about associated resources that are identified for action by the runtime instance of
     *         the lifecycle policy.
     */
    public final LifecycleExecutionResourcesImpactedSummary resourcesImpactedSummary() {
        return resourcesImpactedSummary;
    }

    /**
     * <p>
     * Runtime state that reports if the policy action ran successfully, failed, or was skipped.
     * </p>
     * 
     * @return Runtime state that reports if the policy action ran successfully, failed, or was skipped.
     */
    public final LifecycleExecutionState state() {
        return state;
    }

    /**
     * <p>
     * The timestamp when the lifecycle runtime instance started.
     * </p>
     * 
     * @return The timestamp when the lifecycle runtime instance started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The timestamp when the lifecycle runtime instance completed.
     * </p>
     * 
     * @return The timestamp when the lifecycle runtime instance completed.
     */
    public final Instant endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(lifecyclePolicyArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourcesImpactedSummary());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecycleExecution)) {
            return false;
        }
        LifecycleExecution other = (LifecycleExecution) obj;
        return Objects.equals(lifecycleExecutionId(), other.lifecycleExecutionId())
                && Objects.equals(lifecyclePolicyArn(), other.lifecyclePolicyArn())
                && Objects.equals(resourcesImpactedSummary(), other.resourcesImpactedSummary())
                && Objects.equals(state(), other.state()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LifecycleExecution").add("LifecycleExecutionId", lifecycleExecutionId())
                .add("LifecyclePolicyArn", lifecyclePolicyArn()).add("ResourcesImpactedSummary", resourcesImpactedSummary())
                .add("State", state()).add("StartTime", startTime()).add("EndTime", endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lifecycleExecutionId":
            return Optional.ofNullable(clazz.cast(lifecycleExecutionId()));
        case "lifecyclePolicyArn":
            return Optional.ofNullable(clazz.cast(lifecyclePolicyArn()));
        case "resourcesImpactedSummary":
            return Optional.ofNullable(clazz.cast(resourcesImpactedSummary()));
        case "state":
            return Optional.ofNullable(clazz.cast(state()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("lifecycleExecutionId", LIFECYCLE_EXECUTION_ID_FIELD);
        map.put("lifecyclePolicyArn", LIFECYCLE_POLICY_ARN_FIELD);
        map.put("resourcesImpactedSummary", RESOURCES_IMPACTED_SUMMARY_FIELD);
        map.put("state", STATE_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LifecycleExecution, T> g) {
        return obj -> g.apply((LifecycleExecution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LifecycleExecution> {
        /**
         * <p>
         * Identifies the lifecycle policy runtime instance.
         * </p>
         * 
         * @param lifecycleExecutionId
         *        Identifies the lifecycle policy runtime instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleExecutionId(String lifecycleExecutionId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the lifecycle policy that ran.
         * </p>
         * 
         * @param lifecyclePolicyArn
         *        The Amazon Resource Name (ARN) of the lifecycle policy that ran.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecyclePolicyArn(String lifecyclePolicyArn);

        /**
         * <p>
         * Contains information about associated resources that are identified for action by the runtime instance of the
         * lifecycle policy.
         * </p>
         * 
         * @param resourcesImpactedSummary
         *        Contains information about associated resources that are identified for action by the runtime instance
         *        of the lifecycle policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesImpactedSummary(LifecycleExecutionResourcesImpactedSummary resourcesImpactedSummary);

        /**
         * <p>
         * Contains information about associated resources that are identified for action by the runtime instance of the
         * lifecycle policy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link LifecycleExecutionResourcesImpactedSummary.Builder} avoiding the need to create one manually via
         * {@link LifecycleExecutionResourcesImpactedSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LifecycleExecutionResourcesImpactedSummary.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #resourcesImpactedSummary(LifecycleExecutionResourcesImpactedSummary)}.
         * 
         * @param resourcesImpactedSummary
         *        a consumer that will call methods on {@link LifecycleExecutionResourcesImpactedSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourcesImpactedSummary(LifecycleExecutionResourcesImpactedSummary)
         */
        default Builder resourcesImpactedSummary(
                Consumer<LifecycleExecutionResourcesImpactedSummary.Builder> resourcesImpactedSummary) {
            return resourcesImpactedSummary(LifecycleExecutionResourcesImpactedSummary.builder()
                    .applyMutation(resourcesImpactedSummary).build());
        }

        /**
         * <p>
         * Runtime state that reports if the policy action ran successfully, failed, or was skipped.
         * </p>
         * 
         * @param state
         *        Runtime state that reports if the policy action ran successfully, failed, or was skipped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(LifecycleExecutionState state);

        /**
         * <p>
         * Runtime state that reports if the policy action ran successfully, failed, or was skipped.
         * </p>
         * This is a convenience method that creates an instance of the {@link LifecycleExecutionState.Builder} avoiding
         * the need to create one manually via {@link LifecycleExecutionState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LifecycleExecutionState.Builder#build()} is called immediately
         * and its result is passed to {@link #state(LifecycleExecutionState)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link LifecycleExecutionState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(LifecycleExecutionState)
         */
        default Builder state(Consumer<LifecycleExecutionState.Builder> state) {
            return state(LifecycleExecutionState.builder().applyMutation(state).build());
        }

        /**
         * <p>
         * The timestamp when the lifecycle runtime instance started.
         * </p>
         * 
         * @param startTime
         *        The timestamp when the lifecycle runtime instance started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The timestamp when the lifecycle runtime instance completed.
         * </p>
         * 
         * @param endTime
         *        The timestamp when the lifecycle runtime instance completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);
    }

    static final class BuilderImpl implements Builder {
        private String lifecycleExecutionId;

        private String lifecyclePolicyArn;

        private LifecycleExecutionResourcesImpactedSummary resourcesImpactedSummary;

        private LifecycleExecutionState state;

        private Instant startTime;

        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecycleExecution model) {
            lifecycleExecutionId(model.lifecycleExecutionId);
            lifecyclePolicyArn(model.lifecyclePolicyArn);
            resourcesImpactedSummary(model.resourcesImpactedSummary);
            state(model.state);
            startTime(model.startTime);
            endTime(model.endTime);
        }

        public final String getLifecycleExecutionId() {
            return lifecycleExecutionId;
        }

        public final void setLifecycleExecutionId(String lifecycleExecutionId) {
            this.lifecycleExecutionId = lifecycleExecutionId;
        }

        @Override
        public final Builder lifecycleExecutionId(String lifecycleExecutionId) {
            this.lifecycleExecutionId = lifecycleExecutionId;
            return this;
        }

        public final String getLifecyclePolicyArn() {
            return lifecyclePolicyArn;
        }

        public final void setLifecyclePolicyArn(String lifecyclePolicyArn) {
            this.lifecyclePolicyArn = lifecyclePolicyArn;
        }

        @Override
        public final Builder lifecyclePolicyArn(String lifecyclePolicyArn) {
            this.lifecyclePolicyArn = lifecyclePolicyArn;
            return this;
        }

        public final LifecycleExecutionResourcesImpactedSummary.Builder getResourcesImpactedSummary() {
            return resourcesImpactedSummary != null ? resourcesImpactedSummary.toBuilder() : null;
        }

        public final void setResourcesImpactedSummary(
                LifecycleExecutionResourcesImpactedSummary.BuilderImpl resourcesImpactedSummary) {
            this.resourcesImpactedSummary = resourcesImpactedSummary != null ? resourcesImpactedSummary.build() : null;
        }

        @Override
        public final Builder resourcesImpactedSummary(LifecycleExecutionResourcesImpactedSummary resourcesImpactedSummary) {
            this.resourcesImpactedSummary = resourcesImpactedSummary;
            return this;
        }

        public final LifecycleExecutionState.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        public final void setState(LifecycleExecutionState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(LifecycleExecutionState state) {
            this.state = state;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public LifecycleExecution build() {
            return new LifecycleExecution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
