/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration details for a lifecycle policy resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LifecyclePolicyDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<LifecyclePolicyDetail.Builder, LifecyclePolicyDetail> {
    private static final SdkField<LifecyclePolicyDetailAction> ACTION_FIELD = SdkField
            .<LifecyclePolicyDetailAction> builder(MarshallingType.SDK_POJO).memberName("action")
            .getter(getter(LifecyclePolicyDetail::action)).setter(setter(Builder::action))
            .constructor(LifecyclePolicyDetailAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<LifecyclePolicyDetailFilter> FILTER_FIELD = SdkField
            .<LifecyclePolicyDetailFilter> builder(MarshallingType.SDK_POJO).memberName("filter")
            .getter(getter(LifecyclePolicyDetail::filter)).setter(setter(Builder::filter))
            .constructor(LifecyclePolicyDetailFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final SdkField<LifecyclePolicyDetailExclusionRules> EXCLUSION_RULES_FIELD = SdkField
            .<LifecyclePolicyDetailExclusionRules> builder(MarshallingType.SDK_POJO).memberName("exclusionRules")
            .getter(getter(LifecyclePolicyDetail::exclusionRules)).setter(setter(Builder::exclusionRules))
            .constructor(LifecyclePolicyDetailExclusionRules::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exclusionRules").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, FILTER_FIELD,
            EXCLUSION_RULES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LifecyclePolicyDetailAction action;

    private final LifecyclePolicyDetailFilter filter;

    private final LifecyclePolicyDetailExclusionRules exclusionRules;

    private LifecyclePolicyDetail(BuilderImpl builder) {
        this.action = builder.action;
        this.filter = builder.filter;
        this.exclusionRules = builder.exclusionRules;
    }

    /**
     * <p>
     * Configuration details for the policy action.
     * </p>
     * 
     * @return Configuration details for the policy action.
     */
    public final LifecyclePolicyDetailAction action() {
        return action;
    }

    /**
     * <p>
     * Specifies the resources that the lifecycle policy applies to.
     * </p>
     * 
     * @return Specifies the resources that the lifecycle policy applies to.
     */
    public final LifecyclePolicyDetailFilter filter() {
        return filter;
    }

    /**
     * <p>
     * Additional rules to specify resources that should be exempt from policy actions.
     * </p>
     * 
     * @return Additional rules to specify resources that should be exempt from policy actions.
     */
    public final LifecyclePolicyDetailExclusionRules exclusionRules() {
        return exclusionRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(exclusionRules());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecyclePolicyDetail)) {
            return false;
        }
        LifecyclePolicyDetail other = (LifecyclePolicyDetail) obj;
        return Objects.equals(action(), other.action()) && Objects.equals(filter(), other.filter())
                && Objects.equals(exclusionRules(), other.exclusionRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LifecyclePolicyDetail").add("Action", action()).add("Filter", filter())
                .add("ExclusionRules", exclusionRules()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "exclusionRules":
            return Optional.ofNullable(clazz.cast(exclusionRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("action", ACTION_FIELD);
        map.put("filter", FILTER_FIELD);
        map.put("exclusionRules", EXCLUSION_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LifecyclePolicyDetail, T> g) {
        return obj -> g.apply((LifecyclePolicyDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LifecyclePolicyDetail> {
        /**
         * <p>
         * Configuration details for the policy action.
         * </p>
         * 
         * @param action
         *        Configuration details for the policy action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(LifecyclePolicyDetailAction action);

        /**
         * <p>
         * Configuration details for the policy action.
         * </p>
         * This is a convenience method that creates an instance of the {@link LifecyclePolicyDetailAction.Builder}
         * avoiding the need to create one manually via {@link LifecyclePolicyDetailAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LifecyclePolicyDetailAction.Builder#build()} is called
         * immediately and its result is passed to {@link #action(LifecyclePolicyDetailAction)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link LifecyclePolicyDetailAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(LifecyclePolicyDetailAction)
         */
        default Builder action(Consumer<LifecyclePolicyDetailAction.Builder> action) {
            return action(LifecyclePolicyDetailAction.builder().applyMutation(action).build());
        }

        /**
         * <p>
         * Specifies the resources that the lifecycle policy applies to.
         * </p>
         * 
         * @param filter
         *        Specifies the resources that the lifecycle policy applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(LifecyclePolicyDetailFilter filter);

        /**
         * <p>
         * Specifies the resources that the lifecycle policy applies to.
         * </p>
         * This is a convenience method that creates an instance of the {@link LifecyclePolicyDetailFilter.Builder}
         * avoiding the need to create one manually via {@link LifecyclePolicyDetailFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LifecyclePolicyDetailFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #filter(LifecyclePolicyDetailFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link LifecyclePolicyDetailFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(LifecyclePolicyDetailFilter)
         */
        default Builder filter(Consumer<LifecyclePolicyDetailFilter.Builder> filter) {
            return filter(LifecyclePolicyDetailFilter.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * Additional rules to specify resources that should be exempt from policy actions.
         * </p>
         * 
         * @param exclusionRules
         *        Additional rules to specify resources that should be exempt from policy actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusionRules(LifecyclePolicyDetailExclusionRules exclusionRules);

        /**
         * <p>
         * Additional rules to specify resources that should be exempt from policy actions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link LifecyclePolicyDetailExclusionRules.Builder} avoiding the need to create one manually via
         * {@link LifecyclePolicyDetailExclusionRules#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LifecyclePolicyDetailExclusionRules.Builder#build()} is called
         * immediately and its result is passed to {@link #exclusionRules(LifecyclePolicyDetailExclusionRules)}.
         * 
         * @param exclusionRules
         *        a consumer that will call methods on {@link LifecyclePolicyDetailExclusionRules.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exclusionRules(LifecyclePolicyDetailExclusionRules)
         */
        default Builder exclusionRules(Consumer<LifecyclePolicyDetailExclusionRules.Builder> exclusionRules) {
            return exclusionRules(LifecyclePolicyDetailExclusionRules.builder().applyMutation(exclusionRules).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LifecyclePolicyDetailAction action;

        private LifecyclePolicyDetailFilter filter;

        private LifecyclePolicyDetailExclusionRules exclusionRules;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecyclePolicyDetail model) {
            action(model.action);
            filter(model.filter);
            exclusionRules(model.exclusionRules);
        }

        public final LifecyclePolicyDetailAction.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        public final void setAction(LifecyclePolicyDetailAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(LifecyclePolicyDetailAction action) {
            this.action = action;
            return this;
        }

        public final LifecyclePolicyDetailFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(LifecyclePolicyDetailFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(LifecyclePolicyDetailFilter filter) {
            this.filter = filter;
            return this;
        }

        public final LifecyclePolicyDetailExclusionRules.Builder getExclusionRules() {
            return exclusionRules != null ? exclusionRules.toBuilder() : null;
        }

        public final void setExclusionRules(LifecyclePolicyDetailExclusionRules.BuilderImpl exclusionRules) {
            this.exclusionRules = exclusionRules != null ? exclusionRules.build() : null;
        }

        @Override
        public final Builder exclusionRules(LifecyclePolicyDetailExclusionRules exclusionRules) {
            this.exclusionRules = exclusionRules;
            return this;
        }

        @Override
        public LifecyclePolicyDetail build() {
            return new LifecyclePolicyDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
