/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListComponentsRequest extends ImagebuilderRequest implements
        ToCopyableBuilder<ListComponentsRequest.Builder, ListComponentsRequest> {
    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("owner")
            .getter(getter(ListComponentsRequest::ownerAsString)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(ListComponentsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> BY_NAME_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("byName").getter(getter(ListComponentsRequest::byName)).setter(setter(Builder::byName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("byName").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListComponentsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListComponentsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_FIELD, FILTERS_FIELD,
            BY_NAME_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String owner;

    private final List<Filter> filters;

    private final Boolean byName;

    private final Integer maxResults;

    private final String nextToken;

    private ListComponentsRequest(BuilderImpl builder) {
        super(builder);
        this.owner = builder.owner;
        this.filters = builder.filters;
        this.byName = builder.byName;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Filters results based on the type of owner for the component. By default, this request returns a list of
     * components that your account owns. To see results for other types of owners, you can specify components that
     * Amazon manages, third party components, or components that other accounts have shared with you.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #owner} will return
     * {@link Ownership#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ownerAsString}.
     * </p>
     * 
     * @return Filters results based on the type of owner for the component. By default, this request returns a list of
     *         components that your account owns. To see results for other types of owners, you can specify components
     *         that Amazon manages, third party components, or components that other accounts have shared with you.
     * @see Ownership
     */
    public final Ownership owner() {
        return Ownership.fromValue(owner);
    }

    /**
     * <p>
     * Filters results based on the type of owner for the component. By default, this request returns a list of
     * components that your account owns. To see results for other types of owners, you can specify components that
     * Amazon manages, third party components, or components that other accounts have shared with you.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #owner} will return
     * {@link Ownership#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ownerAsString}.
     * </p>
     * 
     * @return Filters results based on the type of owner for the component. By default, this request returns a list of
     *         components that your account owns. To see results for other types of owners, you can specify components
     *         that Amazon manages, third party components, or components that other accounts have shared with you.
     * @see Ownership
     */
    public final String ownerAsString() {
        return owner;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Use the following filters to streamline results:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>description</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>name</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>platform</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>supportedOsVersion</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>type</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>version</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return Use the following filters to streamline results:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>description</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>name</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>platform</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>supportedOsVersion</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>type</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>version</code>
     *         </p>
     *         </li>
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * Returns the list of components for the specified name.
     * </p>
     * 
     * @return Returns the list of components for the specified name.
     */
    public final Boolean byName() {
        return byName;
    }

    /**
     * <p>
     * The maximum items to return in a request.
     * </p>
     * 
     * @return The maximum items to return in a request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token to specify where to start paginating. This is the nextToken from a previously truncated response.
     * </p>
     * 
     * @return A token to specify where to start paginating. This is the nextToken from a previously truncated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ownerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(byName());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComponentsRequest)) {
            return false;
        }
        ListComponentsRequest other = (ListComponentsRequest) obj;
        return Objects.equals(ownerAsString(), other.ownerAsString()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && Objects.equals(byName(), other.byName())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListComponentsRequest").add("Owner", ownerAsString())
                .add("Filters", hasFilters() ? filters() : null).add("ByName", byName()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "owner":
            return Optional.ofNullable(clazz.cast(ownerAsString()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "byName":
            return Optional.ofNullable(clazz.cast(byName()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("owner", OWNER_FIELD);
        map.put("filters", FILTERS_FIELD);
        map.put("byName", BY_NAME_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListComponentsRequest, T> g) {
        return obj -> g.apply((ListComponentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListComponentsRequest> {
        /**
         * <p>
         * Filters results based on the type of owner for the component. By default, this request returns a list of
         * components that your account owns. To see results for other types of owners, you can specify components that
         * Amazon manages, third party components, or components that other accounts have shared with you.
         * </p>
         * 
         * @param owner
         *        Filters results based on the type of owner for the component. By default, this request returns a list
         *        of components that your account owns. To see results for other types of owners, you can specify
         *        components that Amazon manages, third party components, or components that other accounts have shared
         *        with you.
         * @see Ownership
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ownership
         */
        Builder owner(String owner);

        /**
         * <p>
         * Filters results based on the type of owner for the component. By default, this request returns a list of
         * components that your account owns. To see results for other types of owners, you can specify components that
         * Amazon manages, third party components, or components that other accounts have shared with you.
         * </p>
         * 
         * @param owner
         *        Filters results based on the type of owner for the component. By default, this request returns a list
         *        of components that your account owns. To see results for other types of owners, you can specify
         *        components that Amazon manages, third party components, or components that other accounts have shared
         *        with you.
         * @see Ownership
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ownership
         */
        Builder owner(Ownership owner);

        /**
         * <p>
         * Use the following filters to streamline results:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>description</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>name</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>supportedOsVersion</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>type</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>version</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        Use the following filters to streamline results:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>description</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>name</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>platform</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>supportedOsVersion</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>type</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>version</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * Use the following filters to streamline results:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>description</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>name</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>supportedOsVersion</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>type</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>version</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        Use the following filters to streamline results:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>description</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>name</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>platform</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>supportedOsVersion</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>type</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>version</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * Use the following filters to streamline results:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>description</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>name</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>supportedOsVersion</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>type</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>version</code>
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.imagebuilder.model.Filter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.imagebuilder.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.imagebuilder.model.Filter.Builder#build()} is called immediately and
         * its result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.imagebuilder.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * Returns the list of components for the specified name.
         * </p>
         * 
         * @param byName
         *        Returns the list of components for the specified name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byName(Boolean byName);

        /**
         * <p>
         * The maximum items to return in a request.
         * </p>
         * 
         * @param maxResults
         *        The maximum items to return in a request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token to specify where to start paginating. This is the nextToken from a previously truncated response.
         * </p>
         * 
         * @param nextToken
         *        A token to specify where to start paginating. This is the nextToken from a previously truncated
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ImagebuilderRequest.BuilderImpl implements Builder {
        private String owner;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private Boolean byName;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComponentsRequest model) {
            super(model);
            owner(model.owner);
            filters(model.filters);
            byName(model.byName);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        @Override
        public final Builder owner(Ownership owner) {
            this.owner(owner == null ? null : owner.toString());
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getByName() {
            return byName;
        }

        public final void setByName(Boolean byName) {
            this.byName = byName;
        }

        @Override
        public final Builder byName(Boolean byName) {
            this.byName = byName;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListComponentsRequest build() {
            return new ListComponentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
