/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListImagesResponse extends ImagebuilderResponse implements
        ToCopyableBuilder<ListImagesResponse.Builder, ListImagesResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestId").getter(getter(ListImagesResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()).build();

    private static final SdkField<List<ImageVersion>> IMAGE_VERSION_LIST_FIELD = SdkField
            .<List<ImageVersion>> builder(MarshallingType.LIST)
            .memberName("imageVersionList")
            .getter(getter(ListImagesResponse::imageVersionList))
            .setter(setter(Builder::imageVersionList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageVersionList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImageVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImageVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListImagesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD,
            IMAGE_VERSION_LIST_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String requestIdValue;

    private final List<ImageVersion> imageVersionList;

    private final String nextToken;

    private ListImagesResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.imageVersionList = builder.imageVersionList;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The request ID that uniquely identifies this request.
     * </p>
     * 
     * @return The request ID that uniquely identifies this request.
     */
    public final String requestId() {
        return requestIdValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImageVersionList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasImageVersionList() {
        return imageVersionList != null && !(imageVersionList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of image semantic versions.
     * </p>
     * <note>
     * <p>
     * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
     * values for the first three, and can filter on all of them.
     * </p>
     * <p>
     * <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most
     * recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in
     * any node, all nodes to the right of the first wildcard must also be wildcards.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImageVersionList} method.
     * </p>
     * 
     * @return The list of image semantic versions.</p> <note>
     *         <p>
     *         The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can
     *         assign values for the first three, and can filter on all of them.
     *         </p>
     *         <p>
     *         <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the
     *         most recent versions or nodes when selecting the base image or components for your recipe. When you use a
     *         wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.
     *         </p>
     */
    public final List<ImageVersion> imageVersionList() {
        return imageVersionList;
    }

    /**
     * <p>
     * The next token used for paginated responses. When this field isn't empty, there are additional elements that the
     * service hasn't included in this request. Use this token with the next request to retrieve additional objects.
     * </p>
     * 
     * @return The next token used for paginated responses. When this field isn't empty, there are additional elements
     *         that the service hasn't included in this request. Use this token with the next request to retrieve
     *         additional objects.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(hasImageVersionList() ? imageVersionList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImagesResponse)) {
            return false;
        }
        ListImagesResponse other = (ListImagesResponse) obj;
        return Objects.equals(requestId(), other.requestId()) && hasImageVersionList() == other.hasImageVersionList()
                && Objects.equals(imageVersionList(), other.imageVersionList()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListImagesResponse").add("RequestId", requestId())
                .add("ImageVersionList", hasImageVersionList() ? imageVersionList() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "requestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "imageVersionList":
            return Optional.ofNullable(clazz.cast(imageVersionList()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("requestId", REQUEST_ID_FIELD);
        map.put("imageVersionList", IMAGE_VERSION_LIST_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListImagesResponse, T> g) {
        return obj -> g.apply((ListImagesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListImagesResponse> {
        /**
         * <p>
         * The request ID that uniquely identifies this request.
         * </p>
         * 
         * @param requestIdValue
         *        The request ID that uniquely identifies this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestIdValue);

        /**
         * <p>
         * The list of image semantic versions.
         * </p>
         * <note>
         * <p>
         * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
         * values for the first three, and can filter on all of them.
         * </p>
         * <p>
         * <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most
         * recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard
         * in any node, all nodes to the right of the first wildcard must also be wildcards.
         * </p>
         * </note>
         * 
         * @param imageVersionList
         *        The list of image semantic versions.</p> <note>
         *        <p>
         *        The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can
         *        assign values for the first three, and can filter on all of them.
         *        </p>
         *        <p>
         *        <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify
         *        the most recent versions or nodes when selecting the base image or components for your recipe. When
         *        you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageVersionList(Collection<ImageVersion> imageVersionList);

        /**
         * <p>
         * The list of image semantic versions.
         * </p>
         * <note>
         * <p>
         * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
         * values for the first three, and can filter on all of them.
         * </p>
         * <p>
         * <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most
         * recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard
         * in any node, all nodes to the right of the first wildcard must also be wildcards.
         * </p>
         * </note>
         * 
         * @param imageVersionList
         *        The list of image semantic versions.</p> <note>
         *        <p>
         *        The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can
         *        assign values for the first three, and can filter on all of them.
         *        </p>
         *        <p>
         *        <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify
         *        the most recent versions or nodes when selecting the base image or components for your recipe. When
         *        you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageVersionList(ImageVersion... imageVersionList);

        /**
         * <p>
         * The list of image semantic versions.
         * </p>
         * <note>
         * <p>
         * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
         * values for the first three, and can filter on all of them.
         * </p>
         * <p>
         * <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most
         * recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard
         * in any node, all nodes to the right of the first wildcard must also be wildcards.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.imagebuilder.model.ImageVersion.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.imagebuilder.model.ImageVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.imagebuilder.model.ImageVersion.Builder#build()} is called immediately
         * and its result is passed to {@link #imageVersionList(List<ImageVersion>)}.
         * 
         * @param imageVersionList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.imagebuilder.model.ImageVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageVersionList(java.util.Collection<ImageVersion>)
         */
        Builder imageVersionList(Consumer<ImageVersion.Builder>... imageVersionList);

        /**
         * <p>
         * The next token used for paginated responses. When this field isn't empty, there are additional elements that
         * the service hasn't included in this request. Use this token with the next request to retrieve additional
         * objects.
         * </p>
         * 
         * @param nextToken
         *        The next token used for paginated responses. When this field isn't empty, there are additional
         *        elements that the service hasn't included in this request. Use this token with the next request to
         *        retrieve additional objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ImagebuilderResponse.BuilderImpl implements Builder {
        private String requestIdValue;

        private List<ImageVersion> imageVersionList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImagesResponse model) {
            super(model);
            requestId(model.requestIdValue);
            imageVersionList(model.imageVersionList);
            nextToken(model.nextToken);
        }

        public final String getRequestId() {
            return requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final List<ImageVersion.Builder> getImageVersionList() {
            List<ImageVersion.Builder> result = ImageVersionListCopier.copyToBuilder(this.imageVersionList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImageVersionList(Collection<ImageVersion.BuilderImpl> imageVersionList) {
            this.imageVersionList = ImageVersionListCopier.copyFromBuilder(imageVersionList);
        }

        @Override
        public final Builder imageVersionList(Collection<ImageVersion> imageVersionList) {
            this.imageVersionList = ImageVersionListCopier.copy(imageVersionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageVersionList(ImageVersion... imageVersionList) {
            imageVersionList(Arrays.asList(imageVersionList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageVersionList(Consumer<ImageVersion.Builder>... imageVersionList) {
            imageVersionList(Stream.of(imageVersionList).map(c -> ImageVersion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListImagesResponse build() {
            return new ListImagesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
