/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLifecycleExecutionResourcesResponse extends ImagebuilderResponse implements
        ToCopyableBuilder<ListLifecycleExecutionResourcesResponse.Builder, ListLifecycleExecutionResourcesResponse> {
    private static final SdkField<String> LIFECYCLE_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lifecycleExecutionId").getter(getter(ListLifecycleExecutionResourcesResponse::lifecycleExecutionId))
            .setter(setter(Builder::lifecycleExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleExecutionId").build())
            .build();

    private static final SdkField<LifecycleExecutionState> LIFECYCLE_EXECUTION_STATE_FIELD = SdkField
            .<LifecycleExecutionState> builder(MarshallingType.SDK_POJO).memberName("lifecycleExecutionState")
            .getter(getter(ListLifecycleExecutionResourcesResponse::lifecycleExecutionState))
            .setter(setter(Builder::lifecycleExecutionState)).constructor(LifecycleExecutionState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleExecutionState").build())
            .build();

    private static final SdkField<List<LifecycleExecutionResource>> RESOURCES_FIELD = SdkField
            .<List<LifecycleExecutionResource>> builder(MarshallingType.LIST)
            .memberName("resources")
            .getter(getter(ListLifecycleExecutionResourcesResponse::resources))
            .setter(setter(Builder::resources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LifecycleExecutionResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(LifecycleExecutionResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListLifecycleExecutionResourcesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_EXECUTION_ID_FIELD,
            LIFECYCLE_EXECUTION_STATE_FIELD, RESOURCES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String lifecycleExecutionId;

    private final LifecycleExecutionState lifecycleExecutionState;

    private final List<LifecycleExecutionResource> resources;

    private final String nextToken;

    private ListLifecycleExecutionResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.lifecycleExecutionId = builder.lifecycleExecutionId;
        this.lifecycleExecutionState = builder.lifecycleExecutionState;
        this.resources = builder.resources;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Runtime details for the specified runtime instance of the lifecycle policy.
     * </p>
     * 
     * @return Runtime details for the specified runtime instance of the lifecycle policy.
     */
    public final String lifecycleExecutionId() {
        return lifecycleExecutionId;
    }

    /**
     * <p>
     * The current state of the lifecycle runtime instance.
     * </p>
     * 
     * @return The current state of the lifecycle runtime instance.
     */
    public final LifecycleExecutionState lifecycleExecutionState() {
        return lifecycleExecutionState;
    }

    /**
     * For responses, this returns true if the service returned a value for the Resources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResources() {
        return resources != null && !(resources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of resources that were identified for lifecycle actions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResources} method.
     * </p>
     * 
     * @return A list of resources that were identified for lifecycle actions.
     */
    public final List<LifecycleExecutionResource> resources() {
        return resources;
    }

    /**
     * <p>
     * The next token used for paginated responses. When this field isn't empty, there are additional elements that the
     * service hasn't included in this request. Use this token with the next request to retrieve additional objects.
     * </p>
     * 
     * @return The next token used for paginated responses. When this field isn't empty, there are additional elements
     *         that the service hasn't included in this request. Use this token with the next request to retrieve
     *         additional objects.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleExecutionState());
        hashCode = 31 * hashCode + Objects.hashCode(hasResources() ? resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLifecycleExecutionResourcesResponse)) {
            return false;
        }
        ListLifecycleExecutionResourcesResponse other = (ListLifecycleExecutionResourcesResponse) obj;
        return Objects.equals(lifecycleExecutionId(), other.lifecycleExecutionId())
                && Objects.equals(lifecycleExecutionState(), other.lifecycleExecutionState())
                && hasResources() == other.hasResources() && Objects.equals(resources(), other.resources())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLifecycleExecutionResourcesResponse").add("LifecycleExecutionId", lifecycleExecutionId())
                .add("LifecycleExecutionState", lifecycleExecutionState()).add("Resources", hasResources() ? resources() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lifecycleExecutionId":
            return Optional.ofNullable(clazz.cast(lifecycleExecutionId()));
        case "lifecycleExecutionState":
            return Optional.ofNullable(clazz.cast(lifecycleExecutionState()));
        case "resources":
            return Optional.ofNullable(clazz.cast(resources()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("lifecycleExecutionId", LIFECYCLE_EXECUTION_ID_FIELD);
        map.put("lifecycleExecutionState", LIFECYCLE_EXECUTION_STATE_FIELD);
        map.put("resources", RESOURCES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLifecycleExecutionResourcesResponse, T> g) {
        return obj -> g.apply((ListLifecycleExecutionResourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListLifecycleExecutionResourcesResponse> {
        /**
         * <p>
         * Runtime details for the specified runtime instance of the lifecycle policy.
         * </p>
         * 
         * @param lifecycleExecutionId
         *        Runtime details for the specified runtime instance of the lifecycle policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleExecutionId(String lifecycleExecutionId);

        /**
         * <p>
         * The current state of the lifecycle runtime instance.
         * </p>
         * 
         * @param lifecycleExecutionState
         *        The current state of the lifecycle runtime instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleExecutionState(LifecycleExecutionState lifecycleExecutionState);

        /**
         * <p>
         * The current state of the lifecycle runtime instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link LifecycleExecutionState.Builder} avoiding
         * the need to create one manually via {@link LifecycleExecutionState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LifecycleExecutionState.Builder#build()} is called immediately
         * and its result is passed to {@link #lifecycleExecutionState(LifecycleExecutionState)}.
         * 
         * @param lifecycleExecutionState
         *        a consumer that will call methods on {@link LifecycleExecutionState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecycleExecutionState(LifecycleExecutionState)
         */
        default Builder lifecycleExecutionState(Consumer<LifecycleExecutionState.Builder> lifecycleExecutionState) {
            return lifecycleExecutionState(LifecycleExecutionState.builder().applyMutation(lifecycleExecutionState).build());
        }

        /**
         * <p>
         * A list of resources that were identified for lifecycle actions.
         * </p>
         * 
         * @param resources
         *        A list of resources that were identified for lifecycle actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Collection<LifecycleExecutionResource> resources);

        /**
         * <p>
         * A list of resources that were identified for lifecycle actions.
         * </p>
         * 
         * @param resources
         *        A list of resources that were identified for lifecycle actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(LifecycleExecutionResource... resources);

        /**
         * <p>
         * A list of resources that were identified for lifecycle actions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionResource.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionResource.Builder#build()} is
         * called immediately and its result is passed to {@link #resources(List<LifecycleExecutionResource>)}.
         * 
         * @param resources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resources(java.util.Collection<LifecycleExecutionResource>)
         */
        Builder resources(Consumer<LifecycleExecutionResource.Builder>... resources);

        /**
         * <p>
         * The next token used for paginated responses. When this field isn't empty, there are additional elements that
         * the service hasn't included in this request. Use this token with the next request to retrieve additional
         * objects.
         * </p>
         * 
         * @param nextToken
         *        The next token used for paginated responses. When this field isn't empty, there are additional
         *        elements that the service hasn't included in this request. Use this token with the next request to
         *        retrieve additional objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ImagebuilderResponse.BuilderImpl implements Builder {
        private String lifecycleExecutionId;

        private LifecycleExecutionState lifecycleExecutionState;

        private List<LifecycleExecutionResource> resources = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLifecycleExecutionResourcesResponse model) {
            super(model);
            lifecycleExecutionId(model.lifecycleExecutionId);
            lifecycleExecutionState(model.lifecycleExecutionState);
            resources(model.resources);
            nextToken(model.nextToken);
        }

        public final String getLifecycleExecutionId() {
            return lifecycleExecutionId;
        }

        public final void setLifecycleExecutionId(String lifecycleExecutionId) {
            this.lifecycleExecutionId = lifecycleExecutionId;
        }

        @Override
        public final Builder lifecycleExecutionId(String lifecycleExecutionId) {
            this.lifecycleExecutionId = lifecycleExecutionId;
            return this;
        }

        public final LifecycleExecutionState.Builder getLifecycleExecutionState() {
            return lifecycleExecutionState != null ? lifecycleExecutionState.toBuilder() : null;
        }

        public final void setLifecycleExecutionState(LifecycleExecutionState.BuilderImpl lifecycleExecutionState) {
            this.lifecycleExecutionState = lifecycleExecutionState != null ? lifecycleExecutionState.build() : null;
        }

        @Override
        public final Builder lifecycleExecutionState(LifecycleExecutionState lifecycleExecutionState) {
            this.lifecycleExecutionState = lifecycleExecutionState;
            return this;
        }

        public final List<LifecycleExecutionResource.Builder> getResources() {
            List<LifecycleExecutionResource.Builder> result = LifecycleExecutionResourceListCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<LifecycleExecutionResource.BuilderImpl> resources) {
            this.resources = LifecycleExecutionResourceListCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<LifecycleExecutionResource> resources) {
            this.resources = LifecycleExecutionResourceListCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(LifecycleExecutionResource... resources) {
            resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<LifecycleExecutionResource.Builder>... resources) {
            resources(Stream.of(resources).map(c -> LifecycleExecutionResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLifecycleExecutionResourcesResponse build() {
            return new ListLifecycleExecutionResourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
