/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLifecyclePoliciesResponse extends ImagebuilderResponse implements
        ToCopyableBuilder<ListLifecyclePoliciesResponse.Builder, ListLifecyclePoliciesResponse> {
    private static final SdkField<List<LifecyclePolicySummary>> LIFECYCLE_POLICY_SUMMARY_LIST_FIELD = SdkField
            .<List<LifecyclePolicySummary>> builder(MarshallingType.LIST)
            .memberName("lifecyclePolicySummaryList")
            .getter(getter(ListLifecyclePoliciesResponse::lifecyclePolicySummaryList))
            .setter(setter(Builder::lifecyclePolicySummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecyclePolicySummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LifecyclePolicySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(LifecyclePolicySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListLifecyclePoliciesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LIFECYCLE_POLICY_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<LifecyclePolicySummary> lifecyclePolicySummaryList;

    private final String nextToken;

    private ListLifecyclePoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.lifecyclePolicySummaryList = builder.lifecyclePolicySummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the LifecyclePolicySummaryList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLifecyclePolicySummaryList() {
        return lifecyclePolicySummaryList != null && !(lifecyclePolicySummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of lifecycle policies in your Amazon Web Services account that meet the criteria specified in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLifecyclePolicySummaryList} method.
     * </p>
     * 
     * @return A list of lifecycle policies in your Amazon Web Services account that meet the criteria specified in the
     *         request.
     */
    public final List<LifecyclePolicySummary> lifecyclePolicySummaryList() {
        return lifecyclePolicySummaryList;
    }

    /**
     * <p>
     * The next token used for paginated responses. When this field isn't empty, there are additional elements that the
     * service hasn't included in this request. Use this token with the next request to retrieve additional objects.
     * </p>
     * 
     * @return The next token used for paginated responses. When this field isn't empty, there are additional elements
     *         that the service hasn't included in this request. Use this token with the next request to retrieve
     *         additional objects.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLifecyclePolicySummaryList() ? lifecyclePolicySummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLifecyclePoliciesResponse)) {
            return false;
        }
        ListLifecyclePoliciesResponse other = (ListLifecyclePoliciesResponse) obj;
        return hasLifecyclePolicySummaryList() == other.hasLifecyclePolicySummaryList()
                && Objects.equals(lifecyclePolicySummaryList(), other.lifecyclePolicySummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLifecyclePoliciesResponse")
                .add("LifecyclePolicySummaryList", hasLifecyclePolicySummaryList() ? lifecyclePolicySummaryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lifecyclePolicySummaryList":
            return Optional.ofNullable(clazz.cast(lifecyclePolicySummaryList()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("lifecyclePolicySummaryList", LIFECYCLE_POLICY_SUMMARY_LIST_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLifecyclePoliciesResponse, T> g) {
        return obj -> g.apply((ListLifecyclePoliciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListLifecyclePoliciesResponse> {
        /**
         * <p>
         * A list of lifecycle policies in your Amazon Web Services account that meet the criteria specified in the
         * request.
         * </p>
         * 
         * @param lifecyclePolicySummaryList
         *        A list of lifecycle policies in your Amazon Web Services account that meet the criteria specified in
         *        the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecyclePolicySummaryList(Collection<LifecyclePolicySummary> lifecyclePolicySummaryList);

        /**
         * <p>
         * A list of lifecycle policies in your Amazon Web Services account that meet the criteria specified in the
         * request.
         * </p>
         * 
         * @param lifecyclePolicySummaryList
         *        A list of lifecycle policies in your Amazon Web Services account that meet the criteria specified in
         *        the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecyclePolicySummaryList(LifecyclePolicySummary... lifecyclePolicySummaryList);

        /**
         * <p>
         * A list of lifecycle policies in your Amazon Web Services account that meet the criteria specified in the
         * request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicySummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicySummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicySummary.Builder#build()} is called
         * immediately and its result is passed to {@link #lifecyclePolicySummaryList(List<LifecyclePolicySummary>)}.
         * 
         * @param lifecyclePolicySummaryList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicySummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecyclePolicySummaryList(java.util.Collection<LifecyclePolicySummary>)
         */
        Builder lifecyclePolicySummaryList(Consumer<LifecyclePolicySummary.Builder>... lifecyclePolicySummaryList);

        /**
         * <p>
         * The next token used for paginated responses. When this field isn't empty, there are additional elements that
         * the service hasn't included in this request. Use this token with the next request to retrieve additional
         * objects.
         * </p>
         * 
         * @param nextToken
         *        The next token used for paginated responses. When this field isn't empty, there are additional
         *        elements that the service hasn't included in this request. Use this token with the next request to
         *        retrieve additional objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ImagebuilderResponse.BuilderImpl implements Builder {
        private List<LifecyclePolicySummary> lifecyclePolicySummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLifecyclePoliciesResponse model) {
            super(model);
            lifecyclePolicySummaryList(model.lifecyclePolicySummaryList);
            nextToken(model.nextToken);
        }

        public final List<LifecyclePolicySummary.Builder> getLifecyclePolicySummaryList() {
            List<LifecyclePolicySummary.Builder> result = LifecyclePolicySummaryListCopier
                    .copyToBuilder(this.lifecyclePolicySummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLifecyclePolicySummaryList(Collection<LifecyclePolicySummary.BuilderImpl> lifecyclePolicySummaryList) {
            this.lifecyclePolicySummaryList = LifecyclePolicySummaryListCopier.copyFromBuilder(lifecyclePolicySummaryList);
        }

        @Override
        public final Builder lifecyclePolicySummaryList(Collection<LifecyclePolicySummary> lifecyclePolicySummaryList) {
            this.lifecyclePolicySummaryList = LifecyclePolicySummaryListCopier.copy(lifecyclePolicySummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecyclePolicySummaryList(LifecyclePolicySummary... lifecyclePolicySummaryList) {
            lifecyclePolicySummaryList(Arrays.asList(lifecyclePolicySummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecyclePolicySummaryList(Consumer<LifecyclePolicySummary.Builder>... lifecyclePolicySummaryList) {
            lifecyclePolicySummaryList(Stream.of(lifecyclePolicySummaryList)
                    .map(c -> LifecyclePolicySummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLifecyclePoliciesResponse build() {
            return new ListLifecyclePoliciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
