/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a single product code.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProductCodeListItem implements SdkPojo, Serializable,
        ToCopyableBuilder<ProductCodeListItem.Builder, ProductCodeListItem> {
    private static final SdkField<String> PRODUCT_CODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("productCodeId").getter(getter(ProductCodeListItem::productCodeId))
            .setter(setter(Builder::productCodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productCodeId").build()).build();

    private static final SdkField<String> PRODUCT_CODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("productCodeType").getter(getter(ProductCodeListItem::productCodeTypeAsString))
            .setter(setter(Builder::productCodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productCodeType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_CODE_ID_FIELD,
            PRODUCT_CODE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String productCodeId;

    private final String productCodeType;

    private ProductCodeListItem(BuilderImpl builder) {
        this.productCodeId = builder.productCodeId;
        this.productCodeType = builder.productCodeType;
    }

    /**
     * <p>
     * For Amazon Web Services Marketplace components, this contains the product code ID that can be stamped onto an EC2
     * AMI to ensure that components are billed correctly. If this property is empty, it might mean that the component
     * is not published.
     * </p>
     * 
     * @return For Amazon Web Services Marketplace components, this contains the product code ID that can be stamped
     *         onto an EC2 AMI to ensure that components are billed correctly. If this property is empty, it might mean
     *         that the component is not published.
     */
    public final String productCodeId() {
        return productCodeId;
    }

    /**
     * <p>
     * The owner of the product code that's billed. If this property is empty, it might mean that the component is not
     * published.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productCodeType}
     * will return {@link ProductCodeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #productCodeTypeAsString}.
     * </p>
     * 
     * @return The owner of the product code that's billed. If this property is empty, it might mean that the component
     *         is not published.
     * @see ProductCodeType
     */
    public final ProductCodeType productCodeType() {
        return ProductCodeType.fromValue(productCodeType);
    }

    /**
     * <p>
     * The owner of the product code that's billed. If this property is empty, it might mean that the component is not
     * published.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productCodeType}
     * will return {@link ProductCodeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #productCodeTypeAsString}.
     * </p>
     * 
     * @return The owner of the product code that's billed. If this property is empty, it might mean that the component
     *         is not published.
     * @see ProductCodeType
     */
    public final String productCodeTypeAsString() {
        return productCodeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(productCodeId());
        hashCode = 31 * hashCode + Objects.hashCode(productCodeTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductCodeListItem)) {
            return false;
        }
        ProductCodeListItem other = (ProductCodeListItem) obj;
        return Objects.equals(productCodeId(), other.productCodeId())
                && Objects.equals(productCodeTypeAsString(), other.productCodeTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProductCodeListItem").add("ProductCodeId", productCodeId())
                .add("ProductCodeType", productCodeTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "productCodeId":
            return Optional.ofNullable(clazz.cast(productCodeId()));
        case "productCodeType":
            return Optional.ofNullable(clazz.cast(productCodeTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("productCodeId", PRODUCT_CODE_ID_FIELD);
        map.put("productCodeType", PRODUCT_CODE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProductCodeListItem, T> g) {
        return obj -> g.apply((ProductCodeListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProductCodeListItem> {
        /**
         * <p>
         * For Amazon Web Services Marketplace components, this contains the product code ID that can be stamped onto an
         * EC2 AMI to ensure that components are billed correctly. If this property is empty, it might mean that the
         * component is not published.
         * </p>
         * 
         * @param productCodeId
         *        For Amazon Web Services Marketplace components, this contains the product code ID that can be stamped
         *        onto an EC2 AMI to ensure that components are billed correctly. If this property is empty, it might
         *        mean that the component is not published.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodeId(String productCodeId);

        /**
         * <p>
         * The owner of the product code that's billed. If this property is empty, it might mean that the component is
         * not published.
         * </p>
         * 
         * @param productCodeType
         *        The owner of the product code that's billed. If this property is empty, it might mean that the
         *        component is not published.
         * @see ProductCodeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProductCodeType
         */
        Builder productCodeType(String productCodeType);

        /**
         * <p>
         * The owner of the product code that's billed. If this property is empty, it might mean that the component is
         * not published.
         * </p>
         * 
         * @param productCodeType
         *        The owner of the product code that's billed. If this property is empty, it might mean that the
         *        component is not published.
         * @see ProductCodeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProductCodeType
         */
        Builder productCodeType(ProductCodeType productCodeType);
    }

    static final class BuilderImpl implements Builder {
        private String productCodeId;

        private String productCodeType;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductCodeListItem model) {
            productCodeId(model.productCodeId);
            productCodeType(model.productCodeType);
        }

        public final String getProductCodeId() {
            return productCodeId;
        }

        public final void setProductCodeId(String productCodeId) {
            this.productCodeId = productCodeId;
        }

        @Override
        public final Builder productCodeId(String productCodeId) {
            this.productCodeId = productCodeId;
            return this;
        }

        public final String getProductCodeType() {
            return productCodeType;
        }

        public final void setProductCodeType(String productCodeType) {
            this.productCodeType = productCodeType;
        }

        @Override
        public final Builder productCodeType(String productCodeType) {
            this.productCodeType = productCodeType;
            return this;
        }

        @Override
        public final Builder productCodeType(ProductCodeType productCodeType) {
            this.productCodeType(productCodeType == null ? null : productCodeType.toString());
            return this;
        }

        @Override
        public ProductCodeListItem build() {
            return new ProductCodeListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
