/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartImagePipelineExecutionRequest extends ImagebuilderRequest implements
        ToCopyableBuilder<StartImagePipelineExecutionRequest.Builder, StartImagePipelineExecutionRequest> {
    private static final SdkField<String> IMAGE_PIPELINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imagePipelineArn").getter(getter(StartImagePipelineExecutionRequest::imagePipelineArn))
            .setter(setter(Builder::imagePipelineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imagePipelineArn").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(StartImagePipelineExecutionRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_PIPELINE_ARN_FIELD,
            CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String imagePipelineArn;

    private final String clientToken;

    private StartImagePipelineExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.imagePipelineArn = builder.imagePipelineArn;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the image pipeline that you want to manually invoke.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the image pipeline that you want to manually invoke.
     */
    public final String imagePipelineArn() {
        return imagePipelineArn;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * idempotency</a> in the <i>Amazon EC2 API Reference</i>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information,
     *         see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         idempotency</a> in the <i>Amazon EC2 API Reference</i>.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(imagePipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartImagePipelineExecutionRequest)) {
            return false;
        }
        StartImagePipelineExecutionRequest other = (StartImagePipelineExecutionRequest) obj;
        return Objects.equals(imagePipelineArn(), other.imagePipelineArn()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartImagePipelineExecutionRequest").add("ImagePipelineArn", imagePipelineArn())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "imagePipelineArn":
            return Optional.ofNullable(clazz.cast(imagePipelineArn()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("imagePipelineArn", IMAGE_PIPELINE_ARN_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartImagePipelineExecutionRequest, T> g) {
        return obj -> g.apply((StartImagePipelineExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartImagePipelineExecutionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the image pipeline that you want to manually invoke.
         * </p>
         * 
         * @param imagePipelineArn
         *        The Amazon Resource Name (ARN) of the image pipeline that you want to manually invoke.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imagePipelineArn(String imagePipelineArn);

        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see
         * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * idempotency</a> in the <i>Amazon EC2 API Reference</i>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        idempotency</a> in the <i>Amazon EC2 API Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ImagebuilderRequest.BuilderImpl implements Builder {
        private String imagePipelineArn;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartImagePipelineExecutionRequest model) {
            super(model);
            imagePipelineArn(model.imagePipelineArn);
            clientToken(model.clientToken);
        }

        public final String getImagePipelineArn() {
            return imagePipelineArn;
        }

        public final void setImagePipelineArn(String imagePipelineArn) {
            this.imagePipelineArn = imagePipelineArn;
        }

        @Override
        public final Builder imagePipelineArn(String imagePipelineArn) {
            this.imagePipelineArn = imagePipelineArn;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartImagePipelineExecutionRequest build() {
            return new StartImagePipelineExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
