/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateImagePipelineRequest extends ImagebuilderRequest implements
        ToCopyableBuilder<UpdateImagePipelineRequest.Builder, UpdateImagePipelineRequest> {
    private static final SdkField<String> IMAGE_PIPELINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imagePipelineArn").getter(getter(UpdateImagePipelineRequest::imagePipelineArn))
            .setter(setter(Builder::imagePipelineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imagePipelineArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateImagePipelineRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> IMAGE_RECIPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageRecipeArn").getter(getter(UpdateImagePipelineRequest::imageRecipeArn))
            .setter(setter(Builder::imageRecipeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageRecipeArn").build()).build();

    private static final SdkField<String> CONTAINER_RECIPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("containerRecipeArn").getter(getter(UpdateImagePipelineRequest::containerRecipeArn))
            .setter(setter(Builder::containerRecipeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerRecipeArn").build())
            .build();

    private static final SdkField<String> INFRASTRUCTURE_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("infrastructureConfigurationArn")
            .getter(getter(UpdateImagePipelineRequest::infrastructureConfigurationArn))
            .setter(setter(Builder::infrastructureConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("infrastructureConfigurationArn")
                    .build()).build();

    private static final SdkField<String> DISTRIBUTION_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("distributionConfigurationArn")
            .getter(getter(UpdateImagePipelineRequest::distributionConfigurationArn))
            .setter(setter(Builder::distributionConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributionConfigurationArn")
                    .build()).build();

    private static final SdkField<ImageTestsConfiguration> IMAGE_TESTS_CONFIGURATION_FIELD = SdkField
            .<ImageTestsConfiguration> builder(MarshallingType.SDK_POJO).memberName("imageTestsConfiguration")
            .getter(getter(UpdateImagePipelineRequest::imageTestsConfiguration)).setter(setter(Builder::imageTestsConfiguration))
            .constructor(ImageTestsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTestsConfiguration").build())
            .build();

    private static final SdkField<Boolean> ENHANCED_IMAGE_METADATA_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enhancedImageMetadataEnabled")
            .getter(getter(UpdateImagePipelineRequest::enhancedImageMetadataEnabled))
            .setter(setter(Builder::enhancedImageMetadataEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedImageMetadataEnabled")
                    .build()).build();

    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.<Schedule> builder(MarshallingType.SDK_POJO)
            .memberName("schedule").getter(getter(UpdateImagePipelineRequest::schedule)).setter(setter(Builder::schedule))
            .constructor(Schedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(UpdateImagePipelineRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateImagePipelineRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<ImageScanningConfiguration> IMAGE_SCANNING_CONFIGURATION_FIELD = SdkField
            .<ImageScanningConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("imageScanningConfiguration")
            .getter(getter(UpdateImagePipelineRequest::imageScanningConfiguration))
            .setter(setter(Builder::imageScanningConfiguration))
            .constructor(ImageScanningConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageScanningConfiguration").build())
            .build();

    private static final SdkField<List<WorkflowConfiguration>> WORKFLOWS_FIELD = SdkField
            .<List<WorkflowConfiguration>> builder(MarshallingType.LIST)
            .memberName("workflows")
            .getter(getter(UpdateImagePipelineRequest::workflows))
            .setter(setter(Builder::workflows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkflowConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkflowConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRole").getter(getter(UpdateImagePipelineRequest::executionRole))
            .setter(setter(Builder::executionRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRole").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_PIPELINE_ARN_FIELD,
            DESCRIPTION_FIELD, IMAGE_RECIPE_ARN_FIELD, CONTAINER_RECIPE_ARN_FIELD, INFRASTRUCTURE_CONFIGURATION_ARN_FIELD,
            DISTRIBUTION_CONFIGURATION_ARN_FIELD, IMAGE_TESTS_CONFIGURATION_FIELD, ENHANCED_IMAGE_METADATA_ENABLED_FIELD,
            SCHEDULE_FIELD, STATUS_FIELD, CLIENT_TOKEN_FIELD, IMAGE_SCANNING_CONFIGURATION_FIELD, WORKFLOWS_FIELD,
            EXECUTION_ROLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String imagePipelineArn;

    private final String description;

    private final String imageRecipeArn;

    private final String containerRecipeArn;

    private final String infrastructureConfigurationArn;

    private final String distributionConfigurationArn;

    private final ImageTestsConfiguration imageTestsConfiguration;

    private final Boolean enhancedImageMetadataEnabled;

    private final Schedule schedule;

    private final String status;

    private final String clientToken;

    private final ImageScanningConfiguration imageScanningConfiguration;

    private final List<WorkflowConfiguration> workflows;

    private final String executionRole;

    private UpdateImagePipelineRequest(BuilderImpl builder) {
        super(builder);
        this.imagePipelineArn = builder.imagePipelineArn;
        this.description = builder.description;
        this.imageRecipeArn = builder.imageRecipeArn;
        this.containerRecipeArn = builder.containerRecipeArn;
        this.infrastructureConfigurationArn = builder.infrastructureConfigurationArn;
        this.distributionConfigurationArn = builder.distributionConfigurationArn;
        this.imageTestsConfiguration = builder.imageTestsConfiguration;
        this.enhancedImageMetadataEnabled = builder.enhancedImageMetadataEnabled;
        this.schedule = builder.schedule;
        this.status = builder.status;
        this.clientToken = builder.clientToken;
        this.imageScanningConfiguration = builder.imageScanningConfiguration;
        this.workflows = builder.workflows;
        this.executionRole = builder.executionRole;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the image pipeline that you want to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the image pipeline that you want to update.
     */
    public final String imagePipelineArn() {
        return imagePipelineArn;
    }

    /**
     * <p>
     * The description of the image pipeline.
     * </p>
     * 
     * @return The description of the image pipeline.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the image recipe that will be used to configure images updated by this image
     * pipeline.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the image recipe that will be used to configure images updated by this
     *         image pipeline.
     */
    public final String imageRecipeArn() {
        return imageRecipeArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the container pipeline to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the container pipeline to update.
     */
    public final String containerRecipeArn() {
        return containerRecipeArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the infrastructure configuration that Image Builder uses to build images that
     * this image pipeline has updated.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the infrastructure configuration that Image Builder uses to build
     *         images that this image pipeline has updated.
     */
    public final String infrastructureConfigurationArn() {
        return infrastructureConfigurationArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the distribution configuration that Image Builder uses to configure and
     * distribute images that this image pipeline has updated.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the distribution configuration that Image Builder uses to configure and
     *         distribute images that this image pipeline has updated.
     */
    public final String distributionConfigurationArn() {
        return distributionConfigurationArn;
    }

    /**
     * <p>
     * The image test configuration of the image pipeline.
     * </p>
     * 
     * @return The image test configuration of the image pipeline.
     */
    public final ImageTestsConfiguration imageTestsConfiguration() {
        return imageTestsConfiguration;
    }

    /**
     * <p>
     * Collects additional information about the image being created, including the operating system (OS) version and
     * package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by
     * default.
     * </p>
     * 
     * @return Collects additional information about the image being created, including the operating system (OS)
     *         version and package list. This information is used to enhance the overall experience of using EC2 Image
     *         Builder. Enabled by default.
     */
    public final Boolean enhancedImageMetadataEnabled() {
        return enhancedImageMetadataEnabled;
    }

    /**
     * <p>
     * The schedule of the image pipeline.
     * </p>
     * 
     * @return The schedule of the image pipeline.
     */
    public final Schedule schedule() {
        return schedule;
    }

    /**
     * <p>
     * The status of the image pipeline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PipelineStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the image pipeline.
     * @see PipelineStatus
     */
    public final PipelineStatus status() {
        return PipelineStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the image pipeline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PipelineStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the image pipeline.
     * @see PipelineStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * idempotency</a> in the <i>Amazon EC2 API Reference</i>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information,
     *         see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         idempotency</a> in the <i>Amazon EC2 API Reference</i>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Contains settings for vulnerability scans.
     * </p>
     * 
     * @return Contains settings for vulnerability scans.
     */
    public final ImageScanningConfiguration imageScanningConfiguration() {
        return imageScanningConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Workflows property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWorkflows() {
        return workflows != null && !(workflows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains the workflows to run for the pipeline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkflows} method.
     * </p>
     * 
     * @return Contains the workflows to run for the pipeline.
     */
    public final List<WorkflowConfiguration> workflows() {
        return workflows;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to perform
     * workflow actions.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to
     *         perform workflow actions.
     */
    public final String executionRole() {
        return executionRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(imagePipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(imageRecipeArn());
        hashCode = 31 * hashCode + Objects.hashCode(containerRecipeArn());
        hashCode = 31 * hashCode + Objects.hashCode(infrastructureConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(distributionConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(imageTestsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(enhancedImageMetadataEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(imageScanningConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkflows() ? workflows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(executionRole());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateImagePipelineRequest)) {
            return false;
        }
        UpdateImagePipelineRequest other = (UpdateImagePipelineRequest) obj;
        return Objects.equals(imagePipelineArn(), other.imagePipelineArn()) && Objects.equals(description(), other.description())
                && Objects.equals(imageRecipeArn(), other.imageRecipeArn())
                && Objects.equals(containerRecipeArn(), other.containerRecipeArn())
                && Objects.equals(infrastructureConfigurationArn(), other.infrastructureConfigurationArn())
                && Objects.equals(distributionConfigurationArn(), other.distributionConfigurationArn())
                && Objects.equals(imageTestsConfiguration(), other.imageTestsConfiguration())
                && Objects.equals(enhancedImageMetadataEnabled(), other.enhancedImageMetadataEnabled())
                && Objects.equals(schedule(), other.schedule()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(imageScanningConfiguration(), other.imageScanningConfiguration())
                && hasWorkflows() == other.hasWorkflows() && Objects.equals(workflows(), other.workflows())
                && Objects.equals(executionRole(), other.executionRole());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateImagePipelineRequest").add("ImagePipelineArn", imagePipelineArn())
                .add("Description", description()).add("ImageRecipeArn", imageRecipeArn())
                .add("ContainerRecipeArn", containerRecipeArn())
                .add("InfrastructureConfigurationArn", infrastructureConfigurationArn())
                .add("DistributionConfigurationArn", distributionConfigurationArn())
                .add("ImageTestsConfiguration", imageTestsConfiguration())
                .add("EnhancedImageMetadataEnabled", enhancedImageMetadataEnabled()).add("Schedule", schedule())
                .add("Status", statusAsString()).add("ClientToken", clientToken())
                .add("ImageScanningConfiguration", imageScanningConfiguration())
                .add("Workflows", hasWorkflows() ? workflows() : null).add("ExecutionRole", executionRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "imagePipelineArn":
            return Optional.ofNullable(clazz.cast(imagePipelineArn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "imageRecipeArn":
            return Optional.ofNullable(clazz.cast(imageRecipeArn()));
        case "containerRecipeArn":
            return Optional.ofNullable(clazz.cast(containerRecipeArn()));
        case "infrastructureConfigurationArn":
            return Optional.ofNullable(clazz.cast(infrastructureConfigurationArn()));
        case "distributionConfigurationArn":
            return Optional.ofNullable(clazz.cast(distributionConfigurationArn()));
        case "imageTestsConfiguration":
            return Optional.ofNullable(clazz.cast(imageTestsConfiguration()));
        case "enhancedImageMetadataEnabled":
            return Optional.ofNullable(clazz.cast(enhancedImageMetadataEnabled()));
        case "schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "imageScanningConfiguration":
            return Optional.ofNullable(clazz.cast(imageScanningConfiguration()));
        case "workflows":
            return Optional.ofNullable(clazz.cast(workflows()));
        case "executionRole":
            return Optional.ofNullable(clazz.cast(executionRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("imagePipelineArn", IMAGE_PIPELINE_ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("imageRecipeArn", IMAGE_RECIPE_ARN_FIELD);
        map.put("containerRecipeArn", CONTAINER_RECIPE_ARN_FIELD);
        map.put("infrastructureConfigurationArn", INFRASTRUCTURE_CONFIGURATION_ARN_FIELD);
        map.put("distributionConfigurationArn", DISTRIBUTION_CONFIGURATION_ARN_FIELD);
        map.put("imageTestsConfiguration", IMAGE_TESTS_CONFIGURATION_FIELD);
        map.put("enhancedImageMetadataEnabled", ENHANCED_IMAGE_METADATA_ENABLED_FIELD);
        map.put("schedule", SCHEDULE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("imageScanningConfiguration", IMAGE_SCANNING_CONFIGURATION_FIELD);
        map.put("workflows", WORKFLOWS_FIELD);
        map.put("executionRole", EXECUTION_ROLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateImagePipelineRequest, T> g) {
        return obj -> g.apply((UpdateImagePipelineRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateImagePipelineRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the image pipeline that you want to update.
         * </p>
         * 
         * @param imagePipelineArn
         *        The Amazon Resource Name (ARN) of the image pipeline that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imagePipelineArn(String imagePipelineArn);

        /**
         * <p>
         * The description of the image pipeline.
         * </p>
         * 
         * @param description
         *        The description of the image pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the image recipe that will be used to configure images updated by this
         * image pipeline.
         * </p>
         * 
         * @param imageRecipeArn
         *        The Amazon Resource Name (ARN) of the image recipe that will be used to configure images updated by
         *        this image pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageRecipeArn(String imageRecipeArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the container pipeline to update.
         * </p>
         * 
         * @param containerRecipeArn
         *        The Amazon Resource Name (ARN) of the container pipeline to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerRecipeArn(String containerRecipeArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the infrastructure configuration that Image Builder uses to build images
         * that this image pipeline has updated.
         * </p>
         * 
         * @param infrastructureConfigurationArn
         *        The Amazon Resource Name (ARN) of the infrastructure configuration that Image Builder uses to build
         *        images that this image pipeline has updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder infrastructureConfigurationArn(String infrastructureConfigurationArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the distribution configuration that Image Builder uses to configure and
         * distribute images that this image pipeline has updated.
         * </p>
         * 
         * @param distributionConfigurationArn
         *        The Amazon Resource Name (ARN) of the distribution configuration that Image Builder uses to configure
         *        and distribute images that this image pipeline has updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionConfigurationArn(String distributionConfigurationArn);

        /**
         * <p>
         * The image test configuration of the image pipeline.
         * </p>
         * 
         * @param imageTestsConfiguration
         *        The image test configuration of the image pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageTestsConfiguration(ImageTestsConfiguration imageTestsConfiguration);

        /**
         * <p>
         * The image test configuration of the image pipeline.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageTestsConfiguration.Builder} avoiding
         * the need to create one manually via {@link ImageTestsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageTestsConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #imageTestsConfiguration(ImageTestsConfiguration)}.
         * 
         * @param imageTestsConfiguration
         *        a consumer that will call methods on {@link ImageTestsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageTestsConfiguration(ImageTestsConfiguration)
         */
        default Builder imageTestsConfiguration(Consumer<ImageTestsConfiguration.Builder> imageTestsConfiguration) {
            return imageTestsConfiguration(ImageTestsConfiguration.builder().applyMutation(imageTestsConfiguration).build());
        }

        /**
         * <p>
         * Collects additional information about the image being created, including the operating system (OS) version
         * and package list. This information is used to enhance the overall experience of using EC2 Image Builder.
         * Enabled by default.
         * </p>
         * 
         * @param enhancedImageMetadataEnabled
         *        Collects additional information about the image being created, including the operating system (OS)
         *        version and package list. This information is used to enhance the overall experience of using EC2
         *        Image Builder. Enabled by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enhancedImageMetadataEnabled(Boolean enhancedImageMetadataEnabled);

        /**
         * <p>
         * The schedule of the image pipeline.
         * </p>
         * 
         * @param schedule
         *        The schedule of the image pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(Schedule schedule);

        /**
         * <p>
         * The schedule of the image pipeline.
         * </p>
         * This is a convenience method that creates an instance of the {@link Schedule.Builder} avoiding the need to
         * create one manually via {@link Schedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Schedule.Builder#build()} is called immediately and its result is
         * passed to {@link #schedule(Schedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link Schedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(Schedule)
         */
        default Builder schedule(Consumer<Schedule.Builder> schedule) {
            return schedule(Schedule.builder().applyMutation(schedule).build());
        }

        /**
         * <p>
         * The status of the image pipeline.
         * </p>
         * 
         * @param status
         *        The status of the image pipeline.
         * @see PipelineStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipelineStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the image pipeline.
         * </p>
         * 
         * @param status
         *        The status of the image pipeline.
         * @see PipelineStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipelineStatus
         */
        Builder status(PipelineStatus status);

        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see
         * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * idempotency</a> in the <i>Amazon EC2 API Reference</i>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        idempotency</a> in the <i>Amazon EC2 API Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Contains settings for vulnerability scans.
         * </p>
         * 
         * @param imageScanningConfiguration
         *        Contains settings for vulnerability scans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageScanningConfiguration(ImageScanningConfiguration imageScanningConfiguration);

        /**
         * <p>
         * Contains settings for vulnerability scans.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageScanningConfiguration.Builder}
         * avoiding the need to create one manually via {@link ImageScanningConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageScanningConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #imageScanningConfiguration(ImageScanningConfiguration)}.
         * 
         * @param imageScanningConfiguration
         *        a consumer that will call methods on {@link ImageScanningConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageScanningConfiguration(ImageScanningConfiguration)
         */
        default Builder imageScanningConfiguration(Consumer<ImageScanningConfiguration.Builder> imageScanningConfiguration) {
            return imageScanningConfiguration(ImageScanningConfiguration.builder().applyMutation(imageScanningConfiguration)
                    .build());
        }

        /**
         * <p>
         * Contains the workflows to run for the pipeline.
         * </p>
         * 
         * @param workflows
         *        Contains the workflows to run for the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflows(Collection<WorkflowConfiguration> workflows);

        /**
         * <p>
         * Contains the workflows to run for the pipeline.
         * </p>
         * 
         * @param workflows
         *        Contains the workflows to run for the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflows(WorkflowConfiguration... workflows);

        /**
         * <p>
         * Contains the workflows to run for the pipeline.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.imagebuilder.model.WorkflowConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.imagebuilder.model.WorkflowConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.imagebuilder.model.WorkflowConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #workflows(List<WorkflowConfiguration>)}.
         * 
         * @param workflows
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.imagebuilder.model.WorkflowConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflows(java.util.Collection<WorkflowConfiguration>)
         */
        Builder workflows(Consumer<WorkflowConfiguration.Builder>... workflows);

        /**
         * <p>
         * The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to
         * perform workflow actions.
         * </p>
         * 
         * @param executionRole
         *        The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to
         *        perform workflow actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRole(String executionRole);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ImagebuilderRequest.BuilderImpl implements Builder {
        private String imagePipelineArn;

        private String description;

        private String imageRecipeArn;

        private String containerRecipeArn;

        private String infrastructureConfigurationArn;

        private String distributionConfigurationArn;

        private ImageTestsConfiguration imageTestsConfiguration;

        private Boolean enhancedImageMetadataEnabled;

        private Schedule schedule;

        private String status;

        private String clientToken;

        private ImageScanningConfiguration imageScanningConfiguration;

        private List<WorkflowConfiguration> workflows = DefaultSdkAutoConstructList.getInstance();

        private String executionRole;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateImagePipelineRequest model) {
            super(model);
            imagePipelineArn(model.imagePipelineArn);
            description(model.description);
            imageRecipeArn(model.imageRecipeArn);
            containerRecipeArn(model.containerRecipeArn);
            infrastructureConfigurationArn(model.infrastructureConfigurationArn);
            distributionConfigurationArn(model.distributionConfigurationArn);
            imageTestsConfiguration(model.imageTestsConfiguration);
            enhancedImageMetadataEnabled(model.enhancedImageMetadataEnabled);
            schedule(model.schedule);
            status(model.status);
            clientToken(model.clientToken);
            imageScanningConfiguration(model.imageScanningConfiguration);
            workflows(model.workflows);
            executionRole(model.executionRole);
        }

        public final String getImagePipelineArn() {
            return imagePipelineArn;
        }

        public final void setImagePipelineArn(String imagePipelineArn) {
            this.imagePipelineArn = imagePipelineArn;
        }

        @Override
        public final Builder imagePipelineArn(String imagePipelineArn) {
            this.imagePipelineArn = imagePipelineArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getImageRecipeArn() {
            return imageRecipeArn;
        }

        public final void setImageRecipeArn(String imageRecipeArn) {
            this.imageRecipeArn = imageRecipeArn;
        }

        @Override
        public final Builder imageRecipeArn(String imageRecipeArn) {
            this.imageRecipeArn = imageRecipeArn;
            return this;
        }

        public final String getContainerRecipeArn() {
            return containerRecipeArn;
        }

        public final void setContainerRecipeArn(String containerRecipeArn) {
            this.containerRecipeArn = containerRecipeArn;
        }

        @Override
        public final Builder containerRecipeArn(String containerRecipeArn) {
            this.containerRecipeArn = containerRecipeArn;
            return this;
        }

        public final String getInfrastructureConfigurationArn() {
            return infrastructureConfigurationArn;
        }

        public final void setInfrastructureConfigurationArn(String infrastructureConfigurationArn) {
            this.infrastructureConfigurationArn = infrastructureConfigurationArn;
        }

        @Override
        public final Builder infrastructureConfigurationArn(String infrastructureConfigurationArn) {
            this.infrastructureConfigurationArn = infrastructureConfigurationArn;
            return this;
        }

        public final String getDistributionConfigurationArn() {
            return distributionConfigurationArn;
        }

        public final void setDistributionConfigurationArn(String distributionConfigurationArn) {
            this.distributionConfigurationArn = distributionConfigurationArn;
        }

        @Override
        public final Builder distributionConfigurationArn(String distributionConfigurationArn) {
            this.distributionConfigurationArn = distributionConfigurationArn;
            return this;
        }

        public final ImageTestsConfiguration.Builder getImageTestsConfiguration() {
            return imageTestsConfiguration != null ? imageTestsConfiguration.toBuilder() : null;
        }

        public final void setImageTestsConfiguration(ImageTestsConfiguration.BuilderImpl imageTestsConfiguration) {
            this.imageTestsConfiguration = imageTestsConfiguration != null ? imageTestsConfiguration.build() : null;
        }

        @Override
        public final Builder imageTestsConfiguration(ImageTestsConfiguration imageTestsConfiguration) {
            this.imageTestsConfiguration = imageTestsConfiguration;
            return this;
        }

        public final Boolean getEnhancedImageMetadataEnabled() {
            return enhancedImageMetadataEnabled;
        }

        public final void setEnhancedImageMetadataEnabled(Boolean enhancedImageMetadataEnabled) {
            this.enhancedImageMetadataEnabled = enhancedImageMetadataEnabled;
        }

        @Override
        public final Builder enhancedImageMetadataEnabled(Boolean enhancedImageMetadataEnabled) {
            this.enhancedImageMetadataEnabled = enhancedImageMetadataEnabled;
            return this;
        }

        public final Schedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PipelineStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final ImageScanningConfiguration.Builder getImageScanningConfiguration() {
            return imageScanningConfiguration != null ? imageScanningConfiguration.toBuilder() : null;
        }

        public final void setImageScanningConfiguration(ImageScanningConfiguration.BuilderImpl imageScanningConfiguration) {
            this.imageScanningConfiguration = imageScanningConfiguration != null ? imageScanningConfiguration.build() : null;
        }

        @Override
        public final Builder imageScanningConfiguration(ImageScanningConfiguration imageScanningConfiguration) {
            this.imageScanningConfiguration = imageScanningConfiguration;
            return this;
        }

        public final List<WorkflowConfiguration.Builder> getWorkflows() {
            List<WorkflowConfiguration.Builder> result = WorkflowConfigurationListCopier.copyToBuilder(this.workflows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkflows(Collection<WorkflowConfiguration.BuilderImpl> workflows) {
            this.workflows = WorkflowConfigurationListCopier.copyFromBuilder(workflows);
        }

        @Override
        public final Builder workflows(Collection<WorkflowConfiguration> workflows) {
            this.workflows = WorkflowConfigurationListCopier.copy(workflows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflows(WorkflowConfiguration... workflows) {
            workflows(Arrays.asList(workflows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflows(Consumer<WorkflowConfiguration.Builder>... workflows) {
            workflows(Stream.of(workflows).map(c -> WorkflowConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getExecutionRole() {
            return executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateImagePipelineRequest build() {
            return new UpdateImagePipelineRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
