/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Includes counts of image and pipeline resource findings by vulnerability.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VulnerabilityIdAggregation implements SdkPojo, Serializable,
        ToCopyableBuilder<VulnerabilityIdAggregation.Builder, VulnerabilityIdAggregation> {
    private static final SdkField<String> VULNERABILITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vulnerabilityId").getter(getter(VulnerabilityIdAggregation::vulnerabilityId))
            .setter(setter(Builder::vulnerabilityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vulnerabilityId").build()).build();

    private static final SdkField<SeverityCounts> SEVERITY_COUNTS_FIELD = SdkField
            .<SeverityCounts> builder(MarshallingType.SDK_POJO).memberName("severityCounts")
            .getter(getter(VulnerabilityIdAggregation::severityCounts)).setter(setter(Builder::severityCounts))
            .constructor(SeverityCounts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severityCounts").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VULNERABILITY_ID_FIELD,
            SEVERITY_COUNTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String vulnerabilityId;

    private final SeverityCounts severityCounts;

    private VulnerabilityIdAggregation(BuilderImpl builder) {
        this.vulnerabilityId = builder.vulnerabilityId;
        this.severityCounts = builder.severityCounts;
    }

    /**
     * <p>
     * The vulnerability Id for this set of counts.
     * </p>
     * 
     * @return The vulnerability Id for this set of counts.
     */
    public final String vulnerabilityId() {
        return vulnerabilityId;
    }

    /**
     * <p>
     * Counts by severity level for medium severity and higher level findings, plus a total for all of the findings for
     * the specified vulnerability.
     * </p>
     * 
     * @return Counts by severity level for medium severity and higher level findings, plus a total for all of the
     *         findings for the specified vulnerability.
     */
    public final SeverityCounts severityCounts() {
        return severityCounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vulnerabilityId());
        hashCode = 31 * hashCode + Objects.hashCode(severityCounts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VulnerabilityIdAggregation)) {
            return false;
        }
        VulnerabilityIdAggregation other = (VulnerabilityIdAggregation) obj;
        return Objects.equals(vulnerabilityId(), other.vulnerabilityId())
                && Objects.equals(severityCounts(), other.severityCounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VulnerabilityIdAggregation").add("VulnerabilityId", vulnerabilityId())
                .add("SeverityCounts", severityCounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vulnerabilityId":
            return Optional.ofNullable(clazz.cast(vulnerabilityId()));
        case "severityCounts":
            return Optional.ofNullable(clazz.cast(severityCounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vulnerabilityId", VULNERABILITY_ID_FIELD);
        map.put("severityCounts", SEVERITY_COUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VulnerabilityIdAggregation, T> g) {
        return obj -> g.apply((VulnerabilityIdAggregation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VulnerabilityIdAggregation> {
        /**
         * <p>
         * The vulnerability Id for this set of counts.
         * </p>
         * 
         * @param vulnerabilityId
         *        The vulnerability Id for this set of counts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vulnerabilityId(String vulnerabilityId);

        /**
         * <p>
         * Counts by severity level for medium severity and higher level findings, plus a total for all of the findings
         * for the specified vulnerability.
         * </p>
         * 
         * @param severityCounts
         *        Counts by severity level for medium severity and higher level findings, plus a total for all of the
         *        findings for the specified vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityCounts(SeverityCounts severityCounts);

        /**
         * <p>
         * Counts by severity level for medium severity and higher level findings, plus a total for all of the findings
         * for the specified vulnerability.
         * </p>
         * This is a convenience method that creates an instance of the {@link SeverityCounts.Builder} avoiding the need
         * to create one manually via {@link SeverityCounts#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SeverityCounts.Builder#build()} is called immediately and its
         * result is passed to {@link #severityCounts(SeverityCounts)}.
         * 
         * @param severityCounts
         *        a consumer that will call methods on {@link SeverityCounts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #severityCounts(SeverityCounts)
         */
        default Builder severityCounts(Consumer<SeverityCounts.Builder> severityCounts) {
            return severityCounts(SeverityCounts.builder().applyMutation(severityCounts).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String vulnerabilityId;

        private SeverityCounts severityCounts;

        private BuilderImpl() {
        }

        private BuilderImpl(VulnerabilityIdAggregation model) {
            vulnerabilityId(model.vulnerabilityId);
            severityCounts(model.severityCounts);
        }

        public final String getVulnerabilityId() {
            return vulnerabilityId;
        }

        public final void setVulnerabilityId(String vulnerabilityId) {
            this.vulnerabilityId = vulnerabilityId;
        }

        @Override
        public final Builder vulnerabilityId(String vulnerabilityId) {
            this.vulnerabilityId = vulnerabilityId;
            return this;
        }

        public final SeverityCounts.Builder getSeverityCounts() {
            return severityCounts != null ? severityCounts.toBuilder() : null;
        }

        public final void setSeverityCounts(SeverityCounts.BuilderImpl severityCounts) {
            this.severityCounts = severityCounts != null ? severityCounts.build() : null;
        }

        @Override
        public final Builder severityCounts(SeverityCounts severityCounts) {
            this.severityCounts = severityCounts;
            return this;
        }

        @Override
        public VulnerabilityIdAggregation build() {
            return new VulnerabilityIdAggregation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
