/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a process that Image Builder uses to build and test images during the image creation process.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Workflow implements SdkPojo, Serializable, ToCopyableBuilder<Workflow.Builder, Workflow> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Workflow::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Workflow::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(Workflow::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(Workflow::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> CHANGE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("changeDescription").getter(getter(Workflow::changeDescription))
            .setter(setter(Builder::changeDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changeDescription").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(Workflow::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<WorkflowState> STATE_FIELD = SdkField.<WorkflowState> builder(MarshallingType.SDK_POJO)
            .memberName("state").getter(getter(Workflow::state)).setter(setter(Builder::state))
            .constructor(WorkflowState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("owner")
            .getter(getter(Workflow::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()).build();

    private static final SdkField<String> DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("data")
            .getter(getter(Workflow::data)).setter(setter(Builder::data))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(Workflow::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<String> DATE_CREATED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dateCreated").getter(getter(Workflow::dateCreated)).setter(setter(Builder::dateCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateCreated").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(Workflow::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<WorkflowParameterDetail>> PARAMETERS_FIELD = SdkField
            .<List<WorkflowParameterDetail>> builder(MarshallingType.LIST)
            .memberName("parameters")
            .getter(getter(Workflow::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkflowParameterDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkflowParameterDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            VERSION_FIELD, DESCRIPTION_FIELD, CHANGE_DESCRIPTION_FIELD, TYPE_FIELD, STATE_FIELD, OWNER_FIELD, DATA_FIELD,
            KMS_KEY_ID_FIELD, DATE_CREATED_FIELD, TAGS_FIELD, PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String version;

    private final String description;

    private final String changeDescription;

    private final String type;

    private final WorkflowState state;

    private final String owner;

    private final String data;

    private final String kmsKeyId;

    private final String dateCreated;

    private final Map<String, String> tags;

    private final List<WorkflowParameterDetail> parameters;

    private Workflow(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.version = builder.version;
        this.description = builder.description;
        this.changeDescription = builder.changeDescription;
        this.type = builder.type;
        this.state = builder.state;
        this.owner = builder.owner;
        this.data = builder.data;
        this.kmsKeyId = builder.kmsKeyId;
        this.dateCreated = builder.dateCreated;
        this.tags = builder.tags;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the workflow resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the workflow resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the workflow resource.
     * </p>
     * 
     * @return The name of the workflow resource.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The workflow resource version. Workflow resources are immutable. To make a change, you can clone a workflow or
     * create a new version.
     * </p>
     * 
     * @return The workflow resource version. Workflow resources are immutable. To make a change, you can clone a
     *         workflow or create a new version.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The description of the workflow.
     * </p>
     * 
     * @return The description of the workflow.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Describes what change has been made in this version of the workflow, or what makes this version different from
     * other versions of the workflow.
     * </p>
     * 
     * @return Describes what change has been made in this version of the workflow, or what makes this version different
     *         from other versions of the workflow.
     */
    public final String changeDescription() {
        return changeDescription;
    }

    /**
     * <p>
     * Specifies the image creation stage that the workflow applies to. Image Builder currently supports build and test
     * workflows.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link WorkflowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies the image creation stage that the workflow applies to. Image Builder currently supports build
     *         and test workflows.
     * @see WorkflowType
     */
    public final WorkflowType type() {
        return WorkflowType.fromValue(type);
    }

    /**
     * <p>
     * Specifies the image creation stage that the workflow applies to. Image Builder currently supports build and test
     * workflows.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link WorkflowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies the image creation stage that the workflow applies to. Image Builder currently supports build
     *         and test workflows.
     * @see WorkflowType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Describes the current status of the workflow and the reason for that status.
     * </p>
     * 
     * @return Describes the current status of the workflow and the reason for that status.
     */
    public final WorkflowState state() {
        return state;
    }

    /**
     * <p>
     * The owner of the workflow resource.
     * </p>
     * 
     * @return The owner of the workflow resource.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * Contains the YAML document content for the workflow.
     * </p>
     * 
     * @return Contains the YAML document content for the workflow.
     */
    public final String data() {
        return data;
    }

    /**
     * <p>
     * The KMS key identifier used to encrypt the workflow resource.
     * </p>
     * 
     * @return The KMS key identifier used to encrypt the workflow resource.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The timestamp when Image Builder created the workflow resource.
     * </p>
     * 
     * @return The timestamp when Image Builder created the workflow resource.
     */
    public final String dateCreated() {
        return dateCreated;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags that apply to the workflow resource
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags that apply to the workflow resource
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of input parameters that that the image workflow uses to control actions or configure settings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return An array of input parameters that that the image workflow uses to control actions or configure settings.
     */
    public final List<WorkflowParameterDetail> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(changeDescription());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(data());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Workflow)) {
            return false;
        }
        Workflow other = (Workflow) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(version(), other.version()) && Objects.equals(description(), other.description())
                && Objects.equals(changeDescription(), other.changeDescription())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(state(), other.state())
                && Objects.equals(owner(), other.owner()) && Objects.equals(data(), other.data())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(dateCreated(), other.dateCreated())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Workflow").add("Arn", arn()).add("Name", name()).add("Version", version())
                .add("Description", description()).add("ChangeDescription", changeDescription()).add("Type", typeAsString())
                .add("State", state()).add("Owner", owner()).add("Data", data()).add("KmsKeyId", kmsKeyId())
                .add("DateCreated", dateCreated()).add("Tags", hasTags() ? tags() : null)
                .add("Parameters", hasParameters() ? parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "changeDescription":
            return Optional.ofNullable(clazz.cast(changeDescription()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "state":
            return Optional.ofNullable(clazz.cast(state()));
        case "owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "data":
            return Optional.ofNullable(clazz.cast(data()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "dateCreated":
            return Optional.ofNullable(clazz.cast(dateCreated()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("changeDescription", CHANGE_DESCRIPTION_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("state", STATE_FIELD);
        map.put("owner", OWNER_FIELD);
        map.put("data", DATA_FIELD);
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        map.put("dateCreated", DATE_CREATED_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Workflow, T> g) {
        return obj -> g.apply((Workflow) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Workflow> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the workflow resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the workflow resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the workflow resource.
         * </p>
         * 
         * @param name
         *        The name of the workflow resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The workflow resource version. Workflow resources are immutable. To make a change, you can clone a workflow
         * or create a new version.
         * </p>
         * 
         * @param version
         *        The workflow resource version. Workflow resources are immutable. To make a change, you can clone a
         *        workflow or create a new version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The description of the workflow.
         * </p>
         * 
         * @param description
         *        The description of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Describes what change has been made in this version of the workflow, or what makes this version different
         * from other versions of the workflow.
         * </p>
         * 
         * @param changeDescription
         *        Describes what change has been made in this version of the workflow, or what makes this version
         *        different from other versions of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeDescription(String changeDescription);

        /**
         * <p>
         * Specifies the image creation stage that the workflow applies to. Image Builder currently supports build and
         * test workflows.
         * </p>
         * 
         * @param type
         *        Specifies the image creation stage that the workflow applies to. Image Builder currently supports
         *        build and test workflows.
         * @see WorkflowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowType
         */
        Builder type(String type);

        /**
         * <p>
         * Specifies the image creation stage that the workflow applies to. Image Builder currently supports build and
         * test workflows.
         * </p>
         * 
         * @param type
         *        Specifies the image creation stage that the workflow applies to. Image Builder currently supports
         *        build and test workflows.
         * @see WorkflowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowType
         */
        Builder type(WorkflowType type);

        /**
         * <p>
         * Describes the current status of the workflow and the reason for that status.
         * </p>
         * 
         * @param state
         *        Describes the current status of the workflow and the reason for that status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(WorkflowState state);

        /**
         * <p>
         * Describes the current status of the workflow and the reason for that status.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkflowState.Builder} avoiding the need
         * to create one manually via {@link WorkflowState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkflowState.Builder#build()} is called immediately and its
         * result is passed to {@link #state(WorkflowState)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link WorkflowState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(WorkflowState)
         */
        default Builder state(Consumer<WorkflowState.Builder> state) {
            return state(WorkflowState.builder().applyMutation(state).build());
        }

        /**
         * <p>
         * The owner of the workflow resource.
         * </p>
         * 
         * @param owner
         *        The owner of the workflow resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * Contains the YAML document content for the workflow.
         * </p>
         * 
         * @param data
         *        Contains the YAML document content for the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(String data);

        /**
         * <p>
         * The KMS key identifier used to encrypt the workflow resource.
         * </p>
         * 
         * @param kmsKeyId
         *        The KMS key identifier used to encrypt the workflow resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The timestamp when Image Builder created the workflow resource.
         * </p>
         * 
         * @param dateCreated
         *        The timestamp when Image Builder created the workflow resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateCreated(String dateCreated);

        /**
         * <p>
         * The tags that apply to the workflow resource
         * </p>
         * 
         * @param tags
         *        The tags that apply to the workflow resource
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * An array of input parameters that that the image workflow uses to control actions or configure settings.
         * </p>
         * 
         * @param parameters
         *        An array of input parameters that that the image workflow uses to control actions or configure
         *        settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<WorkflowParameterDetail> parameters);

        /**
         * <p>
         * An array of input parameters that that the image workflow uses to control actions or configure settings.
         * </p>
         * 
         * @param parameters
         *        An array of input parameters that that the image workflow uses to control actions or configure
         *        settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(WorkflowParameterDetail... parameters);

        /**
         * <p>
         * An array of input parameters that that the image workflow uses to control actions or configure settings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.imagebuilder.model.WorkflowParameterDetail.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.imagebuilder.model.WorkflowParameterDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.imagebuilder.model.WorkflowParameterDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #parameters(List<WorkflowParameterDetail>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.imagebuilder.model.WorkflowParameterDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(java.util.Collection<WorkflowParameterDetail>)
         */
        Builder parameters(Consumer<WorkflowParameterDetail.Builder>... parameters);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String version;

        private String description;

        private String changeDescription;

        private String type;

        private WorkflowState state;

        private String owner;

        private String data;

        private String kmsKeyId;

        private String dateCreated;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<WorkflowParameterDetail> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Workflow model) {
            arn(model.arn);
            name(model.name);
            version(model.version);
            description(model.description);
            changeDescription(model.changeDescription);
            type(model.type);
            state(model.state);
            owner(model.owner);
            data(model.data);
            kmsKeyId(model.kmsKeyId);
            dateCreated(model.dateCreated);
            tags(model.tags);
            parameters(model.parameters);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getChangeDescription() {
            return changeDescription;
        }

        public final void setChangeDescription(String changeDescription) {
            this.changeDescription = changeDescription;
        }

        @Override
        public final Builder changeDescription(String changeDescription) {
            this.changeDescription = changeDescription;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(WorkflowType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final WorkflowState.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        public final void setState(WorkflowState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(WorkflowState state) {
            this.state = state;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getData() {
            return data;
        }

        public final void setData(String data) {
            this.data = data;
        }

        @Override
        public final Builder data(String data) {
            this.data = data;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getDateCreated() {
            return dateCreated;
        }

        public final void setDateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
        }

        @Override
        public final Builder dateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final List<WorkflowParameterDetail.Builder> getParameters() {
            List<WorkflowParameterDetail.Builder> result = WorkflowParameterDetailListCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<WorkflowParameterDetail.BuilderImpl> parameters) {
            this.parameters = WorkflowParameterDetailListCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<WorkflowParameterDetail> parameters) {
            this.parameters = WorkflowParameterDetailListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(WorkflowParameterDetail... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<WorkflowParameterDetail.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> WorkflowParameterDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Workflow build() {
            return new Workflow(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
