/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Runtime details and status for the workflow step.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkflowStepMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkflowStepMetadata.Builder, WorkflowStepMetadata> {
    private static final SdkField<String> STEP_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stepExecutionId").getter(getter(WorkflowStepMetadata::stepExecutionId))
            .setter(setter(Builder::stepExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepExecutionId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(WorkflowStepMetadata::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(WorkflowStepMetadata::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(WorkflowStepMetadata::action)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(WorkflowStepMetadata::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> ROLLBACK_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rollbackStatus").getter(getter(WorkflowStepMetadata::rollbackStatusAsString))
            .setter(setter(Builder::rollbackStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rollbackStatus").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(WorkflowStepMetadata::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<String> INPUTS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("inputs")
            .getter(getter(WorkflowStepMetadata::inputs)).setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputs").build()).build();

    private static final SdkField<String> OUTPUTS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("outputs")
            .getter(getter(WorkflowStepMetadata::outputs)).setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build()).build();

    private static final SdkField<String> START_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("startTime").getter(getter(WorkflowStepMetadata::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<String> END_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endTime").getter(getter(WorkflowStepMetadata::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_EXECUTION_ID_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, ACTION_FIELD, STATUS_FIELD, ROLLBACK_STATUS_FIELD, MESSAGE_FIELD, INPUTS_FIELD,
            OUTPUTS_FIELD, START_TIME_FIELD, END_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String stepExecutionId;

    private final String name;

    private final String description;

    private final String action;

    private final String status;

    private final String rollbackStatus;

    private final String message;

    private final String inputs;

    private final String outputs;

    private final String startTime;

    private final String endTime;

    private WorkflowStepMetadata(BuilderImpl builder) {
        this.stepExecutionId = builder.stepExecutionId;
        this.name = builder.name;
        this.description = builder.description;
        this.action = builder.action;
        this.status = builder.status;
        this.rollbackStatus = builder.rollbackStatus;
        this.message = builder.message;
        this.inputs = builder.inputs;
        this.outputs = builder.outputs;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    /**
     * <p>
     * A unique identifier for the workflow step, assigned at runtime.
     * </p>
     * 
     * @return A unique identifier for the workflow step, assigned at runtime.
     */
    public final String stepExecutionId() {
        return stepExecutionId;
    }

    /**
     * <p>
     * The name of the workflow step.
     * </p>
     * 
     * @return The name of the workflow step.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Description of the workflow step.
     * </p>
     * 
     * @return Description of the workflow step.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The step action name.
     * </p>
     * 
     * @return The step action name.
     */
    public final String action() {
        return action;
    }

    /**
     * <p>
     * Runtime status for the workflow step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkflowStepExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Runtime status for the workflow step.
     * @see WorkflowStepExecutionStatus
     */
    public final WorkflowStepExecutionStatus status() {
        return WorkflowStepExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * Runtime status for the workflow step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkflowStepExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Runtime status for the workflow step.
     * @see WorkflowStepExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Reports on the rollback status of the step, if applicable.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rollbackStatus}
     * will return {@link WorkflowStepExecutionRollbackStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #rollbackStatusAsString}.
     * </p>
     * 
     * @return Reports on the rollback status of the step, if applicable.
     * @see WorkflowStepExecutionRollbackStatus
     */
    public final WorkflowStepExecutionRollbackStatus rollbackStatus() {
        return WorkflowStepExecutionRollbackStatus.fromValue(rollbackStatus);
    }

    /**
     * <p>
     * Reports on the rollback status of the step, if applicable.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rollbackStatus}
     * will return {@link WorkflowStepExecutionRollbackStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #rollbackStatusAsString}.
     * </p>
     * 
     * @return Reports on the rollback status of the step, if applicable.
     * @see WorkflowStepExecutionRollbackStatus
     */
    public final String rollbackStatusAsString() {
        return rollbackStatus;
    }

    /**
     * <p>
     * Detailed output message that the workflow step provides at runtime.
     * </p>
     * 
     * @return Detailed output message that the workflow step provides at runtime.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * Input parameters that Image Builder provides for the workflow step.
     * </p>
     * 
     * @return Input parameters that Image Builder provides for the workflow step.
     */
    public final String inputs() {
        return inputs;
    }

    /**
     * <p>
     * The file names that the workflow step created as output for this runtime instance of the workflow.
     * </p>
     * 
     * @return The file names that the workflow step created as output for this runtime instance of the workflow.
     */
    public final String outputs() {
        return outputs;
    }

    /**
     * <p>
     * The timestamp when the workflow step started.
     * </p>
     * 
     * @return The timestamp when the workflow step started.
     */
    public final String startTime() {
        return startTime;
    }

    /**
     * <p>
     * The timestamp when the workflow step finished.
     * </p>
     * 
     * @return The timestamp when the workflow step finished.
     */
    public final String endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stepExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(rollbackStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(inputs());
        hashCode = 31 * hashCode + Objects.hashCode(outputs());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowStepMetadata)) {
            return false;
        }
        WorkflowStepMetadata other = (WorkflowStepMetadata) obj;
        return Objects.equals(stepExecutionId(), other.stepExecutionId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(action(), other.action())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(rollbackStatusAsString(), other.rollbackStatusAsString())
                && Objects.equals(message(), other.message()) && Objects.equals(inputs(), other.inputs())
                && Objects.equals(outputs(), other.outputs()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkflowStepMetadata").add("StepExecutionId", stepExecutionId()).add("Name", name())
                .add("Description", description()).add("Action", action()).add("Status", statusAsString())
                .add("RollbackStatus", rollbackStatusAsString()).add("Message", message()).add("Inputs", inputs())
                .add("Outputs", outputs()).add("StartTime", startTime()).add("EndTime", endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stepExecutionId":
            return Optional.ofNullable(clazz.cast(stepExecutionId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "rollbackStatus":
            return Optional.ofNullable(clazz.cast(rollbackStatusAsString()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stepExecutionId", STEP_EXECUTION_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("action", ACTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("rollbackStatus", ROLLBACK_STATUS_FIELD);
        map.put("message", MESSAGE_FIELD);
        map.put("inputs", INPUTS_FIELD);
        map.put("outputs", OUTPUTS_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkflowStepMetadata, T> g) {
        return obj -> g.apply((WorkflowStepMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkflowStepMetadata> {
        /**
         * <p>
         * A unique identifier for the workflow step, assigned at runtime.
         * </p>
         * 
         * @param stepExecutionId
         *        A unique identifier for the workflow step, assigned at runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepExecutionId(String stepExecutionId);

        /**
         * <p>
         * The name of the workflow step.
         * </p>
         * 
         * @param name
         *        The name of the workflow step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Description of the workflow step.
         * </p>
         * 
         * @param description
         *        Description of the workflow step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The step action name.
         * </p>
         * 
         * @param action
         *        The step action name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String action);

        /**
         * <p>
         * Runtime status for the workflow step.
         * </p>
         * 
         * @param status
         *        Runtime status for the workflow step.
         * @see WorkflowStepExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowStepExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Runtime status for the workflow step.
         * </p>
         * 
         * @param status
         *        Runtime status for the workflow step.
         * @see WorkflowStepExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowStepExecutionStatus
         */
        Builder status(WorkflowStepExecutionStatus status);

        /**
         * <p>
         * Reports on the rollback status of the step, if applicable.
         * </p>
         * 
         * @param rollbackStatus
         *        Reports on the rollback status of the step, if applicable.
         * @see WorkflowStepExecutionRollbackStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowStepExecutionRollbackStatus
         */
        Builder rollbackStatus(String rollbackStatus);

        /**
         * <p>
         * Reports on the rollback status of the step, if applicable.
         * </p>
         * 
         * @param rollbackStatus
         *        Reports on the rollback status of the step, if applicable.
         * @see WorkflowStepExecutionRollbackStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowStepExecutionRollbackStatus
         */
        Builder rollbackStatus(WorkflowStepExecutionRollbackStatus rollbackStatus);

        /**
         * <p>
         * Detailed output message that the workflow step provides at runtime.
         * </p>
         * 
         * @param message
         *        Detailed output message that the workflow step provides at runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * Input parameters that Image Builder provides for the workflow step.
         * </p>
         * 
         * @param inputs
         *        Input parameters that Image Builder provides for the workflow step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(String inputs);

        /**
         * <p>
         * The file names that the workflow step created as output for this runtime instance of the workflow.
         * </p>
         * 
         * @param outputs
         *        The file names that the workflow step created as output for this runtime instance of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(String outputs);

        /**
         * <p>
         * The timestamp when the workflow step started.
         * </p>
         * 
         * @param startTime
         *        The timestamp when the workflow step started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(String startTime);

        /**
         * <p>
         * The timestamp when the workflow step finished.
         * </p>
         * 
         * @param endTime
         *        The timestamp when the workflow step finished.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(String endTime);
    }

    static final class BuilderImpl implements Builder {
        private String stepExecutionId;

        private String name;

        private String description;

        private String action;

        private String status;

        private String rollbackStatus;

        private String message;

        private String inputs;

        private String outputs;

        private String startTime;

        private String endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowStepMetadata model) {
            stepExecutionId(model.stepExecutionId);
            name(model.name);
            description(model.description);
            action(model.action);
            status(model.status);
            rollbackStatus(model.rollbackStatus);
            message(model.message);
            inputs(model.inputs);
            outputs(model.outputs);
            startTime(model.startTime);
            endTime(model.endTime);
        }

        public final String getStepExecutionId() {
            return stepExecutionId;
        }

        public final void setStepExecutionId(String stepExecutionId) {
            this.stepExecutionId = stepExecutionId;
        }

        @Override
        public final Builder stepExecutionId(String stepExecutionId) {
            this.stepExecutionId = stepExecutionId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkflowStepExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getRollbackStatus() {
            return rollbackStatus;
        }

        public final void setRollbackStatus(String rollbackStatus) {
            this.rollbackStatus = rollbackStatus;
        }

        @Override
        public final Builder rollbackStatus(String rollbackStatus) {
            this.rollbackStatus = rollbackStatus;
            return this;
        }

        @Override
        public final Builder rollbackStatus(WorkflowStepExecutionRollbackStatus rollbackStatus) {
            this.rollbackStatus(rollbackStatus == null ? null : rollbackStatus.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getInputs() {
            return inputs;
        }

        public final void setInputs(String inputs) {
            this.inputs = inputs;
        }

        @Override
        public final Builder inputs(String inputs) {
            this.inputs = inputs;
            return this;
        }

        public final String getOutputs() {
            return outputs;
        }

        public final void setOutputs(String outputs) {
            this.outputs = outputs;
        }

        @Override
        public final Builder outputs(String outputs) {
            this.outputs = outputs;
            return this;
        }

        public final String getStartTime() {
            return startTime;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getEndTime() {
            return endTime;
        }

        public final void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public WorkflowStepMetadata build() {
            return new WorkflowStepMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
