/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of an Amazon EC2 AMI.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ami implements SdkPojo, Serializable, ToCopyableBuilder<Ami.Builder, Ami> {
    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(Ami::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<String> IMAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("image")
            .getter(getter(Ami::image)).setter(setter(Builder::image))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Ami::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(Ami::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<ImageState> STATE_FIELD = SdkField.<ImageState> builder(MarshallingType.SDK_POJO)
            .memberName("state").getter(getter(Ami::state)).setter(setter(Builder::state)).constructor(ImageState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(Ami::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD, IMAGE_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, STATE_FIELD, ACCOUNT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String region;

    private final String image;

    private final String name;

    private final String description;

    private final ImageState state;

    private final String accountId;

    private Ami(BuilderImpl builder) {
        this.region = builder.region;
        this.image = builder.image;
        this.name = builder.name;
        this.description = builder.description;
        this.state = builder.state;
        this.accountId = builder.accountId;
    }

    /**
     * <p>
     * The Amazon Web Services Region of the Amazon EC2 AMI.
     * </p>
     * 
     * @return The Amazon Web Services Region of the Amazon EC2 AMI.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The AMI ID of the Amazon EC2 AMI.
     * </p>
     * 
     * @return The AMI ID of the Amazon EC2 AMI.
     */
    public final String image() {
        return image;
    }

    /**
     * <p>
     * The name of the Amazon EC2 AMI.
     * </p>
     * 
     * @return The name of the Amazon EC2 AMI.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the Amazon EC2 AMI. Minimum and maximum length are in characters.
     * </p>
     * 
     * @return The description of the Amazon EC2 AMI. Minimum and maximum length are in characters.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns the value of the State property for this object.
     * 
     * @return The value of the State property for this object.
     */
    public final ImageState state() {
        return state;
    }

    /**
     * <p>
     * The account ID of the owner of the AMI.
     * </p>
     * 
     * @return The account ID of the owner of the AMI.
     */
    public final String accountId() {
        return accountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ami)) {
            return false;
        }
        Ami other = (Ami) obj;
        return Objects.equals(region(), other.region()) && Objects.equals(image(), other.image())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(state(), other.state()) && Objects.equals(accountId(), other.accountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Ami").add("Region", region()).add("Image", image()).add("Name", name())
                .add("Description", description()).add("State", state()).add("AccountId", accountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "image":
            return Optional.ofNullable(clazz.cast(image()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "state":
            return Optional.ofNullable(clazz.cast(state()));
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("region", REGION_FIELD);
        map.put("image", IMAGE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("state", STATE_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Ami, T> g) {
        return obj -> g.apply((Ami) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ami> {
        /**
         * <p>
         * The Amazon Web Services Region of the Amazon EC2 AMI.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region of the Amazon EC2 AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The AMI ID of the Amazon EC2 AMI.
         * </p>
         * 
         * @param image
         *        The AMI ID of the Amazon EC2 AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(String image);

        /**
         * <p>
         * The name of the Amazon EC2 AMI.
         * </p>
         * 
         * @param name
         *        The name of the Amazon EC2 AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the Amazon EC2 AMI. Minimum and maximum length are in characters.
         * </p>
         * 
         * @param description
         *        The description of the Amazon EC2 AMI. Minimum and maximum length are in characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the State property for this object.
         *
         * @param state
         *        The new value for the State property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(ImageState state);

        /**
         * Sets the value of the State property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ImageState.Builder} avoiding the need to
         * create one manually via {@link ImageState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageState.Builder#build()} is called immediately and its result
         * is passed to {@link #state(ImageState)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link ImageState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(ImageState)
         */
        default Builder state(Consumer<ImageState.Builder> state) {
            return state(ImageState.builder().applyMutation(state).build());
        }

        /**
         * <p>
         * The account ID of the owner of the AMI.
         * </p>
         * 
         * @param accountId
         *        The account ID of the owner of the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);
    }

    static final class BuilderImpl implements Builder {
        private String region;

        private String image;

        private String name;

        private String description;

        private ImageState state;

        private String accountId;

        private BuilderImpl() {
        }

        private BuilderImpl(Ami model) {
            region(model.region);
            image(model.image);
            name(model.name);
            description(model.description);
            state(model.state);
            accountId(model.accountId);
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getImage() {
            return image;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ImageState.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        public final void setState(ImageState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(ImageState state) {
            this.state = state;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        @Override
        public Ami build() {
            return new Ami(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
