/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLifecyclePolicyRequest extends ImagebuilderRequest implements
        ToCopyableBuilder<CreateLifecyclePolicyRequest.Builder, CreateLifecyclePolicyRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateLifecyclePolicyRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateLifecyclePolicyRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateLifecyclePolicyRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRole").getter(getter(CreateLifecyclePolicyRequest::executionRole))
            .setter(setter(Builder::executionRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRole").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(CreateLifecyclePolicyRequest::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<List<LifecyclePolicyDetail>> POLICY_DETAILS_FIELD = SdkField
            .<List<LifecyclePolicyDetail>> builder(MarshallingType.LIST)
            .memberName("policyDetails")
            .getter(getter(CreateLifecyclePolicyRequest::policyDetails))
            .setter(setter(Builder::policyDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LifecyclePolicyDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(LifecyclePolicyDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<LifecyclePolicyResourceSelection> RESOURCE_SELECTION_FIELD = SdkField
            .<LifecyclePolicyResourceSelection> builder(MarshallingType.SDK_POJO).memberName("resourceSelection")
            .getter(getter(CreateLifecyclePolicyRequest::resourceSelection)).setter(setter(Builder::resourceSelection))
            .constructor(LifecyclePolicyResourceSelection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSelection").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateLifecyclePolicyRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateLifecyclePolicyRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            STATUS_FIELD, EXECUTION_ROLE_FIELD, RESOURCE_TYPE_FIELD, POLICY_DETAILS_FIELD, RESOURCE_SELECTION_FIELD, TAGS_FIELD,
            CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String description;

    private final String status;

    private final String executionRole;

    private final String resourceType;

    private final List<LifecyclePolicyDetail> policyDetails;

    private final LifecyclePolicyResourceSelection resourceSelection;

    private final Map<String, String> tags;

    private final String clientToken;

    private CreateLifecyclePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.status = builder.status;
        this.executionRole = builder.executionRole;
        this.resourceType = builder.resourceType;
        this.policyDetails = builder.policyDetails;
        this.resourceSelection = builder.resourceSelection;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name of the lifecycle policy to create.
     * </p>
     * 
     * @return The name of the lifecycle policy to create.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Optional description for the lifecycle policy.
     * </p>
     * 
     * @return Optional description for the lifecycle policy.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Indicates whether the lifecycle policy resource is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LifecyclePolicyStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates whether the lifecycle policy resource is enabled.
     * @see LifecyclePolicyStatus
     */
    public final LifecyclePolicyStatus status() {
        return LifecyclePolicyStatus.fromValue(status);
    }

    /**
     * <p>
     * Indicates whether the lifecycle policy resource is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LifecyclePolicyStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates whether the lifecycle policy resource is enabled.
     * @see LifecyclePolicyStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to run
     * lifecycle actions.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to
     *         run lifecycle actions.
     */
    public final String executionRole() {
        return executionRole;
    }

    /**
     * <p>
     * The type of Image Builder resource that the lifecycle policy applies to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link LifecyclePolicyResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of Image Builder resource that the lifecycle policy applies to.
     * @see LifecyclePolicyResourceType
     */
    public final LifecyclePolicyResourceType resourceType() {
        return LifecyclePolicyResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of Image Builder resource that the lifecycle policy applies to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link LifecyclePolicyResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of Image Builder resource that the lifecycle policy applies to.
     * @see LifecyclePolicyResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the PolicyDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPolicyDetails() {
        return policyDetails != null && !(policyDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configuration details for the lifecycle policy rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicyDetails} method.
     * </p>
     * 
     * @return Configuration details for the lifecycle policy rules.
     */
    public final List<LifecyclePolicyDetail> policyDetails() {
        return policyDetails;
    }

    /**
     * <p>
     * Selection criteria for the resources that the lifecycle policy applies to.
     * </p>
     * 
     * @return Selection criteria for the resources that the lifecycle policy applies to.
     */
    public final LifecyclePolicyResourceSelection resourceSelection() {
        return resourceSelection;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags to apply to the lifecycle policy resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags to apply to the lifecycle policy resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * idempotency</a> in the <i>Amazon EC2 API Reference</i>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information,
     *         see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         idempotency</a> in the <i>Amazon EC2 API Reference</i>.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicyDetails() ? policyDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceSelection());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLifecyclePolicyRequest)) {
            return false;
        }
        CreateLifecyclePolicyRequest other = (CreateLifecyclePolicyRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(executionRole(), other.executionRole())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && hasPolicyDetails() == other.hasPolicyDetails() && Objects.equals(policyDetails(), other.policyDetails())
                && Objects.equals(resourceSelection(), other.resourceSelection()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLifecyclePolicyRequest").add("Name", name()).add("Description", description())
                .add("Status", statusAsString()).add("ExecutionRole", executionRole())
                .add("ResourceType", resourceTypeAsString()).add("PolicyDetails", hasPolicyDetails() ? policyDetails() : null)
                .add("ResourceSelection", resourceSelection()).add("Tags", hasTags() ? tags() : null)
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "executionRole":
            return Optional.ofNullable(clazz.cast(executionRole()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "policyDetails":
            return Optional.ofNullable(clazz.cast(policyDetails()));
        case "resourceSelection":
            return Optional.ofNullable(clazz.cast(resourceSelection()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("executionRole", EXECUTION_ROLE_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("policyDetails", POLICY_DETAILS_FIELD);
        map.put("resourceSelection", RESOURCE_SELECTION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLifecyclePolicyRequest, T> g) {
        return obj -> g.apply((CreateLifecyclePolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ImagebuilderRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateLifecyclePolicyRequest> {
        /**
         * <p>
         * The name of the lifecycle policy to create.
         * </p>
         * 
         * @param name
         *        The name of the lifecycle policy to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Optional description for the lifecycle policy.
         * </p>
         * 
         * @param description
         *        Optional description for the lifecycle policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Indicates whether the lifecycle policy resource is enabled.
         * </p>
         * 
         * @param status
         *        Indicates whether the lifecycle policy resource is enabled.
         * @see LifecyclePolicyStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecyclePolicyStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates whether the lifecycle policy resource is enabled.
         * </p>
         * 
         * @param status
         *        Indicates whether the lifecycle policy resource is enabled.
         * @see LifecyclePolicyStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecyclePolicyStatus
         */
        Builder status(LifecyclePolicyStatus status);

        /**
         * <p>
         * The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to run
         * lifecycle actions.
         * </p>
         * 
         * @param executionRole
         *        The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to
         *        run lifecycle actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRole(String executionRole);

        /**
         * <p>
         * The type of Image Builder resource that the lifecycle policy applies to.
         * </p>
         * 
         * @param resourceType
         *        The type of Image Builder resource that the lifecycle policy applies to.
         * @see LifecyclePolicyResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecyclePolicyResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of Image Builder resource that the lifecycle policy applies to.
         * </p>
         * 
         * @param resourceType
         *        The type of Image Builder resource that the lifecycle policy applies to.
         * @see LifecyclePolicyResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecyclePolicyResourceType
         */
        Builder resourceType(LifecyclePolicyResourceType resourceType);

        /**
         * <p>
         * Configuration details for the lifecycle policy rules.
         * </p>
         * 
         * @param policyDetails
         *        Configuration details for the lifecycle policy rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDetails(Collection<LifecyclePolicyDetail> policyDetails);

        /**
         * <p>
         * Configuration details for the lifecycle policy rules.
         * </p>
         * 
         * @param policyDetails
         *        Configuration details for the lifecycle policy rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDetails(LifecyclePolicyDetail... policyDetails);

        /**
         * <p>
         * Configuration details for the lifecycle policy rules.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetail.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #policyDetails(List<LifecyclePolicyDetail>)}.
         * 
         * @param policyDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyDetails(java.util.Collection<LifecyclePolicyDetail>)
         */
        Builder policyDetails(Consumer<LifecyclePolicyDetail.Builder>... policyDetails);

        /**
         * <p>
         * Selection criteria for the resources that the lifecycle policy applies to.
         * </p>
         * 
         * @param resourceSelection
         *        Selection criteria for the resources that the lifecycle policy applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSelection(LifecyclePolicyResourceSelection resourceSelection);

        /**
         * <p>
         * Selection criteria for the resources that the lifecycle policy applies to.
         * </p>
         * This is a convenience method that creates an instance of the {@link LifecyclePolicyResourceSelection.Builder}
         * avoiding the need to create one manually via {@link LifecyclePolicyResourceSelection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LifecyclePolicyResourceSelection.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceSelection(LifecyclePolicyResourceSelection)}.
         * 
         * @param resourceSelection
         *        a consumer that will call methods on {@link LifecyclePolicyResourceSelection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceSelection(LifecyclePolicyResourceSelection)
         */
        default Builder resourceSelection(Consumer<LifecyclePolicyResourceSelection.Builder> resourceSelection) {
            return resourceSelection(LifecyclePolicyResourceSelection.builder().applyMutation(resourceSelection).build());
        }

        /**
         * <p>
         * Tags to apply to the lifecycle policy resource.
         * </p>
         * 
         * @param tags
         *        Tags to apply to the lifecycle policy resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see
         * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * idempotency</a> in the <i>Amazon EC2 API Reference</i>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        idempotency</a> in the <i>Amazon EC2 API Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ImagebuilderRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String status;

        private String executionRole;

        private String resourceType;

        private List<LifecyclePolicyDetail> policyDetails = DefaultSdkAutoConstructList.getInstance();

        private LifecyclePolicyResourceSelection resourceSelection;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLifecyclePolicyRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            status(model.status);
            executionRole(model.executionRole);
            resourceType(model.resourceType);
            policyDetails(model.policyDetails);
            resourceSelection(model.resourceSelection);
            tags(model.tags);
            clientToken(model.clientToken);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LifecyclePolicyStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getExecutionRole() {
            return executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(LifecyclePolicyResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final List<LifecyclePolicyDetail.Builder> getPolicyDetails() {
            List<LifecyclePolicyDetail.Builder> result = LifecyclePolicyDetailsCopier.copyToBuilder(this.policyDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyDetails(Collection<LifecyclePolicyDetail.BuilderImpl> policyDetails) {
            this.policyDetails = LifecyclePolicyDetailsCopier.copyFromBuilder(policyDetails);
        }

        @Override
        public final Builder policyDetails(Collection<LifecyclePolicyDetail> policyDetails) {
            this.policyDetails = LifecyclePolicyDetailsCopier.copy(policyDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyDetails(LifecyclePolicyDetail... policyDetails) {
            policyDetails(Arrays.asList(policyDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyDetails(Consumer<LifecyclePolicyDetail.Builder>... policyDetails) {
            policyDetails(Stream.of(policyDetails).map(c -> LifecyclePolicyDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final LifecyclePolicyResourceSelection.Builder getResourceSelection() {
            return resourceSelection != null ? resourceSelection.toBuilder() : null;
        }

        public final void setResourceSelection(LifecyclePolicyResourceSelection.BuilderImpl resourceSelection) {
            this.resourceSelection = resourceSelection != null ? resourceSelection.build() : null;
        }

        @Override
        public final Builder resourceSelection(LifecyclePolicyResourceSelection resourceSelection) {
            this.resourceSelection = resourceSelection;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLifecyclePolicyRequest build() {
            return new CreateLifecyclePolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
