/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDistributionConfigurationResponse extends ImagebuilderResponse implements
        ToCopyableBuilder<DeleteDistributionConfigurationResponse.Builder, DeleteDistributionConfigurationResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestId").getter(getter(DeleteDistributionConfigurationResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()).build();

    private static final SdkField<String> DISTRIBUTION_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("distributionConfigurationArn")
            .getter(getter(DeleteDistributionConfigurationResponse::distributionConfigurationArn))
            .setter(setter(Builder::distributionConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributionConfigurationArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD,
            DISTRIBUTION_CONFIGURATION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String requestIdValue;

    private final String distributionConfigurationArn;

    private DeleteDistributionConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.distributionConfigurationArn = builder.distributionConfigurationArn;
    }

    /**
     * <p>
     * The request ID that uniquely identifies this request.
     * </p>
     * 
     * @return The request ID that uniquely identifies this request.
     */
    public final String requestId() {
        return requestIdValue;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the distribution configuration that was deleted.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the distribution configuration that was deleted.
     */
    public final String distributionConfigurationArn() {
        return distributionConfigurationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(distributionConfigurationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDistributionConfigurationResponse)) {
            return false;
        }
        DeleteDistributionConfigurationResponse other = (DeleteDistributionConfigurationResponse) obj;
        return Objects.equals(requestId(), other.requestId())
                && Objects.equals(distributionConfigurationArn(), other.distributionConfigurationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteDistributionConfigurationResponse").add("RequestId", requestId())
                .add("DistributionConfigurationArn", distributionConfigurationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "requestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "distributionConfigurationArn":
            return Optional.ofNullable(clazz.cast(distributionConfigurationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("requestId", REQUEST_ID_FIELD);
        map.put("distributionConfigurationArn", DISTRIBUTION_CONFIGURATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteDistributionConfigurationResponse, T> g) {
        return obj -> g.apply((DeleteDistributionConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ImagebuilderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteDistributionConfigurationResponse> {
        /**
         * <p>
         * The request ID that uniquely identifies this request.
         * </p>
         * 
         * @param requestIdValue
         *        The request ID that uniquely identifies this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestIdValue);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the distribution configuration that was deleted.
         * </p>
         * 
         * @param distributionConfigurationArn
         *        The Amazon Resource Name (ARN) of the distribution configuration that was deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionConfigurationArn(String distributionConfigurationArn);
    }

    static final class BuilderImpl extends ImagebuilderResponse.BuilderImpl implements Builder {
        private String requestIdValue;

        private String distributionConfigurationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDistributionConfigurationResponse model) {
            super(model);
            requestId(model.requestIdValue);
            distributionConfigurationArn(model.distributionConfigurationArn);
        }

        public final String getRequestId() {
            return requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final String getDistributionConfigurationArn() {
            return distributionConfigurationArn;
        }

        public final void setDistributionConfigurationArn(String distributionConfigurationArn) {
            this.distributionConfigurationArn = distributionConfigurationArn;
        }

        @Override
        public final Builder distributionConfigurationArn(String distributionConfigurationArn) {
            this.distributionConfigurationArn = distributionConfigurationArn;
            return this;
        }

        @Override
        public DeleteDistributionConfigurationResponse build() {
            return new DeleteDistributionConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
