/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the settings for a specific Region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Distribution implements SdkPojo, Serializable, ToCopyableBuilder<Distribution.Builder, Distribution> {
    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(Distribution::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<AmiDistributionConfiguration> AMI_DISTRIBUTION_CONFIGURATION_FIELD = SdkField
            .<AmiDistributionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("amiDistributionConfiguration")
            .getter(getter(Distribution::amiDistributionConfiguration))
            .setter(setter(Builder::amiDistributionConfiguration))
            .constructor(AmiDistributionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amiDistributionConfiguration")
                    .build()).build();

    private static final SdkField<ContainerDistributionConfiguration> CONTAINER_DISTRIBUTION_CONFIGURATION_FIELD = SdkField
            .<ContainerDistributionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("containerDistributionConfiguration")
            .getter(getter(Distribution::containerDistributionConfiguration))
            .setter(setter(Builder::containerDistributionConfiguration))
            .constructor(ContainerDistributionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerDistributionConfiguration")
                    .build()).build();

    private static final SdkField<List<String>> LICENSE_CONFIGURATION_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("licenseConfigurationArns")
            .getter(getter(Distribution::licenseConfigurationArns))
            .setter(setter(Builder::licenseConfigurationArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseConfigurationArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LaunchTemplateConfiguration>> LAUNCH_TEMPLATE_CONFIGURATIONS_FIELD = SdkField
            .<List<LaunchTemplateConfiguration>> builder(MarshallingType.LIST)
            .memberName("launchTemplateConfigurations")
            .getter(getter(Distribution::launchTemplateConfigurations))
            .setter(setter(Builder::launchTemplateConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchTemplateConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LaunchTemplateConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchTemplateConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<S3ExportConfiguration> S3_EXPORT_CONFIGURATION_FIELD = SdkField
            .<S3ExportConfiguration> builder(MarshallingType.SDK_POJO).memberName("s3ExportConfiguration")
            .getter(getter(Distribution::s3ExportConfiguration)).setter(setter(Builder::s3ExportConfiguration))
            .constructor(S3ExportConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3ExportConfiguration").build())
            .build();

    private static final SdkField<List<FastLaunchConfiguration>> FAST_LAUNCH_CONFIGURATIONS_FIELD = SdkField
            .<List<FastLaunchConfiguration>> builder(MarshallingType.LIST)
            .memberName("fastLaunchConfigurations")
            .getter(getter(Distribution::fastLaunchConfigurations))
            .setter(setter(Builder::fastLaunchConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fastLaunchConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FastLaunchConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(FastLaunchConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SsmParameterConfiguration>> SSM_PARAMETER_CONFIGURATIONS_FIELD = SdkField
            .<List<SsmParameterConfiguration>> builder(MarshallingType.LIST)
            .memberName("ssmParameterConfigurations")
            .getter(getter(Distribution::ssmParameterConfigurations))
            .setter(setter(Builder::ssmParameterConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssmParameterConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SsmParameterConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(SsmParameterConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD,
            AMI_DISTRIBUTION_CONFIGURATION_FIELD, CONTAINER_DISTRIBUTION_CONFIGURATION_FIELD, LICENSE_CONFIGURATION_ARNS_FIELD,
            LAUNCH_TEMPLATE_CONFIGURATIONS_FIELD, S3_EXPORT_CONFIGURATION_FIELD, FAST_LAUNCH_CONFIGURATIONS_FIELD,
            SSM_PARAMETER_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String region;

    private final AmiDistributionConfiguration amiDistributionConfiguration;

    private final ContainerDistributionConfiguration containerDistributionConfiguration;

    private final List<String> licenseConfigurationArns;

    private final List<LaunchTemplateConfiguration> launchTemplateConfigurations;

    private final S3ExportConfiguration s3ExportConfiguration;

    private final List<FastLaunchConfiguration> fastLaunchConfigurations;

    private final List<SsmParameterConfiguration> ssmParameterConfigurations;

    private Distribution(BuilderImpl builder) {
        this.region = builder.region;
        this.amiDistributionConfiguration = builder.amiDistributionConfiguration;
        this.containerDistributionConfiguration = builder.containerDistributionConfiguration;
        this.licenseConfigurationArns = builder.licenseConfigurationArns;
        this.launchTemplateConfigurations = builder.launchTemplateConfigurations;
        this.s3ExportConfiguration = builder.s3ExportConfiguration;
        this.fastLaunchConfigurations = builder.fastLaunchConfigurations;
        this.ssmParameterConfigurations = builder.ssmParameterConfigurations;
    }

    /**
     * <p>
     * The target Region.
     * </p>
     * 
     * @return The target Region.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The specific AMI settings; for example, launch permissions or AMI tags.
     * </p>
     * 
     * @return The specific AMI settings; for example, launch permissions or AMI tags.
     */
    public final AmiDistributionConfiguration amiDistributionConfiguration() {
        return amiDistributionConfiguration;
    }

    /**
     * <p>
     * Container distribution settings for encryption, licensing, and sharing in a specific Region.
     * </p>
     * 
     * @return Container distribution settings for encryption, licensing, and sharing in a specific Region.
     */
    public final ContainerDistributionConfiguration containerDistributionConfiguration() {
        return containerDistributionConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the LicenseConfigurationArns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLicenseConfigurationArns() {
        return licenseConfigurationArns != null && !(licenseConfigurationArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The License Manager Configuration to associate with the AMI in the specified Region.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLicenseConfigurationArns} method.
     * </p>
     * 
     * @return The License Manager Configuration to associate with the AMI in the specified Region.
     */
    public final List<String> licenseConfigurationArns() {
        return licenseConfigurationArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the LaunchTemplateConfigurations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLaunchTemplateConfigurations() {
        return launchTemplateConfigurations != null && !(launchTemplateConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A group of launchTemplateConfiguration settings that apply to image distribution for specified accounts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLaunchTemplateConfigurations} method.
     * </p>
     * 
     * @return A group of launchTemplateConfiguration settings that apply to image distribution for specified accounts.
     */
    public final List<LaunchTemplateConfiguration> launchTemplateConfigurations() {
        return launchTemplateConfigurations;
    }

    /**
     * <p>
     * Configure export settings to deliver disk images created from your image build, using a file format that is
     * compatible with your VMs in that Region.
     * </p>
     * 
     * @return Configure export settings to deliver disk images created from your image build, using a file format that
     *         is compatible with your VMs in that Region.
     */
    public final S3ExportConfiguration s3ExportConfiguration() {
        return s3ExportConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the FastLaunchConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasFastLaunchConfigurations() {
        return fastLaunchConfigurations != null && !(fastLaunchConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Windows faster-launching configurations to use for AMI distribution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFastLaunchConfigurations} method.
     * </p>
     * 
     * @return The Windows faster-launching configurations to use for AMI distribution.
     */
    public final List<FastLaunchConfiguration> fastLaunchConfigurations() {
        return fastLaunchConfigurations;
    }

    /**
     * For responses, this returns true if the service returned a value for the SsmParameterConfigurations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSsmParameterConfigurations() {
        return ssmParameterConfigurations != null && !(ssmParameterConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains settings to update Amazon Web Services Systems Manager (SSM) Parameter Store Parameters with output AMI
     * IDs from the build by target Region.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSsmParameterConfigurations} method.
     * </p>
     * 
     * @return Contains settings to update Amazon Web Services Systems Manager (SSM) Parameter Store Parameters with
     *         output AMI IDs from the build by target Region.
     */
    public final List<SsmParameterConfiguration> ssmParameterConfigurations() {
        return ssmParameterConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(amiDistributionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(containerDistributionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasLicenseConfigurationArns() ? licenseConfigurationArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLaunchTemplateConfigurations() ? launchTemplateConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(s3ExportConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasFastLaunchConfigurations() ? fastLaunchConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSsmParameterConfigurations() ? ssmParameterConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Distribution)) {
            return false;
        }
        Distribution other = (Distribution) obj;
        return Objects.equals(region(), other.region())
                && Objects.equals(amiDistributionConfiguration(), other.amiDistributionConfiguration())
                && Objects.equals(containerDistributionConfiguration(), other.containerDistributionConfiguration())
                && hasLicenseConfigurationArns() == other.hasLicenseConfigurationArns()
                && Objects.equals(licenseConfigurationArns(), other.licenseConfigurationArns())
                && hasLaunchTemplateConfigurations() == other.hasLaunchTemplateConfigurations()
                && Objects.equals(launchTemplateConfigurations(), other.launchTemplateConfigurations())
                && Objects.equals(s3ExportConfiguration(), other.s3ExportConfiguration())
                && hasFastLaunchConfigurations() == other.hasFastLaunchConfigurations()
                && Objects.equals(fastLaunchConfigurations(), other.fastLaunchConfigurations())
                && hasSsmParameterConfigurations() == other.hasSsmParameterConfigurations()
                && Objects.equals(ssmParameterConfigurations(), other.ssmParameterConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Distribution").add("Region", region())
                .add("AmiDistributionConfiguration", amiDistributionConfiguration())
                .add("ContainerDistributionConfiguration", containerDistributionConfiguration())
                .add("LicenseConfigurationArns", hasLicenseConfigurationArns() ? licenseConfigurationArns() : null)
                .add("LaunchTemplateConfigurations", hasLaunchTemplateConfigurations() ? launchTemplateConfigurations() : null)
                .add("S3ExportConfiguration", s3ExportConfiguration())
                .add("FastLaunchConfigurations", hasFastLaunchConfigurations() ? fastLaunchConfigurations() : null)
                .add("SsmParameterConfigurations", hasSsmParameterConfigurations() ? ssmParameterConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "amiDistributionConfiguration":
            return Optional.ofNullable(clazz.cast(amiDistributionConfiguration()));
        case "containerDistributionConfiguration":
            return Optional.ofNullable(clazz.cast(containerDistributionConfiguration()));
        case "licenseConfigurationArns":
            return Optional.ofNullable(clazz.cast(licenseConfigurationArns()));
        case "launchTemplateConfigurations":
            return Optional.ofNullable(clazz.cast(launchTemplateConfigurations()));
        case "s3ExportConfiguration":
            return Optional.ofNullable(clazz.cast(s3ExportConfiguration()));
        case "fastLaunchConfigurations":
            return Optional.ofNullable(clazz.cast(fastLaunchConfigurations()));
        case "ssmParameterConfigurations":
            return Optional.ofNullable(clazz.cast(ssmParameterConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("region", REGION_FIELD);
        map.put("amiDistributionConfiguration", AMI_DISTRIBUTION_CONFIGURATION_FIELD);
        map.put("containerDistributionConfiguration", CONTAINER_DISTRIBUTION_CONFIGURATION_FIELD);
        map.put("licenseConfigurationArns", LICENSE_CONFIGURATION_ARNS_FIELD);
        map.put("launchTemplateConfigurations", LAUNCH_TEMPLATE_CONFIGURATIONS_FIELD);
        map.put("s3ExportConfiguration", S3_EXPORT_CONFIGURATION_FIELD);
        map.put("fastLaunchConfigurations", FAST_LAUNCH_CONFIGURATIONS_FIELD);
        map.put("ssmParameterConfigurations", SSM_PARAMETER_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Distribution, T> g) {
        return obj -> g.apply((Distribution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Distribution> {
        /**
         * <p>
         * The target Region.
         * </p>
         * 
         * @param region
         *        The target Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The specific AMI settings; for example, launch permissions or AMI tags.
         * </p>
         * 
         * @param amiDistributionConfiguration
         *        The specific AMI settings; for example, launch permissions or AMI tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amiDistributionConfiguration(AmiDistributionConfiguration amiDistributionConfiguration);

        /**
         * <p>
         * The specific AMI settings; for example, launch permissions or AMI tags.
         * </p>
         * This is a convenience method that creates an instance of the {@link AmiDistributionConfiguration.Builder}
         * avoiding the need to create one manually via {@link AmiDistributionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmiDistributionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #amiDistributionConfiguration(AmiDistributionConfiguration)}.
         * 
         * @param amiDistributionConfiguration
         *        a consumer that will call methods on {@link AmiDistributionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amiDistributionConfiguration(AmiDistributionConfiguration)
         */
        default Builder amiDistributionConfiguration(Consumer<AmiDistributionConfiguration.Builder> amiDistributionConfiguration) {
            return amiDistributionConfiguration(AmiDistributionConfiguration.builder()
                    .applyMutation(amiDistributionConfiguration).build());
        }

        /**
         * <p>
         * Container distribution settings for encryption, licensing, and sharing in a specific Region.
         * </p>
         * 
         * @param containerDistributionConfiguration
         *        Container distribution settings for encryption, licensing, and sharing in a specific Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerDistributionConfiguration(ContainerDistributionConfiguration containerDistributionConfiguration);

        /**
         * <p>
         * Container distribution settings for encryption, licensing, and sharing in a specific Region.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ContainerDistributionConfiguration.Builder} avoiding the need to create one manually via
         * {@link ContainerDistributionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContainerDistributionConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #containerDistributionConfiguration(ContainerDistributionConfiguration)}.
         * 
         * @param containerDistributionConfiguration
         *        a consumer that will call methods on {@link ContainerDistributionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerDistributionConfiguration(ContainerDistributionConfiguration)
         */
        default Builder containerDistributionConfiguration(
                Consumer<ContainerDistributionConfiguration.Builder> containerDistributionConfiguration) {
            return containerDistributionConfiguration(ContainerDistributionConfiguration.builder()
                    .applyMutation(containerDistributionConfiguration).build());
        }

        /**
         * <p>
         * The License Manager Configuration to associate with the AMI in the specified Region.
         * </p>
         * 
         * @param licenseConfigurationArns
         *        The License Manager Configuration to associate with the AMI in the specified Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseConfigurationArns(Collection<String> licenseConfigurationArns);

        /**
         * <p>
         * The License Manager Configuration to associate with the AMI in the specified Region.
         * </p>
         * 
         * @param licenseConfigurationArns
         *        The License Manager Configuration to associate with the AMI in the specified Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseConfigurationArns(String... licenseConfigurationArns);

        /**
         * <p>
         * A group of launchTemplateConfiguration settings that apply to image distribution for specified accounts.
         * </p>
         * 
         * @param launchTemplateConfigurations
         *        A group of launchTemplateConfiguration settings that apply to image distribution for specified
         *        accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateConfigurations(Collection<LaunchTemplateConfiguration> launchTemplateConfigurations);

        /**
         * <p>
         * A group of launchTemplateConfiguration settings that apply to image distribution for specified accounts.
         * </p>
         * 
         * @param launchTemplateConfigurations
         *        A group of launchTemplateConfiguration settings that apply to image distribution for specified
         *        accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateConfigurations(LaunchTemplateConfiguration... launchTemplateConfigurations);

        /**
         * <p>
         * A group of launchTemplateConfiguration settings that apply to image distribution for specified accounts.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.imagebuilder.model.LaunchTemplateConfiguration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.imagebuilder.model.LaunchTemplateConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.imagebuilder.model.LaunchTemplateConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #launchTemplateConfigurations(List<LaunchTemplateConfiguration>)}.
         * 
         * @param launchTemplateConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.imagebuilder.model.LaunchTemplateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplateConfigurations(java.util.Collection<LaunchTemplateConfiguration>)
         */
        Builder launchTemplateConfigurations(Consumer<LaunchTemplateConfiguration.Builder>... launchTemplateConfigurations);

        /**
         * <p>
         * Configure export settings to deliver disk images created from your image build, using a file format that is
         * compatible with your VMs in that Region.
         * </p>
         * 
         * @param s3ExportConfiguration
         *        Configure export settings to deliver disk images created from your image build, using a file format
         *        that is compatible with your VMs in that Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ExportConfiguration(S3ExportConfiguration s3ExportConfiguration);

        /**
         * <p>
         * Configure export settings to deliver disk images created from your image build, using a file format that is
         * compatible with your VMs in that Region.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3ExportConfiguration.Builder} avoiding
         * the need to create one manually via {@link S3ExportConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3ExportConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #s3ExportConfiguration(S3ExportConfiguration)}.
         * 
         * @param s3ExportConfiguration
         *        a consumer that will call methods on {@link S3ExportConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3ExportConfiguration(S3ExportConfiguration)
         */
        default Builder s3ExportConfiguration(Consumer<S3ExportConfiguration.Builder> s3ExportConfiguration) {
            return s3ExportConfiguration(S3ExportConfiguration.builder().applyMutation(s3ExportConfiguration).build());
        }

        /**
         * <p>
         * The Windows faster-launching configurations to use for AMI distribution.
         * </p>
         * 
         * @param fastLaunchConfigurations
         *        The Windows faster-launching configurations to use for AMI distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fastLaunchConfigurations(Collection<FastLaunchConfiguration> fastLaunchConfigurations);

        /**
         * <p>
         * The Windows faster-launching configurations to use for AMI distribution.
         * </p>
         * 
         * @param fastLaunchConfigurations
         *        The Windows faster-launching configurations to use for AMI distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fastLaunchConfigurations(FastLaunchConfiguration... fastLaunchConfigurations);

        /**
         * <p>
         * The Windows faster-launching configurations to use for AMI distribution.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.imagebuilder.model.FastLaunchConfiguration.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.imagebuilder.model.FastLaunchConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.imagebuilder.model.FastLaunchConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #fastLaunchConfigurations(List<FastLaunchConfiguration>)}.
         * 
         * @param fastLaunchConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.imagebuilder.model.FastLaunchConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fastLaunchConfigurations(java.util.Collection<FastLaunchConfiguration>)
         */
        Builder fastLaunchConfigurations(Consumer<FastLaunchConfiguration.Builder>... fastLaunchConfigurations);

        /**
         * <p>
         * Contains settings to update Amazon Web Services Systems Manager (SSM) Parameter Store Parameters with output
         * AMI IDs from the build by target Region.
         * </p>
         * 
         * @param ssmParameterConfigurations
         *        Contains settings to update Amazon Web Services Systems Manager (SSM) Parameter Store Parameters with
         *        output AMI IDs from the build by target Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssmParameterConfigurations(Collection<SsmParameterConfiguration> ssmParameterConfigurations);

        /**
         * <p>
         * Contains settings to update Amazon Web Services Systems Manager (SSM) Parameter Store Parameters with output
         * AMI IDs from the build by target Region.
         * </p>
         * 
         * @param ssmParameterConfigurations
         *        Contains settings to update Amazon Web Services Systems Manager (SSM) Parameter Store Parameters with
         *        output AMI IDs from the build by target Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssmParameterConfigurations(SsmParameterConfiguration... ssmParameterConfigurations);

        /**
         * <p>
         * Contains settings to update Amazon Web Services Systems Manager (SSM) Parameter Store Parameters with output
         * AMI IDs from the build by target Region.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.imagebuilder.model.SsmParameterConfiguration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.imagebuilder.model.SsmParameterConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.imagebuilder.model.SsmParameterConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #ssmParameterConfigurations(List<SsmParameterConfiguration>)}.
         * 
         * @param ssmParameterConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.imagebuilder.model.SsmParameterConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ssmParameterConfigurations(java.util.Collection<SsmParameterConfiguration>)
         */
        Builder ssmParameterConfigurations(Consumer<SsmParameterConfiguration.Builder>... ssmParameterConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private String region;

        private AmiDistributionConfiguration amiDistributionConfiguration;

        private ContainerDistributionConfiguration containerDistributionConfiguration;

        private List<String> licenseConfigurationArns = DefaultSdkAutoConstructList.getInstance();

        private List<LaunchTemplateConfiguration> launchTemplateConfigurations = DefaultSdkAutoConstructList.getInstance();

        private S3ExportConfiguration s3ExportConfiguration;

        private List<FastLaunchConfiguration> fastLaunchConfigurations = DefaultSdkAutoConstructList.getInstance();

        private List<SsmParameterConfiguration> ssmParameterConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Distribution model) {
            region(model.region);
            amiDistributionConfiguration(model.amiDistributionConfiguration);
            containerDistributionConfiguration(model.containerDistributionConfiguration);
            licenseConfigurationArns(model.licenseConfigurationArns);
            launchTemplateConfigurations(model.launchTemplateConfigurations);
            s3ExportConfiguration(model.s3ExportConfiguration);
            fastLaunchConfigurations(model.fastLaunchConfigurations);
            ssmParameterConfigurations(model.ssmParameterConfigurations);
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final AmiDistributionConfiguration.Builder getAmiDistributionConfiguration() {
            return amiDistributionConfiguration != null ? amiDistributionConfiguration.toBuilder() : null;
        }

        public final void setAmiDistributionConfiguration(AmiDistributionConfiguration.BuilderImpl amiDistributionConfiguration) {
            this.amiDistributionConfiguration = amiDistributionConfiguration != null ? amiDistributionConfiguration.build()
                    : null;
        }

        @Override
        public final Builder amiDistributionConfiguration(AmiDistributionConfiguration amiDistributionConfiguration) {
            this.amiDistributionConfiguration = amiDistributionConfiguration;
            return this;
        }

        public final ContainerDistributionConfiguration.Builder getContainerDistributionConfiguration() {
            return containerDistributionConfiguration != null ? containerDistributionConfiguration.toBuilder() : null;
        }

        public final void setContainerDistributionConfiguration(
                ContainerDistributionConfiguration.BuilderImpl containerDistributionConfiguration) {
            this.containerDistributionConfiguration = containerDistributionConfiguration != null ? containerDistributionConfiguration
                    .build() : null;
        }

        @Override
        public final Builder containerDistributionConfiguration(
                ContainerDistributionConfiguration containerDistributionConfiguration) {
            this.containerDistributionConfiguration = containerDistributionConfiguration;
            return this;
        }

        public final Collection<String> getLicenseConfigurationArns() {
            if (licenseConfigurationArns instanceof SdkAutoConstructList) {
                return null;
            }
            return licenseConfigurationArns;
        }

        public final void setLicenseConfigurationArns(Collection<String> licenseConfigurationArns) {
            this.licenseConfigurationArns = LicenseConfigurationArnListCopier.copy(licenseConfigurationArns);
        }

        @Override
        public final Builder licenseConfigurationArns(Collection<String> licenseConfigurationArns) {
            this.licenseConfigurationArns = LicenseConfigurationArnListCopier.copy(licenseConfigurationArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseConfigurationArns(String... licenseConfigurationArns) {
            licenseConfigurationArns(Arrays.asList(licenseConfigurationArns));
            return this;
        }

        public final List<LaunchTemplateConfiguration.Builder> getLaunchTemplateConfigurations() {
            List<LaunchTemplateConfiguration.Builder> result = LaunchTemplateConfigurationListCopier
                    .copyToBuilder(this.launchTemplateConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLaunchTemplateConfigurations(
                Collection<LaunchTemplateConfiguration.BuilderImpl> launchTemplateConfigurations) {
            this.launchTemplateConfigurations = LaunchTemplateConfigurationListCopier
                    .copyFromBuilder(launchTemplateConfigurations);
        }

        @Override
        public final Builder launchTemplateConfigurations(Collection<LaunchTemplateConfiguration> launchTemplateConfigurations) {
            this.launchTemplateConfigurations = LaunchTemplateConfigurationListCopier.copy(launchTemplateConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateConfigurations(LaunchTemplateConfiguration... launchTemplateConfigurations) {
            launchTemplateConfigurations(Arrays.asList(launchTemplateConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateConfigurations(
                Consumer<LaunchTemplateConfiguration.Builder>... launchTemplateConfigurations) {
            launchTemplateConfigurations(Stream.of(launchTemplateConfigurations)
                    .map(c -> LaunchTemplateConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final S3ExportConfiguration.Builder getS3ExportConfiguration() {
            return s3ExportConfiguration != null ? s3ExportConfiguration.toBuilder() : null;
        }

        public final void setS3ExportConfiguration(S3ExportConfiguration.BuilderImpl s3ExportConfiguration) {
            this.s3ExportConfiguration = s3ExportConfiguration != null ? s3ExportConfiguration.build() : null;
        }

        @Override
        public final Builder s3ExportConfiguration(S3ExportConfiguration s3ExportConfiguration) {
            this.s3ExportConfiguration = s3ExportConfiguration;
            return this;
        }

        public final List<FastLaunchConfiguration.Builder> getFastLaunchConfigurations() {
            List<FastLaunchConfiguration.Builder> result = FastLaunchConfigurationListCopier
                    .copyToBuilder(this.fastLaunchConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFastLaunchConfigurations(Collection<FastLaunchConfiguration.BuilderImpl> fastLaunchConfigurations) {
            this.fastLaunchConfigurations = FastLaunchConfigurationListCopier.copyFromBuilder(fastLaunchConfigurations);
        }

        @Override
        public final Builder fastLaunchConfigurations(Collection<FastLaunchConfiguration> fastLaunchConfigurations) {
            this.fastLaunchConfigurations = FastLaunchConfigurationListCopier.copy(fastLaunchConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fastLaunchConfigurations(FastLaunchConfiguration... fastLaunchConfigurations) {
            fastLaunchConfigurations(Arrays.asList(fastLaunchConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fastLaunchConfigurations(Consumer<FastLaunchConfiguration.Builder>... fastLaunchConfigurations) {
            fastLaunchConfigurations(Stream.of(fastLaunchConfigurations)
                    .map(c -> FastLaunchConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SsmParameterConfiguration.Builder> getSsmParameterConfigurations() {
            List<SsmParameterConfiguration.Builder> result = SsmParameterConfigurationListCopier
                    .copyToBuilder(this.ssmParameterConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSsmParameterConfigurations(
                Collection<SsmParameterConfiguration.BuilderImpl> ssmParameterConfigurations) {
            this.ssmParameterConfigurations = SsmParameterConfigurationListCopier.copyFromBuilder(ssmParameterConfigurations);
        }

        @Override
        public final Builder ssmParameterConfigurations(Collection<SsmParameterConfiguration> ssmParameterConfigurations) {
            this.ssmParameterConfigurations = SsmParameterConfigurationListCopier.copy(ssmParameterConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ssmParameterConfigurations(SsmParameterConfiguration... ssmParameterConfigurations) {
            ssmParameterConfigurations(Arrays.asList(ssmParameterConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ssmParameterConfigurations(Consumer<SsmParameterConfiguration.Builder>... ssmParameterConfigurations) {
            ssmParameterConfigurations(Stream.of(ssmParameterConfigurations)
                    .map(c -> SsmParameterConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Distribution build() {
            return new Distribution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
