/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains settings for Image Builder image resource and container image scans.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageScanningConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ImageScanningConfiguration.Builder, ImageScanningConfiguration> {
    private static final SdkField<Boolean> IMAGE_SCANNING_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("imageScanningEnabled").getter(getter(ImageScanningConfiguration::imageScanningEnabled))
            .setter(setter(Builder::imageScanningEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageScanningEnabled").build())
            .build();

    private static final SdkField<EcrConfiguration> ECR_CONFIGURATION_FIELD = SdkField
            .<EcrConfiguration> builder(MarshallingType.SDK_POJO).memberName("ecrConfiguration")
            .getter(getter(ImageScanningConfiguration::ecrConfiguration)).setter(setter(Builder::ecrConfiguration))
            .constructor(EcrConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_SCANNING_ENABLED_FIELD,
            ECR_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean imageScanningEnabled;

    private final EcrConfiguration ecrConfiguration;

    private ImageScanningConfiguration(BuilderImpl builder) {
        this.imageScanningEnabled = builder.imageScanningEnabled;
        this.ecrConfiguration = builder.ecrConfiguration;
    }

    /**
     * <p>
     * A setting that indicates whether Image Builder keeps a snapshot of the vulnerability scans that Amazon Inspector
     * runs against the build instance when you create a new image.
     * </p>
     * 
     * @return A setting that indicates whether Image Builder keeps a snapshot of the vulnerability scans that Amazon
     *         Inspector runs against the build instance when you create a new image.
     */
    public final Boolean imageScanningEnabled() {
        return imageScanningEnabled;
    }

    /**
     * <p>
     * Contains Amazon ECR settings for vulnerability scans.
     * </p>
     * 
     * @return Contains Amazon ECR settings for vulnerability scans.
     */
    public final EcrConfiguration ecrConfiguration() {
        return ecrConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageScanningEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(ecrConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageScanningConfiguration)) {
            return false;
        }
        ImageScanningConfiguration other = (ImageScanningConfiguration) obj;
        return Objects.equals(imageScanningEnabled(), other.imageScanningEnabled())
                && Objects.equals(ecrConfiguration(), other.ecrConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageScanningConfiguration").add("ImageScanningEnabled", imageScanningEnabled())
                .add("EcrConfiguration", ecrConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "imageScanningEnabled":
            return Optional.ofNullable(clazz.cast(imageScanningEnabled()));
        case "ecrConfiguration":
            return Optional.ofNullable(clazz.cast(ecrConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("imageScanningEnabled", IMAGE_SCANNING_ENABLED_FIELD);
        map.put("ecrConfiguration", ECR_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageScanningConfiguration, T> g) {
        return obj -> g.apply((ImageScanningConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageScanningConfiguration> {
        /**
         * <p>
         * A setting that indicates whether Image Builder keeps a snapshot of the vulnerability scans that Amazon
         * Inspector runs against the build instance when you create a new image.
         * </p>
         * 
         * @param imageScanningEnabled
         *        A setting that indicates whether Image Builder keeps a snapshot of the vulnerability scans that Amazon
         *        Inspector runs against the build instance when you create a new image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageScanningEnabled(Boolean imageScanningEnabled);

        /**
         * <p>
         * Contains Amazon ECR settings for vulnerability scans.
         * </p>
         * 
         * @param ecrConfiguration
         *        Contains Amazon ECR settings for vulnerability scans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrConfiguration(EcrConfiguration ecrConfiguration);

        /**
         * <p>
         * Contains Amazon ECR settings for vulnerability scans.
         * </p>
         * This is a convenience method that creates an instance of the {@link EcrConfiguration.Builder} avoiding the
         * need to create one manually via {@link EcrConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EcrConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #ecrConfiguration(EcrConfiguration)}.
         * 
         * @param ecrConfiguration
         *        a consumer that will call methods on {@link EcrConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecrConfiguration(EcrConfiguration)
         */
        default Builder ecrConfiguration(Consumer<EcrConfiguration.Builder> ecrConfiguration) {
            return ecrConfiguration(EcrConfiguration.builder().applyMutation(ecrConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean imageScanningEnabled;

        private EcrConfiguration ecrConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageScanningConfiguration model) {
            imageScanningEnabled(model.imageScanningEnabled);
            ecrConfiguration(model.ecrConfiguration);
        }

        public final Boolean getImageScanningEnabled() {
            return imageScanningEnabled;
        }

        public final void setImageScanningEnabled(Boolean imageScanningEnabled) {
            this.imageScanningEnabled = imageScanningEnabled;
        }

        @Override
        public final Builder imageScanningEnabled(Boolean imageScanningEnabled) {
            this.imageScanningEnabled = imageScanningEnabled;
            return this;
        }

        public final EcrConfiguration.Builder getEcrConfiguration() {
            return ecrConfiguration != null ? ecrConfiguration.toBuilder() : null;
        }

        public final void setEcrConfiguration(EcrConfiguration.BuilderImpl ecrConfiguration) {
            this.ecrConfiguration = ecrConfiguration != null ? ecrConfiguration.build() : null;
        }

        @Override
        public final Builder ecrConfiguration(EcrConfiguration ecrConfiguration) {
            this.ecrConfiguration = ecrConfiguration;
            return this;
        }

        @Override
        public ImageScanningConfiguration build() {
            return new ImageScanningConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
