/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies how the lifecycle policy should apply actions to selected resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LifecyclePolicyDetailActionIncludeResources implements SdkPojo, Serializable,
        ToCopyableBuilder<LifecyclePolicyDetailActionIncludeResources.Builder, LifecyclePolicyDetailActionIncludeResources> {
    private static final SdkField<Boolean> AMIS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("amis")
            .getter(getter(LifecyclePolicyDetailActionIncludeResources::amis)).setter(setter(Builder::amis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amis").build()).build();

    private static final SdkField<Boolean> SNAPSHOTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("snapshots").getter(getter(LifecyclePolicyDetailActionIncludeResources::snapshots))
            .setter(setter(Builder::snapshots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshots").build()).build();

    private static final SdkField<Boolean> CONTAINERS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("containers").getter(getter(LifecyclePolicyDetailActionIncludeResources::containers))
            .setter(setter(Builder::containers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containers").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMIS_FIELD, SNAPSHOTS_FIELD,
            CONTAINERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean amis;

    private final Boolean snapshots;

    private final Boolean containers;

    private LifecyclePolicyDetailActionIncludeResources(BuilderImpl builder) {
        this.amis = builder.amis;
        this.snapshots = builder.snapshots;
        this.containers = builder.containers;
    }

    /**
     * <p>
     * Specifies whether the lifecycle action should apply to distributed AMIs.
     * </p>
     * 
     * @return Specifies whether the lifecycle action should apply to distributed AMIs.
     */
    public final Boolean amis() {
        return amis;
    }

    /**
     * <p>
     * Specifies whether the lifecycle action should apply to snapshots associated with distributed AMIs.
     * </p>
     * 
     * @return Specifies whether the lifecycle action should apply to snapshots associated with distributed AMIs.
     */
    public final Boolean snapshots() {
        return snapshots;
    }

    /**
     * <p>
     * Specifies whether the lifecycle action should apply to distributed containers.
     * </p>
     * 
     * @return Specifies whether the lifecycle action should apply to distributed containers.
     */
    public final Boolean containers() {
        return containers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amis());
        hashCode = 31 * hashCode + Objects.hashCode(snapshots());
        hashCode = 31 * hashCode + Objects.hashCode(containers());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecyclePolicyDetailActionIncludeResources)) {
            return false;
        }
        LifecyclePolicyDetailActionIncludeResources other = (LifecyclePolicyDetailActionIncludeResources) obj;
        return Objects.equals(amis(), other.amis()) && Objects.equals(snapshots(), other.snapshots())
                && Objects.equals(containers(), other.containers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LifecyclePolicyDetailActionIncludeResources").add("Amis", amis()).add("Snapshots", snapshots())
                .add("Containers", containers()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "amis":
            return Optional.ofNullable(clazz.cast(amis()));
        case "snapshots":
            return Optional.ofNullable(clazz.cast(snapshots()));
        case "containers":
            return Optional.ofNullable(clazz.cast(containers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("amis", AMIS_FIELD);
        map.put("snapshots", SNAPSHOTS_FIELD);
        map.put("containers", CONTAINERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LifecyclePolicyDetailActionIncludeResources, T> g) {
        return obj -> g.apply((LifecyclePolicyDetailActionIncludeResources) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LifecyclePolicyDetailActionIncludeResources> {
        /**
         * <p>
         * Specifies whether the lifecycle action should apply to distributed AMIs.
         * </p>
         * 
         * @param amis
         *        Specifies whether the lifecycle action should apply to distributed AMIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amis(Boolean amis);

        /**
         * <p>
         * Specifies whether the lifecycle action should apply to snapshots associated with distributed AMIs.
         * </p>
         * 
         * @param snapshots
         *        Specifies whether the lifecycle action should apply to snapshots associated with distributed AMIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshots(Boolean snapshots);

        /**
         * <p>
         * Specifies whether the lifecycle action should apply to distributed containers.
         * </p>
         * 
         * @param containers
         *        Specifies whether the lifecycle action should apply to distributed containers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(Boolean containers);
    }

    static final class BuilderImpl implements Builder {
        private Boolean amis;

        private Boolean snapshots;

        private Boolean containers;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecyclePolicyDetailActionIncludeResources model) {
            amis(model.amis);
            snapshots(model.snapshots);
            containers(model.containers);
        }

        public final Boolean getAmis() {
            return amis;
        }

        public final void setAmis(Boolean amis) {
            this.amis = amis;
        }

        @Override
        public final Builder amis(Boolean amis) {
            this.amis = amis;
            return this;
        }

        public final Boolean getSnapshots() {
            return snapshots;
        }

        public final void setSnapshots(Boolean snapshots) {
            this.snapshots = snapshots;
        }

        @Override
        public final Builder snapshots(Boolean snapshots) {
            this.snapshots = snapshots;
            return this;
        }

        public final Boolean getContainers() {
            return containers;
        }

        public final void setContainers(Boolean containers) {
            this.containers = containers;
        }

        @Override
        public final Builder containers(Boolean containers) {
            this.containers = containers;
            return this;
        }

        @Override
        public LifecyclePolicyDetailActionIncludeResources build() {
            return new LifecyclePolicyDetailActionIncludeResources(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
