/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines criteria for AMIs that are excluded from lifecycle actions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LifecyclePolicyDetailExclusionRulesAmis implements SdkPojo, Serializable,
        ToCopyableBuilder<LifecyclePolicyDetailExclusionRulesAmis.Builder, LifecyclePolicyDetailExclusionRulesAmis> {
    private static final SdkField<Boolean> IS_PUBLIC_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isPublic").getter(getter(LifecyclePolicyDetailExclusionRulesAmis::isPublic))
            .setter(setter(Builder::isPublic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isPublic").build()).build();

    private static final SdkField<List<String>> REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("regions")
            .getter(getter(LifecyclePolicyDetailExclusionRulesAmis::regions))
            .setter(setter(Builder::regions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SHARED_ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("sharedAccounts")
            .getter(getter(LifecyclePolicyDetailExclusionRulesAmis::sharedAccounts))
            .setter(setter(Builder::sharedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharedAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<LifecyclePolicyDetailExclusionRulesAmisLastLaunched> LAST_LAUNCHED_FIELD = SdkField
            .<LifecyclePolicyDetailExclusionRulesAmisLastLaunched> builder(MarshallingType.SDK_POJO).memberName("lastLaunched")
            .getter(getter(LifecyclePolicyDetailExclusionRulesAmis::lastLaunched)).setter(setter(Builder::lastLaunched))
            .constructor(LifecyclePolicyDetailExclusionRulesAmisLastLaunched::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastLaunched").build()).build();

    private static final SdkField<Map<String, String>> TAG_MAP_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tagMap")
            .getter(getter(LifecyclePolicyDetailExclusionRulesAmis::tagMap))
            .setter(setter(Builder::tagMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_PUBLIC_FIELD,
            REGIONS_FIELD, SHARED_ACCOUNTS_FIELD, LAST_LAUNCHED_FIELD, TAG_MAP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean isPublic;

    private final List<String> regions;

    private final List<String> sharedAccounts;

    private final LifecyclePolicyDetailExclusionRulesAmisLastLaunched lastLaunched;

    private final Map<String, String> tagMap;

    private LifecyclePolicyDetailExclusionRulesAmis(BuilderImpl builder) {
        this.isPublic = builder.isPublic;
        this.regions = builder.regions;
        this.sharedAccounts = builder.sharedAccounts;
        this.lastLaunched = builder.lastLaunched;
        this.tagMap = builder.tagMap;
    }

    /**
     * <p>
     * Configures whether public AMIs are excluded from the lifecycle action.
     * </p>
     * 
     * @return Configures whether public AMIs are excluded from the lifecycle action.
     */
    public final Boolean isPublic() {
        return isPublic;
    }

    /**
     * For responses, this returns true if the service returned a value for the Regions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRegions() {
        return regions != null && !(regions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configures Amazon Web Services Regions that are excluded from the lifecycle action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegions} method.
     * </p>
     * 
     * @return Configures Amazon Web Services Regions that are excluded from the lifecycle action.
     */
    public final List<String> regions() {
        return regions;
    }

    /**
     * For responses, this returns true if the service returned a value for the SharedAccounts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSharedAccounts() {
        return sharedAccounts != null && !(sharedAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies Amazon Web Services accounts whose resources are excluded from the lifecycle action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSharedAccounts} method.
     * </p>
     * 
     * @return Specifies Amazon Web Services accounts whose resources are excluded from the lifecycle action.
     */
    public final List<String> sharedAccounts() {
        return sharedAccounts;
    }

    /**
     * <p>
     * Specifies configuration details for Image Builder to exclude the most recent resources from lifecycle actions.
     * </p>
     * 
     * @return Specifies configuration details for Image Builder to exclude the most recent resources from lifecycle
     *         actions.
     */
    public final LifecyclePolicyDetailExclusionRulesAmisLastLaunched lastLaunched() {
        return lastLaunched;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagMap property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagMap() {
        return tagMap != null && !(tagMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Lists tags that should be excluded from lifecycle actions for the AMIs that have them.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagMap} method.
     * </p>
     * 
     * @return Lists tags that should be excluded from lifecycle actions for the AMIs that have them.
     */
    public final Map<String, String> tagMap() {
        return tagMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isPublic());
        hashCode = 31 * hashCode + Objects.hashCode(hasRegions() ? regions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSharedAccounts() ? sharedAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastLaunched());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagMap() ? tagMap() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecyclePolicyDetailExclusionRulesAmis)) {
            return false;
        }
        LifecyclePolicyDetailExclusionRulesAmis other = (LifecyclePolicyDetailExclusionRulesAmis) obj;
        return Objects.equals(isPublic(), other.isPublic()) && hasRegions() == other.hasRegions()
                && Objects.equals(regions(), other.regions()) && hasSharedAccounts() == other.hasSharedAccounts()
                && Objects.equals(sharedAccounts(), other.sharedAccounts())
                && Objects.equals(lastLaunched(), other.lastLaunched()) && hasTagMap() == other.hasTagMap()
                && Objects.equals(tagMap(), other.tagMap());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LifecyclePolicyDetailExclusionRulesAmis").add("IsPublic", isPublic())
                .add("Regions", hasRegions() ? regions() : null)
                .add("SharedAccounts", hasSharedAccounts() ? sharedAccounts() : null).add("LastLaunched", lastLaunched())
                .add("TagMap", hasTagMap() ? tagMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "isPublic":
            return Optional.ofNullable(clazz.cast(isPublic()));
        case "regions":
            return Optional.ofNullable(clazz.cast(regions()));
        case "sharedAccounts":
            return Optional.ofNullable(clazz.cast(sharedAccounts()));
        case "lastLaunched":
            return Optional.ofNullable(clazz.cast(lastLaunched()));
        case "tagMap":
            return Optional.ofNullable(clazz.cast(tagMap()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("isPublic", IS_PUBLIC_FIELD);
        map.put("regions", REGIONS_FIELD);
        map.put("sharedAccounts", SHARED_ACCOUNTS_FIELD);
        map.put("lastLaunched", LAST_LAUNCHED_FIELD);
        map.put("tagMap", TAG_MAP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LifecyclePolicyDetailExclusionRulesAmis, T> g) {
        return obj -> g.apply((LifecyclePolicyDetailExclusionRulesAmis) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LifecyclePolicyDetailExclusionRulesAmis> {
        /**
         * <p>
         * Configures whether public AMIs are excluded from the lifecycle action.
         * </p>
         * 
         * @param isPublic
         *        Configures whether public AMIs are excluded from the lifecycle action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isPublic(Boolean isPublic);

        /**
         * <p>
         * Configures Amazon Web Services Regions that are excluded from the lifecycle action.
         * </p>
         * 
         * @param regions
         *        Configures Amazon Web Services Regions that are excluded from the lifecycle action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(Collection<String> regions);

        /**
         * <p>
         * Configures Amazon Web Services Regions that are excluded from the lifecycle action.
         * </p>
         * 
         * @param regions
         *        Configures Amazon Web Services Regions that are excluded from the lifecycle action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(String... regions);

        /**
         * <p>
         * Specifies Amazon Web Services accounts whose resources are excluded from the lifecycle action.
         * </p>
         * 
         * @param sharedAccounts
         *        Specifies Amazon Web Services accounts whose resources are excluded from the lifecycle action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedAccounts(Collection<String> sharedAccounts);

        /**
         * <p>
         * Specifies Amazon Web Services accounts whose resources are excluded from the lifecycle action.
         * </p>
         * 
         * @param sharedAccounts
         *        Specifies Amazon Web Services accounts whose resources are excluded from the lifecycle action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedAccounts(String... sharedAccounts);

        /**
         * <p>
         * Specifies configuration details for Image Builder to exclude the most recent resources from lifecycle
         * actions.
         * </p>
         * 
         * @param lastLaunched
         *        Specifies configuration details for Image Builder to exclude the most recent resources from lifecycle
         *        actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastLaunched(LifecyclePolicyDetailExclusionRulesAmisLastLaunched lastLaunched);

        /**
         * <p>
         * Specifies configuration details for Image Builder to exclude the most recent resources from lifecycle
         * actions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link LifecyclePolicyDetailExclusionRulesAmisLastLaunched.Builder} avoiding the need to create one manually
         * via {@link LifecyclePolicyDetailExclusionRulesAmisLastLaunched#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link LifecyclePolicyDetailExclusionRulesAmisLastLaunched.Builder#build()} is called immediately and its
         * result is passed to {@link #lastLaunched(LifecyclePolicyDetailExclusionRulesAmisLastLaunched)}.
         * 
         * @param lastLaunched
         *        a consumer that will call methods on
         *        {@link LifecyclePolicyDetailExclusionRulesAmisLastLaunched.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastLaunched(LifecyclePolicyDetailExclusionRulesAmisLastLaunched)
         */
        default Builder lastLaunched(Consumer<LifecyclePolicyDetailExclusionRulesAmisLastLaunched.Builder> lastLaunched) {
            return lastLaunched(LifecyclePolicyDetailExclusionRulesAmisLastLaunched.builder().applyMutation(lastLaunched).build());
        }

        /**
         * <p>
         * Lists tags that should be excluded from lifecycle actions for the AMIs that have them.
         * </p>
         * 
         * @param tagMap
         *        Lists tags that should be excluded from lifecycle actions for the AMIs that have them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagMap(Map<String, String> tagMap);
    }

    static final class BuilderImpl implements Builder {
        private Boolean isPublic;

        private List<String> regions = DefaultSdkAutoConstructList.getInstance();

        private List<String> sharedAccounts = DefaultSdkAutoConstructList.getInstance();

        private LifecyclePolicyDetailExclusionRulesAmisLastLaunched lastLaunched;

        private Map<String, String> tagMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LifecyclePolicyDetailExclusionRulesAmis model) {
            isPublic(model.isPublic);
            regions(model.regions);
            sharedAccounts(model.sharedAccounts);
            lastLaunched(model.lastLaunched);
            tagMap(model.tagMap);
        }

        public final Boolean getIsPublic() {
            return isPublic;
        }

        public final void setIsPublic(Boolean isPublic) {
            this.isPublic = isPublic;
        }

        @Override
        public final Builder isPublic(Boolean isPublic) {
            this.isPublic = isPublic;
            return this;
        }

        public final Collection<String> getRegions() {
            if (regions instanceof SdkAutoConstructList) {
                return null;
            }
            return regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = StringListCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = StringListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String... regions) {
            regions(Arrays.asList(regions));
            return this;
        }

        public final Collection<String> getSharedAccounts() {
            if (sharedAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return sharedAccounts;
        }

        public final void setSharedAccounts(Collection<String> sharedAccounts) {
            this.sharedAccounts = AccountListCopier.copy(sharedAccounts);
        }

        @Override
        public final Builder sharedAccounts(Collection<String> sharedAccounts) {
            this.sharedAccounts = AccountListCopier.copy(sharedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sharedAccounts(String... sharedAccounts) {
            sharedAccounts(Arrays.asList(sharedAccounts));
            return this;
        }

        public final LifecyclePolicyDetailExclusionRulesAmisLastLaunched.Builder getLastLaunched() {
            return lastLaunched != null ? lastLaunched.toBuilder() : null;
        }

        public final void setLastLaunched(LifecyclePolicyDetailExclusionRulesAmisLastLaunched.BuilderImpl lastLaunched) {
            this.lastLaunched = lastLaunched != null ? lastLaunched.build() : null;
        }

        @Override
        public final Builder lastLaunched(LifecyclePolicyDetailExclusionRulesAmisLastLaunched lastLaunched) {
            this.lastLaunched = lastLaunched;
            return this;
        }

        public final Map<String, String> getTagMap() {
            if (tagMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return tagMap;
        }

        public final void setTagMap(Map<String, String> tagMap) {
            this.tagMap = TagMapCopier.copy(tagMap);
        }

        @Override
        public final Builder tagMap(Map<String, String> tagMap) {
            this.tagMap = TagMapCopier.copy(tagMap);
            return this;
        }

        @Override
        public LifecyclePolicyDetailExclusionRulesAmis build() {
            return new LifecyclePolicyDetailExclusionRulesAmis(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
