/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWorkflowStepExecutionsResponse extends ImagebuilderResponse implements
        ToCopyableBuilder<ListWorkflowStepExecutionsResponse.Builder, ListWorkflowStepExecutionsResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestId").getter(getter(ListWorkflowStepExecutionsResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()).build();

    private static final SdkField<List<WorkflowStepMetadata>> STEPS_FIELD = SdkField
            .<List<WorkflowStepMetadata>> builder(MarshallingType.LIST)
            .memberName("steps")
            .getter(getter(ListWorkflowStepExecutionsResponse::steps))
            .setter(setter(Builder::steps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("steps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkflowStepMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkflowStepMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> WORKFLOW_BUILD_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowBuildVersionArn").getter(getter(ListWorkflowStepExecutionsResponse::workflowBuildVersionArn))
            .setter(setter(Builder::workflowBuildVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowBuildVersionArn").build())
            .build();

    private static final SdkField<String> WORKFLOW_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowExecutionId").getter(getter(ListWorkflowStepExecutionsResponse::workflowExecutionId))
            .setter(setter(Builder::workflowExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowExecutionId").build())
            .build();

    private static final SdkField<String> IMAGE_BUILD_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageBuildVersionArn").getter(getter(ListWorkflowStepExecutionsResponse::imageBuildVersionArn))
            .setter(setter(Builder::imageBuildVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageBuildVersionArn").build())
            .build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(ListWorkflowStepExecutionsResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListWorkflowStepExecutionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, STEPS_FIELD,
            WORKFLOW_BUILD_VERSION_ARN_FIELD, WORKFLOW_EXECUTION_ID_FIELD, IMAGE_BUILD_VERSION_ARN_FIELD, MESSAGE_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String requestIdValue;

    private final List<WorkflowStepMetadata> steps;

    private final String workflowBuildVersionArn;

    private final String workflowExecutionId;

    private final String imageBuildVersionArn;

    private final String message;

    private final String nextToken;

    private ListWorkflowStepExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.steps = builder.steps;
        this.workflowBuildVersionArn = builder.workflowBuildVersionArn;
        this.workflowExecutionId = builder.workflowExecutionId;
        this.imageBuildVersionArn = builder.imageBuildVersionArn;
        this.message = builder.message;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The request ID that uniquely identifies this request.
     * </p>
     * 
     * @return The request ID that uniquely identifies this request.
     */
    public final String requestId() {
        return requestIdValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the Steps property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSteps() {
        return steps != null && !(steps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains an array of runtime details that represents each step in this runtime instance of the workflow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSteps} method.
     * </p>
     * 
     * @return Contains an array of runtime details that represents each step in this runtime instance of the workflow.
     */
    public final List<WorkflowStepMetadata> steps() {
        return steps;
    }

    /**
     * <p>
     * The build version ARN for the Image Builder workflow resource that defines the steps for this runtime instance of
     * the workflow.
     * </p>
     * 
     * @return The build version ARN for the Image Builder workflow resource that defines the steps for this runtime
     *         instance of the workflow.
     */
    public final String workflowBuildVersionArn() {
        return workflowBuildVersionArn;
    }

    /**
     * <p>
     * The unique identifier that Image Builder assigned to keep track of runtime details when it ran the workflow.
     * </p>
     * 
     * @return The unique identifier that Image Builder assigned to keep track of runtime details when it ran the
     *         workflow.
     */
    public final String workflowExecutionId() {
        return workflowExecutionId;
    }

    /**
     * <p>
     * The image build version resource ARN that's associated with the specified runtime instance of the workflow.
     * </p>
     * 
     * @return The image build version resource ARN that's associated with the specified runtime instance of the
     *         workflow.
     */
    public final String imageBuildVersionArn() {
        return imageBuildVersionArn;
    }

    /**
     * <p>
     * The output message from the list action, if applicable.
     * </p>
     * 
     * @return The output message from the list action, if applicable.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The next token used for paginated responses. When this field isn't empty, there are additional elements that the
     * service hasn't included in this request. Use this token with the next request to retrieve additional objects.
     * </p>
     * 
     * @return The next token used for paginated responses. When this field isn't empty, there are additional elements
     *         that the service hasn't included in this request. Use this token with the next request to retrieve
     *         additional objects.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSteps() ? steps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workflowBuildVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(workflowExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(imageBuildVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkflowStepExecutionsResponse)) {
            return false;
        }
        ListWorkflowStepExecutionsResponse other = (ListWorkflowStepExecutionsResponse) obj;
        return Objects.equals(requestId(), other.requestId()) && hasSteps() == other.hasSteps()
                && Objects.equals(steps(), other.steps())
                && Objects.equals(workflowBuildVersionArn(), other.workflowBuildVersionArn())
                && Objects.equals(workflowExecutionId(), other.workflowExecutionId())
                && Objects.equals(imageBuildVersionArn(), other.imageBuildVersionArn())
                && Objects.equals(message(), other.message()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListWorkflowStepExecutionsResponse").add("RequestId", requestId())
                .add("Steps", hasSteps() ? steps() : null).add("WorkflowBuildVersionArn", workflowBuildVersionArn())
                .add("WorkflowExecutionId", workflowExecutionId()).add("ImageBuildVersionArn", imageBuildVersionArn())
                .add("Message", message()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "requestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "steps":
            return Optional.ofNullable(clazz.cast(steps()));
        case "workflowBuildVersionArn":
            return Optional.ofNullable(clazz.cast(workflowBuildVersionArn()));
        case "workflowExecutionId":
            return Optional.ofNullable(clazz.cast(workflowExecutionId()));
        case "imageBuildVersionArn":
            return Optional.ofNullable(clazz.cast(imageBuildVersionArn()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("requestId", REQUEST_ID_FIELD);
        map.put("steps", STEPS_FIELD);
        map.put("workflowBuildVersionArn", WORKFLOW_BUILD_VERSION_ARN_FIELD);
        map.put("workflowExecutionId", WORKFLOW_EXECUTION_ID_FIELD);
        map.put("imageBuildVersionArn", IMAGE_BUILD_VERSION_ARN_FIELD);
        map.put("message", MESSAGE_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWorkflowStepExecutionsResponse, T> g) {
        return obj -> g.apply((ListWorkflowStepExecutionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ImagebuilderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListWorkflowStepExecutionsResponse> {
        /**
         * <p>
         * The request ID that uniquely identifies this request.
         * </p>
         * 
         * @param requestIdValue
         *        The request ID that uniquely identifies this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestIdValue);

        /**
         * <p>
         * Contains an array of runtime details that represents each step in this runtime instance of the workflow.
         * </p>
         * 
         * @param steps
         *        Contains an array of runtime details that represents each step in this runtime instance of the
         *        workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder steps(Collection<WorkflowStepMetadata> steps);

        /**
         * <p>
         * Contains an array of runtime details that represents each step in this runtime instance of the workflow.
         * </p>
         * 
         * @param steps
         *        Contains an array of runtime details that represents each step in this runtime instance of the
         *        workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder steps(WorkflowStepMetadata... steps);

        /**
         * <p>
         * Contains an array of runtime details that represents each step in this runtime instance of the workflow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.imagebuilder.model.WorkflowStepMetadata.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.imagebuilder.model.WorkflowStepMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.imagebuilder.model.WorkflowStepMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #steps(List<WorkflowStepMetadata>)}.
         * 
         * @param steps
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.imagebuilder.model.WorkflowStepMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #steps(java.util.Collection<WorkflowStepMetadata>)
         */
        Builder steps(Consumer<WorkflowStepMetadata.Builder>... steps);

        /**
         * <p>
         * The build version ARN for the Image Builder workflow resource that defines the steps for this runtime
         * instance of the workflow.
         * </p>
         * 
         * @param workflowBuildVersionArn
         *        The build version ARN for the Image Builder workflow resource that defines the steps for this runtime
         *        instance of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowBuildVersionArn(String workflowBuildVersionArn);

        /**
         * <p>
         * The unique identifier that Image Builder assigned to keep track of runtime details when it ran the workflow.
         * </p>
         * 
         * @param workflowExecutionId
         *        The unique identifier that Image Builder assigned to keep track of runtime details when it ran the
         *        workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecutionId(String workflowExecutionId);

        /**
         * <p>
         * The image build version resource ARN that's associated with the specified runtime instance of the workflow.
         * </p>
         * 
         * @param imageBuildVersionArn
         *        The image build version resource ARN that's associated with the specified runtime instance of the
         *        workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageBuildVersionArn(String imageBuildVersionArn);

        /**
         * <p>
         * The output message from the list action, if applicable.
         * </p>
         * 
         * @param message
         *        The output message from the list action, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The next token used for paginated responses. When this field isn't empty, there are additional elements that
         * the service hasn't included in this request. Use this token with the next request to retrieve additional
         * objects.
         * </p>
         * 
         * @param nextToken
         *        The next token used for paginated responses. When this field isn't empty, there are additional
         *        elements that the service hasn't included in this request. Use this token with the next request to
         *        retrieve additional objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ImagebuilderResponse.BuilderImpl implements Builder {
        private String requestIdValue;

        private List<WorkflowStepMetadata> steps = DefaultSdkAutoConstructList.getInstance();

        private String workflowBuildVersionArn;

        private String workflowExecutionId;

        private String imageBuildVersionArn;

        private String message;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkflowStepExecutionsResponse model) {
            super(model);
            requestId(model.requestIdValue);
            steps(model.steps);
            workflowBuildVersionArn(model.workflowBuildVersionArn);
            workflowExecutionId(model.workflowExecutionId);
            imageBuildVersionArn(model.imageBuildVersionArn);
            message(model.message);
            nextToken(model.nextToken);
        }

        public final String getRequestId() {
            return requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final List<WorkflowStepMetadata.Builder> getSteps() {
            List<WorkflowStepMetadata.Builder> result = WorkflowStepExecutionsListCopier.copyToBuilder(this.steps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSteps(Collection<WorkflowStepMetadata.BuilderImpl> steps) {
            this.steps = WorkflowStepExecutionsListCopier.copyFromBuilder(steps);
        }

        @Override
        public final Builder steps(Collection<WorkflowStepMetadata> steps) {
            this.steps = WorkflowStepExecutionsListCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(WorkflowStepMetadata... steps) {
            steps(Arrays.asList(steps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Consumer<WorkflowStepMetadata.Builder>... steps) {
            steps(Stream.of(steps).map(c -> WorkflowStepMetadata.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getWorkflowBuildVersionArn() {
            return workflowBuildVersionArn;
        }

        public final void setWorkflowBuildVersionArn(String workflowBuildVersionArn) {
            this.workflowBuildVersionArn = workflowBuildVersionArn;
        }

        @Override
        public final Builder workflowBuildVersionArn(String workflowBuildVersionArn) {
            this.workflowBuildVersionArn = workflowBuildVersionArn;
            return this;
        }

        public final String getWorkflowExecutionId() {
            return workflowExecutionId;
        }

        public final void setWorkflowExecutionId(String workflowExecutionId) {
            this.workflowExecutionId = workflowExecutionId;
        }

        @Override
        public final Builder workflowExecutionId(String workflowExecutionId) {
            this.workflowExecutionId = workflowExecutionId;
            return this;
        }

        public final String getImageBuildVersionArn() {
            return imageBuildVersionArn;
        }

        public final void setImageBuildVersionArn(String imageBuildVersionArn) {
            this.imageBuildVersionArn = imageBuildVersionArn;
        }

        @Override
        public final Builder imageBuildVersionArn(String imageBuildVersionArn) {
            this.imageBuildVersionArn = imageBuildVersionArn;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListWorkflowStepExecutionsResponse build() {
            return new ListWorkflowStepExecutionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
