/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * By default, EC2 instances run on shared tenancy hardware. This means that multiple Amazon Web Services accounts might
 * share the same physical hardware. When you use dedicated hardware, the physical server that hosts your instances is
 * dedicated to your Amazon Web Services account. Instance placement settings contain the details for the physical
 * hardware where instances that Image Builder launches during image creation will run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Placement implements SdkPojo, Serializable, ToCopyableBuilder<Placement.Builder, Placement> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZone").getter(getter(Placement::availabilityZone)).setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<String> TENANCY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("tenancy")
            .getter(getter(Placement::tenancyAsString)).setter(setter(Builder::tenancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tenancy").build()).build();

    private static final SdkField<String> HOST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("hostId")
            .getter(getter(Placement::hostId)).setter(setter(Builder::hostId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostId").build()).build();

    private static final SdkField<String> HOST_RESOURCE_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hostResourceGroupArn").getter(getter(Placement::hostResourceGroupArn))
            .setter(setter(Builder::hostResourceGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostResourceGroupArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD,
            TENANCY_FIELD, HOST_ID_FIELD, HOST_RESOURCE_GROUP_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String availabilityZone;

    private final String tenancy;

    private final String hostId;

    private final String hostResourceGroupArn;

    private Placement(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.tenancy = builder.tenancy;
        this.hostId = builder.hostId;
        this.hostResourceGroupArn = builder.hostResourceGroupArn;
    }

    /**
     * <p>
     * The Availability Zone where your build and test instances will launch.
     * </p>
     * 
     * @return The Availability Zone where your build and test instances will launch.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The tenancy of the instance. An instance with a tenancy of <code>dedicated</code> runs on single-tenant hardware.
     * An instance with a tenancy of <code>host</code> runs on a Dedicated Host.
     * </p>
     * <p>
     * If tenancy is set to <code>host</code>, then you can optionally specify one target for placement – either host ID
     * or host resource group ARN. If automatic placement is enabled for your host, and you don't specify any placement
     * target, Amazon EC2 will try to find an available host for your build and test instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tenancy} will
     * return {@link TenancyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tenancyAsString}.
     * </p>
     * 
     * @return The tenancy of the instance. An instance with a tenancy of <code>dedicated</code> runs on single-tenant
     *         hardware. An instance with a tenancy of <code>host</code> runs on a Dedicated Host.</p>
     *         <p>
     *         If tenancy is set to <code>host</code>, then you can optionally specify one target for placement – either
     *         host ID or host resource group ARN. If automatic placement is enabled for your host, and you don't
     *         specify any placement target, Amazon EC2 will try to find an available host for your build and test
     *         instances.
     * @see TenancyType
     */
    public final TenancyType tenancy() {
        return TenancyType.fromValue(tenancy);
    }

    /**
     * <p>
     * The tenancy of the instance. An instance with a tenancy of <code>dedicated</code> runs on single-tenant hardware.
     * An instance with a tenancy of <code>host</code> runs on a Dedicated Host.
     * </p>
     * <p>
     * If tenancy is set to <code>host</code>, then you can optionally specify one target for placement – either host ID
     * or host resource group ARN. If automatic placement is enabled for your host, and you don't specify any placement
     * target, Amazon EC2 will try to find an available host for your build and test instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tenancy} will
     * return {@link TenancyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tenancyAsString}.
     * </p>
     * 
     * @return The tenancy of the instance. An instance with a tenancy of <code>dedicated</code> runs on single-tenant
     *         hardware. An instance with a tenancy of <code>host</code> runs on a Dedicated Host.</p>
     *         <p>
     *         If tenancy is set to <code>host</code>, then you can optionally specify one target for placement – either
     *         host ID or host resource group ARN. If automatic placement is enabled for your host, and you don't
     *         specify any placement target, Amazon EC2 will try to find an available host for your build and test
     *         instances.
     * @see TenancyType
     */
    public final String tenancyAsString() {
        return tenancy;
    }

    /**
     * <p>
     * The ID of the Dedicated Host on which build and test instances run. This only applies if <code>tenancy</code> is
     * <code>host</code>. If you specify the host ID, you must not specify the resource group ARN. If you specify both,
     * Image Builder returns an error.
     * </p>
     * 
     * @return The ID of the Dedicated Host on which build and test instances run. This only applies if
     *         <code>tenancy</code> is <code>host</code>. If you specify the host ID, you must not specify the resource
     *         group ARN. If you specify both, Image Builder returns an error.
     */
    public final String hostId() {
        return hostId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the host resource group in which to launch build and test instances. This only
     * applies if <code>tenancy</code> is <code>host</code>. If you specify the resource group ARN, you must not specify
     * the host ID. If you specify both, Image Builder returns an error.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the host resource group in which to launch build and test instances.
     *         This only applies if <code>tenancy</code> is <code>host</code>. If you specify the resource group ARN,
     *         you must not specify the host ID. If you specify both, Image Builder returns an error.
     */
    public final String hostResourceGroupArn() {
        return hostResourceGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(tenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hostId());
        hashCode = 31 * hashCode + Objects.hashCode(hostResourceGroupArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Placement)) {
            return false;
        }
        Placement other = (Placement) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(tenancyAsString(), other.tenancyAsString()) && Objects.equals(hostId(), other.hostId())
                && Objects.equals(hostResourceGroupArn(), other.hostResourceGroupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Placement").add("AvailabilityZone", availabilityZone()).add("Tenancy", tenancyAsString())
                .add("HostId", hostId()).add("HostResourceGroupArn", hostResourceGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "availabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "tenancy":
            return Optional.ofNullable(clazz.cast(tenancyAsString()));
        case "hostId":
            return Optional.ofNullable(clazz.cast(hostId()));
        case "hostResourceGroupArn":
            return Optional.ofNullable(clazz.cast(hostResourceGroupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("tenancy", TENANCY_FIELD);
        map.put("hostId", HOST_ID_FIELD);
        map.put("hostResourceGroupArn", HOST_RESOURCE_GROUP_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Placement, T> g) {
        return obj -> g.apply((Placement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Placement> {
        /**
         * <p>
         * The Availability Zone where your build and test instances will launch.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone where your build and test instances will launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The tenancy of the instance. An instance with a tenancy of <code>dedicated</code> runs on single-tenant
         * hardware. An instance with a tenancy of <code>host</code> runs on a Dedicated Host.
         * </p>
         * <p>
         * If tenancy is set to <code>host</code>, then you can optionally specify one target for placement – either
         * host ID or host resource group ARN. If automatic placement is enabled for your host, and you don't specify
         * any placement target, Amazon EC2 will try to find an available host for your build and test instances.
         * </p>
         * 
         * @param tenancy
         *        The tenancy of the instance. An instance with a tenancy of <code>dedicated</code> runs on
         *        single-tenant hardware. An instance with a tenancy of <code>host</code> runs on a Dedicated Host.</p>
         *        <p>
         *        If tenancy is set to <code>host</code>, then you can optionally specify one target for placement –
         *        either host ID or host resource group ARN. If automatic placement is enabled for your host, and you
         *        don't specify any placement target, Amazon EC2 will try to find an available host for your build and
         *        test instances.
         * @see TenancyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TenancyType
         */
        Builder tenancy(String tenancy);

        /**
         * <p>
         * The tenancy of the instance. An instance with a tenancy of <code>dedicated</code> runs on single-tenant
         * hardware. An instance with a tenancy of <code>host</code> runs on a Dedicated Host.
         * </p>
         * <p>
         * If tenancy is set to <code>host</code>, then you can optionally specify one target for placement – either
         * host ID or host resource group ARN. If automatic placement is enabled for your host, and you don't specify
         * any placement target, Amazon EC2 will try to find an available host for your build and test instances.
         * </p>
         * 
         * @param tenancy
         *        The tenancy of the instance. An instance with a tenancy of <code>dedicated</code> runs on
         *        single-tenant hardware. An instance with a tenancy of <code>host</code> runs on a Dedicated Host.</p>
         *        <p>
         *        If tenancy is set to <code>host</code>, then you can optionally specify one target for placement –
         *        either host ID or host resource group ARN. If automatic placement is enabled for your host, and you
         *        don't specify any placement target, Amazon EC2 will try to find an available host for your build and
         *        test instances.
         * @see TenancyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TenancyType
         */
        Builder tenancy(TenancyType tenancy);

        /**
         * <p>
         * The ID of the Dedicated Host on which build and test instances run. This only applies if <code>tenancy</code>
         * is <code>host</code>. If you specify the host ID, you must not specify the resource group ARN. If you specify
         * both, Image Builder returns an error.
         * </p>
         * 
         * @param hostId
         *        The ID of the Dedicated Host on which build and test instances run. This only applies if
         *        <code>tenancy</code> is <code>host</code>. If you specify the host ID, you must not specify the
         *        resource group ARN. If you specify both, Image Builder returns an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostId(String hostId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the host resource group in which to launch build and test instances. This
         * only applies if <code>tenancy</code> is <code>host</code>. If you specify the resource group ARN, you must
         * not specify the host ID. If you specify both, Image Builder returns an error.
         * </p>
         * 
         * @param hostResourceGroupArn
         *        The Amazon Resource Name (ARN) of the host resource group in which to launch build and test instances.
         *        This only applies if <code>tenancy</code> is <code>host</code>. If you specify the resource group ARN,
         *        you must not specify the host ID. If you specify both, Image Builder returns an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostResourceGroupArn(String hostResourceGroupArn);
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private String tenancy;

        private String hostId;

        private String hostResourceGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Placement model) {
            availabilityZone(model.availabilityZone);
            tenancy(model.tenancy);
            hostId(model.hostId);
            hostResourceGroupArn(model.hostResourceGroupArn);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getTenancy() {
            return tenancy;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(TenancyType tenancy) {
            this.tenancy(tenancy == null ? null : tenancy.toString());
            return this;
        }

        public final String getHostId() {
            return hostId;
        }

        public final void setHostId(String hostId) {
            this.hostId = hostId;
        }

        @Override
        public final Builder hostId(String hostId) {
            this.hostId = hostId;
            return this;
        }

        public final String getHostResourceGroupArn() {
            return hostResourceGroupArn;
        }

        public final void setHostResourceGroupArn(String hostResourceGroupArn) {
            this.hostResourceGroupArn = hostResourceGroupArn;
        }

        @Override
        public final Builder hostResourceGroupArn(String hostResourceGroupArn) {
            this.hostResourceGroupArn = hostResourceGroupArn;
            return this;
        }

        @Override
        public Placement build() {
            return new Placement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
