/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartResourceStateUpdateResponse extends ImagebuilderResponse implements
        ToCopyableBuilder<StartResourceStateUpdateResponse.Builder, StartResourceStateUpdateResponse> {
    private static final SdkField<String> LIFECYCLE_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lifecycleExecutionId").getter(getter(StartResourceStateUpdateResponse::lifecycleExecutionId))
            .setter(setter(Builder::lifecycleExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleExecutionId").build())
            .build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(StartResourceStateUpdateResponse::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_EXECUTION_ID_FIELD,
            RESOURCE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String lifecycleExecutionId;

    private final String resourceArn;

    private StartResourceStateUpdateResponse(BuilderImpl builder) {
        super(builder);
        this.lifecycleExecutionId = builder.lifecycleExecutionId;
        this.resourceArn = builder.resourceArn;
    }

    /**
     * <p>
     * Identifies the lifecycle runtime instance that started the resource state update.
     * </p>
     * 
     * @return Identifies the lifecycle runtime instance that started the resource state update.
     */
    public final String lifecycleExecutionId() {
        return lifecycleExecutionId;
    }

    /**
     * <p>
     * The requested ARN of the Image Builder resource for the asynchronous update.
     * </p>
     * 
     * @return The requested ARN of the Image Builder resource for the asynchronous update.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartResourceStateUpdateResponse)) {
            return false;
        }
        StartResourceStateUpdateResponse other = (StartResourceStateUpdateResponse) obj;
        return Objects.equals(lifecycleExecutionId(), other.lifecycleExecutionId())
                && Objects.equals(resourceArn(), other.resourceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartResourceStateUpdateResponse").add("LifecycleExecutionId", lifecycleExecutionId())
                .add("ResourceArn", resourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lifecycleExecutionId":
            return Optional.ofNullable(clazz.cast(lifecycleExecutionId()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("lifecycleExecutionId", LIFECYCLE_EXECUTION_ID_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartResourceStateUpdateResponse, T> g) {
        return obj -> g.apply((StartResourceStateUpdateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ImagebuilderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartResourceStateUpdateResponse> {
        /**
         * <p>
         * Identifies the lifecycle runtime instance that started the resource state update.
         * </p>
         * 
         * @param lifecycleExecutionId
         *        Identifies the lifecycle runtime instance that started the resource state update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleExecutionId(String lifecycleExecutionId);

        /**
         * <p>
         * The requested ARN of the Image Builder resource for the asynchronous update.
         * </p>
         * 
         * @param resourceArn
         *        The requested ARN of the Image Builder resource for the asynchronous update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);
    }

    static final class BuilderImpl extends ImagebuilderResponse.BuilderImpl implements Builder {
        private String lifecycleExecutionId;

        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StartResourceStateUpdateResponse model) {
            super(model);
            lifecycleExecutionId(model.lifecycleExecutionId);
            resourceArn(model.resourceArn);
        }

        public final String getLifecycleExecutionId() {
            return lifecycleExecutionId;
        }

        public final void setLifecycleExecutionId(String lifecycleExecutionId) {
            this.lifecycleExecutionId = lifecycleExecutionId;
        }

        @Override
        public final Builder lifecycleExecutionId(String lifecycleExecutionId) {
            this.lifecycleExecutionId = lifecycleExecutionId;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        @Override
        public StartResourceStateUpdateResponse build() {
            return new StartResourceStateUpdateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
