/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains runtime details for an instance of a workflow that ran for the associated image build version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkflowStepExecution implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkflowStepExecution.Builder, WorkflowStepExecution> {
    private static final SdkField<String> STEP_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stepExecutionId").getter(getter(WorkflowStepExecution::stepExecutionId))
            .setter(setter(Builder::stepExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepExecutionId").build()).build();

    private static final SdkField<String> IMAGE_BUILD_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageBuildVersionArn").getter(getter(WorkflowStepExecution::imageBuildVersionArn))
            .setter(setter(Builder::imageBuildVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageBuildVersionArn").build())
            .build();

    private static final SdkField<String> WORKFLOW_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowExecutionId").getter(getter(WorkflowStepExecution::workflowExecutionId))
            .setter(setter(Builder::workflowExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowExecutionId").build())
            .build();

    private static final SdkField<String> WORKFLOW_BUILD_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowBuildVersionArn").getter(getter(WorkflowStepExecution::workflowBuildVersionArn))
            .setter(setter(Builder::workflowBuildVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowBuildVersionArn").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(WorkflowStepExecution::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(WorkflowStepExecution::action)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<String> START_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("startTime").getter(getter(WorkflowStepExecution::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_EXECUTION_ID_FIELD,
            IMAGE_BUILD_VERSION_ARN_FIELD, WORKFLOW_EXECUTION_ID_FIELD, WORKFLOW_BUILD_VERSION_ARN_FIELD, NAME_FIELD,
            ACTION_FIELD, START_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String stepExecutionId;

    private final String imageBuildVersionArn;

    private final String workflowExecutionId;

    private final String workflowBuildVersionArn;

    private final String name;

    private final String action;

    private final String startTime;

    private WorkflowStepExecution(BuilderImpl builder) {
        this.stepExecutionId = builder.stepExecutionId;
        this.imageBuildVersionArn = builder.imageBuildVersionArn;
        this.workflowExecutionId = builder.workflowExecutionId;
        this.workflowBuildVersionArn = builder.workflowBuildVersionArn;
        this.name = builder.name;
        this.action = builder.action;
        this.startTime = builder.startTime;
    }

    /**
     * <p>
     * Uniquely identifies the workflow step that ran for the associated image build version.
     * </p>
     * 
     * @return Uniquely identifies the workflow step that ran for the associated image build version.
     */
    public final String stepExecutionId() {
        return stepExecutionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the image build version that ran the workflow.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the image build version that ran the workflow.
     */
    public final String imageBuildVersionArn() {
        return imageBuildVersionArn;
    }

    /**
     * <p>
     * Uniquely identifies the runtime instance of the workflow that contains the workflow step that ran for the
     * associated image build version.
     * </p>
     * 
     * @return Uniquely identifies the runtime instance of the workflow that contains the workflow step that ran for the
     *         associated image build version.
     */
    public final String workflowExecutionId() {
        return workflowExecutionId;
    }

    /**
     * <p>
     * The ARN of the workflow resource that ran.
     * </p>
     * 
     * @return The ARN of the workflow resource that ran.
     */
    public final String workflowBuildVersionArn() {
        return workflowBuildVersionArn;
    }

    /**
     * <p>
     * The name of the workflow step.
     * </p>
     * 
     * @return The name of the workflow step.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of the step action.
     * </p>
     * 
     * @return The name of the step action.
     */
    public final String action() {
        return action;
    }

    /**
     * <p>
     * The timestamp when the workflow step started.
     * </p>
     * 
     * @return The timestamp when the workflow step started.
     */
    public final String startTime() {
        return startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stepExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(imageBuildVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(workflowExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(workflowBuildVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowStepExecution)) {
            return false;
        }
        WorkflowStepExecution other = (WorkflowStepExecution) obj;
        return Objects.equals(stepExecutionId(), other.stepExecutionId())
                && Objects.equals(imageBuildVersionArn(), other.imageBuildVersionArn())
                && Objects.equals(workflowExecutionId(), other.workflowExecutionId())
                && Objects.equals(workflowBuildVersionArn(), other.workflowBuildVersionArn())
                && Objects.equals(name(), other.name()) && Objects.equals(action(), other.action())
                && Objects.equals(startTime(), other.startTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkflowStepExecution").add("StepExecutionId", stepExecutionId())
                .add("ImageBuildVersionArn", imageBuildVersionArn()).add("WorkflowExecutionId", workflowExecutionId())
                .add("WorkflowBuildVersionArn", workflowBuildVersionArn()).add("Name", name()).add("Action", action())
                .add("StartTime", startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stepExecutionId":
            return Optional.ofNullable(clazz.cast(stepExecutionId()));
        case "imageBuildVersionArn":
            return Optional.ofNullable(clazz.cast(imageBuildVersionArn()));
        case "workflowExecutionId":
            return Optional.ofNullable(clazz.cast(workflowExecutionId()));
        case "workflowBuildVersionArn":
            return Optional.ofNullable(clazz.cast(workflowBuildVersionArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stepExecutionId", STEP_EXECUTION_ID_FIELD);
        map.put("imageBuildVersionArn", IMAGE_BUILD_VERSION_ARN_FIELD);
        map.put("workflowExecutionId", WORKFLOW_EXECUTION_ID_FIELD);
        map.put("workflowBuildVersionArn", WORKFLOW_BUILD_VERSION_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("action", ACTION_FIELD);
        map.put("startTime", START_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkflowStepExecution, T> g) {
        return obj -> g.apply((WorkflowStepExecution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkflowStepExecution> {
        /**
         * <p>
         * Uniquely identifies the workflow step that ran for the associated image build version.
         * </p>
         * 
         * @param stepExecutionId
         *        Uniquely identifies the workflow step that ran for the associated image build version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepExecutionId(String stepExecutionId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the image build version that ran the workflow.
         * </p>
         * 
         * @param imageBuildVersionArn
         *        The Amazon Resource Name (ARN) of the image build version that ran the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageBuildVersionArn(String imageBuildVersionArn);

        /**
         * <p>
         * Uniquely identifies the runtime instance of the workflow that contains the workflow step that ran for the
         * associated image build version.
         * </p>
         * 
         * @param workflowExecutionId
         *        Uniquely identifies the runtime instance of the workflow that contains the workflow step that ran for
         *        the associated image build version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecutionId(String workflowExecutionId);

        /**
         * <p>
         * The ARN of the workflow resource that ran.
         * </p>
         * 
         * @param workflowBuildVersionArn
         *        The ARN of the workflow resource that ran.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowBuildVersionArn(String workflowBuildVersionArn);

        /**
         * <p>
         * The name of the workflow step.
         * </p>
         * 
         * @param name
         *        The name of the workflow step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the step action.
         * </p>
         * 
         * @param action
         *        The name of the step action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String action);

        /**
         * <p>
         * The timestamp when the workflow step started.
         * </p>
         * 
         * @param startTime
         *        The timestamp when the workflow step started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(String startTime);
    }

    static final class BuilderImpl implements Builder {
        private String stepExecutionId;

        private String imageBuildVersionArn;

        private String workflowExecutionId;

        private String workflowBuildVersionArn;

        private String name;

        private String action;

        private String startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowStepExecution model) {
            stepExecutionId(model.stepExecutionId);
            imageBuildVersionArn(model.imageBuildVersionArn);
            workflowExecutionId(model.workflowExecutionId);
            workflowBuildVersionArn(model.workflowBuildVersionArn);
            name(model.name);
            action(model.action);
            startTime(model.startTime);
        }

        public final String getStepExecutionId() {
            return stepExecutionId;
        }

        public final void setStepExecutionId(String stepExecutionId) {
            this.stepExecutionId = stepExecutionId;
        }

        @Override
        public final Builder stepExecutionId(String stepExecutionId) {
            this.stepExecutionId = stepExecutionId;
            return this;
        }

        public final String getImageBuildVersionArn() {
            return imageBuildVersionArn;
        }

        public final void setImageBuildVersionArn(String imageBuildVersionArn) {
            this.imageBuildVersionArn = imageBuildVersionArn;
        }

        @Override
        public final Builder imageBuildVersionArn(String imageBuildVersionArn) {
            this.imageBuildVersionArn = imageBuildVersionArn;
            return this;
        }

        public final String getWorkflowExecutionId() {
            return workflowExecutionId;
        }

        public final void setWorkflowExecutionId(String workflowExecutionId) {
            this.workflowExecutionId = workflowExecutionId;
        }

        @Override
        public final Builder workflowExecutionId(String workflowExecutionId) {
            this.workflowExecutionId = workflowExecutionId;
            return this;
        }

        public final String getWorkflowBuildVersionArn() {
            return workflowBuildVersionArn;
        }

        public final void setWorkflowBuildVersionArn(String workflowBuildVersionArn) {
            this.workflowBuildVersionArn = workflowBuildVersionArn;
        }

        @Override
        public final Builder workflowBuildVersionArn(String workflowBuildVersionArn) {
            this.workflowBuildVersionArn = workflowBuildVersionArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final String getStartTime() {
            return startTime;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public WorkflowStepExecution build() {
            return new WorkflowStepExecution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
