/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.imagebuilder.internal.ImagebuilderServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.imagebuilder.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.imagebuilder.model.CallRateLimitExceededException;
import software.amazon.awssdk.services.imagebuilder.model.CancelImageCreationRequest;
import software.amazon.awssdk.services.imagebuilder.model.CancelImageCreationResponse;
import software.amazon.awssdk.services.imagebuilder.model.CancelLifecycleExecutionRequest;
import software.amazon.awssdk.services.imagebuilder.model.CancelLifecycleExecutionResponse;
import software.amazon.awssdk.services.imagebuilder.model.ClientException;
import software.amazon.awssdk.services.imagebuilder.model.CreateComponentRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateComponentResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateContainerRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateContainerRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateDistributionConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateDistributionConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateImagePipelineRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateImagePipelineResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateImageRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateImageRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateImageRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateImageResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateInfrastructureConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateInfrastructureConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateLifecyclePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateLifecyclePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.CreateWorkflowRequest;
import software.amazon.awssdk.services.imagebuilder.model.CreateWorkflowResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteComponentRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteComponentResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteContainerRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteContainerRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteDistributionConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteDistributionConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImagePipelineRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImagePipelineResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImageRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImageRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImageRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteImageResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteInfrastructureConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteInfrastructureConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteLifecyclePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteLifecyclePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.DeleteWorkflowRequest;
import software.amazon.awssdk.services.imagebuilder.model.DeleteWorkflowResponse;
import software.amazon.awssdk.services.imagebuilder.model.ForbiddenException;
import software.amazon.awssdk.services.imagebuilder.model.GetComponentPolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetComponentPolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetComponentRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetComponentResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetDistributionConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetDistributionConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetImagePipelineRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetImagePipelineResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetImagePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetImagePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetImageRecipePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetImageRecipePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetImageRecipeRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetImageRecipeResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetImageRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetImageResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetInfrastructureConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetInfrastructureConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetLifecycleExecutionRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetLifecycleExecutionResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetLifecyclePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetLifecyclePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetMarketplaceResourceRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetMarketplaceResourceResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetWorkflowExecutionRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetWorkflowExecutionResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetWorkflowRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetWorkflowResponse;
import software.amazon.awssdk.services.imagebuilder.model.GetWorkflowStepExecutionRequest;
import software.amazon.awssdk.services.imagebuilder.model.GetWorkflowStepExecutionResponse;
import software.amazon.awssdk.services.imagebuilder.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderException;
import software.amazon.awssdk.services.imagebuilder.model.ImportComponentRequest;
import software.amazon.awssdk.services.imagebuilder.model.ImportComponentResponse;
import software.amazon.awssdk.services.imagebuilder.model.ImportDiskImageRequest;
import software.amazon.awssdk.services.imagebuilder.model.ImportDiskImageResponse;
import software.amazon.awssdk.services.imagebuilder.model.ImportVmImageRequest;
import software.amazon.awssdk.services.imagebuilder.model.ImportVmImageResponse;
import software.amazon.awssdk.services.imagebuilder.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.imagebuilder.model.InvalidParameterCombinationException;
import software.amazon.awssdk.services.imagebuilder.model.InvalidParameterException;
import software.amazon.awssdk.services.imagebuilder.model.InvalidParameterValueException;
import software.amazon.awssdk.services.imagebuilder.model.InvalidRequestException;
import software.amazon.awssdk.services.imagebuilder.model.InvalidVersionNumberException;
import software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListComponentsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListComponentsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingAggregationsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingAggregationsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListImagesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImagesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionResourcesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionResourcesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListLifecyclePoliciesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListLifecyclePoliciesResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListWaitingWorkflowStepsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListWaitingWorkflowStepsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListWorkflowBuildVersionsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListWorkflowBuildVersionsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListWorkflowExecutionsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListWorkflowExecutionsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListWorkflowStepExecutionsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListWorkflowStepExecutionsResponse;
import software.amazon.awssdk.services.imagebuilder.model.ListWorkflowsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListWorkflowsResponse;
import software.amazon.awssdk.services.imagebuilder.model.PutComponentPolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.PutComponentPolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.PutContainerRecipePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.PutContainerRecipePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.PutImagePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.PutImagePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.PutImageRecipePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.PutImageRecipePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.imagebuilder.model.ResourceDependencyException;
import software.amazon.awssdk.services.imagebuilder.model.ResourceInUseException;
import software.amazon.awssdk.services.imagebuilder.model.ResourceNotFoundException;
import software.amazon.awssdk.services.imagebuilder.model.SendWorkflowStepActionRequest;
import software.amazon.awssdk.services.imagebuilder.model.SendWorkflowStepActionResponse;
import software.amazon.awssdk.services.imagebuilder.model.ServiceException;
import software.amazon.awssdk.services.imagebuilder.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.imagebuilder.model.ServiceUnavailableException;
import software.amazon.awssdk.services.imagebuilder.model.StartImagePipelineExecutionRequest;
import software.amazon.awssdk.services.imagebuilder.model.StartImagePipelineExecutionResponse;
import software.amazon.awssdk.services.imagebuilder.model.StartResourceStateUpdateRequest;
import software.amazon.awssdk.services.imagebuilder.model.StartResourceStateUpdateResponse;
import software.amazon.awssdk.services.imagebuilder.model.TagResourceRequest;
import software.amazon.awssdk.services.imagebuilder.model.TagResourceResponse;
import software.amazon.awssdk.services.imagebuilder.model.UntagResourceRequest;
import software.amazon.awssdk.services.imagebuilder.model.UntagResourceResponse;
import software.amazon.awssdk.services.imagebuilder.model.UpdateDistributionConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.UpdateDistributionConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.UpdateImagePipelineRequest;
import software.amazon.awssdk.services.imagebuilder.model.UpdateImagePipelineResponse;
import software.amazon.awssdk.services.imagebuilder.model.UpdateInfrastructureConfigurationRequest;
import software.amazon.awssdk.services.imagebuilder.model.UpdateInfrastructureConfigurationResponse;
import software.amazon.awssdk.services.imagebuilder.model.UpdateLifecyclePolicyRequest;
import software.amazon.awssdk.services.imagebuilder.model.UpdateLifecyclePolicyResponse;
import software.amazon.awssdk.services.imagebuilder.transform.CancelImageCreationRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.CancelLifecycleExecutionRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.CreateComponentRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.CreateContainerRecipeRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.CreateDistributionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.CreateImagePipelineRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.CreateImageRecipeRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.CreateImageRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.CreateInfrastructureConfigurationRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.CreateLifecyclePolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.CreateWorkflowRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.DeleteComponentRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.DeleteContainerRecipeRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.DeleteDistributionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.DeleteImagePipelineRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.DeleteImageRecipeRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.DeleteImageRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.DeleteInfrastructureConfigurationRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.DeleteLifecyclePolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.DeleteWorkflowRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetComponentPolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetComponentRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetContainerRecipePolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetContainerRecipeRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetDistributionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetImagePipelineRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetImagePolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetImageRecipePolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetImageRecipeRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetImageRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetInfrastructureConfigurationRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetLifecycleExecutionRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetLifecyclePolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetMarketplaceResourceRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetWorkflowExecutionRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetWorkflowRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.GetWorkflowStepExecutionRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ImportComponentRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ImportDiskImageRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ImportVmImageRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListComponentBuildVersionsRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListComponentsRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListContainerRecipesRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListDistributionConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListImageBuildVersionsRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListImagePackagesRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListImagePipelineImagesRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListImagePipelinesRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListImageRecipesRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListImageScanFindingAggregationsRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListImageScanFindingsRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListImagesRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListInfrastructureConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListLifecycleExecutionResourcesRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListLifecycleExecutionsRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListLifecyclePoliciesRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListWaitingWorkflowStepsRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListWorkflowBuildVersionsRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListWorkflowExecutionsRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListWorkflowStepExecutionsRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.ListWorkflowsRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.PutComponentPolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.PutContainerRecipePolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.PutImagePolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.PutImageRecipePolicyRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.SendWorkflowStepActionRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.StartImagePipelineExecutionRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.StartResourceStateUpdateRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.UpdateDistributionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.UpdateImagePipelineRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.UpdateInfrastructureConfigurationRequestMarshaller;
import software.amazon.awssdk.services.imagebuilder.transform.UpdateLifecyclePolicyRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link ImagebuilderClient}.
 *
 * @see ImagebuilderClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultImagebuilderClient implements ImagebuilderClient {
    private static final Logger log = Logger.loggerFor(DefaultImagebuilderClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultImagebuilderClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "imagebuilder" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * CancelImageCreation cancels the creation of Image. This operation can only be used on images in a non-terminal
     * state.
     * </p>
     *
     * @param cancelImageCreationRequest
     * @return Result of the CancelImageCreation operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CancelImageCreation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CancelImageCreation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CancelImageCreationResponse cancelImageCreation(CancelImageCreationRequest cancelImageCreationRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            IdempotentParameterMismatchException, ForbiddenException, CallRateLimitExceededException, ResourceInUseException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelImageCreationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CancelImageCreationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelImageCreationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelImageCreationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelImageCreation");

            return clientHandler.execute(new ClientExecutionParams<CancelImageCreationRequest, CancelImageCreationResponse>()
                    .withOperationName("CancelImageCreation").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(cancelImageCreationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CancelImageCreationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancel a specific image lifecycle policy runtime instance.
     * </p>
     *
     * @param cancelLifecycleExecutionRequest
     * @return Result of the CancelLifecycleExecution operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CancelLifecycleExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CancelLifecycleExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CancelLifecycleExecutionResponse cancelLifecycleExecution(
            CancelLifecycleExecutionRequest cancelLifecycleExecutionRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, IdempotentParameterMismatchException, ForbiddenException,
            CallRateLimitExceededException, ResourceInUseException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelLifecycleExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CancelLifecycleExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelLifecycleExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelLifecycleExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelLifecycleExecution");

            return clientHandler
                    .execute(new ClientExecutionParams<CancelLifecycleExecutionRequest, CancelLifecycleExecutionResponse>()
                            .withOperationName("CancelLifecycleExecution").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(cancelLifecycleExecutionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CancelLifecycleExecutionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new component that can be used to build, validate, test, and assess your image. The component is based
     * on a YAML document that you specify using exactly one of the following methods:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Inline, using the <code>data</code> property in the request body.
     * </p>
     * </li>
     * <li>
     * <p>
     * A URL that points to a YAML document file stored in Amazon S3, using the <code>uri</code> property in the request
     * body.
     * </p>
     * </li>
     * </ul>
     *
     * @param createComponentRequest
     * @return Result of the CreateComponent operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws InvalidVersionNumberException
     *         Your version number is out of bounds or does not follow the required syntax.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws InvalidParameterCombinationException
     *         You have specified two or more mutually exclusive parameters. Review the error message for details.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the number of permitted resources or operations for this service. For service quotas,
     *         see <a href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2
     *         Image Builder endpoints and quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CreateComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateComponent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateComponentResponse createComponent(CreateComponentRequest createComponentRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, IdempotentParameterMismatchException,
            ForbiddenException, CallRateLimitExceededException, InvalidVersionNumberException, ResourceInUseException,
            InvalidParameterCombinationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateComponentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateComponentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createComponentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateComponent");

            return clientHandler.execute(new ClientExecutionParams<CreateComponentRequest, CreateComponentResponse>()
                    .withOperationName("CreateComponent").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createComponentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateComponentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new container recipe. Container recipes define how images are configured, tested, and assessed.
     * </p>
     *
     * @param createContainerRecipeRequest
     * @return Result of the CreateContainerRecipe operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws InvalidVersionNumberException
     *         Your version number is out of bounds or does not follow the required syntax.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws ResourceAlreadyExistsException
     *         The resource that you are trying to create already exists.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the number of permitted resources or operations for this service. For service quotas,
     *         see <a href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2
     *         Image Builder endpoints and quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CreateContainerRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateContainerRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateContainerRecipeResponse createContainerRecipe(CreateContainerRecipeRequest createContainerRecipeRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            IdempotentParameterMismatchException, ForbiddenException, CallRateLimitExceededException,
            InvalidVersionNumberException, ResourceInUseException, ResourceAlreadyExistsException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateContainerRecipeResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateContainerRecipeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createContainerRecipeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createContainerRecipeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateContainerRecipe");

            return clientHandler.execute(new ClientExecutionParams<CreateContainerRecipeRequest, CreateContainerRecipeResponse>()
                    .withOperationName("CreateContainerRecipe").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createContainerRecipeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateContainerRecipeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new distribution configuration. Distribution configurations define and configure the outputs of your
     * pipeline.
     * </p>
     *
     * @param createDistributionConfigurationRequest
     * @return Result of the CreateDistributionConfiguration operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws ResourceAlreadyExistsException
     *         The resource that you are trying to create already exists.
     * @throws InvalidParameterCombinationException
     *         You have specified two or more mutually exclusive parameters. Review the error message for details.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the number of permitted resources or operations for this service. For service quotas,
     *         see <a href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2
     *         Image Builder endpoints and quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CreateDistributionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateDistributionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateDistributionConfigurationResponse createDistributionConfiguration(
            CreateDistributionConfigurationRequest createDistributionConfigurationRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, IdempotentParameterMismatchException,
            ForbiddenException, CallRateLimitExceededException, ResourceInUseException, ResourceAlreadyExistsException,
            InvalidParameterCombinationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDistributionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateDistributionConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDistributionConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createDistributionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDistributionConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateDistributionConfigurationRequest, CreateDistributionConfigurationResponse>()
                            .withOperationName("CreateDistributionConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createDistributionConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateDistributionConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new image. This request will create a new image along with all of the configured output resources
     * defined in the distribution configuration. You must specify exactly one recipe for your image, using either a
     * ContainerRecipeArn or an ImageRecipeArn.
     * </p>
     *
     * @param createImageRequest
     * @return Result of the CreateImage operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the number of permitted resources or operations for this service. For service quotas,
     *         see <a href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2
     *         Image Builder endpoints and quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CreateImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateImageResponse createImage(CreateImageRequest createImageRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, IdempotentParameterMismatchException, ForbiddenException,
            CallRateLimitExceededException, ResourceInUseException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateImageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateImageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createImageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateImage");

            return clientHandler.execute(new ClientExecutionParams<CreateImageRequest, CreateImageResponse>()
                    .withOperationName("CreateImage").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createImageRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new image pipeline. Image pipelines enable you to automate the creation and distribution of images.
     * </p>
     *
     * @param createImagePipelineRequest
     * @return Result of the CreateImagePipeline operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws ResourceAlreadyExistsException
     *         The resource that you are trying to create already exists.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the number of permitted resources or operations for this service. For service quotas,
     *         see <a href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2
     *         Image Builder endpoints and quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CreateImagePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateImagePipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateImagePipelineResponse createImagePipeline(CreateImagePipelineRequest createImagePipelineRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            IdempotentParameterMismatchException, ForbiddenException, CallRateLimitExceededException, ResourceInUseException,
            ResourceAlreadyExistsException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateImagePipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateImagePipelineResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createImagePipelineRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createImagePipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateImagePipeline");

            return clientHandler.execute(new ClientExecutionParams<CreateImagePipelineRequest, CreateImagePipelineResponse>()
                    .withOperationName("CreateImagePipeline").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createImagePipelineRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateImagePipelineRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new image recipe. Image recipes define how images are configured, tested, and assessed.
     * </p>
     *
     * @param createImageRecipeRequest
     * @return Result of the CreateImageRecipe operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws InvalidVersionNumberException
     *         Your version number is out of bounds or does not follow the required syntax.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws ResourceAlreadyExistsException
     *         The resource that you are trying to create already exists.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the number of permitted resources or operations for this service. For service quotas,
     *         see <a href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2
     *         Image Builder endpoints and quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CreateImageRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateImageRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateImageRecipeResponse createImageRecipe(CreateImageRecipeRequest createImageRecipeRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            IdempotentParameterMismatchException, ForbiddenException, CallRateLimitExceededException,
            InvalidVersionNumberException, ResourceInUseException, ResourceAlreadyExistsException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateImageRecipeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateImageRecipeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createImageRecipeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createImageRecipeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateImageRecipe");

            return clientHandler.execute(new ClientExecutionParams<CreateImageRecipeRequest, CreateImageRecipeResponse>()
                    .withOperationName("CreateImageRecipe").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createImageRecipeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateImageRecipeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new infrastructure configuration. An infrastructure configuration defines the environment in which your
     * image will be built and tested.
     * </p>
     *
     * @param createInfrastructureConfigurationRequest
     * @return Result of the CreateInfrastructureConfiguration operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws ResourceAlreadyExistsException
     *         The resource that you are trying to create already exists.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the number of permitted resources or operations for this service. For service quotas,
     *         see <a href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2
     *         Image Builder endpoints and quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CreateInfrastructureConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateInfrastructureConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateInfrastructureConfigurationResponse createInfrastructureConfiguration(
            CreateInfrastructureConfigurationRequest createInfrastructureConfigurationRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, IdempotentParameterMismatchException,
            ForbiddenException, CallRateLimitExceededException, ResourceInUseException, ResourceAlreadyExistsException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateInfrastructureConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateInfrastructureConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createInfrastructureConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createInfrastructureConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInfrastructureConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateInfrastructureConfigurationRequest, CreateInfrastructureConfigurationResponse>()
                            .withOperationName("CreateInfrastructureConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createInfrastructureConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateInfrastructureConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create a lifecycle policy resource.
     * </p>
     *
     * @param createLifecyclePolicyRequest
     * @return Result of the CreateLifecyclePolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws ResourceAlreadyExistsException
     *         The resource that you are trying to create already exists.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the number of permitted resources or operations for this service. For service quotas,
     *         see <a href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2
     *         Image Builder endpoints and quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CreateLifecyclePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateLifecyclePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateLifecyclePolicyResponse createLifecyclePolicy(CreateLifecyclePolicyRequest createLifecyclePolicyRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            IdempotentParameterMismatchException, ForbiddenException, CallRateLimitExceededException, ResourceInUseException,
            ResourceAlreadyExistsException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateLifecyclePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateLifecyclePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createLifecyclePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLifecyclePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLifecyclePolicy");

            return clientHandler.execute(new ClientExecutionParams<CreateLifecyclePolicyRequest, CreateLifecyclePolicyResponse>()
                    .withOperationName("CreateLifecyclePolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createLifecyclePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateLifecyclePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create a new workflow or a new version of an existing workflow.
     * </p>
     *
     * @param createWorkflowRequest
     * @return Result of the CreateWorkflow operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws InvalidVersionNumberException
     *         Your version number is out of bounds or does not follow the required syntax.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws InvalidParameterCombinationException
     *         You have specified two or more mutually exclusive parameters. Review the error message for details.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the number of permitted resources or operations for this service. For service quotas,
     *         see <a href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2
     *         Image Builder endpoints and quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.CreateWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateWorkflow" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateWorkflowResponse createWorkflow(CreateWorkflowRequest createWorkflowRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, IdempotentParameterMismatchException,
            ForbiddenException, CallRateLimitExceededException, InvalidVersionNumberException, ResourceInUseException,
            InvalidParameterCombinationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateWorkflowResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWorkflowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkflowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkflow");

            return clientHandler.execute(new ClientExecutionParams<CreateWorkflowRequest, CreateWorkflowResponse>()
                    .withOperationName("CreateWorkflow").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createWorkflowRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateWorkflowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a component build version.
     * </p>
     *
     * @param deleteComponentRequest
     * @return Result of the DeleteComponent operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceDependencyException
     *         You have attempted to mutate or delete a resource with a dependency that prohibits this action. See the
     *         error message for more details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.DeleteComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteComponent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteComponentResponse deleteComponent(DeleteComponentRequest deleteComponentRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, ResourceDependencyException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteComponentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteComponentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteComponentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteComponent");

            return clientHandler.execute(new ClientExecutionParams<DeleteComponentRequest, DeleteComponentResponse>()
                    .withOperationName("DeleteComponent").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteComponentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteComponentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a container recipe.
     * </p>
     *
     * @param deleteContainerRecipeRequest
     * @return Result of the DeleteContainerRecipe operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceDependencyException
     *         You have attempted to mutate or delete a resource with a dependency that prohibits this action. See the
     *         error message for more details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.DeleteContainerRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteContainerRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteContainerRecipeResponse deleteContainerRecipe(DeleteContainerRecipeRequest deleteContainerRecipeRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, ResourceDependencyException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteContainerRecipeResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteContainerRecipeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteContainerRecipeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteContainerRecipeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteContainerRecipe");

            return clientHandler.execute(new ClientExecutionParams<DeleteContainerRecipeRequest, DeleteContainerRecipeResponse>()
                    .withOperationName("DeleteContainerRecipe").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteContainerRecipeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteContainerRecipeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a distribution configuration.
     * </p>
     *
     * @param deleteDistributionConfigurationRequest
     * @return Result of the DeleteDistributionConfiguration operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceDependencyException
     *         You have attempted to mutate or delete a resource with a dependency that prohibits this action. See the
     *         error message for more details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.DeleteDistributionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteDistributionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteDistributionConfigurationResponse deleteDistributionConfiguration(
            DeleteDistributionConfigurationRequest deleteDistributionConfigurationRequest) throws ServiceException,
            ClientException, InvalidRequestException, ServiceUnavailableException, ForbiddenException,
            CallRateLimitExceededException, ResourceDependencyException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDistributionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteDistributionConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDistributionConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteDistributionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDistributionConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteDistributionConfigurationRequest, DeleteDistributionConfigurationResponse>()
                            .withOperationName("DeleteDistributionConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteDistributionConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteDistributionConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Image Builder image resource. This does not delete any EC2 AMIs or ECR container images that are
     * created during the image build process. You must clean those up separately, using the appropriate Amazon EC2 or
     * Amazon ECR console actions, or API or CLI commands.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To deregister an EC2 Linux AMI, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/deregister-ami.html">Deregister your Linux AMI</a> in
     * the <i> <i>Amazon EC2 User Guide</i> </i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To deregister an EC2 Windows AMI, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/deregister-ami.html">Deregister your Windows AMI</a>
     * in the <i> <i>Amazon EC2 Windows Guide</i> </i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To delete a container image from Amazon ECR, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/delete_image.html">Deleting an image</a> in the
     * <i>Amazon ECR User Guide</i>.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteImageRequest
     * @return Result of the DeleteImage operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceDependencyException
     *         You have attempted to mutate or delete a resource with a dependency that prohibits this action. See the
     *         error message for more details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.DeleteImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteImageResponse deleteImage(DeleteImageRequest deleteImageRequest) throws ServiceException, ClientException,
            InvalidRequestException, ServiceUnavailableException, ForbiddenException, CallRateLimitExceededException,
            ResourceDependencyException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteImageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteImageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteImageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteImage");

            return clientHandler.execute(new ClientExecutionParams<DeleteImageRequest, DeleteImageResponse>()
                    .withOperationName("DeleteImage").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteImageRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an image pipeline.
     * </p>
     *
     * @param deleteImagePipelineRequest
     * @return Result of the DeleteImagePipeline operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceDependencyException
     *         You have attempted to mutate or delete a resource with a dependency that prohibits this action. See the
     *         error message for more details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.DeleteImagePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteImagePipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteImagePipelineResponse deleteImagePipeline(DeleteImagePipelineRequest deleteImagePipelineRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, ResourceDependencyException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteImagePipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteImagePipelineResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteImagePipelineRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteImagePipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteImagePipeline");

            return clientHandler.execute(new ClientExecutionParams<DeleteImagePipelineRequest, DeleteImagePipelineResponse>()
                    .withOperationName("DeleteImagePipeline").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteImagePipelineRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteImagePipelineRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an image recipe.
     * </p>
     *
     * @param deleteImageRecipeRequest
     * @return Result of the DeleteImageRecipe operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceDependencyException
     *         You have attempted to mutate or delete a resource with a dependency that prohibits this action. See the
     *         error message for more details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.DeleteImageRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteImageRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteImageRecipeResponse deleteImageRecipe(DeleteImageRecipeRequest deleteImageRecipeRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, ResourceDependencyException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteImageRecipeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteImageRecipeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteImageRecipeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteImageRecipeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteImageRecipe");

            return clientHandler.execute(new ClientExecutionParams<DeleteImageRecipeRequest, DeleteImageRecipeResponse>()
                    .withOperationName("DeleteImageRecipe").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteImageRecipeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteImageRecipeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an infrastructure configuration.
     * </p>
     *
     * @param deleteInfrastructureConfigurationRequest
     * @return Result of the DeleteInfrastructureConfiguration operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceDependencyException
     *         You have attempted to mutate or delete a resource with a dependency that prohibits this action. See the
     *         error message for more details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.DeleteInfrastructureConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteInfrastructureConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteInfrastructureConfigurationResponse deleteInfrastructureConfiguration(
            DeleteInfrastructureConfigurationRequest deleteInfrastructureConfigurationRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, ResourceDependencyException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteInfrastructureConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteInfrastructureConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteInfrastructureConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteInfrastructureConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInfrastructureConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteInfrastructureConfigurationRequest, DeleteInfrastructureConfigurationResponse>()
                            .withOperationName("DeleteInfrastructureConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteInfrastructureConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteInfrastructureConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete the specified lifecycle policy resource.
     * </p>
     *
     * @param deleteLifecyclePolicyRequest
     * @return Result of the DeleteLifecyclePolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceDependencyException
     *         You have attempted to mutate or delete a resource with a dependency that prohibits this action. See the
     *         error message for more details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.DeleteLifecyclePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteLifecyclePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteLifecyclePolicyResponse deleteLifecyclePolicy(DeleteLifecyclePolicyRequest deleteLifecyclePolicyRequest)
            throws ServiceException, ClientException, InvalidRequestException, ServiceUnavailableException, ForbiddenException,
            CallRateLimitExceededException, ResourceDependencyException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteLifecyclePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteLifecyclePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteLifecyclePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLifecyclePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLifecyclePolicy");

            return clientHandler.execute(new ClientExecutionParams<DeleteLifecyclePolicyRequest, DeleteLifecyclePolicyResponse>()
                    .withOperationName("DeleteLifecyclePolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteLifecyclePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteLifecyclePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a specific workflow resource.
     * </p>
     *
     * @param deleteWorkflowRequest
     * @return Result of the DeleteWorkflow operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceDependencyException
     *         You have attempted to mutate or delete a resource with a dependency that prohibits this action. See the
     *         error message for more details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.DeleteWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteWorkflow" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteWorkflowResponse deleteWorkflow(DeleteWorkflowRequest deleteWorkflowRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, ResourceDependencyException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteWorkflowResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteWorkflowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWorkflowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWorkflow");

            return clientHandler.execute(new ClientExecutionParams<DeleteWorkflowRequest, DeleteWorkflowResponse>()
                    .withOperationName("DeleteWorkflow").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteWorkflowRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteWorkflowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a component object.
     * </p>
     *
     * @param getComponentRequest
     * @return Result of the GetComponent operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetComponent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetComponentResponse getComponent(GetComponentRequest getComponentRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, ForbiddenException, CallRateLimitExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetComponentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetComponentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getComponentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetComponent");

            return clientHandler.execute(new ClientExecutionParams<GetComponentRequest, GetComponentResponse>()
                    .withOperationName("GetComponent").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getComponentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetComponentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a component policy.
     * </p>
     *
     * @param getComponentPolicyRequest
     * @return Result of the GetComponentPolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetComponentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetComponentPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetComponentPolicyResponse getComponentPolicy(GetComponentPolicyRequest getComponentPolicyRequest)
            throws ServiceException, ServiceUnavailableException, ResourceNotFoundException, InvalidRequestException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetComponentPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetComponentPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getComponentPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getComponentPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetComponentPolicy");

            return clientHandler.execute(new ClientExecutionParams<GetComponentPolicyRequest, GetComponentPolicyResponse>()
                    .withOperationName("GetComponentPolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getComponentPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetComponentPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a container recipe.
     * </p>
     *
     * @param getContainerRecipeRequest
     * @return Result of the GetContainerRecipe operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetContainerRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetContainerRecipe"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetContainerRecipeResponse getContainerRecipe(GetContainerRecipeRequest getContainerRecipeRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetContainerRecipeResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetContainerRecipeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getContainerRecipeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getContainerRecipeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetContainerRecipe");

            return clientHandler.execute(new ClientExecutionParams<GetContainerRecipeRequest, GetContainerRecipeResponse>()
                    .withOperationName("GetContainerRecipe").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getContainerRecipeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetContainerRecipeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the policy for a container recipe.
     * </p>
     *
     * @param getContainerRecipePolicyRequest
     * @return Result of the GetContainerRecipePolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetContainerRecipePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetContainerRecipePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetContainerRecipePolicyResponse getContainerRecipePolicy(
            GetContainerRecipePolicyRequest getContainerRecipePolicyRequest) throws ServiceException,
            ServiceUnavailableException, InvalidRequestException, ResourceNotFoundException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetContainerRecipePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetContainerRecipePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getContainerRecipePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getContainerRecipePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetContainerRecipePolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<GetContainerRecipePolicyRequest, GetContainerRecipePolicyResponse>()
                            .withOperationName("GetContainerRecipePolicy").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getContainerRecipePolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetContainerRecipePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a distribution configuration.
     * </p>
     *
     * @param getDistributionConfigurationRequest
     * @return Result of the GetDistributionConfiguration operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetDistributionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetDistributionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetDistributionConfigurationResponse getDistributionConfiguration(
            GetDistributionConfigurationRequest getDistributionConfigurationRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, ForbiddenException, CallRateLimitExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDistributionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDistributionConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDistributionConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDistributionConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDistributionConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<GetDistributionConfigurationRequest, GetDistributionConfigurationResponse>()
                            .withOperationName("GetDistributionConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getDistributionConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetDistributionConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets an image.
     * </p>
     *
     * @param getImageRequest
     * @return Result of the GetImage operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetImageResponse getImage(GetImageRequest getImageRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, ForbiddenException, CallRateLimitExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetImageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetImageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getImageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImage");

            return clientHandler.execute(new ClientExecutionParams<GetImageRequest, GetImageResponse>()
                    .withOperationName("GetImage").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getImageRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets an image pipeline.
     * </p>
     *
     * @param getImagePipelineRequest
     * @return Result of the GetImagePipeline operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetImagePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImagePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetImagePipelineResponse getImagePipeline(GetImagePipelineRequest getImagePipelineRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetImagePipelineResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetImagePipelineResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getImagePipelineRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImagePipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImagePipeline");

            return clientHandler.execute(new ClientExecutionParams<GetImagePipelineRequest, GetImagePipelineResponse>()
                    .withOperationName("GetImagePipeline").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getImagePipelineRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetImagePipelineRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets an image policy.
     * </p>
     *
     * @param getImagePolicyRequest
     * @return Result of the GetImagePolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetImagePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImagePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetImagePolicyResponse getImagePolicy(GetImagePolicyRequest getImagePolicyRequest) throws ServiceException,
            ServiceUnavailableException, ResourceNotFoundException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetImagePolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetImagePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getImagePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImagePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImagePolicy");

            return clientHandler.execute(new ClientExecutionParams<GetImagePolicyRequest, GetImagePolicyResponse>()
                    .withOperationName("GetImagePolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getImagePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetImagePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets an image recipe.
     * </p>
     *
     * @param getImageRecipeRequest
     * @return Result of the GetImageRecipe operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetImageRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImageRecipe" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetImageRecipeResponse getImageRecipe(GetImageRecipeRequest getImageRecipeRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetImageRecipeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetImageRecipeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getImageRecipeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImageRecipeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImageRecipe");

            return clientHandler.execute(new ClientExecutionParams<GetImageRecipeRequest, GetImageRecipeResponse>()
                    .withOperationName("GetImageRecipe").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getImageRecipeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetImageRecipeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets an image recipe policy.
     * </p>
     *
     * @param getImageRecipePolicyRequest
     * @return Result of the GetImageRecipePolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetImageRecipePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetImageRecipePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetImageRecipePolicyResponse getImageRecipePolicy(GetImageRecipePolicyRequest getImageRecipePolicyRequest)
            throws ServiceException, ServiceUnavailableException, InvalidRequestException, ResourceNotFoundException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetImageRecipePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetImageRecipePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getImageRecipePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImageRecipePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImageRecipePolicy");

            return clientHandler.execute(new ClientExecutionParams<GetImageRecipePolicyRequest, GetImageRecipePolicyResponse>()
                    .withOperationName("GetImageRecipePolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getImageRecipePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetImageRecipePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets an infrastructure configuration.
     * </p>
     *
     * @param getInfrastructureConfigurationRequest
     *        GetInfrastructureConfiguration request object.
     * @return Result of the GetInfrastructureConfiguration operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetInfrastructureConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetInfrastructureConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetInfrastructureConfigurationResponse getInfrastructureConfiguration(
            GetInfrastructureConfigurationRequest getInfrastructureConfigurationRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetInfrastructureConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetInfrastructureConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getInfrastructureConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getInfrastructureConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInfrastructureConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<GetInfrastructureConfigurationRequest, GetInfrastructureConfigurationResponse>()
                            .withOperationName("GetInfrastructureConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getInfrastructureConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetInfrastructureConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get the runtime information that was logged for a specific runtime instance of the lifecycle policy.
     * </p>
     *
     * @param getLifecycleExecutionRequest
     * @return Result of the GetLifecycleExecution operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetLifecycleExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetLifecycleExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetLifecycleExecutionResponse getLifecycleExecution(GetLifecycleExecutionRequest getLifecycleExecutionRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetLifecycleExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetLifecycleExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getLifecycleExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLifecycleExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLifecycleExecution");

            return clientHandler.execute(new ClientExecutionParams<GetLifecycleExecutionRequest, GetLifecycleExecutionResponse>()
                    .withOperationName("GetLifecycleExecution").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getLifecycleExecutionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetLifecycleExecutionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get details for the specified image lifecycle policy.
     * </p>
     *
     * @param getLifecyclePolicyRequest
     * @return Result of the GetLifecyclePolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetLifecyclePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetLifecyclePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetLifecyclePolicyResponse getLifecyclePolicy(GetLifecyclePolicyRequest getLifecyclePolicyRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetLifecyclePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetLifecyclePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getLifecyclePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLifecyclePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLifecyclePolicy");

            return clientHandler.execute(new ClientExecutionParams<GetLifecyclePolicyRequest, GetLifecyclePolicyResponse>()
                    .withOperationName("GetLifecyclePolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getLifecyclePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetLifecyclePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Verify the subscription and perform resource dependency checks on the requested Amazon Web Services Marketplace
     * resource. For Amazon Web Services Marketplace components, the response contains fields to download the components
     * and their artifacts.
     * </p>
     *
     * @param getMarketplaceResourceRequest
     * @return Result of the GetMarketplaceResource operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetMarketplaceResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetMarketplaceResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetMarketplaceResourceResponse getMarketplaceResource(GetMarketplaceResourceRequest getMarketplaceResourceRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMarketplaceResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetMarketplaceResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMarketplaceResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMarketplaceResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMarketplaceResource");

            return clientHandler
                    .execute(new ClientExecutionParams<GetMarketplaceResourceRequest, GetMarketplaceResourceResponse>()
                            .withOperationName("GetMarketplaceResource").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getMarketplaceResourceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetMarketplaceResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get a workflow resource object.
     * </p>
     *
     * @param getWorkflowRequest
     * @return Result of the GetWorkflow operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetWorkflowResponse getWorkflow(GetWorkflowRequest getWorkflowRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, ForbiddenException, CallRateLimitExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetWorkflowResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWorkflowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWorkflowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWorkflow");

            return clientHandler.execute(new ClientExecutionParams<GetWorkflowRequest, GetWorkflowResponse>()
                    .withOperationName("GetWorkflow").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getWorkflowRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetWorkflowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get the runtime information that was logged for a specific runtime instance of the workflow.
     * </p>
     *
     * @param getWorkflowExecutionRequest
     * @return Result of the GetWorkflowExecution operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetWorkflowExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetWorkflowExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetWorkflowExecutionResponse getWorkflowExecution(GetWorkflowExecutionRequest getWorkflowExecutionRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetWorkflowExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetWorkflowExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWorkflowExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWorkflowExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWorkflowExecution");

            return clientHandler.execute(new ClientExecutionParams<GetWorkflowExecutionRequest, GetWorkflowExecutionResponse>()
                    .withOperationName("GetWorkflowExecution").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getWorkflowExecutionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetWorkflowExecutionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get the runtime information that was logged for a specific runtime instance of the workflow step.
     * </p>
     *
     * @param getWorkflowStepExecutionRequest
     * @return Result of the GetWorkflowStepExecution operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.GetWorkflowStepExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetWorkflowStepExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetWorkflowStepExecutionResponse getWorkflowStepExecution(
            GetWorkflowStepExecutionRequest getWorkflowStepExecutionRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, ForbiddenException, CallRateLimitExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetWorkflowStepExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetWorkflowStepExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWorkflowStepExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWorkflowStepExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWorkflowStepExecution");

            return clientHandler
                    .execute(new ClientExecutionParams<GetWorkflowStepExecutionRequest, GetWorkflowStepExecutionResponse>()
                            .withOperationName("GetWorkflowStepExecution").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getWorkflowStepExecutionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetWorkflowStepExecutionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Imports a component and transforms its data into a component document.
     * </p>
     *
     * @param importComponentRequest
     * @return Result of the ImportComponent operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws InvalidVersionNumberException
     *         Your version number is out of bounds or does not follow the required syntax.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws InvalidParameterCombinationException
     *         You have specified two or more mutually exclusive parameters. Review the error message for details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ImportComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ImportComponent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ImportComponentResponse importComponent(ImportComponentRequest importComponentRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, IdempotentParameterMismatchException,
            ForbiddenException, CallRateLimitExceededException, InvalidVersionNumberException, ResourceInUseException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ImportComponentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ImportComponentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(importComponentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportComponent");

            return clientHandler.execute(new ClientExecutionParams<ImportComponentRequest, ImportComponentResponse>()
                    .withOperationName("ImportComponent").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(importComponentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ImportComponentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Import a Windows operating system image from a verified Microsoft ISO disk file. The following disk images are
     * supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Windows 11 Enterprise
     * </p>
     * </li>
     * </ul>
     *
     * @param importDiskImageRequest
     * @return Result of the ImportDiskImage operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ImportDiskImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ImportDiskImage" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ImportDiskImageResponse importDiskImage(ImportDiskImageRequest importDiskImageRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ImportDiskImageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ImportDiskImageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(importDiskImageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importDiskImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportDiskImage");

            return clientHandler.execute(new ClientExecutionParams<ImportDiskImageRequest, ImportDiskImageResponse>()
                    .withOperationName("ImportDiskImage").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(importDiskImageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ImportDiskImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * When you export your virtual machine (VM) from its virtualization environment, that process creates a set of one
     * or more disk container files that act as snapshots of your VM’s environment, settings, and data. The Amazon EC2
     * API <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportImage.html">ImportImage</a> action
     * uses those files to import your VM and create an AMI. To import using the CLI command, see <a
     * href="https://docs.aws.amazon.com/cli/latest/reference/ec2/import-image.html">import-image</a>
     * </p>
     * <p>
     * You can reference the task ID from the VM import to pull in the AMI that the import created as the base image for
     * your Image Builder recipe.
     * </p>
     *
     * @param importVmImageRequest
     * @return Result of the ImportVmImage operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ImportVmImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ImportVmImage" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ImportVmImageResponse importVmImage(ImportVmImageRequest importVmImageRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ImportVmImageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ImportVmImageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(importVmImageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importVmImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportVmImage");

            return clientHandler.execute(new ClientExecutionParams<ImportVmImageRequest, ImportVmImageResponse>()
                    .withOperationName("ImportVmImage").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(importVmImageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ImportVmImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the list of component build versions for the specified component version Amazon Resource Name (ARN).
     * </p>
     *
     * @param listComponentBuildVersionsRequest
     * @return Result of the ListComponentBuildVersions operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListComponentBuildVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListComponentBuildVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListComponentBuildVersionsResponse listComponentBuildVersions(
            ListComponentBuildVersionsRequest listComponentBuildVersionsRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListComponentBuildVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListComponentBuildVersionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listComponentBuildVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listComponentBuildVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListComponentBuildVersions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListComponentBuildVersionsRequest, ListComponentBuildVersionsResponse>()
                            .withOperationName("ListComponentBuildVersions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listComponentBuildVersionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListComponentBuildVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the list of components that can be filtered by name, or by using the listed <code>filters</code> to
     * streamline results. Newly created components can take up to two minutes to appear in the ListComponents API
     * Results.
     * </p>
     * <note>
     * <p>
     * The semantic version has four nodes: &lt;major&gt;.&lt;minor&gt;.&lt;patch&gt;/&lt;build&gt;. You can assign
     * values for the first three, and can filter on all of them.
     * </p>
     * <p>
     * <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most
     * recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in
     * any node, all nodes to the right of the first wildcard must also be wildcards.
     * </p>
     * </note>
     *
     * @param listComponentsRequest
     * @return Result of the ListComponents operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListComponents" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListComponentsResponse listComponents(ListComponentsRequest listComponentsRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListComponentsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListComponentsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listComponentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listComponentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListComponents");

            return clientHandler.execute(new ClientExecutionParams<ListComponentsRequest, ListComponentsResponse>()
                    .withOperationName("ListComponents").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listComponentsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListComponentsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of container recipes.
     * </p>
     *
     * @param listContainerRecipesRequest
     * @return Result of the ListContainerRecipes operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListContainerRecipes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListContainerRecipes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListContainerRecipesResponse listContainerRecipes(ListContainerRecipesRequest listContainerRecipesRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListContainerRecipesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListContainerRecipesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listContainerRecipesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listContainerRecipesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListContainerRecipes");

            return clientHandler.execute(new ClientExecutionParams<ListContainerRecipesRequest, ListContainerRecipesResponse>()
                    .withOperationName("ListContainerRecipes").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listContainerRecipesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListContainerRecipesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of distribution configurations.
     * </p>
     *
     * @param listDistributionConfigurationsRequest
     * @return Result of the ListDistributionConfigurations operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListDistributionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListDistributionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDistributionConfigurationsResponse listDistributionConfigurations(
            ListDistributionConfigurationsRequest listDistributionConfigurationsRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDistributionConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListDistributionConfigurationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDistributionConfigurationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listDistributionConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDistributionConfigurations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListDistributionConfigurationsRequest, ListDistributionConfigurationsResponse>()
                            .withOperationName("ListDistributionConfigurations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listDistributionConfigurationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListDistributionConfigurationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of image build versions.
     * </p>
     *
     * @param listImageBuildVersionsRequest
     * @return Result of the ListImageBuildVersions operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImageBuildVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageBuildVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListImageBuildVersionsResponse listImageBuildVersions(ListImageBuildVersionsRequest listImageBuildVersionsRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListImageBuildVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListImageBuildVersionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listImageBuildVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImageBuildVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImageBuildVersions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListImageBuildVersionsRequest, ListImageBuildVersionsResponse>()
                            .withOperationName("ListImageBuildVersions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listImageBuildVersionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListImageBuildVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List the Packages that are associated with an Image Build Version, as determined by Amazon Web Services Systems
     * Manager Inventory at build time.
     * </p>
     *
     * @param listImagePackagesRequest
     * @return Result of the ListImagePackages operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImagePackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePackages"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListImagePackagesResponse listImagePackages(ListImagePackagesRequest listImagePackagesRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ResourceNotFoundException, ForbiddenException, CallRateLimitExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListImagePackagesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListImagePackagesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listImagePackagesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImagePackagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImagePackages");

            return clientHandler.execute(new ClientExecutionParams<ListImagePackagesRequest, ListImagePackagesResponse>()
                    .withOperationName("ListImagePackages").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listImagePackagesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListImagePackagesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of images created by the specified pipeline.
     * </p>
     *
     * @param listImagePipelineImagesRequest
     * @return Result of the ListImagePipelineImages operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImagePipelineImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePipelineImages"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListImagePipelineImagesResponse listImagePipelineImages(ListImagePipelineImagesRequest listImagePipelineImagesRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ResourceNotFoundException, ForbiddenException, CallRateLimitExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListImagePipelineImagesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListImagePipelineImagesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listImagePipelineImagesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImagePipelineImagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImagePipelineImages");

            return clientHandler
                    .execute(new ClientExecutionParams<ListImagePipelineImagesRequest, ListImagePipelineImagesResponse>()
                            .withOperationName("ListImagePipelineImages").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listImagePipelineImagesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListImagePipelineImagesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of image pipelines.
     * </p>
     *
     * @param listImagePipelinesRequest
     * @return Result of the ListImagePipelines operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImagePipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImagePipelines"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListImagePipelinesResponse listImagePipelines(ListImagePipelinesRequest listImagePipelinesRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListImagePipelinesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListImagePipelinesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listImagePipelinesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImagePipelinesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImagePipelines");

            return clientHandler.execute(new ClientExecutionParams<ListImagePipelinesRequest, ListImagePipelinesResponse>()
                    .withOperationName("ListImagePipelines").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listImagePipelinesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListImagePipelinesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of image recipes.
     * </p>
     *
     * @param listImageRecipesRequest
     * @return Result of the ListImageRecipes operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImageRecipes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageRecipes" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListImageRecipesResponse listImageRecipes(ListImageRecipesRequest listImageRecipesRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListImageRecipesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListImageRecipesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listImageRecipesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImageRecipesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImageRecipes");

            return clientHandler.execute(new ClientExecutionParams<ListImageRecipesRequest, ListImageRecipesResponse>()
                    .withOperationName("ListImageRecipes").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listImageRecipesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListImageRecipesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of image scan aggregations for your account. You can filter by the type of key that Image Builder
     * uses to group results. For example, if you want to get a list of findings by severity level for one of your
     * pipelines, you might specify your pipeline with the <code>imagePipelineArn</code> filter. If you don't specify a
     * filter, Image Builder returns an aggregation for your account.
     * </p>
     * <p>
     * To streamline results, you can use the following filters in your request:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>accountId</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>imageBuildVersionArn</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>imagePipelineArn</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vulnerabilityId</code>
     * </p>
     * </li>
     * </ul>
     *
     * @param listImageScanFindingAggregationsRequest
     * @return Result of the ListImageScanFindingAggregations operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImageScanFindingAggregations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageScanFindingAggregations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListImageScanFindingAggregationsResponse listImageScanFindingAggregations(
            ListImageScanFindingAggregationsRequest listImageScanFindingAggregationsRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListImageScanFindingAggregationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListImageScanFindingAggregationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listImageScanFindingAggregationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listImageScanFindingAggregationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImageScanFindingAggregations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListImageScanFindingAggregationsRequest, ListImageScanFindingAggregationsResponse>()
                            .withOperationName("ListImageScanFindingAggregations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listImageScanFindingAggregationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListImageScanFindingAggregationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of image scan findings for your account.
     * </p>
     *
     * @param listImageScanFindingsRequest
     * @return Result of the ListImageScanFindings operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImageScanFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageScanFindings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListImageScanFindingsResponse listImageScanFindings(ListImageScanFindingsRequest listImageScanFindingsRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListImageScanFindingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListImageScanFindingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listImageScanFindingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImageScanFindingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImageScanFindings");

            return clientHandler.execute(new ClientExecutionParams<ListImageScanFindingsRequest, ListImageScanFindingsResponse>()
                    .withOperationName("ListImageScanFindings").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listImageScanFindingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListImageScanFindingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the list of images that you have access to. Newly created images can take up to two minutes to appear in
     * the ListImages API Results.
     * </p>
     *
     * @param listImagesRequest
     * @return Result of the ListImages operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImages" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListImagesResponse listImages(ListImagesRequest listImagesRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListImagesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListImagesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listImagesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImages");

            return clientHandler.execute(new ClientExecutionParams<ListImagesRequest, ListImagesResponse>()
                    .withOperationName("ListImages").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listImagesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListImagesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of infrastructure configurations.
     * </p>
     *
     * @param listInfrastructureConfigurationsRequest
     * @return Result of the ListInfrastructureConfigurations operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListInfrastructureConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListInfrastructureConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListInfrastructureConfigurationsResponse listInfrastructureConfigurations(
            ListInfrastructureConfigurationsRequest listInfrastructureConfigurationsRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListInfrastructureConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListInfrastructureConfigurationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listInfrastructureConfigurationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listInfrastructureConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListInfrastructureConfigurations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListInfrastructureConfigurationsRequest, ListInfrastructureConfigurationsResponse>()
                            .withOperationName("ListInfrastructureConfigurations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listInfrastructureConfigurationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListInfrastructureConfigurationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List resources that the runtime instance of the image lifecycle identified for lifecycle actions.
     * </p>
     *
     * @param listLifecycleExecutionResourcesRequest
     * @return Result of the ListLifecycleExecutionResources operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListLifecycleExecutionResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListLifecycleExecutionResources"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListLifecycleExecutionResourcesResponse listLifecycleExecutionResources(
            ListLifecycleExecutionResourcesRequest listLifecycleExecutionResourcesRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListLifecycleExecutionResourcesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListLifecycleExecutionResourcesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listLifecycleExecutionResourcesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listLifecycleExecutionResourcesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLifecycleExecutionResources");

            return clientHandler
                    .execute(new ClientExecutionParams<ListLifecycleExecutionResourcesRequest, ListLifecycleExecutionResourcesResponse>()
                            .withOperationName("ListLifecycleExecutionResources").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listLifecycleExecutionResourcesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListLifecycleExecutionResourcesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get the lifecycle runtime history for the specified resource.
     * </p>
     *
     * @param listLifecycleExecutionsRequest
     * @return Result of the ListLifecycleExecutions operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListLifecycleExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListLifecycleExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListLifecycleExecutionsResponse listLifecycleExecutions(ListLifecycleExecutionsRequest listLifecycleExecutionsRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListLifecycleExecutionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListLifecycleExecutionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listLifecycleExecutionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLifecycleExecutionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLifecycleExecutions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListLifecycleExecutionsRequest, ListLifecycleExecutionsResponse>()
                            .withOperationName("ListLifecycleExecutions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listLifecycleExecutionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListLifecycleExecutionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get a list of lifecycle policies in your Amazon Web Services account.
     * </p>
     *
     * @param listLifecyclePoliciesRequest
     * @return Result of the ListLifecyclePolicies operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListLifecyclePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListLifecyclePolicies"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListLifecyclePoliciesResponse listLifecyclePolicies(ListLifecyclePoliciesRequest listLifecyclePoliciesRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListLifecyclePoliciesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListLifecyclePoliciesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listLifecyclePoliciesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLifecyclePoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLifecyclePolicies");

            return clientHandler.execute(new ClientExecutionParams<ListLifecyclePoliciesRequest, ListLifecyclePoliciesResponse>()
                    .withOperationName("ListLifecyclePolicies").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listLifecyclePoliciesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListLifecyclePoliciesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the list of tags for the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ServiceException, InvalidParameterException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get a list of workflow steps that are waiting for action for workflows in your Amazon Web Services account.
     * </p>
     *
     * @param listWaitingWorkflowStepsRequest
     * @return Result of the ListWaitingWorkflowSteps operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListWaitingWorkflowSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListWaitingWorkflowSteps"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListWaitingWorkflowStepsResponse listWaitingWorkflowSteps(
            ListWaitingWorkflowStepsRequest listWaitingWorkflowStepsRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListWaitingWorkflowStepsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListWaitingWorkflowStepsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWaitingWorkflowStepsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWaitingWorkflowStepsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWaitingWorkflowSteps");

            return clientHandler
                    .execute(new ClientExecutionParams<ListWaitingWorkflowStepsRequest, ListWaitingWorkflowStepsResponse>()
                            .withOperationName("ListWaitingWorkflowSteps").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listWaitingWorkflowStepsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListWaitingWorkflowStepsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of build versions for a specific workflow resource.
     * </p>
     *
     * @param listWorkflowBuildVersionsRequest
     * @return Result of the ListWorkflowBuildVersions operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListWorkflowBuildVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListWorkflowBuildVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListWorkflowBuildVersionsResponse listWorkflowBuildVersions(
            ListWorkflowBuildVersionsRequest listWorkflowBuildVersionsRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListWorkflowBuildVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListWorkflowBuildVersionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWorkflowBuildVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWorkflowBuildVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWorkflowBuildVersions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListWorkflowBuildVersionsRequest, ListWorkflowBuildVersionsResponse>()
                            .withOperationName("ListWorkflowBuildVersions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listWorkflowBuildVersionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListWorkflowBuildVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of workflow runtime instance metadata objects for a specific image build version.
     * </p>
     *
     * @param listWorkflowExecutionsRequest
     * @return Result of the ListWorkflowExecutions operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListWorkflowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListWorkflowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListWorkflowExecutionsResponse listWorkflowExecutions(ListWorkflowExecutionsRequest listWorkflowExecutionsRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidPaginationTokenException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListWorkflowExecutionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListWorkflowExecutionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWorkflowExecutionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWorkflowExecutionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWorkflowExecutions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListWorkflowExecutionsRequest, ListWorkflowExecutionsResponse>()
                            .withOperationName("ListWorkflowExecutions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listWorkflowExecutionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListWorkflowExecutionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns runtime data for each step in a runtime instance of the workflow that you specify in the request.
     * </p>
     *
     * @param listWorkflowStepExecutionsRequest
     * @return Result of the ListWorkflowStepExecutions operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListWorkflowStepExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListWorkflowStepExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListWorkflowStepExecutionsResponse listWorkflowStepExecutions(
            ListWorkflowStepExecutionsRequest listWorkflowStepExecutionsRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException, ForbiddenException,
            CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListWorkflowStepExecutionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListWorkflowStepExecutionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWorkflowStepExecutionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWorkflowStepExecutionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWorkflowStepExecutions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListWorkflowStepExecutionsRequest, ListWorkflowStepExecutionsResponse>()
                            .withOperationName("ListWorkflowStepExecutions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listWorkflowStepExecutionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListWorkflowStepExecutionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists workflow build versions based on filtering parameters.
     * </p>
     *
     * @param listWorkflowsRequest
     * @return Result of the ListWorkflows operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidPaginationTokenException
     *         You have provided an invalid pagination token in your request.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.ListWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListWorkflows" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListWorkflowsResponse listWorkflows(ListWorkflowsRequest listWorkflowsRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidPaginationTokenException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListWorkflowsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListWorkflowsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWorkflowsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWorkflowsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWorkflows");

            return clientHandler.execute(new ClientExecutionParams<ListWorkflowsRequest, ListWorkflowsResponse>()
                    .withOperationName("ListWorkflows").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listWorkflowsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListWorkflowsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Applies a policy to a component. We recommend that you call the RAM API <a
     * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare</a>
     * to share resources. If you call the Image Builder API <code>PutComponentPolicy</code>, you must also call the RAM
     * API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html">
     * PromoteResourceShareCreatedFromPolicy</a> in order for the resource to be visible to all principals with whom the
     * resource is shared.
     * </p>
     *
     * @param putComponentPolicyRequest
     * @return Result of the PutComponentPolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidParameterValueException
     *         The value that you provided for the specified parameter is invalid.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.PutComponentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutComponentPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutComponentPolicyResponse putComponentPolicy(PutComponentPolicyRequest putComponentPolicyRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidParameterValueException, ResourceNotFoundException, ForbiddenException, CallRateLimitExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutComponentPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutComponentPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putComponentPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putComponentPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutComponentPolicy");

            return clientHandler.execute(new ClientExecutionParams<PutComponentPolicyRequest, PutComponentPolicyResponse>()
                    .withOperationName("PutComponentPolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(putComponentPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutComponentPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Applies a policy to a container image. We recommend that you call the RAM API CreateResourceShare
     * (https://docs.aws.amazon.com//ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you
     * call the Image Builder API <code>PutContainerImagePolicy</code>, you must also call the RAM API
     * PromoteResourceShareCreatedFromPolicy
     * (https://docs.aws.amazon.com//ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order
     * for the resource to be visible to all principals with whom the resource is shared.
     * </p>
     *
     * @param putContainerRecipePolicyRequest
     * @return Result of the PutContainerRecipePolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidParameterValueException
     *         The value that you provided for the specified parameter is invalid.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.PutContainerRecipePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutContainerRecipePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutContainerRecipePolicyResponse putContainerRecipePolicy(
            PutContainerRecipePolicyRequest putContainerRecipePolicyRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, InvalidParameterValueException, ResourceNotFoundException,
            ForbiddenException, CallRateLimitExceededException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutContainerRecipePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutContainerRecipePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putContainerRecipePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putContainerRecipePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutContainerRecipePolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<PutContainerRecipePolicyRequest, PutContainerRecipePolicyResponse>()
                            .withOperationName("PutContainerRecipePolicy").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(putContainerRecipePolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutContainerRecipePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Applies a policy to an image. We recommend that you call the RAM API <a
     * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare</a>
     * to share resources. If you call the Image Builder API <code>PutImagePolicy</code>, you must also call the RAM API
     * <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html">
     * PromoteResourceShareCreatedFromPolicy</a> in order for the resource to be visible to all principals with whom the
     * resource is shared.
     * </p>
     *
     * @param putImagePolicyRequest
     * @return Result of the PutImagePolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidParameterValueException
     *         The value that you provided for the specified parameter is invalid.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.PutImagePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutImagePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public PutImagePolicyResponse putImagePolicy(PutImagePolicyRequest putImagePolicyRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, InvalidParameterValueException,
            ResourceNotFoundException, ForbiddenException, CallRateLimitExceededException, AwsServiceException,
            SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutImagePolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutImagePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putImagePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putImagePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutImagePolicy");

            return clientHandler.execute(new ClientExecutionParams<PutImagePolicyRequest, PutImagePolicyResponse>()
                    .withOperationName("PutImagePolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(putImagePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutImagePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Applies a policy to an image recipe. We recommend that you call the RAM API <a
     * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare</a>
     * to share resources. If you call the Image Builder API <code>PutImageRecipePolicy</code>, you must also call the
     * RAM API <a
     * href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html"
     * >PromoteResourceShareCreatedFromPolicy</a> in order for the resource to be visible to all principals with whom
     * the resource is shared.
     * </p>
     *
     * @param putImageRecipePolicyRequest
     * @return Result of the PutImageRecipePolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidParameterValueException
     *         The value that you provided for the specified parameter is invalid.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.PutImageRecipePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutImageRecipePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutImageRecipePolicyResponse putImageRecipePolicy(PutImageRecipePolicyRequest putImageRecipePolicyRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            InvalidParameterValueException, ResourceNotFoundException, ForbiddenException, CallRateLimitExceededException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutImageRecipePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutImageRecipePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putImageRecipePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putImageRecipePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutImageRecipePolicy");

            return clientHandler.execute(new ClientExecutionParams<PutImageRecipePolicyRequest, PutImageRecipePolicyResponse>()
                    .withOperationName("PutImageRecipePolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(putImageRecipePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutImageRecipePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Pauses or resumes image creation when the associated workflow runs a <code>WaitForAction</code> step.
     * </p>
     *
     * @param sendWorkflowStepActionRequest
     * @return Result of the SendWorkflowStepAction operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws InvalidParameterValueException
     *         The value that you provided for the specified parameter is invalid.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.SendWorkflowStepAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/SendWorkflowStepAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SendWorkflowStepActionResponse sendWorkflowStepAction(SendWorkflowStepActionRequest sendWorkflowStepActionRequest)
            throws ServiceException, ClientException, ResourceNotFoundException, InvalidRequestException,
            InvalidParameterValueException, ServiceUnavailableException, IdempotentParameterMismatchException,
            ForbiddenException, CallRateLimitExceededException, ResourceInUseException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SendWorkflowStepActionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, SendWorkflowStepActionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(sendWorkflowStepActionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, sendWorkflowStepActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SendWorkflowStepAction");

            return clientHandler
                    .execute(new ClientExecutionParams<SendWorkflowStepActionRequest, SendWorkflowStepActionResponse>()
                            .withOperationName("SendWorkflowStepAction").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(sendWorkflowStepActionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new SendWorkflowStepActionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Manually triggers a pipeline to create an image.
     * </p>
     *
     * @param startImagePipelineExecutionRequest
     * @return Result of the StartImagePipelineExecution operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.StartImagePipelineExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/StartImagePipelineExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartImagePipelineExecutionResponse startImagePipelineExecution(
            StartImagePipelineExecutionRequest startImagePipelineExecutionRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, ResourceNotFoundException,
            IdempotentParameterMismatchException, ForbiddenException, CallRateLimitExceededException, ResourceInUseException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartImagePipelineExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartImagePipelineExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startImagePipelineExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startImagePipelineExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartImagePipelineExecution");

            return clientHandler
                    .execute(new ClientExecutionParams<StartImagePipelineExecutionRequest, StartImagePipelineExecutionResponse>()
                            .withOperationName("StartImagePipelineExecution").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(startImagePipelineExecutionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartImagePipelineExecutionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Begin asynchronous resource state update for lifecycle changes to the specified image resources.
     * </p>
     *
     * @param startResourceStateUpdateRequest
     * @return Result of the StartResourceStateUpdate operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.StartResourceStateUpdate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/StartResourceStateUpdate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartResourceStateUpdateResponse startResourceStateUpdate(
            StartResourceStateUpdateRequest startResourceStateUpdateRequest) throws ServiceException, ClientException,
            ServiceUnavailableException, InvalidRequestException, ResourceNotFoundException,
            IdempotentParameterMismatchException, ForbiddenException, CallRateLimitExceededException, ResourceInUseException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartResourceStateUpdateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartResourceStateUpdateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startResourceStateUpdateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startResourceStateUpdateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartResourceStateUpdate");

            return clientHandler
                    .execute(new ClientExecutionParams<StartResourceStateUpdateRequest, StartResourceStateUpdateResponse>()
                            .withOperationName("StartResourceStateUpdate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(startResourceStateUpdateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartResourceStateUpdateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds a tag to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServiceException,
            InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a tag from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ResourceNotFoundException
     *         At least one of the resources referenced by your request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ServiceException,
            InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a new distribution configuration. Distribution configurations define and configure the outputs of your
     * pipeline.
     * </p>
     *
     * @param updateDistributionConfigurationRequest
     * @return Result of the UpdateDistributionConfiguration operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws InvalidParameterCombinationException
     *         You have specified two or more mutually exclusive parameters. Review the error message for details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.UpdateDistributionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UpdateDistributionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateDistributionConfigurationResponse updateDistributionConfiguration(
            UpdateDistributionConfigurationRequest updateDistributionConfigurationRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, IdempotentParameterMismatchException,
            ForbiddenException, CallRateLimitExceededException, ResourceInUseException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDistributionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateDistributionConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDistributionConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateDistributionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDistributionConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateDistributionConfigurationRequest, UpdateDistributionConfigurationResponse>()
                            .withOperationName("UpdateDistributionConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateDistributionConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateDistributionConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an image pipeline. Image pipelines enable you to automate the creation and distribution of images. You
     * must specify exactly one recipe for your image, using either a <code>containerRecipeArn</code> or an
     * <code>imageRecipeArn</code>.
     * </p>
     * <note>
     * <p>
     * UpdateImagePipeline does not support selective updates for the pipeline. You must specify all of the required
     * properties in the update request, not just the properties that have changed.
     * </p>
     * </note>
     *
     * @param updateImagePipelineRequest
     * @return Result of the UpdateImagePipeline operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.UpdateImagePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UpdateImagePipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateImagePipelineResponse updateImagePipeline(UpdateImagePipelineRequest updateImagePipelineRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            IdempotentParameterMismatchException, ForbiddenException, CallRateLimitExceededException, ResourceInUseException,
            AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateImagePipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateImagePipelineResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateImagePipelineRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateImagePipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateImagePipeline");

            return clientHandler.execute(new ClientExecutionParams<UpdateImagePipelineRequest, UpdateImagePipelineResponse>()
                    .withOperationName("UpdateImagePipeline").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateImagePipelineRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateImagePipelineRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a new infrastructure configuration. An infrastructure configuration defines the environment in which your
     * image will be built and tested.
     * </p>
     *
     * @param updateInfrastructureConfigurationRequest
     * @return Result of the UpdateInfrastructureConfiguration operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.UpdateInfrastructureConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UpdateInfrastructureConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateInfrastructureConfigurationResponse updateInfrastructureConfiguration(
            UpdateInfrastructureConfigurationRequest updateInfrastructureConfigurationRequest) throws ServiceException,
            ClientException, ServiceUnavailableException, InvalidRequestException, IdempotentParameterMismatchException,
            ForbiddenException, CallRateLimitExceededException, ResourceInUseException, AwsServiceException, SdkClientException,
            ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateInfrastructureConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateInfrastructureConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateInfrastructureConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateInfrastructureConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateInfrastructureConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateInfrastructureConfigurationRequest, UpdateInfrastructureConfigurationResponse>()
                            .withOperationName("UpdateInfrastructureConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateInfrastructureConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateInfrastructureConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update the specified lifecycle policy.
     * </p>
     *
     * @param updateLifecyclePolicyRequest
     * @return Result of the UpdateLifecyclePolicy operation returned by the service.
     * @throws ServiceException
     *         This exception is thrown when the service encounters an unrecoverable exception.
     * @throws ClientException
     *         These errors are usually caused by a client action, such as using an action or resource on behalf of a
     *         user that doesn't have permissions to use the action or resource, or specifying an invalid resource
     *         identifier.
     * @throws ServiceUnavailableException
     *         The service is unable to process your request at this time.
     * @throws InvalidRequestException
     *         You have requested an action that that the service doesn't support.
     * @throws IdempotentParameterMismatchException
     *         You have specified a client token for an operation using parameter values that differ from a previous
     *         request that used the same client token.
     * @throws ForbiddenException
     *         You are not authorized to perform the requested operation.
     * @throws CallRateLimitExceededException
     *         You have exceeded the permitted request rate for the specific operation.
     * @throws ResourceInUseException
     *         The resource that you are trying to operate on is currently in use. Review the message details and retry
     *         later.
     * @throws InvalidParameterCombinationException
     *         You have specified two or more mutually exclusive parameters. Review the error message for details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ImagebuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ImagebuilderClient.UpdateLifecyclePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/UpdateLifecyclePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateLifecyclePolicyResponse updateLifecyclePolicy(UpdateLifecyclePolicyRequest updateLifecyclePolicyRequest)
            throws ServiceException, ClientException, ServiceUnavailableException, InvalidRequestException,
            IdempotentParameterMismatchException, ForbiddenException, CallRateLimitExceededException, ResourceInUseException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, ImagebuilderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateLifecyclePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateLifecyclePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidVersionNumberException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidVersionNumberException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidVersionNumberException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IdempotentParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "ForbiddenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(403)
                        .exceptionBuilderSupplier(ForbiddenException::builder).build());
            case "ResourceDependencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDependencyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDependencyException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidPaginationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "CallRateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CallRateLimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(CallRateLimitExceededException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateLifecyclePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateLifecyclePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "imagebuilder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateLifecyclePolicy");

            return clientHandler.execute(new ClientExecutionParams<UpdateLifecyclePolicyRequest, UpdateLifecyclePolicyResponse>()
                    .withOperationName("UpdateLifecyclePolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateLifecyclePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateLifecyclePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        ImagebuilderServiceClientConfigurationBuilder serviceConfigBuilder = new ImagebuilderServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder.clientConfiguration(clientConfiguration).defaultServiceExceptionSupplier(ImagebuilderException::builder)
                .protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final ImagebuilderServiceClientConfiguration serviceClientConfiguration() {
        return new ImagebuilderServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
