/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the rules by which an image pipeline is automatically disabled when it fails.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoDisablePolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoDisablePolicy.Builder, AutoDisablePolicy> {
    private static final SdkField<Integer> FAILURE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("failureCount").getter(getter(AutoDisablePolicy::failureCount)).setter(setter(Builder::failureCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURE_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer failureCount;

    private AutoDisablePolicy(BuilderImpl builder) {
        this.failureCount = builder.failureCount;
    }

    /**
     * <p>
     * The number of consecutive scheduled image pipeline executions that must fail before Image Builder automatically
     * disables the pipeline.
     * </p>
     * 
     * @return The number of consecutive scheduled image pipeline executions that must fail before Image Builder
     *         automatically disables the pipeline.
     */
    public final Integer failureCount() {
        return failureCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failureCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoDisablePolicy)) {
            return false;
        }
        AutoDisablePolicy other = (AutoDisablePolicy) obj;
        return Objects.equals(failureCount(), other.failureCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoDisablePolicy").add("FailureCount", failureCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "failureCount":
            return Optional.ofNullable(clazz.cast(failureCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("failureCount", FAILURE_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoDisablePolicy, T> g) {
        return obj -> g.apply((AutoDisablePolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoDisablePolicy> {
        /**
         * <p>
         * The number of consecutive scheduled image pipeline executions that must fail before Image Builder
         * automatically disables the pipeline.
         * </p>
         * 
         * @param failureCount
         *        The number of consecutive scheduled image pipeline executions that must fail before Image Builder
         *        automatically disables the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureCount(Integer failureCount);
    }

    static final class BuilderImpl implements Builder {
        private Integer failureCount;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoDisablePolicy model) {
            failureCount(model.failureCount);
        }

        public final Integer getFailureCount() {
            return failureCount;
        }

        public final void setFailureCount(Integer failureCount) {
            this.failureCount = failureCount;
        }

        @Override
        public final Builder failureCount(Integer failureCount) {
            this.failureCount = failureCount;
            return this;
        }

        @Override
        public AutoDisablePolicy build() {
            return new AutoDisablePolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
