/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container encapsulates the runtime environment for an application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Container implements SdkPojo, Serializable, ToCopyableBuilder<Container.Builder, Container> {
    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(Container::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<List<String>> IMAGE_URIS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("imageUris")
            .getter(getter(Container::imageUris))
            .setter(setter(Builder::imageUris))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageUris").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(REGION_FIELD, IMAGE_URIS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String region;

    private final List<String> imageUris;

    private Container(BuilderImpl builder) {
        this.region = builder.region;
        this.imageUris = builder.imageUris;
    }

    /**
     * <p>
     * Containers and container images are Region-specific. This is the Region context for the container.
     * </p>
     * 
     * @return Containers and container images are Region-specific. This is the Region context for the container.
     */
    public final String region() {
        return region;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImageUris property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasImageUris() {
        return imageUris != null && !(imageUris instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of URIs for containers created in the context Region.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImageUris} method.
     * </p>
     * 
     * @return A list of URIs for containers created in the context Region.
     */
    public final List<String> imageUris() {
        return imageUris;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(hasImageUris() ? imageUris() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Container)) {
            return false;
        }
        Container other = (Container) obj;
        return Objects.equals(region(), other.region()) && hasImageUris() == other.hasImageUris()
                && Objects.equals(imageUris(), other.imageUris());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Container").add("Region", region()).add("ImageUris", hasImageUris() ? imageUris() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "imageUris":
            return Optional.ofNullable(clazz.cast(imageUris()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("region", REGION_FIELD);
        map.put("imageUris", IMAGE_URIS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Container, T> g) {
        return obj -> g.apply((Container) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Container> {
        /**
         * <p>
         * Containers and container images are Region-specific. This is the Region context for the container.
         * </p>
         * 
         * @param region
         *        Containers and container images are Region-specific. This is the Region context for the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * A list of URIs for containers created in the context Region.
         * </p>
         * 
         * @param imageUris
         *        A list of URIs for containers created in the context Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageUris(Collection<String> imageUris);

        /**
         * <p>
         * A list of URIs for containers created in the context Region.
         * </p>
         * 
         * @param imageUris
         *        A list of URIs for containers created in the context Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageUris(String... imageUris);
    }

    static final class BuilderImpl implements Builder {
        private String region;

        private List<String> imageUris = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Container model) {
            region(model.region);
            imageUris(model.imageUris);
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final Collection<String> getImageUris() {
            if (imageUris instanceof SdkAutoConstructList) {
                return null;
            }
            return imageUris;
        }

        public final void setImageUris(Collection<String> imageUris) {
            this.imageUris = StringListCopier.copy(imageUris);
        }

        @Override
        public final Builder imageUris(Collection<String> imageUris) {
            this.imageUris = StringListCopier.copy(imageUris);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageUris(String... imageUris) {
            imageUris(Arrays.asList(imageUris));
            return this;
        }

        @Override
        public Container build() {
            return new Container(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
