/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Define and configure faster launching for output Windows AMIs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FastLaunchConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FastLaunchConfiguration.Builder, FastLaunchConfiguration> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(FastLaunchConfiguration::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<FastLaunchSnapshotConfiguration> SNAPSHOT_CONFIGURATION_FIELD = SdkField
            .<FastLaunchSnapshotConfiguration> builder(MarshallingType.SDK_POJO).memberName("snapshotConfiguration")
            .getter(getter(FastLaunchConfiguration::snapshotConfiguration)).setter(setter(Builder::snapshotConfiguration))
            .constructor(FastLaunchSnapshotConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotConfiguration").build())
            .build();

    private static final SdkField<Integer> MAX_PARALLEL_LAUNCHES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxParallelLaunches").getter(getter(FastLaunchConfiguration::maxParallelLaunches))
            .setter(setter(Builder::maxParallelLaunches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxParallelLaunches").build())
            .build();

    private static final SdkField<FastLaunchLaunchTemplateSpecification> LAUNCH_TEMPLATE_FIELD = SdkField
            .<FastLaunchLaunchTemplateSpecification> builder(MarshallingType.SDK_POJO).memberName("launchTemplate")
            .getter(getter(FastLaunchConfiguration::launchTemplate)).setter(setter(Builder::launchTemplate))
            .constructor(FastLaunchLaunchTemplateSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchTemplate").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(FastLaunchConfiguration::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            SNAPSHOT_CONFIGURATION_FIELD, MAX_PARALLEL_LAUNCHES_FIELD, LAUNCH_TEMPLATE_FIELD, ACCOUNT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final FastLaunchSnapshotConfiguration snapshotConfiguration;

    private final Integer maxParallelLaunches;

    private final FastLaunchLaunchTemplateSpecification launchTemplate;

    private final String accountId;

    private FastLaunchConfiguration(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.snapshotConfiguration = builder.snapshotConfiguration;
        this.maxParallelLaunches = builder.maxParallelLaunches;
        this.launchTemplate = builder.launchTemplate;
        this.accountId = builder.accountId;
    }

    /**
     * <p>
     * A Boolean that represents the current state of faster launching for the Windows AMI. Set to <code>true</code> to
     * start using Windows faster launching, or <code>false</code> to stop using it.
     * </p>
     * 
     * @return A Boolean that represents the current state of faster launching for the Windows AMI. Set to
     *         <code>true</code> to start using Windows faster launching, or <code>false</code> to stop using it.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * Configuration settings for managing the number of snapshots that are created from pre-provisioned instances for
     * the Windows AMI when faster launching is enabled.
     * </p>
     * 
     * @return Configuration settings for managing the number of snapshots that are created from pre-provisioned
     *         instances for the Windows AMI when faster launching is enabled.
     */
    public final FastLaunchSnapshotConfiguration snapshotConfiguration() {
        return snapshotConfiguration;
    }

    /**
     * <p>
     * The maximum number of parallel instances that are launched for creating resources.
     * </p>
     * 
     * @return The maximum number of parallel instances that are launched for creating resources.
     */
    public final Integer maxParallelLaunches() {
        return maxParallelLaunches;
    }

    /**
     * <p>
     * The launch template that the fast-launch enabled Windows AMI uses when it launches Windows instances to create
     * pre-provisioned snapshots.
     * </p>
     * 
     * @return The launch template that the fast-launch enabled Windows AMI uses when it launches Windows instances to
     *         create pre-provisioned snapshots.
     */
    public final FastLaunchLaunchTemplateSpecification launchTemplate() {
        return launchTemplate;
    }

    /**
     * <p>
     * The owner account ID for the fast-launch enabled Windows AMI.
     * </p>
     * 
     * @return The owner account ID for the fast-launch enabled Windows AMI.
     */
    public final String accountId() {
        return accountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(maxParallelLaunches());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FastLaunchConfiguration)) {
            return false;
        }
        FastLaunchConfiguration other = (FastLaunchConfiguration) obj;
        return Objects.equals(enabled(), other.enabled())
                && Objects.equals(snapshotConfiguration(), other.snapshotConfiguration())
                && Objects.equals(maxParallelLaunches(), other.maxParallelLaunches())
                && Objects.equals(launchTemplate(), other.launchTemplate()) && Objects.equals(accountId(), other.accountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FastLaunchConfiguration").add("Enabled", enabled())
                .add("SnapshotConfiguration", snapshotConfiguration()).add("MaxParallelLaunches", maxParallelLaunches())
                .add("LaunchTemplate", launchTemplate()).add("AccountId", accountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "snapshotConfiguration":
            return Optional.ofNullable(clazz.cast(snapshotConfiguration()));
        case "maxParallelLaunches":
            return Optional.ofNullable(clazz.cast(maxParallelLaunches()));
        case "launchTemplate":
            return Optional.ofNullable(clazz.cast(launchTemplate()));
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enabled", ENABLED_FIELD);
        map.put("snapshotConfiguration", SNAPSHOT_CONFIGURATION_FIELD);
        map.put("maxParallelLaunches", MAX_PARALLEL_LAUNCHES_FIELD);
        map.put("launchTemplate", LAUNCH_TEMPLATE_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FastLaunchConfiguration, T> g) {
        return obj -> g.apply((FastLaunchConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FastLaunchConfiguration> {
        /**
         * <p>
         * A Boolean that represents the current state of faster launching for the Windows AMI. Set to <code>true</code>
         * to start using Windows faster launching, or <code>false</code> to stop using it.
         * </p>
         * 
         * @param enabled
         *        A Boolean that represents the current state of faster launching for the Windows AMI. Set to
         *        <code>true</code> to start using Windows faster launching, or <code>false</code> to stop using it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * Configuration settings for managing the number of snapshots that are created from pre-provisioned instances
         * for the Windows AMI when faster launching is enabled.
         * </p>
         * 
         * @param snapshotConfiguration
         *        Configuration settings for managing the number of snapshots that are created from pre-provisioned
         *        instances for the Windows AMI when faster launching is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotConfiguration(FastLaunchSnapshotConfiguration snapshotConfiguration);

        /**
         * <p>
         * Configuration settings for managing the number of snapshots that are created from pre-provisioned instances
         * for the Windows AMI when faster launching is enabled.
         * </p>
         * This is a convenience method that creates an instance of the {@link FastLaunchSnapshotConfiguration.Builder}
         * avoiding the need to create one manually via {@link FastLaunchSnapshotConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FastLaunchSnapshotConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #snapshotConfiguration(FastLaunchSnapshotConfiguration)}.
         * 
         * @param snapshotConfiguration
         *        a consumer that will call methods on {@link FastLaunchSnapshotConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snapshotConfiguration(FastLaunchSnapshotConfiguration)
         */
        default Builder snapshotConfiguration(Consumer<FastLaunchSnapshotConfiguration.Builder> snapshotConfiguration) {
            return snapshotConfiguration(FastLaunchSnapshotConfiguration.builder().applyMutation(snapshotConfiguration).build());
        }

        /**
         * <p>
         * The maximum number of parallel instances that are launched for creating resources.
         * </p>
         * 
         * @param maxParallelLaunches
         *        The maximum number of parallel instances that are launched for creating resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxParallelLaunches(Integer maxParallelLaunches);

        /**
         * <p>
         * The launch template that the fast-launch enabled Windows AMI uses when it launches Windows instances to
         * create pre-provisioned snapshots.
         * </p>
         * 
         * @param launchTemplate
         *        The launch template that the fast-launch enabled Windows AMI uses when it launches Windows instances
         *        to create pre-provisioned snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplate(FastLaunchLaunchTemplateSpecification launchTemplate);

        /**
         * <p>
         * The launch template that the fast-launch enabled Windows AMI uses when it launches Windows instances to
         * create pre-provisioned snapshots.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link FastLaunchLaunchTemplateSpecification.Builder} avoiding the need to create one manually via
         * {@link FastLaunchLaunchTemplateSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FastLaunchLaunchTemplateSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #launchTemplate(FastLaunchLaunchTemplateSpecification)}.
         * 
         * @param launchTemplate
         *        a consumer that will call methods on {@link FastLaunchLaunchTemplateSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplate(FastLaunchLaunchTemplateSpecification)
         */
        default Builder launchTemplate(Consumer<FastLaunchLaunchTemplateSpecification.Builder> launchTemplate) {
            return launchTemplate(FastLaunchLaunchTemplateSpecification.builder().applyMutation(launchTemplate).build());
        }

        /**
         * <p>
         * The owner account ID for the fast-launch enabled Windows AMI.
         * </p>
         * 
         * @param accountId
         *        The owner account ID for the fast-launch enabled Windows AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private FastLaunchSnapshotConfiguration snapshotConfiguration;

        private Integer maxParallelLaunches;

        private FastLaunchLaunchTemplateSpecification launchTemplate;

        private String accountId;

        private BuilderImpl() {
        }

        private BuilderImpl(FastLaunchConfiguration model) {
            enabled(model.enabled);
            snapshotConfiguration(model.snapshotConfiguration);
            maxParallelLaunches(model.maxParallelLaunches);
            launchTemplate(model.launchTemplate);
            accountId(model.accountId);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final FastLaunchSnapshotConfiguration.Builder getSnapshotConfiguration() {
            return snapshotConfiguration != null ? snapshotConfiguration.toBuilder() : null;
        }

        public final void setSnapshotConfiguration(FastLaunchSnapshotConfiguration.BuilderImpl snapshotConfiguration) {
            this.snapshotConfiguration = snapshotConfiguration != null ? snapshotConfiguration.build() : null;
        }

        @Override
        public final Builder snapshotConfiguration(FastLaunchSnapshotConfiguration snapshotConfiguration) {
            this.snapshotConfiguration = snapshotConfiguration;
            return this;
        }

        public final Integer getMaxParallelLaunches() {
            return maxParallelLaunches;
        }

        public final void setMaxParallelLaunches(Integer maxParallelLaunches) {
            this.maxParallelLaunches = maxParallelLaunches;
        }

        @Override
        public final Builder maxParallelLaunches(Integer maxParallelLaunches) {
            this.maxParallelLaunches = maxParallelLaunches;
            return this;
        }

        public final FastLaunchLaunchTemplateSpecification.Builder getLaunchTemplate() {
            return launchTemplate != null ? launchTemplate.toBuilder() : null;
        }

        public final void setLaunchTemplate(FastLaunchLaunchTemplateSpecification.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        @Override
        public final Builder launchTemplate(FastLaunchLaunchTemplateSpecification launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        @Override
        public FastLaunchConfiguration build() {
            return new FastLaunchConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
