/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportDiskImageRequest extends ImagebuilderRequest implements
        ToCopyableBuilder<ImportDiskImageRequest.Builder, ImportDiskImageRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ImportDiskImageRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SEMANTIC_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("semanticVersion").getter(getter(ImportDiskImageRequest::semanticVersion))
            .setter(setter(Builder::semanticVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticVersion").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ImportDiskImageRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platform").getter(getter(ImportDiskImageRequest::platform)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final SdkField<String> OS_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("osVersion").getter(getter(ImportDiskImageRequest::osVersion)).setter(setter(Builder::osVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("osVersion").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRole").getter(getter(ImportDiskImageRequest::executionRole))
            .setter(setter(Builder::executionRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRole").build()).build();

    private static final SdkField<String> INFRASTRUCTURE_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("infrastructureConfigurationArn")
            .getter(getter(ImportDiskImageRequest::infrastructureConfigurationArn))
            .setter(setter(Builder::infrastructureConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("infrastructureConfigurationArn")
                    .build()).build();

    private static final SdkField<String> URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("uri")
            .getter(getter(ImportDiskImageRequest::uri)).setter(setter(Builder::uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uri").build()).build();

    private static final SdkField<ImageLoggingConfiguration> LOGGING_CONFIGURATION_FIELD = SdkField
            .<ImageLoggingConfiguration> builder(MarshallingType.SDK_POJO).memberName("loggingConfiguration")
            .getter(getter(ImportDiskImageRequest::loggingConfiguration)).setter(setter(Builder::loggingConfiguration))
            .constructor(ImageLoggingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingConfiguration").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(ImportDiskImageRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(ImportDiskImageRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            SEMANTIC_VERSION_FIELD, DESCRIPTION_FIELD, PLATFORM_FIELD, OS_VERSION_FIELD, EXECUTION_ROLE_FIELD,
            INFRASTRUCTURE_CONFIGURATION_ARN_FIELD, URI_FIELD, LOGGING_CONFIGURATION_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String semanticVersion;

    private final String description;

    private final String platform;

    private final String osVersion;

    private final String executionRole;

    private final String infrastructureConfigurationArn;

    private final String uri;

    private final ImageLoggingConfiguration loggingConfiguration;

    private final Map<String, String> tags;

    private final String clientToken;

    private ImportDiskImageRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.semanticVersion = builder.semanticVersion;
        this.description = builder.description;
        this.platform = builder.platform;
        this.osVersion = builder.osVersion;
        this.executionRole = builder.executionRole;
        this.infrastructureConfigurationArn = builder.infrastructureConfigurationArn;
        this.uri = builder.uri;
        this.loggingConfiguration = builder.loggingConfiguration;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name of the image resource that's created from the import.
     * </p>
     * 
     * @return The name of the image resource that's created from the import.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The semantic version to attach to the image that's created during the import process. This version follows the
     * semantic version syntax.
     * </p>
     * 
     * @return The semantic version to attach to the image that's created during the import process. This version
     *         follows the semantic version syntax.
     */
    public final String semanticVersion() {
        return semanticVersion;
    }

    /**
     * <p>
     * The description for your disk image import.
     * </p>
     * 
     * @return The description for your disk image import.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The operating system platform for the imported image. Allowed values include the following: <code>Windows</code>.
     * </p>
     * 
     * @return The operating system platform for the imported image. Allowed values include the following:
     *         <code>Windows</code>.
     */
    public final String platform() {
        return platform;
    }

    /**
     * <p>
     * The operating system version for the imported image. Allowed values include the following:
     * <code>Microsoft Windows 11</code>.
     * </p>
     * 
     * @return The operating system version for the imported image. Allowed values include the following:
     *         <code>Microsoft Windows 11</code>.
     */
    public final String osVersion() {
        return osVersion;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to perform
     * workflow actions to import an image from a Microsoft ISO file.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to
     *         perform workflow actions to import an image from a Microsoft ISO file.
     */
    public final String executionRole() {
        return executionRole;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the infrastructure configuration resource that's used for launching the EC2
     * instance on which the ISO image is built.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the infrastructure configuration resource that's used for launching the
     *         EC2 instance on which the ISO image is built.
     */
    public final String infrastructureConfigurationArn() {
        return infrastructureConfigurationArn;
    }

    /**
     * <p>
     * The <code>uri</code> of the ISO disk file that's stored in Amazon S3.
     * </p>
     * 
     * @return The <code>uri</code> of the ISO disk file that's stored in Amazon S3.
     */
    public final String uri() {
        return uri;
    }

    /**
     * <p>
     * Define logging configuration for the image build process.
     * </p>
     * 
     * @return Define logging configuration for the image build process.
     */
    public final ImageLoggingConfiguration loggingConfiguration() {
        return loggingConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags that are attached to image resources created from the import.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags that are attached to image resources created from the import.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * idempotency</a> in the <i>Amazon EC2 API Reference</i>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information,
     *         see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         idempotency</a> in the <i>Amazon EC2 API Reference</i>.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(osVersion());
        hashCode = 31 * hashCode + Objects.hashCode(executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(infrastructureConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(uri());
        hashCode = 31 * hashCode + Objects.hashCode(loggingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportDiskImageRequest)) {
            return false;
        }
        ImportDiskImageRequest other = (ImportDiskImageRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(semanticVersion(), other.semanticVersion())
                && Objects.equals(description(), other.description()) && Objects.equals(platform(), other.platform())
                && Objects.equals(osVersion(), other.osVersion()) && Objects.equals(executionRole(), other.executionRole())
                && Objects.equals(infrastructureConfigurationArn(), other.infrastructureConfigurationArn())
                && Objects.equals(uri(), other.uri()) && Objects.equals(loggingConfiguration(), other.loggingConfiguration())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportDiskImageRequest").add("Name", name()).add("SemanticVersion", semanticVersion())
                .add("Description", description()).add("Platform", platform()).add("OsVersion", osVersion())
                .add("ExecutionRole", executionRole()).add("InfrastructureConfigurationArn", infrastructureConfigurationArn())
                .add("Uri", uri()).add("LoggingConfiguration", loggingConfiguration()).add("Tags", hasTags() ? tags() : null)
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "semanticVersion":
            return Optional.ofNullable(clazz.cast(semanticVersion()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "platform":
            return Optional.ofNullable(clazz.cast(platform()));
        case "osVersion":
            return Optional.ofNullable(clazz.cast(osVersion()));
        case "executionRole":
            return Optional.ofNullable(clazz.cast(executionRole()));
        case "infrastructureConfigurationArn":
            return Optional.ofNullable(clazz.cast(infrastructureConfigurationArn()));
        case "uri":
            return Optional.ofNullable(clazz.cast(uri()));
        case "loggingConfiguration":
            return Optional.ofNullable(clazz.cast(loggingConfiguration()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("semanticVersion", SEMANTIC_VERSION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("platform", PLATFORM_FIELD);
        map.put("osVersion", OS_VERSION_FIELD);
        map.put("executionRole", EXECUTION_ROLE_FIELD);
        map.put("infrastructureConfigurationArn", INFRASTRUCTURE_CONFIGURATION_ARN_FIELD);
        map.put("uri", URI_FIELD);
        map.put("loggingConfiguration", LOGGING_CONFIGURATION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportDiskImageRequest, T> g) {
        return obj -> g.apply((ImportDiskImageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ImagebuilderRequest.Builder, SdkPojo, CopyableBuilder<Builder, ImportDiskImageRequest> {
        /**
         * <p>
         * The name of the image resource that's created from the import.
         * </p>
         * 
         * @param name
         *        The name of the image resource that's created from the import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The semantic version to attach to the image that's created during the import process. This version follows
         * the semantic version syntax.
         * </p>
         * 
         * @param semanticVersion
         *        The semantic version to attach to the image that's created during the import process. This version
         *        follows the semantic version syntax.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semanticVersion(String semanticVersion);

        /**
         * <p>
         * The description for your disk image import.
         * </p>
         * 
         * @param description
         *        The description for your disk image import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The operating system platform for the imported image. Allowed values include the following:
         * <code>Windows</code>.
         * </p>
         * 
         * @param platform
         *        The operating system platform for the imported image. Allowed values include the following:
         *        <code>Windows</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * The operating system version for the imported image. Allowed values include the following:
         * <code>Microsoft Windows 11</code>.
         * </p>
         * 
         * @param osVersion
         *        The operating system version for the imported image. Allowed values include the following:
         *        <code>Microsoft Windows 11</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder osVersion(String osVersion);

        /**
         * <p>
         * The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to
         * perform workflow actions to import an image from a Microsoft ISO file.
         * </p>
         * 
         * @param executionRole
         *        The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to
         *        perform workflow actions to import an image from a Microsoft ISO file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRole(String executionRole);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the infrastructure configuration resource that's used for launching the EC2
         * instance on which the ISO image is built.
         * </p>
         * 
         * @param infrastructureConfigurationArn
         *        The Amazon Resource Name (ARN) of the infrastructure configuration resource that's used for launching
         *        the EC2 instance on which the ISO image is built.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder infrastructureConfigurationArn(String infrastructureConfigurationArn);

        /**
         * <p>
         * The <code>uri</code> of the ISO disk file that's stored in Amazon S3.
         * </p>
         * 
         * @param uri
         *        The <code>uri</code> of the ISO disk file that's stored in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uri(String uri);

        /**
         * <p>
         * Define logging configuration for the image build process.
         * </p>
         * 
         * @param loggingConfiguration
         *        Define logging configuration for the image build process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingConfiguration(ImageLoggingConfiguration loggingConfiguration);

        /**
         * <p>
         * Define logging configuration for the image build process.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageLoggingConfiguration.Builder}
         * avoiding the need to create one manually via {@link ImageLoggingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageLoggingConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #loggingConfiguration(ImageLoggingConfiguration)}.
         * 
         * @param loggingConfiguration
         *        a consumer that will call methods on {@link ImageLoggingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingConfiguration(ImageLoggingConfiguration)
         */
        default Builder loggingConfiguration(Consumer<ImageLoggingConfiguration.Builder> loggingConfiguration) {
            return loggingConfiguration(ImageLoggingConfiguration.builder().applyMutation(loggingConfiguration).build());
        }

        /**
         * <p>
         * Tags that are attached to image resources created from the import.
         * </p>
         * 
         * @param tags
         *        Tags that are attached to image resources created from the import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see
         * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * idempotency</a> in the <i>Amazon EC2 API Reference</i>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        idempotency</a> in the <i>Amazon EC2 API Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ImagebuilderRequest.BuilderImpl implements Builder {
        private String name;

        private String semanticVersion;

        private String description;

        private String platform;

        private String osVersion;

        private String executionRole;

        private String infrastructureConfigurationArn;

        private String uri;

        private ImageLoggingConfiguration loggingConfiguration;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportDiskImageRequest model) {
            super(model);
            name(model.name);
            semanticVersion(model.semanticVersion);
            description(model.description);
            platform(model.platform);
            osVersion(model.osVersion);
            executionRole(model.executionRole);
            infrastructureConfigurationArn(model.infrastructureConfigurationArn);
            uri(model.uri);
            loggingConfiguration(model.loggingConfiguration);
            tags(model.tags);
            clientToken(model.clientToken);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSemanticVersion() {
            return semanticVersion;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        @Override
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final String getOsVersion() {
            return osVersion;
        }

        public final void setOsVersion(String osVersion) {
            this.osVersion = osVersion;
        }

        @Override
        public final Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        public final String getExecutionRole() {
            return executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final String getInfrastructureConfigurationArn() {
            return infrastructureConfigurationArn;
        }

        public final void setInfrastructureConfigurationArn(String infrastructureConfigurationArn) {
            this.infrastructureConfigurationArn = infrastructureConfigurationArn;
        }

        @Override
        public final Builder infrastructureConfigurationArn(String infrastructureConfigurationArn) {
            this.infrastructureConfigurationArn = infrastructureConfigurationArn;
            return this;
        }

        public final String getUri() {
            return uri;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final ImageLoggingConfiguration.Builder getLoggingConfiguration() {
            return loggingConfiguration != null ? loggingConfiguration.toBuilder() : null;
        }

        public final void setLoggingConfiguration(ImageLoggingConfiguration.BuilderImpl loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration != null ? loggingConfiguration.build() : null;
        }

        @Override
        public final Builder loggingConfiguration(ImageLoggingConfiguration loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportDiskImageRequest build() {
            return new ImportDiskImageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
