/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the state of an impacted snapshot resource that the runtime instance of the lifecycle policy identified for
 * action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LifecycleExecutionSnapshotResource implements SdkPojo, Serializable,
        ToCopyableBuilder<LifecycleExecutionSnapshotResource.Builder, LifecycleExecutionSnapshotResource> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("snapshotId").getter(getter(LifecycleExecutionSnapshotResource::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotId").build()).build();

    private static final SdkField<LifecycleExecutionResourceState> STATE_FIELD = SdkField
            .<LifecycleExecutionResourceState> builder(MarshallingType.SDK_POJO).memberName("state")
            .getter(getter(LifecycleExecutionSnapshotResource::state)).setter(setter(Builder::state))
            .constructor(LifecycleExecutionResourceState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SNAPSHOT_ID_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String snapshotId;

    private final LifecycleExecutionResourceState state;

    private LifecycleExecutionSnapshotResource(BuilderImpl builder) {
        this.snapshotId = builder.snapshotId;
        this.state = builder.state;
    }

    /**
     * <p>
     * Identifies the impacted snapshot resource.
     * </p>
     * 
     * @return Identifies the impacted snapshot resource.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The runtime status of the lifecycle action taken for the snapshot.
     * </p>
     * 
     * @return The runtime status of the lifecycle action taken for the snapshot.
     */
    public final LifecycleExecutionResourceState state() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecycleExecutionSnapshotResource)) {
            return false;
        }
        LifecycleExecutionSnapshotResource other = (LifecycleExecutionSnapshotResource) obj;
        return Objects.equals(snapshotId(), other.snapshotId()) && Objects.equals(state(), other.state());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LifecycleExecutionSnapshotResource").add("SnapshotId", snapshotId()).add("State", state())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "snapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "state":
            return Optional.ofNullable(clazz.cast(state()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("snapshotId", SNAPSHOT_ID_FIELD);
        map.put("state", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LifecycleExecutionSnapshotResource, T> g) {
        return obj -> g.apply((LifecycleExecutionSnapshotResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LifecycleExecutionSnapshotResource> {
        /**
         * <p>
         * Identifies the impacted snapshot resource.
         * </p>
         * 
         * @param snapshotId
         *        Identifies the impacted snapshot resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The runtime status of the lifecycle action taken for the snapshot.
         * </p>
         * 
         * @param state
         *        The runtime status of the lifecycle action taken for the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(LifecycleExecutionResourceState state);

        /**
         * <p>
         * The runtime status of the lifecycle action taken for the snapshot.
         * </p>
         * This is a convenience method that creates an instance of the {@link LifecycleExecutionResourceState.Builder}
         * avoiding the need to create one manually via {@link LifecycleExecutionResourceState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LifecycleExecutionResourceState.Builder#build()} is called
         * immediately and its result is passed to {@link #state(LifecycleExecutionResourceState)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link LifecycleExecutionResourceState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(LifecycleExecutionResourceState)
         */
        default Builder state(Consumer<LifecycleExecutionResourceState.Builder> state) {
            return state(LifecycleExecutionResourceState.builder().applyMutation(state).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String snapshotId;

        private LifecycleExecutionResourceState state;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecycleExecutionSnapshotResource model) {
            snapshotId(model.snapshotId);
            state(model.state);
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final LifecycleExecutionResourceState.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        public final void setState(LifecycleExecutionResourceState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(LifecycleExecutionResourceState state) {
            this.state = state;
            return this;
        }

        @Override
        public LifecycleExecutionSnapshotResource build() {
            return new LifecycleExecutionSnapshotResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
