/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration details for a lifecycle policy resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LifecyclePolicy implements SdkPojo, Serializable, ToCopyableBuilder<LifecyclePolicy.Builder, LifecyclePolicy> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(LifecyclePolicy::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(LifecyclePolicy::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(LifecyclePolicy::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(LifecyclePolicy::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRole").getter(getter(LifecyclePolicy::executionRole)).setter(setter(Builder::executionRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRole").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(LifecyclePolicy::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<List<LifecyclePolicyDetail>> POLICY_DETAILS_FIELD = SdkField
            .<List<LifecyclePolicyDetail>> builder(MarshallingType.LIST)
            .memberName("policyDetails")
            .getter(getter(LifecyclePolicy::policyDetails))
            .setter(setter(Builder::policyDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LifecyclePolicyDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(LifecyclePolicyDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<LifecyclePolicyResourceSelection> RESOURCE_SELECTION_FIELD = SdkField
            .<LifecyclePolicyResourceSelection> builder(MarshallingType.SDK_POJO).memberName("resourceSelection")
            .getter(getter(LifecyclePolicy::resourceSelection)).setter(setter(Builder::resourceSelection))
            .constructor(LifecyclePolicyResourceSelection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSelection").build()).build();

    private static final SdkField<Instant> DATE_CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("dateCreated").getter(getter(LifecyclePolicy::dateCreated)).setter(setter(Builder::dateCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateCreated").build()).build();

    private static final SdkField<Instant> DATE_UPDATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("dateUpdated").getter(getter(LifecyclePolicy::dateUpdated)).setter(setter(Builder::dateUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateUpdated").build()).build();

    private static final SdkField<Instant> DATE_LAST_RUN_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("dateLastRun").getter(getter(LifecyclePolicy::dateLastRun)).setter(setter(Builder::dateLastRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateLastRun").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(LifecyclePolicy::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, STATUS_FIELD, EXECUTION_ROLE_FIELD, RESOURCE_TYPE_FIELD, POLICY_DETAILS_FIELD,
            RESOURCE_SELECTION_FIELD, DATE_CREATED_FIELD, DATE_UPDATED_FIELD, DATE_LAST_RUN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String description;

    private final String status;

    private final String executionRole;

    private final String resourceType;

    private final List<LifecyclePolicyDetail> policyDetails;

    private final LifecyclePolicyResourceSelection resourceSelection;

    private final Instant dateCreated;

    private final Instant dateUpdated;

    private final Instant dateLastRun;

    private final Map<String, String> tags;

    private LifecyclePolicy(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.status = builder.status;
        this.executionRole = builder.executionRole;
        this.resourceType = builder.resourceType;
        this.policyDetails = builder.policyDetails;
        this.resourceSelection = builder.resourceSelection;
        this.dateCreated = builder.dateCreated;
        this.dateUpdated = builder.dateUpdated;
        this.dateLastRun = builder.dateLastRun;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the lifecycle policy resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the lifecycle policy resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the lifecycle policy.
     * </p>
     * 
     * @return The name of the lifecycle policy.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Optional description for the lifecycle policy.
     * </p>
     * 
     * @return Optional description for the lifecycle policy.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Indicates whether the lifecycle policy resource is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LifecyclePolicyStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates whether the lifecycle policy resource is enabled.
     * @see LifecyclePolicyStatus
     */
    public final LifecyclePolicyStatus status() {
        return LifecyclePolicyStatus.fromValue(status);
    }

    /**
     * <p>
     * Indicates whether the lifecycle policy resource is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LifecyclePolicyStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates whether the lifecycle policy resource is enabled.
     * @see LifecyclePolicyStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the IAM role that Image Builder uses to run the lifecycle policy. This
     * is a custom role that you create.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the IAM role that Image Builder uses to run the lifecycle
     *         policy. This is a custom role that you create.
     */
    public final String executionRole() {
        return executionRole;
    }

    /**
     * <p>
     * The type of resources the lifecycle policy targets.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link LifecyclePolicyResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resources the lifecycle policy targets.
     * @see LifecyclePolicyResourceType
     */
    public final LifecyclePolicyResourceType resourceType() {
        return LifecyclePolicyResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of resources the lifecycle policy targets.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link LifecyclePolicyResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resources the lifecycle policy targets.
     * @see LifecyclePolicyResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the PolicyDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPolicyDetails() {
        return policyDetails != null && !(policyDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration details for a lifecycle policy resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicyDetails} method.
     * </p>
     * 
     * @return The configuration details for a lifecycle policy resource.
     */
    public final List<LifecyclePolicyDetail> policyDetails() {
        return policyDetails;
    }

    /**
     * <p>
     * Resource selection criteria used to run the lifecycle policy.
     * </p>
     * 
     * @return Resource selection criteria used to run the lifecycle policy.
     */
    public final LifecyclePolicyResourceSelection resourceSelection() {
        return resourceSelection;
    }

    /**
     * <p>
     * The timestamp when Image Builder created the lifecycle policy resource.
     * </p>
     * 
     * @return The timestamp when Image Builder created the lifecycle policy resource.
     */
    public final Instant dateCreated() {
        return dateCreated;
    }

    /**
     * <p>
     * The timestamp when Image Builder updated the lifecycle policy resource.
     * </p>
     * 
     * @return The timestamp when Image Builder updated the lifecycle policy resource.
     */
    public final Instant dateUpdated() {
        return dateUpdated;
    }

    /**
     * <p>
     * The timestamp for the last time Image Builder ran the lifecycle policy.
     * </p>
     * 
     * @return The timestamp for the last time Image Builder ran the lifecycle policy.
     */
    public final Instant dateLastRun() {
        return dateLastRun;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * To help manage your lifecycle policy resources, you can assign your own metadata to each resource in the form of
     * tags. Each tag consists of a key and an optional value, both of which you define.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return To help manage your lifecycle policy resources, you can assign your own metadata to each resource in the
     *         form of tags. Each tag consists of a key and an optional value, both of which you define.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicyDetails() ? policyDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceSelection());
        hashCode = 31 * hashCode + Objects.hashCode(dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(dateUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(dateLastRun());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecyclePolicy)) {
            return false;
        }
        LifecyclePolicy other = (LifecyclePolicy) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(executionRole(), other.executionRole())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && hasPolicyDetails() == other.hasPolicyDetails() && Objects.equals(policyDetails(), other.policyDetails())
                && Objects.equals(resourceSelection(), other.resourceSelection())
                && Objects.equals(dateCreated(), other.dateCreated()) && Objects.equals(dateUpdated(), other.dateUpdated())
                && Objects.equals(dateLastRun(), other.dateLastRun()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LifecyclePolicy").add("Arn", arn()).add("Name", name()).add("Description", description())
                .add("Status", statusAsString()).add("ExecutionRole", executionRole())
                .add("ResourceType", resourceTypeAsString()).add("PolicyDetails", hasPolicyDetails() ? policyDetails() : null)
                .add("ResourceSelection", resourceSelection()).add("DateCreated", dateCreated())
                .add("DateUpdated", dateUpdated()).add("DateLastRun", dateLastRun()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "executionRole":
            return Optional.ofNullable(clazz.cast(executionRole()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "policyDetails":
            return Optional.ofNullable(clazz.cast(policyDetails()));
        case "resourceSelection":
            return Optional.ofNullable(clazz.cast(resourceSelection()));
        case "dateCreated":
            return Optional.ofNullable(clazz.cast(dateCreated()));
        case "dateUpdated":
            return Optional.ofNullable(clazz.cast(dateUpdated()));
        case "dateLastRun":
            return Optional.ofNullable(clazz.cast(dateLastRun()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("executionRole", EXECUTION_ROLE_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("policyDetails", POLICY_DETAILS_FIELD);
        map.put("resourceSelection", RESOURCE_SELECTION_FIELD);
        map.put("dateCreated", DATE_CREATED_FIELD);
        map.put("dateUpdated", DATE_UPDATED_FIELD);
        map.put("dateLastRun", DATE_LAST_RUN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LifecyclePolicy, T> g) {
        return obj -> g.apply((LifecyclePolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LifecyclePolicy> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the lifecycle policy resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the lifecycle policy resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the lifecycle policy.
         * </p>
         * 
         * @param name
         *        The name of the lifecycle policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Optional description for the lifecycle policy.
         * </p>
         * 
         * @param description
         *        Optional description for the lifecycle policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Indicates whether the lifecycle policy resource is enabled.
         * </p>
         * 
         * @param status
         *        Indicates whether the lifecycle policy resource is enabled.
         * @see LifecyclePolicyStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecyclePolicyStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates whether the lifecycle policy resource is enabled.
         * </p>
         * 
         * @param status
         *        Indicates whether the lifecycle policy resource is enabled.
         * @see LifecyclePolicyStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecyclePolicyStatus
         */
        Builder status(LifecyclePolicyStatus status);

        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the IAM role that Image Builder uses to run the lifecycle policy.
         * This is a custom role that you create.
         * </p>
         * 
         * @param executionRole
         *        The name or Amazon Resource Name (ARN) of the IAM role that Image Builder uses to run the lifecycle
         *        policy. This is a custom role that you create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRole(String executionRole);

        /**
         * <p>
         * The type of resources the lifecycle policy targets.
         * </p>
         * 
         * @param resourceType
         *        The type of resources the lifecycle policy targets.
         * @see LifecyclePolicyResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecyclePolicyResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resources the lifecycle policy targets.
         * </p>
         * 
         * @param resourceType
         *        The type of resources the lifecycle policy targets.
         * @see LifecyclePolicyResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecyclePolicyResourceType
         */
        Builder resourceType(LifecyclePolicyResourceType resourceType);

        /**
         * <p>
         * The configuration details for a lifecycle policy resource.
         * </p>
         * 
         * @param policyDetails
         *        The configuration details for a lifecycle policy resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDetails(Collection<LifecyclePolicyDetail> policyDetails);

        /**
         * <p>
         * The configuration details for a lifecycle policy resource.
         * </p>
         * 
         * @param policyDetails
         *        The configuration details for a lifecycle policy resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDetails(LifecyclePolicyDetail... policyDetails);

        /**
         * <p>
         * The configuration details for a lifecycle policy resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetail.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #policyDetails(List<LifecyclePolicyDetail>)}.
         * 
         * @param policyDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyDetails(java.util.Collection<LifecyclePolicyDetail>)
         */
        Builder policyDetails(Consumer<LifecyclePolicyDetail.Builder>... policyDetails);

        /**
         * <p>
         * Resource selection criteria used to run the lifecycle policy.
         * </p>
         * 
         * @param resourceSelection
         *        Resource selection criteria used to run the lifecycle policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSelection(LifecyclePolicyResourceSelection resourceSelection);

        /**
         * <p>
         * Resource selection criteria used to run the lifecycle policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link LifecyclePolicyResourceSelection.Builder}
         * avoiding the need to create one manually via {@link LifecyclePolicyResourceSelection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LifecyclePolicyResourceSelection.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceSelection(LifecyclePolicyResourceSelection)}.
         * 
         * @param resourceSelection
         *        a consumer that will call methods on {@link LifecyclePolicyResourceSelection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceSelection(LifecyclePolicyResourceSelection)
         */
        default Builder resourceSelection(Consumer<LifecyclePolicyResourceSelection.Builder> resourceSelection) {
            return resourceSelection(LifecyclePolicyResourceSelection.builder().applyMutation(resourceSelection).build());
        }

        /**
         * <p>
         * The timestamp when Image Builder created the lifecycle policy resource.
         * </p>
         * 
         * @param dateCreated
         *        The timestamp when Image Builder created the lifecycle policy resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateCreated(Instant dateCreated);

        /**
         * <p>
         * The timestamp when Image Builder updated the lifecycle policy resource.
         * </p>
         * 
         * @param dateUpdated
         *        The timestamp when Image Builder updated the lifecycle policy resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateUpdated(Instant dateUpdated);

        /**
         * <p>
         * The timestamp for the last time Image Builder ran the lifecycle policy.
         * </p>
         * 
         * @param dateLastRun
         *        The timestamp for the last time Image Builder ran the lifecycle policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateLastRun(Instant dateLastRun);

        /**
         * <p>
         * To help manage your lifecycle policy resources, you can assign your own metadata to each resource in the form
         * of tags. Each tag consists of a key and an optional value, both of which you define.
         * </p>
         * 
         * @param tags
         *        To help manage your lifecycle policy resources, you can assign your own metadata to each resource in
         *        the form of tags. Each tag consists of a key and an optional value, both of which you define.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String description;

        private String status;

        private String executionRole;

        private String resourceType;

        private List<LifecyclePolicyDetail> policyDetails = DefaultSdkAutoConstructList.getInstance();

        private LifecyclePolicyResourceSelection resourceSelection;

        private Instant dateCreated;

        private Instant dateUpdated;

        private Instant dateLastRun;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LifecyclePolicy model) {
            arn(model.arn);
            name(model.name);
            description(model.description);
            status(model.status);
            executionRole(model.executionRole);
            resourceType(model.resourceType);
            policyDetails(model.policyDetails);
            resourceSelection(model.resourceSelection);
            dateCreated(model.dateCreated);
            dateUpdated(model.dateUpdated);
            dateLastRun(model.dateLastRun);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LifecyclePolicyStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getExecutionRole() {
            return executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(LifecyclePolicyResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final List<LifecyclePolicyDetail.Builder> getPolicyDetails() {
            List<LifecyclePolicyDetail.Builder> result = LifecyclePolicyDetailsCopier.copyToBuilder(this.policyDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyDetails(Collection<LifecyclePolicyDetail.BuilderImpl> policyDetails) {
            this.policyDetails = LifecyclePolicyDetailsCopier.copyFromBuilder(policyDetails);
        }

        @Override
        public final Builder policyDetails(Collection<LifecyclePolicyDetail> policyDetails) {
            this.policyDetails = LifecyclePolicyDetailsCopier.copy(policyDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyDetails(LifecyclePolicyDetail... policyDetails) {
            policyDetails(Arrays.asList(policyDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyDetails(Consumer<LifecyclePolicyDetail.Builder>... policyDetails) {
            policyDetails(Stream.of(policyDetails).map(c -> LifecyclePolicyDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final LifecyclePolicyResourceSelection.Builder getResourceSelection() {
            return resourceSelection != null ? resourceSelection.toBuilder() : null;
        }

        public final void setResourceSelection(LifecyclePolicyResourceSelection.BuilderImpl resourceSelection) {
            this.resourceSelection = resourceSelection != null ? resourceSelection.build() : null;
        }

        @Override
        public final Builder resourceSelection(LifecyclePolicyResourceSelection resourceSelection) {
            this.resourceSelection = resourceSelection;
            return this;
        }

        public final Instant getDateCreated() {
            return dateCreated;
        }

        public final void setDateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
        }

        @Override
        public final Builder dateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final Instant getDateUpdated() {
            return dateUpdated;
        }

        public final void setDateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
        }

        @Override
        public final Builder dateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public final Instant getDateLastRun() {
            return dateLastRun;
        }

        public final void setDateLastRun(Instant dateLastRun) {
            this.dateLastRun = dateLastRun;
        }

        @Override
        public final Builder dateLastRun(Instant dateLastRun) {
            this.dateLastRun = dateLastRun;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public LifecyclePolicy build() {
            return new LifecyclePolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
