/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListImageBuildVersionsResponse extends ImagebuilderResponse implements
        ToCopyableBuilder<ListImageBuildVersionsResponse.Builder, ListImageBuildVersionsResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestId").getter(getter(ListImageBuildVersionsResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()).build();

    private static final SdkField<List<ImageSummary>> IMAGE_SUMMARY_LIST_FIELD = SdkField
            .<List<ImageSummary>> builder(MarshallingType.LIST)
            .memberName("imageSummaryList")
            .getter(getter(ListImageBuildVersionsResponse::imageSummaryList))
            .setter(setter(Builder::imageSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImageSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImageSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListImageBuildVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD,
            IMAGE_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String requestIdValue;

    private final List<ImageSummary> imageSummaryList;

    private final String nextToken;

    private ListImageBuildVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.imageSummaryList = builder.imageSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The request ID that uniquely identifies this request.
     * </p>
     * 
     * @return The request ID that uniquely identifies this request.
     */
    public final String requestId() {
        return requestIdValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImageSummaryList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasImageSummaryList() {
        return imageSummaryList != null && !(imageSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of image build versions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImageSummaryList} method.
     * </p>
     * 
     * @return The list of image build versions.
     */
    public final List<ImageSummary> imageSummaryList() {
        return imageSummaryList;
    }

    /**
     * <p>
     * The next token used for paginated responses. When this field isn't empty, there are additional elements that the
     * service hasn't included in this request. Use this token with the next request to retrieve additional objects.
     * </p>
     * 
     * @return The next token used for paginated responses. When this field isn't empty, there are additional elements
     *         that the service hasn't included in this request. Use this token with the next request to retrieve
     *         additional objects.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(hasImageSummaryList() ? imageSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImageBuildVersionsResponse)) {
            return false;
        }
        ListImageBuildVersionsResponse other = (ListImageBuildVersionsResponse) obj;
        return Objects.equals(requestId(), other.requestId()) && hasImageSummaryList() == other.hasImageSummaryList()
                && Objects.equals(imageSummaryList(), other.imageSummaryList()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListImageBuildVersionsResponse").add("RequestId", requestId())
                .add("ImageSummaryList", hasImageSummaryList() ? imageSummaryList() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "requestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "imageSummaryList":
            return Optional.ofNullable(clazz.cast(imageSummaryList()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("requestId", REQUEST_ID_FIELD);
        map.put("imageSummaryList", IMAGE_SUMMARY_LIST_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListImageBuildVersionsResponse, T> g) {
        return obj -> g.apply((ListImageBuildVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ImagebuilderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListImageBuildVersionsResponse> {
        /**
         * <p>
         * The request ID that uniquely identifies this request.
         * </p>
         * 
         * @param requestIdValue
         *        The request ID that uniquely identifies this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestIdValue);

        /**
         * <p>
         * The list of image build versions.
         * </p>
         * 
         * @param imageSummaryList
         *        The list of image build versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageSummaryList(Collection<ImageSummary> imageSummaryList);

        /**
         * <p>
         * The list of image build versions.
         * </p>
         * 
         * @param imageSummaryList
         *        The list of image build versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageSummaryList(ImageSummary... imageSummaryList);

        /**
         * <p>
         * The list of image build versions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.imagebuilder.model.ImageSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.imagebuilder.model.ImageSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.imagebuilder.model.ImageSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #imageSummaryList(List<ImageSummary>)}.
         * 
         * @param imageSummaryList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.imagebuilder.model.ImageSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageSummaryList(java.util.Collection<ImageSummary>)
         */
        Builder imageSummaryList(Consumer<ImageSummary.Builder>... imageSummaryList);

        /**
         * <p>
         * The next token used for paginated responses. When this field isn't empty, there are additional elements that
         * the service hasn't included in this request. Use this token with the next request to retrieve additional
         * objects.
         * </p>
         * 
         * @param nextToken
         *        The next token used for paginated responses. When this field isn't empty, there are additional
         *        elements that the service hasn't included in this request. Use this token with the next request to
         *        retrieve additional objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ImagebuilderResponse.BuilderImpl implements Builder {
        private String requestIdValue;

        private List<ImageSummary> imageSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImageBuildVersionsResponse model) {
            super(model);
            requestId(model.requestIdValue);
            imageSummaryList(model.imageSummaryList);
            nextToken(model.nextToken);
        }

        public final String getRequestId() {
            return requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final List<ImageSummary.Builder> getImageSummaryList() {
            List<ImageSummary.Builder> result = ImageSummaryListCopier.copyToBuilder(this.imageSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImageSummaryList(Collection<ImageSummary.BuilderImpl> imageSummaryList) {
            this.imageSummaryList = ImageSummaryListCopier.copyFromBuilder(imageSummaryList);
        }

        @Override
        public final Builder imageSummaryList(Collection<ImageSummary> imageSummaryList) {
            this.imageSummaryList = ImageSummaryListCopier.copy(imageSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageSummaryList(ImageSummary... imageSummaryList) {
            imageSummaryList(Arrays.asList(imageSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageSummaryList(Consumer<ImageSummary.Builder>... imageSummaryList) {
            imageSummaryList(Stream.of(imageSummaryList).map(c -> ImageSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListImageBuildVersionsResponse build() {
            return new ListImageBuildVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
