/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLifecycleExecutionResourcesRequest extends ImagebuilderRequest implements
        ToCopyableBuilder<ListLifecycleExecutionResourcesRequest.Builder, ListLifecycleExecutionResourcesRequest> {
    private static final SdkField<String> LIFECYCLE_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lifecycleExecutionId").getter(getter(ListLifecycleExecutionResourcesRequest::lifecycleExecutionId))
            .setter(setter(Builder::lifecycleExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleExecutionId").build())
            .build();

    private static final SdkField<String> PARENT_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentResourceId").getter(getter(ListLifecycleExecutionResourcesRequest::parentResourceId))
            .setter(setter(Builder::parentResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentResourceId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListLifecycleExecutionResourcesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListLifecycleExecutionResourcesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_EXECUTION_ID_FIELD,
            PARENT_RESOURCE_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String lifecycleExecutionId;

    private final String parentResourceId;

    private final Integer maxResults;

    private final String nextToken;

    private ListLifecycleExecutionResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.lifecycleExecutionId = builder.lifecycleExecutionId;
        this.parentResourceId = builder.parentResourceId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Use the unique identifier for a runtime instance of the lifecycle policy to get runtime details.
     * </p>
     * 
     * @return Use the unique identifier for a runtime instance of the lifecycle policy to get runtime details.
     */
    public final String lifecycleExecutionId() {
        return lifecycleExecutionId;
    }

    /**
     * <p>
     * You can leave this empty to get a list of Image Builder resources that were identified for lifecycle actions.
     * </p>
     * <p>
     * To get a list of associated resources that are impacted for an individual resource (the parent), specify its
     * Amazon Resource Name (ARN). Associated resources are produced from your image and distributed when you run a
     * build, such as AMIs or container images stored in ECR repositories.
     * </p>
     * 
     * @return You can leave this empty to get a list of Image Builder resources that were identified for lifecycle
     *         actions.</p>
     *         <p>
     *         To get a list of associated resources that are impacted for an individual resource (the parent), specify
     *         its Amazon Resource Name (ARN). Associated resources are produced from your image and distributed when
     *         you run a build, such as AMIs or container images stored in ECR repositories.
     */
    public final String parentResourceId() {
        return parentResourceId;
    }

    /**
     * <p>
     * Specify the maximum number of items to return in a request.
     * </p>
     * 
     * @return Specify the maximum number of items to return in a request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token to specify where to start paginating. This is the nextToken from a previously truncated response.
     * </p>
     * 
     * @return A token to specify where to start paginating. This is the nextToken from a previously truncated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(parentResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLifecycleExecutionResourcesRequest)) {
            return false;
        }
        ListLifecycleExecutionResourcesRequest other = (ListLifecycleExecutionResourcesRequest) obj;
        return Objects.equals(lifecycleExecutionId(), other.lifecycleExecutionId())
                && Objects.equals(parentResourceId(), other.parentResourceId())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLifecycleExecutionResourcesRequest").add("LifecycleExecutionId", lifecycleExecutionId())
                .add("ParentResourceId", parentResourceId()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lifecycleExecutionId":
            return Optional.ofNullable(clazz.cast(lifecycleExecutionId()));
        case "parentResourceId":
            return Optional.ofNullable(clazz.cast(parentResourceId()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("lifecycleExecutionId", LIFECYCLE_EXECUTION_ID_FIELD);
        map.put("parentResourceId", PARENT_RESOURCE_ID_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLifecycleExecutionResourcesRequest, T> g) {
        return obj -> g.apply((ListLifecycleExecutionResourcesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ImagebuilderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListLifecycleExecutionResourcesRequest> {
        /**
         * <p>
         * Use the unique identifier for a runtime instance of the lifecycle policy to get runtime details.
         * </p>
         * 
         * @param lifecycleExecutionId
         *        Use the unique identifier for a runtime instance of the lifecycle policy to get runtime details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleExecutionId(String lifecycleExecutionId);

        /**
         * <p>
         * You can leave this empty to get a list of Image Builder resources that were identified for lifecycle actions.
         * </p>
         * <p>
         * To get a list of associated resources that are impacted for an individual resource (the parent), specify its
         * Amazon Resource Name (ARN). Associated resources are produced from your image and distributed when you run a
         * build, such as AMIs or container images stored in ECR repositories.
         * </p>
         * 
         * @param parentResourceId
         *        You can leave this empty to get a list of Image Builder resources that were identified for lifecycle
         *        actions.</p>
         *        <p>
         *        To get a list of associated resources that are impacted for an individual resource (the parent),
         *        specify its Amazon Resource Name (ARN). Associated resources are produced from your image and
         *        distributed when you run a build, such as AMIs or container images stored in ECR repositories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentResourceId(String parentResourceId);

        /**
         * <p>
         * Specify the maximum number of items to return in a request.
         * </p>
         * 
         * @param maxResults
         *        Specify the maximum number of items to return in a request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token to specify where to start paginating. This is the nextToken from a previously truncated response.
         * </p>
         * 
         * @param nextToken
         *        A token to specify where to start paginating. This is the nextToken from a previously truncated
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ImagebuilderRequest.BuilderImpl implements Builder {
        private String lifecycleExecutionId;

        private String parentResourceId;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLifecycleExecutionResourcesRequest model) {
            super(model);
            lifecycleExecutionId(model.lifecycleExecutionId);
            parentResourceId(model.parentResourceId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getLifecycleExecutionId() {
            return lifecycleExecutionId;
        }

        public final void setLifecycleExecutionId(String lifecycleExecutionId) {
            this.lifecycleExecutionId = lifecycleExecutionId;
        }

        @Override
        public final Builder lifecycleExecutionId(String lifecycleExecutionId) {
            this.lifecycleExecutionId = lifecycleExecutionId;
            return this;
        }

        public final String getParentResourceId() {
            return parentResourceId;
        }

        public final void setParentResourceId(String parentResourceId) {
            this.parentResourceId = parentResourceId;
        }

        @Override
        public final Builder parentResourceId(String parentResourceId) {
            this.parentResourceId = parentResourceId;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListLifecycleExecutionResourcesRequest build() {
            return new ListLifecycleExecutionResourcesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
