/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWorkflowExecutionsResponse extends ImagebuilderResponse implements
        ToCopyableBuilder<ListWorkflowExecutionsResponse.Builder, ListWorkflowExecutionsResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestId").getter(getter(ListWorkflowExecutionsResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()).build();

    private static final SdkField<List<WorkflowExecutionMetadata>> WORKFLOW_EXECUTIONS_FIELD = SdkField
            .<List<WorkflowExecutionMetadata>> builder(MarshallingType.LIST)
            .memberName("workflowExecutions")
            .getter(getter(ListWorkflowExecutionsResponse::workflowExecutions))
            .setter(setter(Builder::workflowExecutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowExecutions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkflowExecutionMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkflowExecutionMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IMAGE_BUILD_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageBuildVersionArn").getter(getter(ListWorkflowExecutionsResponse::imageBuildVersionArn))
            .setter(setter(Builder::imageBuildVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageBuildVersionArn").build())
            .build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(ListWorkflowExecutionsResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListWorkflowExecutionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD,
            WORKFLOW_EXECUTIONS_FIELD, IMAGE_BUILD_VERSION_ARN_FIELD, MESSAGE_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String requestIdValue;

    private final List<WorkflowExecutionMetadata> workflowExecutions;

    private final String imageBuildVersionArn;

    private final String message;

    private final String nextToken;

    private ListWorkflowExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.workflowExecutions = builder.workflowExecutions;
        this.imageBuildVersionArn = builder.imageBuildVersionArn;
        this.message = builder.message;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The request ID that uniquely identifies this request.
     * </p>
     * 
     * @return The request ID that uniquely identifies this request.
     */
    public final String requestId() {
        return requestIdValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the WorkflowExecutions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWorkflowExecutions() {
        return workflowExecutions != null && !(workflowExecutions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains an array of runtime details that represents each time a workflow ran for the requested image build
     * version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkflowExecutions} method.
     * </p>
     * 
     * @return Contains an array of runtime details that represents each time a workflow ran for the requested image
     *         build version.
     */
    public final List<WorkflowExecutionMetadata> workflowExecutions() {
        return workflowExecutions;
    }

    /**
     * <p>
     * The resource ARN of the image build version for which you requested a list of workflow runtime details.
     * </p>
     * 
     * @return The resource ARN of the image build version for which you requested a list of workflow runtime details.
     */
    public final String imageBuildVersionArn() {
        return imageBuildVersionArn;
    }

    /**
     * <p>
     * The output message from the list action, if applicable.
     * </p>
     * 
     * @return The output message from the list action, if applicable.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The next token used for paginated responses. When this field isn't empty, there are additional elements that the
     * service hasn't included in this request. Use this token with the next request to retrieve additional objects.
     * </p>
     * 
     * @return The next token used for paginated responses. When this field isn't empty, there are additional elements
     *         that the service hasn't included in this request. Use this token with the next request to retrieve
     *         additional objects.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkflowExecutions() ? workflowExecutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(imageBuildVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkflowExecutionsResponse)) {
            return false;
        }
        ListWorkflowExecutionsResponse other = (ListWorkflowExecutionsResponse) obj;
        return Objects.equals(requestId(), other.requestId()) && hasWorkflowExecutions() == other.hasWorkflowExecutions()
                && Objects.equals(workflowExecutions(), other.workflowExecutions())
                && Objects.equals(imageBuildVersionArn(), other.imageBuildVersionArn())
                && Objects.equals(message(), other.message()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListWorkflowExecutionsResponse").add("RequestId", requestId())
                .add("WorkflowExecutions", hasWorkflowExecutions() ? workflowExecutions() : null)
                .add("ImageBuildVersionArn", imageBuildVersionArn()).add("Message", message()).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "requestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "workflowExecutions":
            return Optional.ofNullable(clazz.cast(workflowExecutions()));
        case "imageBuildVersionArn":
            return Optional.ofNullable(clazz.cast(imageBuildVersionArn()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("requestId", REQUEST_ID_FIELD);
        map.put("workflowExecutions", WORKFLOW_EXECUTIONS_FIELD);
        map.put("imageBuildVersionArn", IMAGE_BUILD_VERSION_ARN_FIELD);
        map.put("message", MESSAGE_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWorkflowExecutionsResponse, T> g) {
        return obj -> g.apply((ListWorkflowExecutionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ImagebuilderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListWorkflowExecutionsResponse> {
        /**
         * <p>
         * The request ID that uniquely identifies this request.
         * </p>
         * 
         * @param requestIdValue
         *        The request ID that uniquely identifies this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestIdValue);

        /**
         * <p>
         * Contains an array of runtime details that represents each time a workflow ran for the requested image build
         * version.
         * </p>
         * 
         * @param workflowExecutions
         *        Contains an array of runtime details that represents each time a workflow ran for the requested image
         *        build version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecutions(Collection<WorkflowExecutionMetadata> workflowExecutions);

        /**
         * <p>
         * Contains an array of runtime details that represents each time a workflow ran for the requested image build
         * version.
         * </p>
         * 
         * @param workflowExecutions
         *        Contains an array of runtime details that represents each time a workflow ran for the requested image
         *        build version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowExecutions(WorkflowExecutionMetadata... workflowExecutions);

        /**
         * <p>
         * Contains an array of runtime details that represents each time a workflow ran for the requested image build
         * version.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionMetadata.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionMetadata.Builder#build()} is
         * called immediately and its result is passed to {@link #workflowExecutions(List<WorkflowExecutionMetadata>)}.
         * 
         * @param workflowExecutions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflowExecutions(java.util.Collection<WorkflowExecutionMetadata>)
         */
        Builder workflowExecutions(Consumer<WorkflowExecutionMetadata.Builder>... workflowExecutions);

        /**
         * <p>
         * The resource ARN of the image build version for which you requested a list of workflow runtime details.
         * </p>
         * 
         * @param imageBuildVersionArn
         *        The resource ARN of the image build version for which you requested a list of workflow runtime
         *        details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageBuildVersionArn(String imageBuildVersionArn);

        /**
         * <p>
         * The output message from the list action, if applicable.
         * </p>
         * 
         * @param message
         *        The output message from the list action, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The next token used for paginated responses. When this field isn't empty, there are additional elements that
         * the service hasn't included in this request. Use this token with the next request to retrieve additional
         * objects.
         * </p>
         * 
         * @param nextToken
         *        The next token used for paginated responses. When this field isn't empty, there are additional
         *        elements that the service hasn't included in this request. Use this token with the next request to
         *        retrieve additional objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ImagebuilderResponse.BuilderImpl implements Builder {
        private String requestIdValue;

        private List<WorkflowExecutionMetadata> workflowExecutions = DefaultSdkAutoConstructList.getInstance();

        private String imageBuildVersionArn;

        private String message;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkflowExecutionsResponse model) {
            super(model);
            requestId(model.requestIdValue);
            workflowExecutions(model.workflowExecutions);
            imageBuildVersionArn(model.imageBuildVersionArn);
            message(model.message);
            nextToken(model.nextToken);
        }

        public final String getRequestId() {
            return requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final List<WorkflowExecutionMetadata.Builder> getWorkflowExecutions() {
            List<WorkflowExecutionMetadata.Builder> result = WorkflowExecutionsListCopier.copyToBuilder(this.workflowExecutions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkflowExecutions(Collection<WorkflowExecutionMetadata.BuilderImpl> workflowExecutions) {
            this.workflowExecutions = WorkflowExecutionsListCopier.copyFromBuilder(workflowExecutions);
        }

        @Override
        public final Builder workflowExecutions(Collection<WorkflowExecutionMetadata> workflowExecutions) {
            this.workflowExecutions = WorkflowExecutionsListCopier.copy(workflowExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflowExecutions(WorkflowExecutionMetadata... workflowExecutions) {
            workflowExecutions(Arrays.asList(workflowExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflowExecutions(Consumer<WorkflowExecutionMetadata.Builder>... workflowExecutions) {
            workflowExecutions(Stream.of(workflowExecutions)
                    .map(c -> WorkflowExecutionMetadata.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getImageBuildVersionArn() {
            return imageBuildVersionArn;
        }

        public final void setImageBuildVersionArn(String imageBuildVersionArn) {
            this.imageBuildVersionArn = imageBuildVersionArn;
        }

        @Override
        public final Builder imageBuildVersionArn(String imageBuildVersionArn) {
            this.imageBuildVersionArn = imageBuildVersionArn;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListWorkflowExecutionsResponse build() {
            return new ListWorkflowExecutionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
