/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The logging configuration that's defined for pipeline execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipelineLoggingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PipelineLoggingConfiguration.Builder, PipelineLoggingConfiguration> {
    private static final SdkField<String> IMAGE_LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageLogGroupName").getter(getter(PipelineLoggingConfiguration::imageLogGroupName))
            .setter(setter(Builder::imageLogGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageLogGroupName").build()).build();

    private static final SdkField<String> PIPELINE_LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipelineLogGroupName").getter(getter(PipelineLoggingConfiguration::pipelineLogGroupName))
            .setter(setter(Builder::pipelineLogGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineLogGroupName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_LOG_GROUP_NAME_FIELD,
            PIPELINE_LOG_GROUP_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String imageLogGroupName;

    private final String pipelineLogGroupName;

    private PipelineLoggingConfiguration(BuilderImpl builder) {
        this.imageLogGroupName = builder.imageLogGroupName;
        this.pipelineLogGroupName = builder.pipelineLogGroupName;
    }

    /**
     * <p>
     * The log group name that Image Builder uses for image creation. If not specified, the log group name defaults to
     * <code>/aws/imagebuilder/image-name</code>.
     * </p>
     * 
     * @return The log group name that Image Builder uses for image creation. If not specified, the log group name
     *         defaults to <code>/aws/imagebuilder/image-name</code>.
     */
    public final String imageLogGroupName() {
        return imageLogGroupName;
    }

    /**
     * <p>
     * The log group name that Image Builder uses for the log output during creation of a new pipeline. If not
     * specified, the pipeline log group name defaults to <code>/aws/imagebuilder/pipeline/pipeline-name</code>.
     * </p>
     * 
     * @return The log group name that Image Builder uses for the log output during creation of a new pipeline. If not
     *         specified, the pipeline log group name defaults to <code>/aws/imagebuilder/pipeline/pipeline-name</code>.
     */
    public final String pipelineLogGroupName() {
        return pipelineLogGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageLogGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineLogGroupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineLoggingConfiguration)) {
            return false;
        }
        PipelineLoggingConfiguration other = (PipelineLoggingConfiguration) obj;
        return Objects.equals(imageLogGroupName(), other.imageLogGroupName())
                && Objects.equals(pipelineLogGroupName(), other.pipelineLogGroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipelineLoggingConfiguration").add("ImageLogGroupName", imageLogGroupName())
                .add("PipelineLogGroupName", pipelineLogGroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "imageLogGroupName":
            return Optional.ofNullable(clazz.cast(imageLogGroupName()));
        case "pipelineLogGroupName":
            return Optional.ofNullable(clazz.cast(pipelineLogGroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("imageLogGroupName", IMAGE_LOG_GROUP_NAME_FIELD);
        map.put("pipelineLogGroupName", PIPELINE_LOG_GROUP_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PipelineLoggingConfiguration, T> g) {
        return obj -> g.apply((PipelineLoggingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipelineLoggingConfiguration> {
        /**
         * <p>
         * The log group name that Image Builder uses for image creation. If not specified, the log group name defaults
         * to <code>/aws/imagebuilder/image-name</code>.
         * </p>
         * 
         * @param imageLogGroupName
         *        The log group name that Image Builder uses for image creation. If not specified, the log group name
         *        defaults to <code>/aws/imagebuilder/image-name</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageLogGroupName(String imageLogGroupName);

        /**
         * <p>
         * The log group name that Image Builder uses for the log output during creation of a new pipeline. If not
         * specified, the pipeline log group name defaults to <code>/aws/imagebuilder/pipeline/pipeline-name</code>.
         * </p>
         * 
         * @param pipelineLogGroupName
         *        The log group name that Image Builder uses for the log output during creation of a new pipeline. If
         *        not specified, the pipeline log group name defaults to
         *        <code>/aws/imagebuilder/pipeline/pipeline-name</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineLogGroupName(String pipelineLogGroupName);
    }

    static final class BuilderImpl implements Builder {
        private String imageLogGroupName;

        private String pipelineLogGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineLoggingConfiguration model) {
            imageLogGroupName(model.imageLogGroupName);
            pipelineLogGroupName(model.pipelineLogGroupName);
        }

        public final String getImageLogGroupName() {
            return imageLogGroupName;
        }

        public final void setImageLogGroupName(String imageLogGroupName) {
            this.imageLogGroupName = imageLogGroupName;
        }

        @Override
        public final Builder imageLogGroupName(String imageLogGroupName) {
            this.imageLogGroupName = imageLogGroupName;
            return this;
        }

        public final String getPipelineLogGroupName() {
            return pipelineLogGroupName;
        }

        public final void setPipelineLogGroupName(String pipelineLogGroupName) {
            this.pipelineLogGroupName = pipelineLogGroupName;
        }

        @Override
        public final Builder pipelineLogGroupName(String pipelineLogGroupName) {
            this.pipelineLogGroupName = pipelineLogGroupName;
            return this;
        }

        @Override
        public PipelineLoggingConfiguration build() {
            return new PipelineLoggingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
