/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendWorkflowStepActionRequest extends ImagebuilderRequest implements
        ToCopyableBuilder<SendWorkflowStepActionRequest.Builder, SendWorkflowStepActionRequest> {
    private static final SdkField<String> STEP_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stepExecutionId").getter(getter(SendWorkflowStepActionRequest::stepExecutionId))
            .setter(setter(Builder::stepExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepExecutionId").build()).build();

    private static final SdkField<String> IMAGE_BUILD_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageBuildVersionArn").getter(getter(SendWorkflowStepActionRequest::imageBuildVersionArn))
            .setter(setter(Builder::imageBuildVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageBuildVersionArn").build())
            .build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(SendWorkflowStepActionRequest::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(SendWorkflowStepActionRequest::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(SendWorkflowStepActionRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_EXECUTION_ID_FIELD,
            IMAGE_BUILD_VERSION_ARN_FIELD, ACTION_FIELD, REASON_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String stepExecutionId;

    private final String imageBuildVersionArn;

    private final String action;

    private final String reason;

    private final String clientToken;

    private SendWorkflowStepActionRequest(BuilderImpl builder) {
        super(builder);
        this.stepExecutionId = builder.stepExecutionId;
        this.imageBuildVersionArn = builder.imageBuildVersionArn;
        this.action = builder.action;
        this.reason = builder.reason;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * Uniquely identifies the workflow step that sent the step action.
     * </p>
     * 
     * @return Uniquely identifies the workflow step that sent the step action.
     */
    public final String stepExecutionId() {
        return stepExecutionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the image build version to send action for.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the image build version to send action for.
     */
    public final String imageBuildVersionArn() {
        return imageBuildVersionArn;
    }

    /**
     * <p>
     * The action for the image creation process to take while a workflow <code>WaitForAction</code> step waits for an
     * asynchronous action to complete.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link WorkflowStepActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionAsString}.
     * </p>
     * 
     * @return The action for the image creation process to take while a workflow <code>WaitForAction</code> step waits
     *         for an asynchronous action to complete.
     * @see WorkflowStepActionType
     */
    public final WorkflowStepActionType action() {
        return WorkflowStepActionType.fromValue(action);
    }

    /**
     * <p>
     * The action for the image creation process to take while a workflow <code>WaitForAction</code> step waits for an
     * asynchronous action to complete.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link WorkflowStepActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionAsString}.
     * </p>
     * 
     * @return The action for the image creation process to take while a workflow <code>WaitForAction</code> step waits
     *         for an asynchronous action to complete.
     * @see WorkflowStepActionType
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The reason why this action is sent.
     * </p>
     * 
     * @return The reason why this action is sent.
     */
    public final String reason() {
        return reason;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * idempotency</a> in the <i>Amazon EC2 API Reference</i>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information,
     *         see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         idempotency</a> in the <i>Amazon EC2 API Reference</i>.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stepExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(imageBuildVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendWorkflowStepActionRequest)) {
            return false;
        }
        SendWorkflowStepActionRequest other = (SendWorkflowStepActionRequest) obj;
        return Objects.equals(stepExecutionId(), other.stepExecutionId())
                && Objects.equals(imageBuildVersionArn(), other.imageBuildVersionArn())
                && Objects.equals(actionAsString(), other.actionAsString()) && Objects.equals(reason(), other.reason())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendWorkflowStepActionRequest").add("StepExecutionId", stepExecutionId())
                .add("ImageBuildVersionArn", imageBuildVersionArn()).add("Action", actionAsString()).add("Reason", reason())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stepExecutionId":
            return Optional.ofNullable(clazz.cast(stepExecutionId()));
        case "imageBuildVersionArn":
            return Optional.ofNullable(clazz.cast(imageBuildVersionArn()));
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "reason":
            return Optional.ofNullable(clazz.cast(reason()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stepExecutionId", STEP_EXECUTION_ID_FIELD);
        map.put("imageBuildVersionArn", IMAGE_BUILD_VERSION_ARN_FIELD);
        map.put("action", ACTION_FIELD);
        map.put("reason", REASON_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendWorkflowStepActionRequest, T> g) {
        return obj -> g.apply((SendWorkflowStepActionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ImagebuilderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SendWorkflowStepActionRequest> {
        /**
         * <p>
         * Uniquely identifies the workflow step that sent the step action.
         * </p>
         * 
         * @param stepExecutionId
         *        Uniquely identifies the workflow step that sent the step action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepExecutionId(String stepExecutionId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the image build version to send action for.
         * </p>
         * 
         * @param imageBuildVersionArn
         *        The Amazon Resource Name (ARN) of the image build version to send action for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageBuildVersionArn(String imageBuildVersionArn);

        /**
         * <p>
         * The action for the image creation process to take while a workflow <code>WaitForAction</code> step waits for
         * an asynchronous action to complete.
         * </p>
         * 
         * @param action
         *        The action for the image creation process to take while a workflow <code>WaitForAction</code> step
         *        waits for an asynchronous action to complete.
         * @see WorkflowStepActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowStepActionType
         */
        Builder action(String action);

        /**
         * <p>
         * The action for the image creation process to take while a workflow <code>WaitForAction</code> step waits for
         * an asynchronous action to complete.
         * </p>
         * 
         * @param action
         *        The action for the image creation process to take while a workflow <code>WaitForAction</code> step
         *        waits for an asynchronous action to complete.
         * @see WorkflowStepActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowStepActionType
         */
        Builder action(WorkflowStepActionType action);

        /**
         * <p>
         * The reason why this action is sent.
         * </p>
         * 
         * @param reason
         *        The reason why this action is sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see
         * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * idempotency</a> in the <i>Amazon EC2 API Reference</i>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        idempotency</a> in the <i>Amazon EC2 API Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ImagebuilderRequest.BuilderImpl implements Builder {
        private String stepExecutionId;

        private String imageBuildVersionArn;

        private String action;

        private String reason;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SendWorkflowStepActionRequest model) {
            super(model);
            stepExecutionId(model.stepExecutionId);
            imageBuildVersionArn(model.imageBuildVersionArn);
            action(model.action);
            reason(model.reason);
            clientToken(model.clientToken);
        }

        public final String getStepExecutionId() {
            return stepExecutionId;
        }

        public final void setStepExecutionId(String stepExecutionId) {
            this.stepExecutionId = stepExecutionId;
        }

        @Override
        public final Builder stepExecutionId(String stepExecutionId) {
            this.stepExecutionId = stepExecutionId;
            return this;
        }

        public final String getImageBuildVersionArn() {
            return imageBuildVersionArn;
        }

        public final void setImageBuildVersionArn(String imageBuildVersionArn) {
            this.imageBuildVersionArn = imageBuildVersionArn;
        }

        @Override
        public final Builder imageBuildVersionArn(String imageBuildVersionArn) {
            this.imageBuildVersionArn = imageBuildVersionArn;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(WorkflowStepActionType action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendWorkflowStepActionRequest build() {
            return new SendWorkflowStepActionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
