/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for a single Parameter in the Amazon Web Services Systems Manager (SSM) Parameter Store in a given
 * Region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SsmParameterConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SsmParameterConfiguration.Builder, SsmParameterConfiguration> {
    private static final SdkField<String> AMI_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("amiAccountId").getter(getter(SsmParameterConfiguration::amiAccountId))
            .setter(setter(Builder::amiAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amiAccountId").build()).build();

    private static final SdkField<String> PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parameterName").getter(getter(SsmParameterConfiguration::parameterName))
            .setter(setter(Builder::parameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterName").build()).build();

    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataType").getter(getter(SsmParameterConfiguration::dataTypeAsString)).setter(setter(Builder::dataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMI_ACCOUNT_ID_FIELD,
            PARAMETER_NAME_FIELD, DATA_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String amiAccountId;

    private final String parameterName;

    private final String dataType;

    private SsmParameterConfiguration(BuilderImpl builder) {
        this.amiAccountId = builder.amiAccountId;
        this.parameterName = builder.parameterName;
        this.dataType = builder.dataType;
    }

    /**
     * <p>
     * Specify the account that will own the Parameter in a given Region. During distribution, this account must be
     * specified in distribution settings as a target account for the Region.
     * </p>
     * 
     * @return Specify the account that will own the Parameter in a given Region. During distribution, this account must
     *         be specified in distribution settings as a target account for the Region.
     */
    public final String amiAccountId() {
        return amiAccountId;
    }

    /**
     * <p>
     * This is the name of the Parameter in the target Region or account. The image distribution creates the Parameter
     * if it doesn't already exist. Otherwise, it updates the parameter.
     * </p>
     * 
     * @return This is the name of the Parameter in the target Region or account. The image distribution creates the
     *         Parameter if it doesn't already exist. Otherwise, it updates the parameter.
     */
    public final String parameterName() {
        return parameterName;
    }

    /**
     * <p>
     * The data type specifies what type of value the Parameter contains. We recommend that you use data type
     * <code>aws:ec2:image</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link SsmParameterDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dataTypeAsString}.
     * </p>
     * 
     * @return The data type specifies what type of value the Parameter contains. We recommend that you use data type
     *         <code>aws:ec2:image</code>.
     * @see SsmParameterDataType
     */
    public final SsmParameterDataType dataType() {
        return SsmParameterDataType.fromValue(dataType);
    }

    /**
     * <p>
     * The data type specifies what type of value the Parameter contains. We recommend that you use data type
     * <code>aws:ec2:image</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link SsmParameterDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dataTypeAsString}.
     * </p>
     * 
     * @return The data type specifies what type of value the Parameter contains. We recommend that you use data type
     *         <code>aws:ec2:image</code>.
     * @see SsmParameterDataType
     */
    public final String dataTypeAsString() {
        return dataType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amiAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(parameterName());
        hashCode = 31 * hashCode + Objects.hashCode(dataTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SsmParameterConfiguration)) {
            return false;
        }
        SsmParameterConfiguration other = (SsmParameterConfiguration) obj;
        return Objects.equals(amiAccountId(), other.amiAccountId()) && Objects.equals(parameterName(), other.parameterName())
                && Objects.equals(dataTypeAsString(), other.dataTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SsmParameterConfiguration").add("AmiAccountId", amiAccountId())
                .add("ParameterName", parameterName()).add("DataType", dataTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "amiAccountId":
            return Optional.ofNullable(clazz.cast(amiAccountId()));
        case "parameterName":
            return Optional.ofNullable(clazz.cast(parameterName()));
        case "dataType":
            return Optional.ofNullable(clazz.cast(dataTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("amiAccountId", AMI_ACCOUNT_ID_FIELD);
        map.put("parameterName", PARAMETER_NAME_FIELD);
        map.put("dataType", DATA_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SsmParameterConfiguration, T> g) {
        return obj -> g.apply((SsmParameterConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SsmParameterConfiguration> {
        /**
         * <p>
         * Specify the account that will own the Parameter in a given Region. During distribution, this account must be
         * specified in distribution settings as a target account for the Region.
         * </p>
         * 
         * @param amiAccountId
         *        Specify the account that will own the Parameter in a given Region. During distribution, this account
         *        must be specified in distribution settings as a target account for the Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amiAccountId(String amiAccountId);

        /**
         * <p>
         * This is the name of the Parameter in the target Region or account. The image distribution creates the
         * Parameter if it doesn't already exist. Otherwise, it updates the parameter.
         * </p>
         * 
         * @param parameterName
         *        This is the name of the Parameter in the target Region or account. The image distribution creates the
         *        Parameter if it doesn't already exist. Otherwise, it updates the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterName(String parameterName);

        /**
         * <p>
         * The data type specifies what type of value the Parameter contains. We recommend that you use data type
         * <code>aws:ec2:image</code>.
         * </p>
         * 
         * @param dataType
         *        The data type specifies what type of value the Parameter contains. We recommend that you use data type
         *        <code>aws:ec2:image</code>.
         * @see SsmParameterDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SsmParameterDataType
         */
        Builder dataType(String dataType);

        /**
         * <p>
         * The data type specifies what type of value the Parameter contains. We recommend that you use data type
         * <code>aws:ec2:image</code>.
         * </p>
         * 
         * @param dataType
         *        The data type specifies what type of value the Parameter contains. We recommend that you use data type
         *        <code>aws:ec2:image</code>.
         * @see SsmParameterDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SsmParameterDataType
         */
        Builder dataType(SsmParameterDataType dataType);
    }

    static final class BuilderImpl implements Builder {
        private String amiAccountId;

        private String parameterName;

        private String dataType;

        private BuilderImpl() {
        }

        private BuilderImpl(SsmParameterConfiguration model) {
            amiAccountId(model.amiAccountId);
            parameterName(model.parameterName);
            dataType(model.dataType);
        }

        public final String getAmiAccountId() {
            return amiAccountId;
        }

        public final void setAmiAccountId(String amiAccountId) {
            this.amiAccountId = amiAccountId;
        }

        @Override
        public final Builder amiAccountId(String amiAccountId) {
            this.amiAccountId = amiAccountId;
            return this;
        }

        public final String getParameterName() {
            return parameterName;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public final String getDataType() {
            return dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(SsmParameterDataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        @Override
        public SsmParameterConfiguration build() {
            return new SsmParameterConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
