/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.inspector.model.FailedItemDetails;
import software.amazon.awssdk.services.inspector.model.FailedItemsCopier;
import software.amazon.awssdk.services.inspector.model.InspectorResponse;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddAttributesToFindingsResponse
extends InspectorResponse
implements ToCopyableBuilder<Builder, AddAttributesToFindingsResponse> {
    private static final SdkField<Map<String, FailedItemDetails>> FAILED_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(AddAttributesToFindingsResponse.getter(AddAttributesToFindingsResponse::failedItems)).setter(AddAttributesToFindingsResponse.setter(Builder::failedItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedItems").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedItemDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_ITEMS_FIELD));
    private final Map<String, FailedItemDetails> failedItems;

    private AddAttributesToFindingsResponse(BuilderImpl builder) {
        super(builder);
        this.failedItems = builder.failedItems;
    }

    public Map<String, FailedItemDetails> failedItems() {
        return this.failedItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.failedItems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddAttributesToFindingsResponse)) {
            return false;
        }
        AddAttributesToFindingsResponse other = (AddAttributesToFindingsResponse)((Object)obj);
        return Objects.equals(this.failedItems(), other.failedItems());
    }

    public String toString() {
        return ToString.builder((String)"AddAttributesToFindingsResponse").add("FailedItems", this.failedItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "failedItems": {
                return Optional.ofNullable(clazz.cast(this.failedItems()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddAttributesToFindingsResponse, T> g) {
        return obj -> g.apply((AddAttributesToFindingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorResponse.BuilderImpl
    implements Builder {
        private Map<String, FailedItemDetails> failedItems = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddAttributesToFindingsResponse model) {
            super(model);
            this.failedItems(model.failedItems);
        }

        public final Map<String, FailedItemDetails.Builder> getFailedItems() {
            return this.failedItems != null ? CollectionUtils.mapValues(this.failedItems, FailedItemDetails::toBuilder) : null;
        }

        @Override
        public final Builder failedItems(Map<String, FailedItemDetails> failedItems) {
            this.failedItems = FailedItemsCopier.copy(failedItems);
            return this;
        }

        public final void setFailedItems(Map<String, FailedItemDetails.BuilderImpl> failedItems) {
            this.failedItems = FailedItemsCopier.copyFromBuilder(failedItems);
        }

        @Override
        public AddAttributesToFindingsResponse build() {
            return new AddAttributesToFindingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends InspectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddAttributesToFindingsResponse> {
        public Builder failedItems(Map<String, FailedItemDetails> var1);
    }
}

