/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.inspector.model.AssessmentTemplateRulesPackageArnListCopier;
import software.amazon.awssdk.services.inspector.model.Attribute;
import software.amazon.awssdk.services.inspector.model.UserAttributeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssessmentTemplate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssessmentTemplate> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssessmentTemplate.getter(AssessmentTemplate::arn)).setter(AssessmentTemplate.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssessmentTemplate.getter(AssessmentTemplate::name)).setter(AssessmentTemplate.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ASSESSMENT_TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssessmentTemplate.getter(AssessmentTemplate::assessmentTargetArn)).setter(AssessmentTemplate.setter(Builder::assessmentTargetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentTargetArn").build()}).build();
    private static final SdkField<Integer> DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(AssessmentTemplate.getter(AssessmentTemplate::durationInSeconds)).setter(AssessmentTemplate.setter(Builder::durationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationInSeconds").build()}).build();
    private static final SdkField<List<String>> RULES_PACKAGE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AssessmentTemplate.getter(AssessmentTemplate::rulesPackageArns)).setter(AssessmentTemplate.setter(Builder::rulesPackageArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rulesPackageArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Attribute>> USER_ATTRIBUTES_FOR_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AssessmentTemplate.getter(AssessmentTemplate::userAttributesForFindings)).setter(AssessmentTemplate.setter(Builder::userAttributesForFindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAttributesForFindings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Attribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LAST_ASSESSMENT_RUN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssessmentTemplate.getter(AssessmentTemplate::lastAssessmentRunArn)).setter(AssessmentTemplate.setter(Builder::lastAssessmentRunArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastAssessmentRunArn").build()}).build();
    private static final SdkField<Integer> ASSESSMENT_RUN_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(AssessmentTemplate.getter(AssessmentTemplate::assessmentRunCount)).setter(AssessmentTemplate.setter(Builder::assessmentRunCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentRunCount").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(AssessmentTemplate.getter(AssessmentTemplate::createdAt)).setter(AssessmentTemplate.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, ASSESSMENT_TARGET_ARN_FIELD, DURATION_IN_SECONDS_FIELD, RULES_PACKAGE_ARNS_FIELD, USER_ATTRIBUTES_FOR_FINDINGS_FIELD, LAST_ASSESSMENT_RUN_ARN_FIELD, ASSESSMENT_RUN_COUNT_FIELD, CREATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String assessmentTargetArn;
    private final Integer durationInSeconds;
    private final List<String> rulesPackageArns;
    private final List<Attribute> userAttributesForFindings;
    private final String lastAssessmentRunArn;
    private final Integer assessmentRunCount;
    private final Instant createdAt;

    private AssessmentTemplate(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.assessmentTargetArn = builder.assessmentTargetArn;
        this.durationInSeconds = builder.durationInSeconds;
        this.rulesPackageArns = builder.rulesPackageArns;
        this.userAttributesForFindings = builder.userAttributesForFindings;
        this.lastAssessmentRunArn = builder.lastAssessmentRunArn;
        this.assessmentRunCount = builder.assessmentRunCount;
        this.createdAt = builder.createdAt;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public String assessmentTargetArn() {
        return this.assessmentTargetArn;
    }

    public Integer durationInSeconds() {
        return this.durationInSeconds;
    }

    public List<String> rulesPackageArns() {
        return this.rulesPackageArns;
    }

    public List<Attribute> userAttributesForFindings() {
        return this.userAttributesForFindings;
    }

    public String lastAssessmentRunArn() {
        return this.lastAssessmentRunArn;
    }

    public Integer assessmentRunCount() {
        return this.assessmentRunCount;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentTargetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.rulesPackageArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.userAttributesForFindings());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAssessmentRunArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentRunCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentTemplate)) {
            return false;
        }
        AssessmentTemplate other = (AssessmentTemplate)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.assessmentTargetArn(), other.assessmentTargetArn()) && Objects.equals(this.durationInSeconds(), other.durationInSeconds()) && Objects.equals(this.rulesPackageArns(), other.rulesPackageArns()) && Objects.equals(this.userAttributesForFindings(), other.userAttributesForFindings()) && Objects.equals(this.lastAssessmentRunArn(), other.lastAssessmentRunArn()) && Objects.equals(this.assessmentRunCount(), other.assessmentRunCount()) && Objects.equals(this.createdAt(), other.createdAt());
    }

    public String toString() {
        return ToString.builder((String)"AssessmentTemplate").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("AssessmentTargetArn", (Object)this.assessmentTargetArn()).add("DurationInSeconds", (Object)this.durationInSeconds()).add("RulesPackageArns", this.rulesPackageArns()).add("UserAttributesForFindings", this.userAttributesForFindings()).add("LastAssessmentRunArn", (Object)this.lastAssessmentRunArn()).add("AssessmentRunCount", (Object)this.assessmentRunCount()).add("CreatedAt", (Object)this.createdAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "assessmentTargetArn": {
                return Optional.ofNullable(clazz.cast(this.assessmentTargetArn()));
            }
            case "durationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.durationInSeconds()));
            }
            case "rulesPackageArns": {
                return Optional.ofNullable(clazz.cast(this.rulesPackageArns()));
            }
            case "userAttributesForFindings": {
                return Optional.ofNullable(clazz.cast(this.userAttributesForFindings()));
            }
            case "lastAssessmentRunArn": {
                return Optional.ofNullable(clazz.cast(this.lastAssessmentRunArn()));
            }
            case "assessmentRunCount": {
                return Optional.ofNullable(clazz.cast(this.assessmentRunCount()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssessmentTemplate, T> g) {
        return obj -> g.apply((AssessmentTemplate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String assessmentTargetArn;
        private Integer durationInSeconds;
        private List<String> rulesPackageArns = DefaultSdkAutoConstructList.getInstance();
        private List<Attribute> userAttributesForFindings = DefaultSdkAutoConstructList.getInstance();
        private String lastAssessmentRunArn;
        private Integer assessmentRunCount;
        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentTemplate model) {
            this.arn(model.arn);
            this.name(model.name);
            this.assessmentTargetArn(model.assessmentTargetArn);
            this.durationInSeconds(model.durationInSeconds);
            this.rulesPackageArns(model.rulesPackageArns);
            this.userAttributesForFindings(model.userAttributesForFindings);
            this.lastAssessmentRunArn(model.lastAssessmentRunArn);
            this.assessmentRunCount(model.assessmentRunCount);
            this.createdAt(model.createdAt);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getAssessmentTargetArn() {
            return this.assessmentTargetArn;
        }

        @Override
        public final Builder assessmentTargetArn(String assessmentTargetArn) {
            this.assessmentTargetArn = assessmentTargetArn;
            return this;
        }

        public final void setAssessmentTargetArn(String assessmentTargetArn) {
            this.assessmentTargetArn = assessmentTargetArn;
        }

        public final Integer getDurationInSeconds() {
            return this.durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        public final void setDurationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        public final Collection<String> getRulesPackageArns() {
            return this.rulesPackageArns;
        }

        @Override
        public final Builder rulesPackageArns(Collection<String> rulesPackageArns) {
            this.rulesPackageArns = AssessmentTemplateRulesPackageArnListCopier.copy(rulesPackageArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rulesPackageArns(String ... rulesPackageArns) {
            this.rulesPackageArns(Arrays.asList(rulesPackageArns));
            return this;
        }

        public final void setRulesPackageArns(Collection<String> rulesPackageArns) {
            this.rulesPackageArns = AssessmentTemplateRulesPackageArnListCopier.copy(rulesPackageArns);
        }

        public final Collection<Attribute.Builder> getUserAttributesForFindings() {
            return this.userAttributesForFindings != null ? (Collection)this.userAttributesForFindings.stream().map(Attribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userAttributesForFindings(Collection<Attribute> userAttributesForFindings) {
            this.userAttributesForFindings = UserAttributeListCopier.copy(userAttributesForFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributesForFindings(Attribute ... userAttributesForFindings) {
            this.userAttributesForFindings(Arrays.asList(userAttributesForFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributesForFindings(Consumer<Attribute.Builder> ... userAttributesForFindings) {
            this.userAttributesForFindings(Stream.of(userAttributesForFindings).map(c -> (Attribute)((Attribute.Builder)Attribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserAttributesForFindings(Collection<Attribute.BuilderImpl> userAttributesForFindings) {
            this.userAttributesForFindings = UserAttributeListCopier.copyFromBuilder(userAttributesForFindings);
        }

        public final String getLastAssessmentRunArn() {
            return this.lastAssessmentRunArn;
        }

        @Override
        public final Builder lastAssessmentRunArn(String lastAssessmentRunArn) {
            this.lastAssessmentRunArn = lastAssessmentRunArn;
            return this;
        }

        public final void setLastAssessmentRunArn(String lastAssessmentRunArn) {
            this.lastAssessmentRunArn = lastAssessmentRunArn;
        }

        public final Integer getAssessmentRunCount() {
            return this.assessmentRunCount;
        }

        @Override
        public final Builder assessmentRunCount(Integer assessmentRunCount) {
            this.assessmentRunCount = assessmentRunCount;
            return this;
        }

        public final void setAssessmentRunCount(Integer assessmentRunCount) {
            this.assessmentRunCount = assessmentRunCount;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public AssessmentTemplate build() {
            return new AssessmentTemplate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssessmentTemplate> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder assessmentTargetArn(String var1);

        public Builder durationInSeconds(Integer var1);

        public Builder rulesPackageArns(Collection<String> var1);

        public Builder rulesPackageArns(String ... var1);

        public Builder userAttributesForFindings(Collection<Attribute> var1);

        public Builder userAttributesForFindings(Attribute ... var1);

        public Builder userAttributesForFindings(Consumer<Attribute.Builder> ... var1);

        public Builder lastAssessmentRunArn(String var1);

        public Builder assessmentRunCount(Integer var1);

        public Builder createdAt(Instant var1);
    }
}

