/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector.model.InspectorException;
import software.amazon.awssdk.services.inspector.model.LimitExceededErrorCode;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LimitExceededException
extends InspectorException
implements ToCopyableBuilder<Builder, LimitExceededException> {
    private static final SdkField<Boolean> CAN_RETRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(LimitExceededException.getter(LimitExceededException::canRetry)).setter(LimitExceededException.setter(Builder::canRetry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canRetry").build()}).build();
    private static final SdkField<String> INSPECTOR_ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LimitExceededException.getter(LimitExceededException::inspectorErrorCodeAsString)).setter(LimitExceededException.setter(Builder::inspectorErrorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAN_RETRY_FIELD, INSPECTOR_ERROR_CODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean canRetry;
    private final String inspectorErrorCode;

    private LimitExceededException(BuilderImpl builder) {
        super(builder);
        this.canRetry = builder.canRetry;
        this.inspectorErrorCode = builder.inspectorErrorCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public Boolean canRetry() {
        return this.canRetry;
    }

    public LimitExceededErrorCode inspectorErrorCode() {
        return LimitExceededErrorCode.fromValue(this.inspectorErrorCode);
    }

    public String inspectorErrorCodeAsString() {
        return this.inspectorErrorCode;
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LimitExceededException, T> g) {
        return obj -> g.apply((LimitExceededException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorException.BuilderImpl
    implements Builder {
        private Boolean canRetry;
        private String inspectorErrorCode;

        private BuilderImpl() {
        }

        private BuilderImpl(LimitExceededException model) {
            super(model);
            this.canRetry(model.canRetry);
            this.inspectorErrorCode(model.inspectorErrorCode);
        }

        public final Boolean getCanRetry() {
            return this.canRetry;
        }

        @Override
        public final Builder canRetry(Boolean canRetry) {
            this.canRetry = canRetry;
            return this;
        }

        public final void setCanRetry(Boolean canRetry) {
            this.canRetry = canRetry;
        }

        public final String getInspectorErrorCodeAsString() {
            return this.inspectorErrorCode;
        }

        @Override
        public final Builder inspectorErrorCode(String inspectorErrorCode) {
            this.inspectorErrorCode = inspectorErrorCode;
            return this;
        }

        @Override
        public final Builder inspectorErrorCode(LimitExceededErrorCode inspectorErrorCode) {
            this.inspectorErrorCode(inspectorErrorCode == null ? null : inspectorErrorCode.toString());
            return this;
        }

        public final void setInspectorErrorCode(String inspectorErrorCode) {
            this.inspectorErrorCode = inspectorErrorCode;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public LimitExceededException build() {
            return new LimitExceededException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LimitExceededException>,
    InspectorException.Builder {
        public Builder canRetry(Boolean var1);

        public Builder inspectorErrorCode(String var1);

        public Builder inspectorErrorCode(LimitExceededErrorCode var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);
    }
}

