/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.inspector.model.AssessmentRunAgent;
import software.amazon.awssdk.services.inspector.model.AssessmentRunAgentListCopier;
import software.amazon.awssdk.services.inspector.model.InspectorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssessmentRunAgentsResponse
extends InspectorResponse
implements ToCopyableBuilder<Builder, ListAssessmentRunAgentsResponse> {
    private static final SdkField<List<AssessmentRunAgent>> ASSESSMENT_RUN_AGENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListAssessmentRunAgentsResponse.getter(ListAssessmentRunAgentsResponse::assessmentRunAgents)).setter(ListAssessmentRunAgentsResponse.setter(Builder::assessmentRunAgents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentRunAgents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssessmentRunAgent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListAssessmentRunAgentsResponse.getter(ListAssessmentRunAgentsResponse::nextToken)).setter(ListAssessmentRunAgentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_RUN_AGENTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AssessmentRunAgent> assessmentRunAgents;
    private final String nextToken;

    private ListAssessmentRunAgentsResponse(BuilderImpl builder) {
        super(builder);
        this.assessmentRunAgents = builder.assessmentRunAgents;
        this.nextToken = builder.nextToken;
    }

    public List<AssessmentRunAgent> assessmentRunAgents() {
        return this.assessmentRunAgents;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentRunAgents());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssessmentRunAgentsResponse)) {
            return false;
        }
        ListAssessmentRunAgentsResponse other = (ListAssessmentRunAgentsResponse)((Object)obj);
        return Objects.equals(this.assessmentRunAgents(), other.assessmentRunAgents()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListAssessmentRunAgentsResponse").add("AssessmentRunAgents", this.assessmentRunAgents()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assessmentRunAgents": {
                return Optional.ofNullable(clazz.cast(this.assessmentRunAgents()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssessmentRunAgentsResponse, T> g) {
        return obj -> g.apply((ListAssessmentRunAgentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorResponse.BuilderImpl
    implements Builder {
        private List<AssessmentRunAgent> assessmentRunAgents = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssessmentRunAgentsResponse model) {
            super(model);
            this.assessmentRunAgents(model.assessmentRunAgents);
            this.nextToken(model.nextToken);
        }

        public final Collection<AssessmentRunAgent.Builder> getAssessmentRunAgents() {
            return this.assessmentRunAgents != null ? (Collection)this.assessmentRunAgents.stream().map(AssessmentRunAgent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder assessmentRunAgents(Collection<AssessmentRunAgent> assessmentRunAgents) {
            this.assessmentRunAgents = AssessmentRunAgentListCopier.copy(assessmentRunAgents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentRunAgents(AssessmentRunAgent ... assessmentRunAgents) {
            this.assessmentRunAgents(Arrays.asList(assessmentRunAgents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentRunAgents(Consumer<AssessmentRunAgent.Builder> ... assessmentRunAgents) {
            this.assessmentRunAgents(Stream.of(assessmentRunAgents).map(c -> (AssessmentRunAgent)((AssessmentRunAgent.Builder)AssessmentRunAgent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssessmentRunAgents(Collection<AssessmentRunAgent.BuilderImpl> assessmentRunAgents) {
            this.assessmentRunAgents = AssessmentRunAgentListCopier.copyFromBuilder(assessmentRunAgents);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAssessmentRunAgentsResponse build() {
            return new ListAssessmentRunAgentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends InspectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssessmentRunAgentsResponse> {
        public Builder assessmentRunAgents(Collection<AssessmentRunAgent> var1);

        public Builder assessmentRunAgents(AssessmentRunAgent ... var1);

        public Builder assessmentRunAgents(Consumer<AssessmentRunAgent.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

