/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeExclusionsResponse extends InspectorResponse implements
        ToCopyableBuilder<DescribeExclusionsResponse.Builder, DescribeExclusionsResponse> {
    private static final SdkField<Map<String, Exclusion>> EXCLUSIONS_FIELD = SdkField
            .<Map<String, Exclusion>> builder(MarshallingType.MAP)
            .getter(getter(DescribeExclusionsResponse::exclusions))
            .setter(setter(Builder::exclusions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exclusions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Exclusion> builder(MarshallingType.SDK_POJO)
                                            .constructor(Exclusion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, FailedItemDetails>> FAILED_ITEMS_FIELD = SdkField
            .<Map<String, FailedItemDetails>> builder(MarshallingType.MAP)
            .getter(getter(DescribeExclusionsResponse::failedItems))
            .setter(setter(Builder::failedItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedItems").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<FailedItemDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailedItemDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCLUSIONS_FIELD,
            FAILED_ITEMS_FIELD));

    private final Map<String, Exclusion> exclusions;

    private final Map<String, FailedItemDetails> failedItems;

    private DescribeExclusionsResponse(BuilderImpl builder) {
        super(builder);
        this.exclusions = builder.exclusions;
        this.failedItems = builder.failedItems;
    }

    /**
     * <p>
     * Information about the exclusions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the exclusions.
     */
    public Map<String, Exclusion> exclusions() {
        return exclusions;
    }

    /**
     * <p>
     * Exclusion details that cannot be described. An error code is provided for each failed item.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Exclusion details that cannot be described. An error code is provided for each failed item.
     */
    public Map<String, FailedItemDetails> failedItems() {
        return failedItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(exclusions());
        hashCode = 31 * hashCode + Objects.hashCode(failedItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExclusionsResponse)) {
            return false;
        }
        DescribeExclusionsResponse other = (DescribeExclusionsResponse) obj;
        return Objects.equals(exclusions(), other.exclusions()) && Objects.equals(failedItems(), other.failedItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeExclusionsResponse").add("Exclusions", exclusions()).add("FailedItems", failedItems())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "exclusions":
            return Optional.ofNullable(clazz.cast(exclusions()));
        case "failedItems":
            return Optional.ofNullable(clazz.cast(failedItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeExclusionsResponse, T> g) {
        return obj -> g.apply((DescribeExclusionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InspectorResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeExclusionsResponse> {
        /**
         * <p>
         * Information about the exclusions.
         * </p>
         * 
         * @param exclusions
         *        Information about the exclusions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusions(Map<String, Exclusion> exclusions);

        /**
         * <p>
         * Exclusion details that cannot be described. An error code is provided for each failed item.
         * </p>
         * 
         * @param failedItems
         *        Exclusion details that cannot be described. An error code is provided for each failed item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedItems(Map<String, FailedItemDetails> failedItems);
    }

    static final class BuilderImpl extends InspectorResponse.BuilderImpl implements Builder {
        private Map<String, Exclusion> exclusions = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, FailedItemDetails> failedItems = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExclusionsResponse model) {
            super(model);
            exclusions(model.exclusions);
            failedItems(model.failedItems);
        }

        public final Map<String, Exclusion.Builder> getExclusions() {
            return exclusions != null ? CollectionUtils.mapValues(exclusions, Exclusion::toBuilder) : null;
        }

        @Override
        public final Builder exclusions(Map<String, Exclusion> exclusions) {
            this.exclusions = ExclusionMapCopier.copy(exclusions);
            return this;
        }

        public final void setExclusions(Map<String, Exclusion.BuilderImpl> exclusions) {
            this.exclusions = ExclusionMapCopier.copyFromBuilder(exclusions);
        }

        public final Map<String, FailedItemDetails.Builder> getFailedItems() {
            return failedItems != null ? CollectionUtils.mapValues(failedItems, FailedItemDetails::toBuilder) : null;
        }

        @Override
        public final Builder failedItems(Map<String, FailedItemDetails> failedItems) {
            this.failedItems = FailedItemsCopier.copy(failedItems);
            return this;
        }

        public final void setFailedItems(Map<String, FailedItemDetails.BuilderImpl> failedItems) {
            this.failedItems = FailedItemsCopier.copyFromBuilder(failedItems);
        }

        @Override
        public DescribeExclusionsResponse build() {
            return new DescribeExclusionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
