/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This data type is used in the <a>Finding</a> data type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InspectorServiceAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<InspectorServiceAttributes.Builder, InspectorServiceAttributes> {
    private static final SdkField<Integer> SCHEMA_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(InspectorServiceAttributes::schemaVersion)).setter(setter(Builder::schemaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaVersion").build()).build();

    private static final SdkField<String> ASSESSMENT_RUN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InspectorServiceAttributes::assessmentRunArn)).setter(setter(Builder::assessmentRunArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentRunArn").build()).build();

    private static final SdkField<String> RULES_PACKAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InspectorServiceAttributes::rulesPackageArn)).setter(setter(Builder::rulesPackageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rulesPackageArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_VERSION_FIELD,
            ASSESSMENT_RUN_ARN_FIELD, RULES_PACKAGE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer schemaVersion;

    private final String assessmentRunArn;

    private final String rulesPackageArn;

    private InspectorServiceAttributes(BuilderImpl builder) {
        this.schemaVersion = builder.schemaVersion;
        this.assessmentRunArn = builder.assessmentRunArn;
        this.rulesPackageArn = builder.rulesPackageArn;
    }

    /**
     * <p>
     * The schema version of this data type.
     * </p>
     * 
     * @return The schema version of this data type.
     */
    public Integer schemaVersion() {
        return schemaVersion;
    }

    /**
     * <p>
     * The ARN of the assessment run during which the finding is generated.
     * </p>
     * 
     * @return The ARN of the assessment run during which the finding is generated.
     */
    public String assessmentRunArn() {
        return assessmentRunArn;
    }

    /**
     * <p>
     * The ARN of the rules package that is used to generate the finding.
     * </p>
     * 
     * @return The ARN of the rules package that is used to generate the finding.
     */
    public String rulesPackageArn() {
        return rulesPackageArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentRunArn());
        hashCode = 31 * hashCode + Objects.hashCode(rulesPackageArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InspectorServiceAttributes)) {
            return false;
        }
        InspectorServiceAttributes other = (InspectorServiceAttributes) obj;
        return Objects.equals(schemaVersion(), other.schemaVersion())
                && Objects.equals(assessmentRunArn(), other.assessmentRunArn())
                && Objects.equals(rulesPackageArn(), other.rulesPackageArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InspectorServiceAttributes").add("SchemaVersion", schemaVersion())
                .add("AssessmentRunArn", assessmentRunArn()).add("RulesPackageArn", rulesPackageArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "schemaVersion":
            return Optional.ofNullable(clazz.cast(schemaVersion()));
        case "assessmentRunArn":
            return Optional.ofNullable(clazz.cast(assessmentRunArn()));
        case "rulesPackageArn":
            return Optional.ofNullable(clazz.cast(rulesPackageArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InspectorServiceAttributes, T> g) {
        return obj -> g.apply((InspectorServiceAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InspectorServiceAttributes> {
        /**
         * <p>
         * The schema version of this data type.
         * </p>
         * 
         * @param schemaVersion
         *        The schema version of this data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersion(Integer schemaVersion);

        /**
         * <p>
         * The ARN of the assessment run during which the finding is generated.
         * </p>
         * 
         * @param assessmentRunArn
         *        The ARN of the assessment run during which the finding is generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentRunArn(String assessmentRunArn);

        /**
         * <p>
         * The ARN of the rules package that is used to generate the finding.
         * </p>
         * 
         * @param rulesPackageArn
         *        The ARN of the rules package that is used to generate the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rulesPackageArn(String rulesPackageArn);
    }

    static final class BuilderImpl implements Builder {
        private Integer schemaVersion;

        private String assessmentRunArn;

        private String rulesPackageArn;

        private BuilderImpl() {
        }

        private BuilderImpl(InspectorServiceAttributes model) {
            schemaVersion(model.schemaVersion);
            assessmentRunArn(model.assessmentRunArn);
            rulesPackageArn(model.rulesPackageArn);
        }

        public final Integer getSchemaVersion() {
            return schemaVersion;
        }

        @Override
        public final Builder schemaVersion(Integer schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final void setSchemaVersion(Integer schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        public final String getAssessmentRunArn() {
            return assessmentRunArn;
        }

        @Override
        public final Builder assessmentRunArn(String assessmentRunArn) {
            this.assessmentRunArn = assessmentRunArn;
            return this;
        }

        public final void setAssessmentRunArn(String assessmentRunArn) {
            this.assessmentRunArn = assessmentRunArn;
        }

        public final String getRulesPackageArn() {
            return rulesPackageArn;
        }

        @Override
        public final Builder rulesPackageArn(String rulesPackageArn) {
            this.rulesPackageArn = rulesPackageArn;
            return this;
        }

        public final void setRulesPackageArn(String rulesPackageArn) {
            this.rulesPackageArn = rulesPackageArn;
        }

        @Override
        public InspectorServiceAttributes build() {
            return new InspectorServiceAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
