/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This data type is used as a response element in the <a>ListEventSubscriptions</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Subscription implements SdkPojo, Serializable, ToCopyableBuilder<Subscription.Builder, Subscription> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Subscription::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Subscription::topicArn)).setter(setter(Builder::topicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicArn").build()).build();

    private static final SdkField<List<EventSubscription>> EVENT_SUBSCRIPTIONS_FIELD = SdkField
            .<List<EventSubscription>> builder(MarshallingType.LIST)
            .getter(getter(Subscription::eventSubscriptions))
            .setter(setter(Builder::eventSubscriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventSubscriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventSubscription> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventSubscription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            TOPIC_ARN_FIELD, EVENT_SUBSCRIPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceArn;

    private final String topicArn;

    private final List<EventSubscription> eventSubscriptions;

    private Subscription(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.topicArn = builder.topicArn;
        this.eventSubscriptions = builder.eventSubscriptions;
    }

    /**
     * <p>
     * The ARN of the assessment template that is used during the event for which the SNS notification is sent.
     * </p>
     * 
     * @return The ARN of the assessment template that is used during the event for which the SNS notification is sent.
     */
    public String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The ARN of the Amazon Simple Notification Service (SNS) topic to which the SNS notifications are sent.
     * </p>
     * 
     * @return The ARN of the Amazon Simple Notification Service (SNS) topic to which the SNS notifications are sent.
     */
    public String topicArn() {
        return topicArn;
    }

    /**
     * <p>
     * The list of existing event subscriptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of existing event subscriptions.
     */
    public List<EventSubscription> eventSubscriptions() {
        return eventSubscriptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(eventSubscriptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(topicArn(), other.topicArn())
                && Objects.equals(eventSubscriptions(), other.eventSubscriptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Subscription").add("ResourceArn", resourceArn()).add("TopicArn", topicArn())
                .add("EventSubscriptions", eventSubscriptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "topicArn":
            return Optional.ofNullable(clazz.cast(topicArn()));
        case "eventSubscriptions":
            return Optional.ofNullable(clazz.cast(eventSubscriptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Subscription, T> g) {
        return obj -> g.apply((Subscription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Subscription> {
        /**
         * <p>
         * The ARN of the assessment template that is used during the event for which the SNS notification is sent.
         * </p>
         * 
         * @param resourceArn
         *        The ARN of the assessment template that is used during the event for which the SNS notification is
         *        sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The ARN of the Amazon Simple Notification Service (SNS) topic to which the SNS notifications are sent.
         * </p>
         * 
         * @param topicArn
         *        The ARN of the Amazon Simple Notification Service (SNS) topic to which the SNS notifications are sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);

        /**
         * <p>
         * The list of existing event subscriptions.
         * </p>
         * 
         * @param eventSubscriptions
         *        The list of existing event subscriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSubscriptions(Collection<EventSubscription> eventSubscriptions);

        /**
         * <p>
         * The list of existing event subscriptions.
         * </p>
         * 
         * @param eventSubscriptions
         *        The list of existing event subscriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSubscriptions(EventSubscription... eventSubscriptions);

        /**
         * <p>
         * The list of existing event subscriptions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EventSubscription>.Builder} avoiding the
         * need to create one manually via {@link List<EventSubscription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EventSubscription>.Builder#build()} is called immediately
         * and its result is passed to {@link #eventSubscriptions(List<EventSubscription>)}.
         * 
         * @param eventSubscriptions
         *        a consumer that will call methods on {@link List<EventSubscription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventSubscriptions(List<EventSubscription>)
         */
        Builder eventSubscriptions(Consumer<EventSubscription.Builder>... eventSubscriptions);
    }

    static final class BuilderImpl implements Builder {
        private String resourceArn;

        private String topicArn;

        private List<EventSubscription> eventSubscriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Subscription model) {
            resourceArn(model.resourceArn);
            topicArn(model.topicArn);
            eventSubscriptions(model.eventSubscriptions);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final String getTopicArn() {
            return topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final Collection<EventSubscription.Builder> getEventSubscriptions() {
            return eventSubscriptions != null ? eventSubscriptions.stream().map(EventSubscription::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder eventSubscriptions(Collection<EventSubscription> eventSubscriptions) {
            this.eventSubscriptions = EventSubscriptionListCopier.copy(eventSubscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSubscriptions(EventSubscription... eventSubscriptions) {
            eventSubscriptions(Arrays.asList(eventSubscriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSubscriptions(Consumer<EventSubscription.Builder>... eventSubscriptions) {
            eventSubscriptions(Stream.of(eventSubscriptions).map(c -> EventSubscription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEventSubscriptions(Collection<EventSubscription.BuilderImpl> eventSubscriptions) {
            this.eventSubscriptions = EventSubscriptionListCopier.copyFromBuilder(eventSubscriptions);
        }

        @Override
        public Subscription build() {
            return new Subscription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
